/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.models;

import com.azure.cosmos.implementation.ImplementationBridgeHelpers;
import com.azure.cosmos.implementation.JsonSerializable;
import com.azure.cosmos.implementation.PartitionKeyHelper;
import com.azure.cosmos.implementation.Utils;
import com.azure.cosmos.implementation.guava25.base.Preconditions;
import com.azure.cosmos.implementation.routing.PartitionKeyInternal;
import com.azure.cosmos.models.PartitionKeyDefinition;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.List;
import java.util.Map;

public class PartitionKey {
    private final PartitionKeyInternal internalPartitionKey;
    private Object keyObject;
    public static final PartitionKey NONE = new PartitionKey(PartitionKeyInternal.None);

    PartitionKey(PartitionKeyInternal partitionKeyInternal) {
        this.internalPartitionKey = partitionKeyInternal;
    }

    public PartitionKey(Object key) {
        this.keyObject = key;
        this.internalPartitionKey = PartitionKeyInternal.fromObjectArray(new Object[]{key}, true);
    }

    static PartitionKey fromJsonString(String jsonString) {
        return new PartitionKey(PartitionKeyInternal.fromJsonString(jsonString));
    }

    public String toString() {
        return this.internalPartitionKey.toJson();
    }

    PartitionKeyInternal getInternalPartitionKey() {
        return this.internalPartitionKey;
    }

    public static PartitionKey fromObjectArray(Object[] values, boolean strict) {
        Preconditions.checkNotNull(values, "Argument 'values' must not be null.");
        Preconditions.checkNotNull(strict, "Argument 'strict' must not be null.");
        if (values.length == 0) {
            throw new NullPointerException("Argument 'values' must not be null.");
        }
        return new PartitionKey(PartitionKeyInternal.fromObjectArray(values, strict));
    }

    public static PartitionKey fromItem(Map<String, Object> item, PartitionKeyDefinition partitionKeyDefinition) {
        Preconditions.checkNotNull(item, "Argument 'item' must not be null.");
        Preconditions.checkNotNull(partitionKeyDefinition, "Argument 'partitionKeyDefinition' must not be null.");
        return PartitionKeyHelper.extractPartitionKeyFromDocument(new JsonSerializable((ObjectNode)Utils.getSimpleObjectMapper().convertValue(item, ObjectNode.class)), partitionKeyDefinition);
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (this == other) {
            return true;
        }
        PartitionKey otherKey = Utils.as(other, PartitionKey.class);
        return otherKey != null && this.internalPartitionKey.equals(otherKey.internalPartitionKey);
    }

    public int hashCode() {
        return super.hashCode();
    }

    static void initialize() {
        ImplementationBridgeHelpers.PartitionKeyHelper.setPartitionKeyAccessor(new ImplementationBridgeHelpers.PartitionKeyHelper.PartitionKeyAccessor(){

            @Override
            public PartitionKey toPartitionKey(PartitionKeyInternal partitionKeyInternal) {
                return new PartitionKey(partitionKeyInternal);
            }

            @Override
            public PartitionKey toPartitionKey(List<Object> values, boolean strict) {
                PartitionKeyInternal partitionKeyInternal = PartitionKeyInternal.fromObjectArray(values, strict);
                return new PartitionKey(partitionKeyInternal);
            }

            @Override
            public PartitionKeyInternal getPartitionKeyInternal(PartitionKey partitionKey) {
                return partitionKey.internalPartitionKey;
            }
        });
    }

    static {
        PartitionKey.initialize();
    }
}

