/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.models;

import com.azure.cosmos.implementation.feedranges.FeedRangeEpkImpl;
import com.azure.cosmos.implementation.feedranges.FeedRangeInternal;
import com.azure.cosmos.implementation.feedranges.FeedRangePartitionKeyImpl;
import com.azure.cosmos.implementation.guava25.base.Preconditions;
import com.azure.cosmos.models.ModelBridgeInternal;
import com.azure.cosmos.models.PartitionKey;

public interface FeedRange {
    public static FeedRange fromString(String json) {
        return FeedRangeInternal.fromBase64EncodedJsonString(json);
    }

    public String toString();

    public static FeedRange forLogicalPartition(PartitionKey partitionKey) {
        Preconditions.checkNotNull(partitionKey, "Argument 'partitionKey' must not be null.");
        return new FeedRangePartitionKeyImpl(ModelBridgeInternal.getPartitionKeyInternal(partitionKey));
    }

    public static FeedRange forFullRange() {
        return FeedRangeEpkImpl.forFullRange();
    }
}

