/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation;

import com.azure.cosmos.implementation.Configs;
import com.azure.cosmos.implementation.Exceptions;
import com.azure.cosmos.implementation.ISessionToken;
import com.azure.cosmos.implementation.InternalServerErrorException;
import com.azure.cosmos.implementation.Strings;
import com.azure.cosmos.implementation.Utils;
import com.azure.cosmos.implementation.apachecommons.collections.map.UnmodifiableMap;
import com.azure.cosmos.implementation.apachecommons.lang.ObjectUtils;
import com.azure.cosmos.implementation.apachecommons.lang.StringUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VectorSessionToken
implements ISessionToken {
    private static final Logger logger = LoggerFactory.getLogger(VectorSessionToken.class);
    public static final char SegmentSeparator = '#';
    public static final char RegionProgressSeparator = '=';
    private final long version;
    private final long globalLsn;
    private final UnmodifiableMap<Integer, Long> localLsnByRegion;
    private final String sessionToken;
    private final boolean isSessionTokenFalseProgressMergeEnabled = Configs.isSessionTokenFalseProgressMergeEnabled();

    private VectorSessionToken(long version, long globalLsn, UnmodifiableMap<Integer, Long> localLsnByRegion) {
        this(version, globalLsn, localLsnByRegion, null);
    }

    private VectorSessionToken(long version, long globalLsn, UnmodifiableMap<Integer, Long> localLsnByRegion, String sessionToken) {
        this.version = version;
        this.globalLsn = globalLsn;
        this.localLsnByRegion = localLsnByRegion;
        if (sessionToken == null) {
            String regionProgress = String.join((CharSequence)Character.toString('#'), localLsnByRegion.entrySet().stream().map(kvp -> new StringBuilder().append(kvp.getKey()).append('=').append(kvp.getValue())).collect(Collectors.toList()));
            if (Strings.isNullOrEmpty(regionProgress)) {
                StringBuilder sb = new StringBuilder();
                sb.append(this.version).append('#').append(this.globalLsn);
                this.sessionToken = sb.toString();
            } else {
                StringBuilder sb = new StringBuilder();
                sb.append(this.version).append('#').append(this.globalLsn).append('#').append(regionProgress);
                this.sessionToken = sb.toString();
            }
        } else {
            this.sessionToken = sessionToken;
        }
    }

    public static boolean tryCreate(String sessionToken, Utils.ValueHolder<ISessionToken> parsedSessionToken) {
        Utils.ValueHolder<Object> localLsnByRegion;
        Utils.ValueHolder<Long> globalLsnHolder;
        Utils.ValueHolder<Long> versionHolder = Utils.ValueHolder.initialize(-1L);
        if (VectorSessionToken.tryParseSessionToken(sessionToken, versionHolder, globalLsnHolder = Utils.ValueHolder.initialize(-1L), localLsnByRegion = Utils.ValueHolder.initialize(null))) {
            parsedSessionToken.v = new VectorSessionToken((Long)versionHolder.v, (Long)globalLsnHolder.v, (UnmodifiableMap)localLsnByRegion.v, sessionToken);
            return true;
        }
        return false;
    }

    @Override
    public long getLSN() {
        return this.globalLsn;
    }

    public boolean equals(Object obj) {
        VectorSessionToken other = Utils.as(obj, VectorSessionToken.class);
        if (other == null) {
            return false;
        }
        return this.version == other.version && this.globalLsn == other.globalLsn && this.areRegionProgressEqual(other.localLsnByRegion);
    }

    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public boolean isValid(ISessionToken otherSessionToken) {
        VectorSessionToken other = Utils.as(otherSessionToken, VectorSessionToken.class);
        if (other == null) {
            throw new IllegalArgumentException("otherSessionToken");
        }
        if (!this.isSessionTokenFalseProgressMergeEnabled ? other.version < this.version || other.globalLsn < this.globalLsn : other.version < this.version || other.version == this.version && other.globalLsn < this.globalLsn) {
            return false;
        }
        if (other.version == this.version && other.localLsnByRegion.size() != this.localLsnByRegion.size()) {
            throw new InternalServerErrorException(Exceptions.getInternalServerErrorMessage(String.format("Compared session tokens '%s' and '%s' has unexpected regions.", this.sessionToken, other.sessionToken)), 20903);
        }
        for (Map.Entry<Integer, Long> kvp : other.localLsnByRegion.entrySet()) {
            Integer regionId = kvp.getKey();
            long otherLocalLsn = kvp.getValue();
            Utils.ValueHolder<Long> localLsn = Utils.ValueHolder.initialize(-1L);
            if (!Utils.tryGetValue(this.localLsnByRegion, regionId, localLsn)) {
                if (this.version != other.version) continue;
                throw new InternalServerErrorException(Exceptions.getInternalServerErrorMessage(String.format("Compared session tokens '%s' and '%s' has unexpected regions.", this.sessionToken, other.sessionToken)), 20903);
            }
            if (otherLocalLsn >= (Long)localLsn.v) continue;
            return false;
        }
        return true;
    }

    @Override
    public ISessionToken merge(ISessionToken obj) {
        VectorSessionToken sessionTokenWithHigherVersion;
        VectorSessionToken sessionTokenWithLowerVersion;
        VectorSessionToken other = Utils.as(obj, VectorSessionToken.class);
        if (other == null) {
            throw new IllegalArgumentException("obj");
        }
        if (this.version == other.version && this.localLsnByRegion.size() != other.localLsnByRegion.size()) {
            throw new InternalServerErrorException(Exceptions.getInternalServerErrorMessage(String.format("Compared session tokens '%s' and '%s' has unexpected regions.", this.sessionToken, other.sessionToken)), 20903);
        }
        if (this.version < other.version) {
            sessionTokenWithLowerVersion = this;
            sessionTokenWithHigherVersion = other;
        } else {
            sessionTokenWithLowerVersion = other;
            sessionTokenWithHigherVersion = this;
        }
        HashMap<Integer, Long> highestLocalLsnByRegion = new HashMap<Integer, Long>();
        for (Map.Entry<Integer, Long> kvp : sessionTokenWithHigherVersion.localLsnByRegion.entrySet()) {
            Integer regionId = kvp.getKey();
            long localLsn1 = kvp.getValue();
            Utils.ValueHolder<Long> localLsn2 = Utils.ValueHolder.initialize(-1L);
            if (Utils.tryGetValue(sessionTokenWithLowerVersion.localLsnByRegion, regionId, localLsn2)) {
                highestLocalLsnByRegion.put(regionId, Math.max(localLsn1, (Long)localLsn2.v));
                continue;
            }
            if (this.version == other.version) {
                throw new InternalServerErrorException(Exceptions.getInternalServerErrorMessage(String.format("Compared session tokens '%s' and '%s' has unexpected regions.", this.sessionToken, other.sessionToken)), 20903);
            }
            highestLocalLsnByRegion.put(regionId, localLsn1);
        }
        return new VectorSessionToken(Math.max(this.version, other.version), !this.isSessionTokenFalseProgressMergeEnabled || this.version == other.version ? Math.max(this.globalLsn, other.globalLsn) : sessionTokenWithHigherVersion.globalLsn, (UnmodifiableMap)UnmodifiableMap.unmodifiableMap(highestLocalLsnByRegion));
    }

    @Override
    public String convertToString() {
        return this.sessionToken;
    }

    public long getVersion() {
        return this.version;
    }

    public UnmodifiableMap<Integer, Long> getLocalLsnByRegion() {
        return this.localLsnByRegion;
    }

    private boolean areRegionProgressEqual(UnmodifiableMap<Integer, Long> other) {
        if (this.localLsnByRegion.size() != other.size()) {
            return false;
        }
        for (Map.Entry<Integer, Long> kvp : this.localLsnByRegion.entrySet()) {
            Integer regionId = kvp.getKey();
            Utils.ValueHolder<Long> localLsn1 = Utils.ValueHolder.initialize(kvp.getValue());
            Utils.ValueHolder<Long> localLsn2 = Utils.ValueHolder.initialize(-1L);
            if (!Utils.tryGetValue(other, regionId, localLsn2) || !ObjectUtils.notEqual(localLsn1.v, localLsn2.v)) continue;
            return false;
        }
        return true;
    }

    private static boolean tryParseSessionToken(String sessionToken, Utils.ValueHolder<Long> version, Utils.ValueHolder<Long> globalLsn, Utils.ValueHolder<UnmodifiableMap<Integer, Long>> localLsnByRegion) {
        version.v = 0L;
        localLsnByRegion.v = null;
        globalLsn.v = -1L;
        if (Strings.isNullOrEmpty(sessionToken)) {
            logger.info("SESSION token is empty");
            return false;
        }
        String[] segments = StringUtils.split(sessionToken, '#');
        if (segments.length < 2) {
            return false;
        }
        if (!VectorSessionToken.tryParseLong(segments[0], version) || !VectorSessionToken.tryParseLong(segments[1], globalLsn)) {
            logger.warn("Unexpected session token version number '{}' OR global lsn '{}'.", (Object)segments[0], (Object)segments[1]);
            return false;
        }
        HashMap<Integer, Long> lsnByRegion = new HashMap<Integer, Long>();
        for (int i = 2; i < segments.length; ++i) {
            String regionSegment = segments[i];
            String[] regionIdWithLsn = StringUtils.split(regionSegment, '=');
            if (regionIdWithLsn.length != 2) {
                logger.warn("Unexpected region progress segment length '{}' in session token.", (Object)regionIdWithLsn.length);
                return false;
            }
            Utils.ValueHolder<Integer> regionId = Utils.ValueHolder.initialize(0);
            Utils.ValueHolder<Long> localLsn = Utils.ValueHolder.initialize(-1L);
            if (!VectorSessionToken.tryParseInt(regionIdWithLsn[0], regionId) || !VectorSessionToken.tryParseLong(regionIdWithLsn[1], localLsn)) {
                logger.warn("Unexpected region progress '{}' for region '{}' in session token.", (Object)regionIdWithLsn[0], (Object)regionIdWithLsn[1]);
                return false;
            }
            lsnByRegion.put((Integer)regionId.v, (Long)localLsn.v);
        }
        localLsnByRegion.v = (UnmodifiableMap)UnmodifiableMap.unmodifiableMap(lsnByRegion);
        return true;
    }

    public static boolean tryParseLong(String str, Utils.ValueHolder<Long> value) {
        try {
            value.v = Long.parseLong(str);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean tryParseInt(String str, Utils.ValueHolder<Integer> value) {
        try {
            value.v = Integer.parseInt(str);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }
}

