/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation;

import com.azure.cosmos.implementation.DataType;
import com.azure.cosmos.implementation.Index;
import com.azure.cosmos.implementation.IndexKind;
import com.azure.cosmos.implementation.apachecommons.lang.StringUtils;
import com.fasterxml.jackson.databind.node.ObjectNode;

public final class RangeIndex
extends Index {
    RangeIndex(DataType dataType) {
        super(IndexKind.RANGE);
        this.setDataType(dataType);
    }

    RangeIndex(DataType dataType, int precision) {
        super(IndexKind.RANGE);
        this.setDataType(dataType);
        this.setPrecision(precision);
    }

    public RangeIndex(String jsonString) {
        super(jsonString, IndexKind.RANGE);
        if (this.getDataType() == null) {
            throw new IllegalArgumentException("The jsonString doesn't contain a valid 'dataType'.");
        }
    }

    RangeIndex(ObjectNode objectNode) {
        super(objectNode, IndexKind.RANGE);
        if (this.getDataType() == null) {
            throw new IllegalArgumentException("The jsonString doesn't contain a valid 'dataType'.");
        }
    }

    public DataType getDataType() {
        DataType result = null;
        try {
            result = DataType.valueOf(StringUtils.upperCase(super.getString("dataType")));
        }
        catch (IllegalArgumentException e) {
            super.getLogger().warn("INVALID index dataType value {}.", (Object)super.getString("dataType"));
        }
        return result;
    }

    public RangeIndex setDataType(DataType dataType) {
        super.set("dataType", dataType.toString());
        return this;
    }

    public int getPrecision() {
        return super.getInt("precision");
    }

    public RangeIndex setPrecision(int precision) {
        super.set("precision", precision);
        return this;
    }

    boolean hasPrecision() {
        return super.has("precision");
    }
}

