/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation;

import java.util.HashMap;
import java.util.Map;

public enum OperationKind {
    CREATE("create"),
    DELETE("delete"),
    REPLACE("replace"),
    UPDATE("update"),
    UNKNOWN("unknown");

    private final String stringValue;
    private static Map<String, OperationKind> operationKindHashMap;

    private OperationKind(String stringValue) {
        this.stringValue = stringValue;
    }

    static OperationKind fromServiceSerializedFormat(String operationKind) {
        OperationKind operationKindEnum = operationKindHashMap.get(operationKind);
        if (operationKindEnum == null) {
            operationKindEnum = UNKNOWN;
        }
        return operationKindEnum;
    }

    public String toString() {
        return this.stringValue;
    }

    static {
        operationKindHashMap = new HashMap<String, OperationKind>();
        for (OperationKind cl : OperationKind.values()) {
            operationKindHashMap.put(cl.toString(), cl);
        }
    }
}

