'use strict';(function(){angular.module(clearreportsApp.name).controller("pdfViewerController",["$scope","$rootScope","pdfviewer","pdfviewerFactory","$timeout","moduleHeader","dataservice","errorservice","dialogservice","$compile","$window",function($scope,$rootScope,$pdfviewer,pdfviewerFactory,$timeout,moduleHeader,dataservice,errorservice,dialogservice,$compile,$window){$scope.$pdfviewer=$pdfviewer;$scope.$pdfviewer.viewer=$("#__pdfviewer");$scope.$pdfviewer.container=$("#pdfjsContainer");$scope.$pdfviewer.containerViewer=
$("#pdfjsViewer");$scope.$pdfviewer.scrollPane=$scope.$pdfviewer.container;$scope.$pdfviewer.model.isEmbeddedMode=$($window.document).find("html").hasClass("embedded")||(window.pdfviewer.PROPS.pdfviewer||{}).isEmbedded;let pdfViewerInfo=window.pdfviewer.PROPS.pdfviewer;if(pdfViewerInfo){$scope.$pdfviewer.model.canReload=pdfViewerInfo.canReload!==undefined?pdfViewerInfo.canReload:true;$scope.$pdfviewer.model.canOpen=pdfViewerInfo.canOpen!==undefined?pdfViewerInfo.canOpen:true;$scope.$pdfviewer.model.canSave=
pdfViewerInfo.canSave!==undefined?pdfViewerInfo.canSave:true;$scope.$pdfviewer.model.hasInfo=pdfViewerInfo.hasInfo!==undefined?pdfViewerInfo.hasInfo:true}if(!$scope.$pdfviewer.model.isEmbeddedMode)moduleHeader.setNavigationFullWidthComponent("\x3cpdf-viewer-menubar\x3e\x3c/pdf-viewer-menubar\x3e");var pdfjsViewer=window.pdfjsViewer;$pdfviewer.viewer.eventBus=new pdfjsViewer.EventBus;$pdfviewer.viewer.linkService=new pdfjsViewer.PDFLinkService({eventBus:$pdfviewer.viewer.eventBus,externalLinkTarget:pdfjsViewer.LinkTarget.BLANK});
$pdfviewer.viewer.findController=new pdfjsViewer.PDFFindController({eventBus:$pdfviewer.viewer.eventBus,linkService:$pdfviewer.viewer.linkService});var rebuildPDFViewer=function(){$pdfviewer.viewer.pdfViewer=new pdfjsViewer.PDFViewer({container:$scope.$pdfviewer.container[0],eventBus:$pdfviewer.viewer.eventBus,linkService:$pdfviewer.viewer.linkService,findController:$pdfviewer.viewer.findController});$pdfviewer.viewer.linkService.setViewer($pdfviewer.viewer.pdfViewer)};rebuildPDFViewer();var setStatus=
function(progress){if(progress==undefined){dataservice.updateProgressState(undefined);return}dataservice.updateProgressState({progress:progress,subMessage:$rootScope.getMsg("pdfviewer.loadingProgress")})};$scope.checkProgress=undefined;var checkProgress=function(){var promise=(new Promise(function(resolve,reject){if($pdfviewer.model.isPDFFile){reject();return}$scope.checkProgress=$timeout(function(){errorservice.clearErrorContent("#__pdferror");dataservice.execute("",{url:$pdfviewer.model.baseUrl+
"\x26cmd\x3dstatus",encrypt:false,alertSelector:"#__pdferror",handleSuccess:function(response){response=JSON.parse(response);setStatus(response.progress);if(response.state=="NO_CACHE_ENTRY")reject();else if(response.progress>=100)resolve();else checkProgress().then(resolve)}})},1E3)})).finally(setStatus);return promise};var pagesInitEvent=function(){$pdfviewer.PDF_CSS_UNIT=$pdfviewer.PDF_CSS_UNIT||pdfviewerFactory.initPDFCSStoPDFUnits();$pdfviewer.viewer.find("div.page").each(function(_i,elem){(Object.getOwnPropertyDescriptor(elem,
"offsetParent")||{configurable:true}).configurable&&Object.defineProperty(elem,"offsetParent",{set:$.noop,get:function(){return{}}})});$pdfviewer.viewer.pdfViewer.currentScaleValue=$pdfviewer.getScale()/$pdfviewer.PDF_CSS_UNIT;setStatus(undefined);dataservice.hideWaitingOverlay();$pdfviewer.model.isLoading=false};var pageRenderedEvent=function(pdfPageView){pdfviewerFactory.getPageScrollObserver().observe(pdfPageView.source.div)};var textLayerRenderedEvent=function(pdfPageView){$compile(pdfPageView.source.annotationLayer.div)($scope)};
var loadPDFFile=function(pdfFile,password){$pdfviewer.model.pdfFile=pdfFile;$pdfviewer.model.pdfPassword=password||$pdfviewer.model.pdfPassword;$scope.loadingTask=window.pdfjsLib.getDocument({url:pdfFile,httpHeaders:{"accept":"application/pdf, application/error-json"},withCredentials:{},password:$pdfviewer.model.pdfPassword});$scope.loadingTask.promise.then(function(pdf){$pdfviewer.viewer.pdfViewer.setDocument(pdf);$pdfviewer.viewer.linkService.setDocument(pdf);$pdfviewer.viewer.eventBus.on("pagesinit",
pagesInitEvent);$pdfviewer.viewer.eventBus.on("pagerendered",pageRenderedEvent);$pdfviewer.viewer.eventBus.on("textlayerrendered",textLayerRenderedEvent);$timeout(function(){$pdfviewer.model.pdf=pdf;pdf.getOutline().then(pdfviewerFactory.buildGroupTree);pdf.getMetadata().then(function(info){$pdfviewer.model.info=info})})}).catch(function(error){if(error.name==="PasswordException"){var functionScope=$scope.$new(true);functionScope.value=$pdfviewer.model.pdfPassword;functionScope.valuePlaceholder=$rootScope.getMsg("pdfviewer.password.placeholder");
functionScope.valueType="password";var callback=function(isOk){isOk===DIALOGSERVICE.OK&&loadPDFFile(pdfFile,functionScope.value)};switch(error.code){case window.pdfjsLib.PasswordResponses.INCORRECT_PASSWORD:functionScope.errormsg=$rootScope.getMsg("pdfviewer.password.wrong");case window.pdfjsLib.PasswordResponses.NEED_PASSWORD:dialogservice.showInputBox($scope.$pdfviewer.viewer,$rootScope.getMsg("pdfviewer.password.protected.header"),$rootScope.getMsg("pdfviewer.password.protected.body"),DIALOGSERVICE.INFORMATION_MESSAGE,
DIALOGSERVICE.OK_CANCEL_OPTION,callback,functionScope,undefined,true);return}}dataservice.execute("",{url:pdfFile,encrypt:false,handleSuccess:function(){errorservice.showerrorcontent(error.message)},handleError:function(innerError){innerError=innerError?JSON.parse(innerError.json)||JSON.stringify(innerError):error.message;errorservice.showerrorcontent(innerError||error.message,"#__pdferror")}})}).finally(function(){$timeout(function(){$timeout.cancel($scope.checkProgress);dataservice.hideWaitingOverlay();
$pdfviewer.model.isLoading=false})})};$scope.$watch("$window.pdfviewer.PROMPT",function(newPrompts,oldPrompts){if(newPrompts===oldPrompts)return;$scope.loadPDF()});$scope.$watch("$window.pdfviewer.PROPS.vgen",function(newVgen,oldVgen){if(newVgen===oldVgen||!oldVgen)return;$pdfviewer.model.pdf&&$pdfviewer.model.pdf.destroy();$pdfviewer.viewer.eventBus.off("pagerendered",pageRenderedEvent);$pdfviewer.viewer.eventBus.off("textlayerrendered",textLayerRenderedEvent);$pdfviewer.viewer.eventBus.off("pagesinit",
pagesInitEvent);$window.pdfviewer.PROPS.promptonrefresh=$pdfviewer.model.promptOnRefresh===true?true:undefined;$pdfviewer.setInitialModel();$scope.loadPDF(newVgen)});$scope.loadPDF=function(vgen){dataservice.showWaitingOverlay();$pdfviewer.model.isLoading=true;$pdfviewer.model.isPDFFile=$window.pdfviewer.PROPS.pdffile!==undefined;var properties=null;if(!$pdfviewer.model.isPDFFile){properties=$window.pdfviewer.PROPS;properties["vgen"]=vgen||(new Date).getTime()}var baseURL=$pdfviewer.model.baseUrl=
pdfviewerFactory.getBaseURL(properties,$pdfviewer.model.isPDFFile?"pdfviewer":null);if($pdfviewer.model.isPDFFile){loadPDFFile(baseURL+"\x26method\x3dpdfviewer.download");return}$pdfviewer.model.baseUrl+="\x26export_fmt\x3dpdf";errorservice.clearErrorContent("#__pdferror");dataservice.execute("",{url:baseURL+"\x26cmd\x3dstart\x26export_fmt\x3dpdfviewer",encrypt:false,handleSuccess:function(response){var data=extractJson(response);$pdfviewer.model.needsPrompts=!!data.needsPrompts;delete $window.pdfviewer.PROPS.promptonrefresh;
if(data.needsPrompts){dataservice.hideWaitingOverlay();$pdfviewer.model.isLoading=false;return}checkProgress().then(function(){loadPDFFile($pdfviewer.model.baseUrl)})},afterError:function(){dataservice.hideWaitingOverlay();$pdfviewer.model.isLoading=false}})};$timeout($scope.loadPDF);$scope.$watch("$pdfviewer.model.baseUrl",function(newBaseUrl,oldBaseUrl){if(newBaseUrl===oldBaseUrl)return;let urlParams=new URLSearchParams((new URL(newBaseUrl)).search);$pdfviewer.model.report=urlParams.get("report")})}]);
angular.module(clearreportsApp.name).controller("pdfViewerDetailsController",["$scope","pdfviewer",function($scope,pdfviewer){$scope.model=[];var keysToShow=["Title","Subject","Author","Producer","CreationDate","ModDate","PDFFormatVersion"];var getValue=function(key){var value=pdfviewer.model.info.info[key];return key.indexOf("Date")>0?__getDate(value).toLocaleString():value};var __getDate=function(date){if(!date||date.length<15||!date.startsWith("D:"))return date;date=date.substring(2);var year=
date.substring(0,4);var month=date.substring(4,6);var day=date.substring(6,8);var hour=date.substring(8,10);var minute=date.substring(10,12);var o=date.charAt(12);var second,offsetPos;if(o==="Z"||o==="+"||o==="-"){second="00";offsetPos=12}else{second=date.substring(12,14);offsetPos=14}var offset=date.substring(offsetPos).replaceAll("'","");return new Date(year+"-"+month+"-"+day+"T"+hour+":"+minute+":"+second+offset)};for(var i=0;i<keysToShow.length;i++)$scope.model.push({key:$scope.getMsg(keysToShow[i]),
value:getValue(keysToShow[i])})}])})();