/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfc.setupwizard;

import com.inet.classloader.BaseLocator;
import com.inet.classloader.I18nMessages;
import com.inet.file.CombinedFileDescription;
import com.inet.file.FileCombiner;
import com.inet.pdfc.PDFCLicenseChecker;
import com.inet.pdfc.setupwizard.steps.license.b;
import com.inet.pdfc.setupwizard.steps.plugin.a;
import com.inet.permissions.Permission;
import com.inet.plugin.PluginInfo;
import com.inet.plugin.ServerPlugin;
import com.inet.plugin.ServerPluginManager;
import com.inet.plugin.fs.FileResourceFile;
import com.inet.plugin.fs.ResourceFile;
import com.inet.setupwizard.api.SetupLogger;
import com.inet.setupwizard.api.SetupStep;
import com.inet.setupwizard.api.SetupStepsExecutionListener;
import com.inet.setupwizard.basicsteps.defaultwebserver.newinstallation.DefaultWebServerStep;
import com.inet.setupwizard.basicsteps.defaultwebserver.uninstaller.DefaultProxySettingsAndResourcesRemover;
import com.inet.setupwizard.basicsteps.defaultwebserver.update.DefaultUpdateWebServerStep;
import com.inet.setupwizard.basicsteps.license.LicenseStepConfigChecker;
import com.inet.setupwizard.basicsteps.license.TrialLicenseKeyProvider;
import com.inet.setupwizard.basicsteps.pam.PamExecutionListener;
import com.inet.setupwizard.basicsteps.pam.ShadowFileChecker;
import com.inet.setupwizard.basicsteps.permissions.init.SystemPermissionInitStep;
import com.inet.setupwizard.basicsteps.plugins.PluginActivationInformation;
import com.inet.setupwizard.basicsteps.webserver.ProxyConnectionRecognizer;
import com.inet.setupwizard.basicsteps.webserver.ProxySetupMetaDataInConfigurationIO;
import com.inet.setupwizard.basicsteps.webserver.ProxySetupMetaDataReader;
import com.inet.setupwizard.basicsteps.webserver.WebServerStepConfigurationUpdater;
import com.inet.setupwizard.basicsteps.webserver.WebServerStepInitialConfigurationCreator;
import com.inet.shared.servlet.PortChecker;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import javax.annotation.Nonnull;
import javax.annotation.SuppressFBWarnings;

@PluginInfo(id="pdfcsetupwizard", version="25.10.217", dependencies="setupwizard;pdfc", optionalDependencies="remotegui;webserver", group="system", flags="core")
public class PDFCSetupWizardPlugin
implements ServerPlugin {
    private final ProxySetupMetaDataInConfigurationIO a = new ProxySetupMetaDataInConfigurationIO();
    private ServerPluginManager b;
    public static final I18nMessages MSG = new I18nMessages("com.inet.pdfc.setupwizard.steps.i18n.Translations", PDFCSetupWizardPlugin.class);

    public void registerExtension(ServerPluginManager spm) {
        CombinedFileDescription combinedFileDescription;
        FileCombiner.CombinedFile combinedFile;
        this.b = spm;
        if (!"pdfc.standalone".equals(spm.getCorePluginId())) {
            this.a((SetupStep<?>)new b(new LicenseStepConfigChecker(), new TrialLicenseKeyProvider(){

                public String tryToDownloadTrialLicenseKey() {
                    try {
                        return PDFCLicenseChecker.requestTrialKeyAndWait((boolean)true);
                    }
                    catch (IOException iOException) {
                        SetupLogger.LOGGER.warn((Object)"Cannot load a trial license");
                        SetupLogger.LOGGER.warn((Object)iOException);
                        return null;
                    }
                }
            }));
            this.a((SetupStep<?>)new SystemPermissionInitStep(new Permission[]{Permission.valueOfExistingOrCreate((String)"comparisongui")}));
            if (spm.isPluginLoaded("webserver")) {
                combinedFile = new PortChecker();
                combinedFileDescription = new ProxyConnectionRecognizer();
                WebServerStepInitialConfigurationCreator webServerStepInitialConfigurationCreator = new WebServerStepInitialConfigurationCreator((ProxyConnectionRecognizer)combinedFileDescription, "pdfc");
                WebServerStepConfigurationUpdater webServerStepConfigurationUpdater = new WebServerStepConfigurationUpdater(webServerStepInitialConfigurationCreator, (ProxySetupMetaDataReader)this.a, (PortChecker)combinedFile);
                Path path = this.a();
                this.a((SetupStep<?>)new DefaultWebServerStep(path, (PortChecker)combinedFile, webServerStepConfigurationUpdater, (ProxySetupMetaDataReader)new ProxySetupMetaDataInConfigurationIO()));
                this.a((SetupStep<?>)new DefaultUpdateWebServerStep(path));
                spm.register(SetupStepsExecutionListener.class, (Object)new PamExecutionListener(new ShadowFileChecker(), "pdfc", "pdfc-server"));
            }
        }
        if (spm.isPluginLoaded("remotegui")) {
            combinedFile = new FileCombiner.CombinedFile("application/x-javascript; charset=utf-8", new URL[0]);
            combinedFile.addMessages(MSG);
            combinedFileDescription = new CombinedFileDescription("remotegui", "setupWizardCore.js", combinedFile);
            spm.register(CombinedFileDescription.class, (Object)combinedFileDescription);
        }
        spm.register(PluginActivationInformation.class, (Object)new a());
    }

    private void a(SetupStep<?> setupStep) {
        this.b.register(SetupStep.class, setupStep);
    }

    @Nonnull
    @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"}, justification="No user input is used")
    private Path a() {
        ResourceFile resourceFile = BaseLocator.getBaseDirectory();
        String string = resourceFile instanceof FileResourceFile ? resourceFile.getAbsolutePath() : "";
        return Paths.get(string, new String[0]).toAbsolutePath();
    }

    public void init(ServerPluginManager spm) {
    }

    public void reset() {
    }

    public void restart() {
    }

    public void uninstall(boolean isFullUninstall) {
        new DefaultProxySettingsAndResourcesRemover().removeProxySettingsAndResourcesIfNeeded(this.a(), (ProxySetupMetaDataReader)this.a);
    }
}

