/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfc.server;

import com.inet.classloader.I18nMessages;
import com.inet.config.ConfigKey;
import com.inet.config.ConfigValue;
import com.inet.config.ConfigurationManager;
import com.inet.config.ConfigurationMigrator;
import com.inet.config.provider.ConfigurationProvider;
import com.inet.config.structure.provider.ConfigStructureProvider;
import com.inet.error.ErrorCode;
import com.inet.file.CombinedFileDescription;
import com.inet.file.FileCombiner;
import com.inet.http.servlet.SessionStore;
import com.inet.id.GUID;
import com.inet.lib.util.StringFunctions;
import com.inet.logging.LogManager;
import com.inet.logging.SourceDescription;
import com.inet.logging.SourceFactory;
import com.inet.pdfc.plugin.persistence.PersistenceFactory;
import com.inet.pdfc.plugin.persistence.ProfilePersistenceManager;
import com.inet.pdfc.plugin.persistence.UserPersistenceManager;
import com.inet.pdfc.server.persistence.ContingentManager;
import com.inet.pdfc.server.setup.a;
import com.inet.pdfc.server.structure.PDFCCompareConfigProvider;
import com.inet.pdfc.server.structure.PDFCProfileStructureProvider;
import com.inet.pdfc.server.structure.b;
import com.inet.pdfc.server.structure.c;
import com.inet.pdfc.server.usersandgroups.d;
import com.inet.pdfc.thread.PdfcSession;
import com.inet.permissions.Permission;
import com.inet.permissions.SystemPermissionManager;
import com.inet.permissions.url.PluginPermissionChecker;
import com.inet.persistence.MaintenanceMode;
import com.inet.persistence.MaintenanceModeListener;
import com.inet.persistence.Persistence;
import com.inet.persistence.PersistenceListener;
import com.inet.plugin.HelpProviderContainer;
import com.inet.plugin.PluginInfo;
import com.inet.plugin.ServerPlugin;
import com.inet.plugin.ServerPluginManager;
import com.inet.plugin.ServerPluginManagerListener;
import com.inet.plugin.help.ConfigHelpProvider;
import com.inet.plugin.help.HelpProvider;
import com.inet.plugin.help.HelpProviderImpl;
import com.inet.plugin.veto.VetoType;
import com.inet.setupwizard.api.SetupStep;
import com.inet.setupwizard.basicsteps.plugins.PluginActivationInformation;
import com.inet.shared.statistics.api.table.TableData;
import com.inet.shared.statistics.eventlog.EventLogColumnDescription;
import com.inet.shared.statistics.eventlog.EventLogDescription;
import com.inet.usersandgroups.UsersAndGroups;
import com.inet.usersandgroups.api.FieldAndGroupTypeAssociation;
import com.inet.usersandgroups.api.UserField;
import com.inet.usersandgroups.api.UserGroupField;
import com.inet.usersandgroups.api.takeout.TakeoutDataProvider;
import com.inet.usersandgroups.api.ui.fields.PermissionPatcher;
import com.inet.usersandgroups.api.user.UserAccount;
import com.inet.usersandgroups.api.user.UserAccountScope;
import com.inet.usersandgroups.api.user.UserEventAdapter;
import com.inet.usersandgroups.api.user.UserEventListener;
import com.inet.usersandgroups.api.user.UserManager;
import java.io.IOException;
import java.net.URL;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ForkJoinPool;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@PluginInfo(id="pdfcserver", dependencies="pdfc", optionalDependencies="maintenance;statistics;theme;setupwizard", group="system;comparisons", packages="com.inet.pdfc.server;com.inet.pdfc.server.structure", version="25.10.314", flags="core", icon="com/inet/pdfc/server/structure/pdfcerver_48.png")
public class PDFCServerPlugin
implements ServerPlugin {
    public static final Permission PERMISSION_OWN_COMPARISONS;
    public static final Permission PERMISSION_PUBLISH;
    public static final ConfigKey COMPARISON_DELETE;
    public static final ConfigKey USER_DISCONNECT_TIME;
    public static final ConfigValue<Boolean> COMPARISON_DELETE_VALUE;
    public static final ConfigValue<Integer> USER_DISCONNECT_TIME_VALUE;
    private com.inet.pdfc.server.persistence.impl.b l;
    public static final I18nMessages MSG;
    public static final I18nMessages MSG_CLIENT;

    public void registerHelp(HelpProviderContainer container) {
        ConfigurationManager.getInstance().addConfigurationMigrator((ConfigurationMigrator)new com.inet.pdfc.server.persistence.a());
        container.add((HelpProvider)new HelpProviderImpl("introduction", 2000, new Permission[0]){}, new String[0]);
        container.add((HelpProvider)new ConfigHelpProvider("configuration", 2300, new Permission[]{Permission.CONFIGURATION}){}, new String[]{"configuration"});
        container.add((HelpProvider)new HelpProviderImpl("manuals", 2500, new Permission[0]){}, new String[0]);
        container.add((HelpProvider)new HelpProviderImpl("usersandgroupsmanager", 9203, new Permission[]{UsersAndGroups.PERMISSION_USERS_AND_GROUPS_MANAGER_ADMIN}){}, new String[0]);
    }

    public void registerExtension(ServerPluginManager spm) {
        FileCombiner.CombinedFile combinedFile;
        com.inet.pdfc.server.persistence.impl.file.b b2 = new com.inet.pdfc.server.persistence.impl.file.b(com.inet.pdfc.server.persistence.b.h());
        this.l = new com.inet.pdfc.server.persistence.impl.b(b2);
        Persistence.getInstance().registerListener((PersistenceListener)b2);
        spm.register(UserField.class, com.inet.pdfc.server.persistence.impl.b.Z);
        spm.register(UserField.class, com.inet.pdfc.server.persistence.impl.b.ac);
        spm.register(UserField.class, (Object)com.inet.pdfc.server.persistence.impl.b.USER_QUOTA_HDD);
        spm.register(UserField.class, (Object)com.inet.pdfc.server.persistence.impl.b.USER_QUOTA_COMPARISONS);
        spm.register(UserField.class, (Object)com.inet.pdfc.server.persistence.impl.b.USER_QUOTA_PAGES);
        spm.register(UserGroupField.class, (Object)com.inet.pdfc.server.persistence.impl.b.GROUP_QUOTA_COMPARISONS);
        spm.register(UserGroupField.class, (Object)com.inet.pdfc.server.persistence.impl.b.GROUP_QUOTA_HDD);
        spm.register(UserGroupField.class, (Object)com.inet.pdfc.server.persistence.impl.b.GROUP_QUOTA_PAGES);
        spm.register(FieldAndGroupTypeAssociation.class, (Object)new FieldAndGroupTypeAssociation(UsersAndGroups.GROUPTYPE_ADMIN, new String[]{ContingentManager.GROUP_QUOTA_COMPARISONS.getKey(), ContingentManager.GROUP_QUOTA_HDD.getKey(), ContingentManager.GROUP_QUOTA_PAGES.getKey()}));
        spm.register(FieldAndGroupTypeAssociation.class, (Object)new FieldAndGroupTypeAssociation(UsersAndGroups.GROUPTYPE_ALLUSERS, new String[]{ContingentManager.GROUP_QUOTA_COMPARISONS.getKey(), ContingentManager.GROUP_QUOTA_HDD.getKey(), ContingentManager.GROUP_QUOTA_PAGES.getKey()}));
        spm.register(FieldAndGroupTypeAssociation.class, (Object)new FieldAndGroupTypeAssociation(UsersAndGroups.GROUPTYPE_AUTH, new String[]{ContingentManager.GROUP_QUOTA_COMPARISONS.getKey(), ContingentManager.GROUP_QUOTA_HDD.getKey(), ContingentManager.GROUP_QUOTA_PAGES.getKey()}));
        spm.register(FieldAndGroupTypeAssociation.class, (Object)new FieldAndGroupTypeAssociation(UsersAndGroups.GROUPTYPE_STANDARD, new String[]{ContingentManager.GROUP_QUOTA_COMPARISONS.getKey(), ContingentManager.GROUP_QUOTA_HDD.getKey(), ContingentManager.GROUP_QUOTA_PAGES.getKey()}));
        spm.register(PermissionPatcher.class, (Object)new com.inet.pdfc.server.usersandgroups.a());
        spm.register(PluginPermissionChecker.class, (Object)new d());
        spm.register(PersistenceFactory.class, (Object)b2);
        spm.register(UserPersistenceManager.class, (Object)this.l);
        spm.register(ContingentManager.class, (Object)this.l);
        spm.register(ConfigStructureProvider.class, (Object)new c());
        spm.register(ConfigurationProvider.class, (Object)new PDFCCompareConfigProvider("/comparison"));
        spm.register(ConfigStructureProvider.class, (Object)new PDFCProfileStructureProvider());
        spm.register(ConfigStructureProvider.class, (Object)new b());
        spm.register(TakeoutDataProvider.class, (Object)new com.inet.pdfc.server.persistence.takeout.a());
        if (spm.isPluginLoaded("remotegui")) {
            combinedFile = new FileCombiner.CombinedFile("application/x-javascript; charset=utf-8", new URL[0]);
            combinedFile.add(this.getClass(), "/com/inet/pdfc/server/structure/compareconfigrenderer.js");
            combinedFile.addMessages(MSG_CLIENT);
            spm.register(CombinedFileDescription.class, (Object)new CombinedFileDescription("remotegui", "configAppExtras.js", combinedFile));
            combinedFile = new FileCombiner.CombinedFile("application/x-javascript; charset=utf-8", new URL[0]);
            combinedFile.addMessages(new I18nMessages("com.inet.pdfc.server.i18n.LanguageResources", (Object)this));
            spm.register(CombinedFileDescription.class, (Object)new CombinedFileDescription("remotegui", "remotegui.lib.js", combinedFile));
        }
        if (spm.isPluginLoaded("theme")) {
            com.inet.pdfc.server.theme.a.b(spm);
        }
        combinedFile = new FileCombiner.CombinedFile("text/css; charset=utf-8", new URL[0]);
        spm.register(CombinedFileDescription.class, (Object)new CombinedFileDescription("remotegui", 100, "defaulttheme.css", combinedFile));
        combinedFile.add(this.getClass(), "/com/inet/pdfc/server/theme/pdfcremote.css");
        FileCombiner.CombinedFile combinedFile2 = new FileCombiner.CombinedFile("image/png", new URL[0]);
        spm.register(CombinedFileDescription.class, (Object)new CombinedFileDescription("remotegui", 100, "pdfcbgleft.png", combinedFile2));
        combinedFile2.add(this.getClass(), "/com/inet/pdfc/server/theme/pdfcbgleft.png");
        FileCombiner.CombinedFile combinedFile3 = new FileCombiner.CombinedFile("image/png", new URL[0]);
        spm.register(CombinedFileDescription.class, (Object)new CombinedFileDescription("remotegui", 100, "pdfcbgright.png", combinedFile3));
        combinedFile3.add(this.getClass(), "/com/inet/pdfc/server/theme/pdfcbgright.png");
        spm.register(ServerPluginManagerListener.class, (Object)new ServerPluginManagerListener(){

            public void vetoFinished(@Nullable VetoType type) {
                if (type == null) {
                    PDFCServerPlugin.this.l.synchronizeToPersistence();
                }
            }
        });
        if (spm.isPluginLoaded("maintenance")) {
            MaintenanceMode.addListener((MaintenanceModeListener)new com.inet.pdfc.server.b());
        }
        if (spm.isPluginLoaded("statistics")) {
            spm.register(EventLogDescription.class, (Object)new EventLogDescription(){

                @Nonnull
                public String getExtensionName() {
                    return "comparisons";
                }

                @Nonnull
                public String getTitle() {
                    return MSG.getMsg("eventlog.title", new Object[0]);
                }

                @Nonnull
                protected List<EventLogColumnDescription> getColumns() {
                    List list = super.getColumns();
                    for (int k = 0; k < list.size(); ++k) {
                        if (((EventLogColumnDescription)list.get(k)).getKey() != "statistics.entry.eventlog.data") continue;
                        list.remove(k);
                        break;
                    }
                    list.add(3, new EventLogColumnDescription(MSG, "eventlog.ComparisonID", 258, 6){

                        public TableData.TableCell getCellValue(String[] line, @Nonnull Map states) {
                            String string = line[6];
                            String string2 = SessionStore.getRootURL();
                            if (string2 == null) {
                                string2 = "../";
                            }
                            String string3 = StringFunctions.isEmpty((String)string) ? null : string2 + "comparison/" + string;
                            return new TableData.TableCell((Comparable)((Object)string), string, string3);
                        }
                    });
                    return list;
                }
            });
        }
        if (spm.isPluginLoaded("setupwizard")) {
            spm.register(SetupStep.class, (Object)new com.inet.pdfc.server.usersandgroups.c());
            spm.register(SetupStep.class, (Object)new com.inet.pdfc.server.usersandgroups.b());
            spm.register(PluginActivationInformation.class, (Object)new a());
        }
    }

    public void init(ServerPluginManager spm) {
        ForkJoinPool.commonPool().execute(() -> {
            this.l.k();
            com.inet.pdfc.server.structure.a.aA().aB();
            ((ProfilePersistenceManager)spm.getSingleInstance(ProfilePersistenceManager.class)).addChangeListener((ProfilePersistenceManager.ProfilePersistenceChangeListener)this.l);
            UserManager.getRecoveryEnabledInstance().registerListener((UserEventListener)new UserEventAdapter(){

                public void userAccountBeforeDeleted(@Nonnull UserAccount userAccount) {
                    try (UserAccountScope userAccountScope = UserAccountScope.createPrivileged();){
                        PersistenceFactory persistenceFactory = (PersistenceFactory)ServerPluginManager.getInstance().getSingleInstance(PersistenceFactory.class);
                        List<GUID> list = PDFCServerPlugin.this.l.getComparisonIDsForUser(userAccount.getID(), null);
                        for (GUID gUID : list) {
                            try {
                                persistenceFactory.remove(gUID, true);
                            }
                            catch (IOException iOException) {
                                ErrorCode.throwAny((Throwable)iOException);
                            }
                        }
                    }
                }
            });
        });
    }

    public void reset() {
    }

    public void restart() {
    }

    static {
        Permission.createCategory((String)"comparison", (int)4000, PDFCServerPlugin.class);
        PERMISSION_OWN_COMPARISONS = SystemPermissionManager.add((String)"comparisonowner", (String)"comparison", null, (int)4299, (boolean)false, PDFCServerPlugin.class);
        PERMISSION_PUBLISH = SystemPermissionManager.add((String)"comparisonpublish", (String)"comparison", (String)"comparisonowner", (int)4300, (boolean)false, PDFCServerPlugin.class);
        COMPARISON_DELETE = new ConfigKey("pdfc.security.comparisondelete", "false", Boolean.class);
        USER_DISCONNECT_TIME = new ConfigKey("pdfc.security.disconnecttimer", "15", Integer.class);
        COMPARISON_DELETE_VALUE = new ConfigValue(COMPARISON_DELETE);
        USER_DISCONNECT_TIME_VALUE = new ConfigValue<Integer>(USER_DISCONNECT_TIME){

            protected void setValue(@Nullable String strValue) throws IllegalArgumentException {
                super.setValue(strValue);
                ServerPluginManager serverPluginManager = ServerPluginManager.getInstance();
                if (serverPluginManager.getState() == ServerPluginManager.ServerPluginManagerState.INIT) {
                    PersistenceFactory persistenceFactory;
                    int n = (Integer)this.get();
                    UserPersistenceManager userPersistenceManager = (UserPersistenceManager)serverPluginManager.getSingleInstance(UserPersistenceManager.class);
                    if (userPersistenceManager instanceof com.inet.pdfc.server.persistence.impl.b) {
                        ((com.inet.pdfc.server.persistence.impl.b)userPersistenceManager).a(n);
                    }
                    if ((persistenceFactory = (PersistenceFactory)serverPluginManager.getSingleInstance(PersistenceFactory.class)) instanceof com.inet.pdfc.server.persistence.impl.file.b) {
                        ((com.inet.pdfc.server.persistence.impl.file.b)persistenceFactory).a(n);
                    }
                }
            }
        };
        MSG = new I18nMessages("com.inet.pdfc.server.i18n.LanguageResources", PDFCServerPlugin.class);
        MSG_CLIENT = new I18nMessages("com.inet.pdfc.server.structure.i18n.LanguageResources", PDFCServerPlugin.class);
        LogManager.addSourceFactory((SourceFactory)new SourceFactory(){

            public SourceDescription getSourceDescription() {
                return new SourceDescription(){

                    public Object getSource() {
                        try {
                            return PdfcSession.getSession();
                        }
                        catch (IllegalStateException illegalStateException) {
                            return null;
                        }
                    }

                    public Properties getProperties() {
                        try {
                            PdfcSession pdfcSession = PdfcSession.getSession();
                            return pdfcSession.getSessionProperties();
                        }
                        catch (IllegalStateException illegalStateException) {
                            return new Properties();
                        }
                    }
                };
            }
        });
    }
}

