/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfc.server;

import com.inet.annotations.InternalApi;
import com.inet.pdfc.config.Settings;
import com.inet.pdfc.config.VisibilitySetting;
import com.inet.pdfc.plugin.persistence.ComparePersistence;
import com.inet.pdfc.presenter.BasePresenter;
import com.inet.pdfc.presenter.DifferencesPDFPresenter;
import com.inet.pdfc.presenter.DifferencesPNGPresenter;
import com.inet.pdfc.presenter.ExportFilePresenter;
import com.inet.pdfc.presenter.ReportPresenter;
import com.inet.pdfc.results.ResultModelUpdater;
import com.inet.pdfc.server.model.ExportSetting;
import java.io.IOException;
import java.io.OutputStream;

@InternalApi
public class ServerUtil {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void exportComparePersistence(ComparePersistence persistence, final OutputStream outputStream, ExportSetting exportSetting, Settings settings) throws IOException {
        ReportPresenter reportPresenter;
        Object object = null;
        switch (exportSetting.getExportFormat()) {
            case PDF: {
                object = new DifferencesPDFPresenter(){

                    protected OutputStream getExportStream() throws IOException {
                        return outputStream;
                    }
                };
                ((DifferencesPDFPresenter)object).setPassword(exportSetting.getOwnerPass());
                ((DifferencesPDFPresenter)object).setPagelayout(exportSetting.getPaperWidth(), exportSetting.getPaperHeight(), 10, 10, 10, 10);
                ((DifferencesPDFPresenter)object).setReplaceSystemFonts(exportSetting.isReplace());
                break;
            }
            case PNG: {
                object = new DifferencesPNGPresenter(null){

                    protected OutputStream getExportStream() throws IOException {
                        return outputStream;
                    }
                };
                ((DifferencesPNGPresenter)object).setSize(exportSetting.getPaperWidth(), exportSetting.getPaperHeight());
                break;
            }
            case REPORTODS: {
                object = new ReportPresenter(exportSetting.isReportDetailed(), exportSetting.isReportAppendSetting(), "ods", outputStream);
                break;
            }
            case REPORTPDF: {
                reportPresenter = new ReportPresenter(exportSetting.isReportDetailed(), exportSetting.isReportAppendSetting(), "pdf", outputStream);
                reportPresenter.setPassword(exportSetting.getOwnerPass());
                object = reportPresenter;
                break;
            }
            case REPORTRTF: {
                object = new ReportPresenter(exportSetting.isReportDetailed(), exportSetting.isReportAppendSetting(), "rtf", outputStream);
                break;
            }
            case REPORTXLS: {
                object = new ReportPresenter(exportSetting.isReportDetailed(), exportSetting.isReportAppendSetting(), "xls", outputStream);
                break;
            }
            case REPORTXLSX: {
                object = new ReportPresenter(exportSetting.isReportDetailed(), exportSetting.isReportAppendSetting(), "xlsx", outputStream);
                break;
            }
            default: {
                return;
            }
        }
        if (object instanceof ExportFilePresenter) {
            ((ExportFilePresenter)object).setPrintRange(exportSetting.getStartPage(), exportSetting.getEndPage());
            ((ExportFilePresenter)object).setPaintSides(exportSetting.getExportPage().getValue());
        }
        if ((reportPresenter = persistence.getResult()) != null) {
            boolean bl = settings.isEnabled((VisibilitySetting)Settings.EXPORT.ONLY_ON_DIFFERENCES);
            try {
                settings.setSetting((Object)-1, ResultModelUpdater.DIFF_LIMIT.name());
                settings.setEnabled(false, new VisibilitySetting[]{Settings.EXPORT.ONLY_ON_DIFFERENCES});
                persistence.executeImmediatelyPresenters(settings, new BasePresenter[]{object});
            }
            catch (Throwable throwable) {
                settings.setEnabled(bl, new VisibilitySetting[]{Settings.EXPORT.ONLY_ON_DIFFERENCES});
                throw throwable;
            }
            settings.setEnabled(bl, new VisibilitySetting[]{Settings.EXPORT.ONLY_ON_DIFFERENCES});
        }
    }

    public static String getFileName(ComparePersistence persistence, String suffix) throws IOException {
        Object object = persistence.getMetaProperty("title");
        if (object == null) {
            String string = persistence.getMetaProperty("first.name");
            String string2 = persistence.getMetaProperty("second.name");
            object = "PDFC - " + string + " - " + string2;
        }
        if (!((String)object).toLowerCase().endsWith(suffix)) {
            object = (String)object + suffix;
        }
        object = ((String)object).replace("\"", "");
        return object;
    }
}

