/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfc.server.structure;

import com.inet.config.structure.ConfigStructure;
import com.inet.config.structure.model.ConfigCategory;
import com.inet.config.structure.model.ConfigConditionAction;
import com.inet.config.structure.model.ConfigGroup;
import com.inet.config.structure.model.ConfigProperty;
import com.inet.config.structure.model.ConfigPropertyGroup;
import com.inet.config.structure.model.ConfigRowAction;
import com.inet.config.structure.model.ConfigValidationMsg;
import com.inet.config.structure.model.ItemListConfigProperty;
import com.inet.config.structure.model.UnitConfigProperty;
import com.inet.config.structure.provider.AbstractStructureProvider;
import com.inet.config.structure.provider.ConfigStructureSettings;
import com.inet.config.structure.provider.ConfigValidator;
import com.inet.lib.json.Json;
import com.inet.logging.LogManager;
import com.inet.pdfc.i18n.Msg;
import com.inet.pdfc.plugin.PluginManager;
import com.inet.pdfc.plugin.persistence.ProfilePersistence;
import com.inet.pdfc.plugin.persistence.ProfilePersistenceManager;
import com.inet.pdfc.server.persistence.ContingentManager;
import com.inet.pdfc.server.structure.CompareProfileEntry;
import com.inet.pdfc.server.structure.PDFCConfigKey;
import com.inet.plugin.DynamicExtensionManager;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class c
extends AbstractStructureProvider {
    public void addGroupsTo(@Nonnull Set<ConfigGroup> groups, boolean advanced, @Nonnull ConfigStructureSettings settings) {
    }

    public void addCategoriesTo(@Nonnull Set<ConfigCategory> categories, @Nonnull String groupKey, boolean advanced, @Nonnull ConfigStructureSettings settings) {
        switch (groupKey) {
            case "group.comparison": {
                categories.add(new ConfigCategory(400, "categorie.contingent", Msg.getMsg((String)"Settings.contingents"), "pdfc-contingents"));
                categories.add(new ConfigCategory(500, "category.profiles", this.translate(settings, "category.profiles", new Object[0]), "pdfc-profiles"));
                break;
            }
        }
    }

    public URL getCategoryIcon(@Nonnull String categoryKey) {
        switch (categoryKey) {
            case "categorie.contingent": {
                return ((Object)((Object)this)).getClass().getResource("quota_48.png");
            }
            case "category.profiles": {
                return ((Object)((Object)this)).getClass().getResource("profiles_48.png");
            }
        }
        return null;
    }

    public void addPropertyGroupsTo(@Nonnull Set<ConfigPropertyGroup> configPropertyGroups, @Nonnull String categoryKey, boolean advanced, @Nonnull ConfigStructureSettings settings) {
        switch (categoryKey) {
            case "categorie.contingent": {
                configPropertyGroups.add(new ConfigPropertyGroup(100, "group.contingent"));
                break;
            }
            case "category.profiles": {
                configPropertyGroups.add(new ConfigPropertyGroup(100, "group.profiles"));
                break;
            }
        }
    }

    public void addPropertiesTo(@Nonnull Set<ConfigProperty> configProperties, @Nonnull String propertyGroupKey, boolean advanced, @Nonnull ConfigStructureSettings settings) {
        switch (propertyGroupKey) {
            case "group.contingent": {
                configProperties.add(new ConfigProperty(1, ContingentManager.LIMITCOMPARISIONPERUSER.getKey(), this.getDefaultType(ContingentManager.LIMITCOMPARISIONPERUSER), Msg.getMsg((String)"Settings.contingent.comparision"), ContingentManager.CONTIGENT_COMPARISIONPERUSER.get(), Msg.getMsg((String)"Settings.contingent.tooltip.comparision"), "10"));
                ArrayList<UnitConfigProperty.Unit> arrayList = new ArrayList<UnitConfigProperty.Unit>();
                arrayList.add(new UnitConfigProperty.Unit(1.0, "MB"));
                arrayList.add(new UnitConfigProperty.Unit(9.765625E-4, "GB"));
                arrayList.add(new UnitConfigProperty.Unit(9.5367431640625E-7, "TB"));
                configProperties.add((ConfigProperty)new UnitConfigProperty(10, ContingentManager.LIMITHDD.getKey(), this.getDefaultType(ContingentManager.LIMITHDD), Msg.getMsg((String)"Settings.contingent.hdd"), ContingentManager.CONTIGENT_HDD.get(), Msg.getMsg((String)"Settings.contingent.tooltip.hdd"), arrayList, "500 MB"));
                configProperties.add(new ConfigProperty(100, ContingentManager.LIMITNUMOFPAGES.getKey(), this.getDefaultType(ContingentManager.LIMITNUMOFPAGES), Msg.getMsg((String)"Settings.contingent.numofpages"), ContingentManager.CONTIGENT_NUMOFPAGES.get(), Msg.getMsg((String)"Settings.contingent.tooltip.numofpages"), "5000"));
                break;
            }
            case "group.profiles": {
                ArrayList<CompareProfileEntry> arrayList = new ArrayList<CompareProfileEntry>();
                String string = settings.getValue(PDFCConfigKey.COMPARE_PROFILES_BLACKLIST);
                Set<String> set = new HashSet();
                CompareProfileEntry[] compareProfileEntryArray = (CompareProfileEntry[])settings.getChangedValue(PDFCConfigKey.COMPARE_PROFILES_BLACKLIST, CompareProfileEntry[].class);
                if (compareProfileEntryArray != null) {
                    for (CompareProfileEntry compareProfileEntry : compareProfileEntryArray) {
                        if (compareProfileEntry.isActive()) continue;
                        set.add(compareProfileEntry.getGuid());
                    }
                } else {
                    set = (Set)new Json().fromJson(string, HashSet.class);
                }
                List list = DynamicExtensionManager.getInstance().get(ProfilePersistence.class);
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    ProfilePersistence profilePersistence = (ProfilePersistence)iterator.next();
                    boolean bl = !set.contains(profilePersistence.getGUID().toString());
                    arrayList.add(new CompareProfileEntry(profilePersistence.getName(), profilePersistence.getDescription(true), profilePersistence.getGUID().toString(), bl));
                }
                configProperties.add((ConfigProperty)new ItemListConfigProperty(configProperties.size() * 100, PDFCConfigKey.COMPARE_PROFILES_BLACKLIST.getKey(), "compareconfig", this.translate(settings, "pdfc.compareprofiles.enable", new Object[0]), null, arrayList, null, new ConfigRowAction[0]));
                break;
            }
        }
    }

    public void validate(@Nullable String categoryKey, @Nonnull ArrayList<ConfigValidationMsg> messages, @Nonnull ArrayList<ConfigConditionAction> conditions, @Nonnull ConfigStructureSettings settings) {
        ConfigValidator configValidator = new ConfigValidator(messages, settings);
        if (categoryKey == null || categoryKey.equals("categorie.contingent")) {
            configValidator.validateNumberRange(ContingentManager.LIMITCOMPARISIONPERUSER, -1L, Integer.MAX_VALUE);
            configValidator.validateNumberRange(ContingentManager.LIMITHDD, -1L, Integer.MAX_VALUE);
            configValidator.validateNumberRange(ContingentManager.LIMITNUMOFPAGES, -1L, Integer.MAX_VALUE);
        }
        if ("category.profiles".equals(categoryKey)) {
            String string = settings.getValue(PDFCConfigKey.COMPARE_PROFILES_BLACKLIST);
            Set<String> set = new HashSet();
            ConfigValidationMsg configValidationMsg = (ConfigValidationMsg)settings.getChangedValue(PDFCConfigKey.COMPARE_PROFILES_BLACKLIST, CompareProfileEntry[].class);
            if (configValidationMsg != null) {
                for (Object object : configValidationMsg) {
                    if (((CompareProfileEntry)object).isActive()) continue;
                    set.add(((CompareProfileEntry)object).getGuid());
                }
            } else {
                set = (Set)new Json().fromJson(string, HashSet.class);
            }
            ConfigValidationMsg configValidationMsg2 = new ConfigValidationMsg(ConfigValidationMsg.Type.Invalid, this.translate(settings, "pdfc.compareprofiles.notempty", new Object[0]), PDFCConfigKey.COMPARE_PROFILES_BLACKLIST);
            List list = DynamicExtensionManager.getInstance().get(ProfilePersistence.class);
            for (Object object : list) {
                boolean bl = !set.contains(object.getGUID().toString());
                if (!bl) continue;
                return;
            }
            try {
                Object object;
                ProfilePersistenceManager profilePersistenceManager = (ProfilePersistenceManager)PluginManager.getSingleInstance(ProfilePersistenceManager.class);
                object = profilePersistenceManager.getAllProfiles(null);
                Iterator iterator = object.iterator();
                while (iterator.hasNext()) {
                    ProfilePersistence profilePersistence = (ProfilePersistence)iterator.next();
                    if (profilePersistence.getScope() != ProfilePersistence.SCOPE.PUBLIC) continue;
                    return;
                }
                messages.add(configValidationMsg2);
            }
            catch (IOException iOException) {
                LogManager.getConfigLogger().error((Throwable)iOException);
            }
        }
    }

    public ConfigStructure.SaveState save(String key, String value, @Nonnull ConfigStructureSettings settings) {
        if (key.equals(PDFCConfigKey.COMPARE_PROFILES_BLACKLIST.getKey())) {
            String string = settings.getOriginalValue(PDFCConfigKey.COMPARE_PROFILES_BLACKLIST);
            HashSet hashSet = (HashSet)new Json().fromJson(string, HashSet.class);
            CompareProfileEntry[] compareProfileEntryArray = (CompareProfileEntry[])settings.getChangedValue(PDFCConfigKey.COMPARE_PROFILES_BLACKLIST, CompareProfileEntry[].class);
            if (compareProfileEntryArray != null) {
                for (CompareProfileEntry compareProfileEntry : compareProfileEntryArray) {
                    if (compareProfileEntry.isActive()) {
                        hashSet.remove(compareProfileEntry.getGuid());
                        continue;
                    }
                    hashSet.add(compareProfileEntry.getGuid());
                }
            }
            settings.save(PDFCConfigKey.COMPARE_PROFILES_BLACKLIST, new Json().toJson((Object)hashSet));
            return ConfigStructure.SaveState.SAVE;
        }
        switch (key) {
            case "limitComparisionPerUser": {
                settings.save(ContingentManager.LIMITCOMPARISIONPERUSER, value.isEmpty() ? null : value);
                return ConfigStructure.SaveState.SAVE;
            }
            case "limitHDD": {
                settings.save(ContingentManager.LIMITHDD, value.isEmpty() ? null : value);
                return ConfigStructure.SaveState.SAVE;
            }
            case "limitPages": {
                settings.save(ContingentManager.LIMITNUMOFPAGES, value.isEmpty() ? null : value);
                return ConfigStructure.SaveState.SAVE;
            }
        }
        return ConfigStructure.SaveState.NONE;
    }
}

