/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfc.server.persistence.impl.file;

import com.inet.annotations.JsonData;
import com.inet.authentication.AccessForbiddenException;
import com.inet.cache.InetSerializable;
import com.inet.cache.MemoryStoreMap;
import com.inet.cache.PersistenceKey;
import com.inet.cache.PersistenceStoreMap;
import com.inet.cache.internal.AbstractMap;
import com.inet.cache.internal.MemoryObserver;
import com.inet.error.ErrorCode;
import com.inet.http.ClientMessageException;
import com.inet.id.GUID;
import com.inet.lib.json.Bon;
import com.inet.lib.json.Json;
import com.inet.lib.util.IOFunctions;
import com.inet.lib.util.StringFunctions;
import com.inet.pdfc.PDFCCore;
import com.inet.pdfc.config.ArrayPdfSource;
import com.inet.pdfc.config.DefaultProfile;
import com.inet.pdfc.config.DefaultSetting;
import com.inet.pdfc.config.IProfile;
import com.inet.pdfc.config.PdfSource;
import com.inet.pdfc.config.Settings;
import com.inet.pdfc.config.SettingsControl;
import com.inet.pdfc.config.SourceProfile;
import com.inet.pdfc.config.StorageEntryPdfSource;
import com.inet.pdfc.error.ExceptionData;
import com.inet.pdfc.error.ExceptionDataFactory;
import com.inet.pdfc.error.PdfcException;
import com.inet.pdfc.generator.DataGeneratorListener;
import com.inet.pdfc.generator.message.Chunk;
import com.inet.pdfc.generator.message.ErrorData;
import com.inet.pdfc.generator.message.HighlightData;
import com.inet.pdfc.generator.message.InfoData;
import com.inet.pdfc.generator.message.PageDataImpl;
import com.inet.pdfc.generator.message.PageFilterDone;
import com.inet.pdfc.generator.message.PageReadDone;
import com.inet.pdfc.generator.message.PartialDiffs;
import com.inet.pdfc.generator.message.ProgressState;
import com.inet.pdfc.generator.message.State;
import com.inet.pdfc.generator.model.DiffGroup;
import com.inet.pdfc.generator.model.Modification;
import com.inet.pdfc.generator.rendercache.PageImageCache;
import com.inet.pdfc.generator.rendercache.PdfcRenderCache;
import com.inet.pdfc.i18n.Msg;
import com.inet.pdfc.model.Document;
import com.inet.pdfc.model.EnumerationProgress;
import com.inet.pdfc.pagegraphics.PageGraphicsData;
import com.inet.pdfc.persistence.UserSettingsImpl;
import com.inet.pdfc.plugin.DocumentReader;
import com.inet.pdfc.plugin.PluginManager;
import com.inet.pdfc.plugin.interfaces.CompareRunner;
import com.inet.pdfc.plugin.interfaces.DocumentFactory;
import com.inet.pdfc.plugin.persistence.ComparePersistence;
import com.inet.pdfc.plugin.persistence.CompareState;
import com.inet.pdfc.plugin.persistence.PersistenceFactory;
import com.inet.pdfc.plugin.persistence.PersistenceObserver;
import com.inet.pdfc.plugin.persistence.ProfilePersistence;
import com.inet.pdfc.plugin.persistence.ProfilePersistenceManager;
import com.inet.pdfc.plugin.persistence.QuotaExceededException;
import com.inet.pdfc.plugin.persistence.TextSearchHandler;
import com.inet.pdfc.plugin.persistence.UserPersistenceManager;
import com.inet.pdfc.plugin.persistence.UserSession;
import com.inet.pdfc.plugin.persistence.UserState;
import com.inet.pdfc.presenter.BasePresenter;
import com.inet.pdfc.results.CollapsePagesModelData;
import com.inet.pdfc.results.ResultModel;
import com.inet.pdfc.results.ResultModelData;
import com.inet.pdfc.results.ResultModelUpdater;
import com.inet.pdfc.results.ResultPage;
import com.inet.pdfc.results.TextSelectionUtil;
import com.inet.pdfc.results.filter.ResultFilter;
import com.inet.pdfc.server.PDFCServerPlugin;
import com.inet.pdfc.server.persistence.ContingentManager;
import com.inet.pdfc.server.persistence.impl.file.ResultModelContainer;
import com.inet.pdfc.server.persistence.impl.file.VersionSerializable;
import com.inet.pdfc.server.persistence.impl.file.h;
import com.inet.pdfc.server.persistence.impl.file.i;
import com.inet.pdfc.server.persistence.impl.file.j;
import com.inet.pdfc.textselection.TextInfo;
import com.inet.pdfc.thread.PdfcSession;
import com.inet.permissions.AccessDeniedException;
import com.inet.permissions.Permission;
import com.inet.permissions.SystemPermissionChecker;
import com.inet.persistence.MaintenanceMode;
import com.inet.persistence.Persistence;
import com.inet.persistence.PersistenceEntry;
import com.inet.persistence.RandomAccessRead;
import com.inet.persistence.StorageEntry;
import com.inet.persistence.crypto.Crypto;
import com.inet.persistence.crypto.CryptoAlgorithm;
import com.inet.persistence.crypto.EncryptionData;
import com.inet.persistence.file.FilePersistence;
import com.inet.persistence.file.FileRandomAccessRead;
import com.inet.plugin.ApplicationDescription;
import com.inet.plugin.ServerPluginManager;
import com.inet.search.SuggestedValue;
import com.inet.shared.utils.Version;
import com.inet.thread.BaseRunnableSession;
import com.inet.thread.RunnableSession;
import com.inet.thread.ServerLock;
import com.inet.thread.SessionLocator;
import com.inet.thread.ThreadPool;
import com.inet.thread.timer.DefaultTimer;
import com.inet.thread.timer.DefaultTimerTask;
import com.inet.usersandgroups.UsersAndGroups;
import com.inet.usersandgroups.api.groups.UserGroupManager;
import com.inet.usersandgroups.api.ui.Type;
import com.inet.usersandgroups.api.user.UserAccount;
import com.inet.usersandgroups.api.user.UserAccountScope;
import com.inet.usersandgroups.api.user.UserAccountType;
import com.inet.usersandgroups.api.user.UserManager;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.SuppressFBWarnings;

public class CoreComparePersistence
implements ComparePersistence {
    private final Object aR;
    private final Object aS;
    private final Object aT;
    static final PersistenceKey aU = PersistenceKey.create((String)"resultmodel");
    static final PersistenceKey aV = PersistenceKey.create((String)"version");
    private GUID ownerID;
    private ComparePersistence.PUBLICATION_MODE aW;
    private PersistenceEntry aX;
    private GUID aY;
    private ResultModel aZ;
    private ResultModelUpdater ba;
    private f bb;
    private CompareState bc;
    private CompareState bd;
    private CompareState be;
    private com.inet.pdfc.server.persistence.impl.file.a bf;
    private PdfcSession bg;
    private CompareRunner bh;
    private CompletableFuture<ResultModel> bi;
    private long bj;
    private char[] bk;
    private char[] bl;
    private URL bm;
    private URL bn;
    private PersistencePdfSource bo;
    private PersistencePdfSource bp;
    private List<PersistenceObserver> aC;
    private ContingentManager bq;
    private long br;
    private int bs;
    private PersistenceObserver bt;
    private ThreadLocal<Boolean> bu;
    private DefaultTimerTask bv;
    private Set<ComparePersistence.UserOrGroup> bw;
    private com.inet.pdfc.server.persistence.impl.file.g bx;
    private com.inet.pdfc.server.persistence.impl.file.f by;
    private h bz;
    private TextSearchHandler bA;
    private com.inet.pdfc.server.persistence.impl.file.c bB;
    private j bC;

    @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"}, justification="Path is based on the selected persistence of the server and thus cannot be manipulated by any user or user input")
    CoreComparePersistence(PersistenceEntry rootFolder, GUID compareID, GUID ownerID) throws IOException, IllegalArgumentException {
        Object object;
        Object object2;
        block40: {
            block41: {
                Object object3;
                Object object4;
                Object object5;
                block36: {
                    block39: {
                        this.aR = new Object();
                        this.aS = new Object();
                        this.aT = new Object();
                        this.aW = ComparePersistence.PUBLICATION_MODE.none;
                        this.bb = new f();
                        this.bj = -1L;
                        this.bk = null;
                        this.bl = null;
                        this.bm = null;
                        this.bn = null;
                        this.bo = null;
                        this.bp = null;
                        this.aC = new ArrayList<PersistenceObserver>();
                        this.bu = new ThreadLocal();
                        this.bv = null;
                        this.bw = new HashSet<ComparePersistence.UserOrGroup>();
                        this.aY = compareID;
                        this.aX = rootFolder;
                        this.bf = new com.inet.pdfc.server.persistence.impl.file.a(this);
                        this.bB = new com.inet.pdfc.server.persistence.impl.file.c(rootFolder, this);
                        this.bC = new j(rootFolder, this);
                        if (this.bB.as()) break block39;
                        if (ownerID == null) {
                            throw new IllegalArgumentException("Cannot create a persistence without an owner. (for GUID " + String.valueOf(compareID) + ")");
                        }
                        this.ownerID = ownerID;
                        this.bB.b("owner.id", String.valueOf(ownerID));
                        this.bB.b("created", String.valueOf(System.currentTimeMillis()));
                        this.bB.b("modified", String.valueOf(System.currentTimeMillis()));
                        this.bB.au();
                        this.bc = new CompareState();
                        break block40;
                    }
                    this.br = -1L;
                    object2 = this.bB.getProperty("owner.id");
                    if (object2 == null) {
                        throw new IllegalStateException("Comparison " + String.valueOf(compareID) + " appears to be corrupt as it has no ownerID.");
                    }
                    try {
                        this.ownerID = GUID.generateFor((int)Integer.parseInt((String)object2));
                        this.bB.c("owner.id", this.ownerID.toString());
                    }
                    catch (NumberFormatException numberFormatException) {
                        this.ownerID = GUID.valueOf((String)object2);
                        if (ownerID != null && !ownerID.equals((Object)this.ownerID)) {
                            throw new IllegalStateException("Comparison " + String.valueOf(compareID) + " appears to be corrupt as it has a clash in the owner ID.");
                        }
                        if (this.ownerID == null) {
                            throw new IllegalStateException("Comparison " + String.valueOf(compareID) + " appears to be corrupt as it has no valid owner ID.");
                        }
                        object5 = UserManager.getRecoveryEnabledInstance().getUserAccount(this.ownerID);
                        if (object5 != null) break block36;
                        throw new IllegalStateException("Comparison " + String.valueOf(compareID) + " appears to be corrupt as it has a clash in the owner ID.");
                    }
                }
                this.aW = ComparePersistence.PUBLICATION_MODE.getMode((String)this.bB.getProperty("share.mode"));
                if (this.aW != ComparePersistence.PUBLICATION_MODE.none && (object = this.bB.getProperty("share.groups")) != null) {
                    block37: {
                        try {
                            this.bw = (Set)new Json().fromJson((String)object, c.class);
                        }
                        catch (Exception exception) {
                            PDFCCore.LOGGER_CORE.error((Object)("Unable to read share groups for comparison " + String.valueOf(compareID) + ": " + exception.getMessage()));
                            if (this.aW != ComparePersistence.PUBLICATION_MODE.persistent_hidden) break block37;
                            this.bw.add(new ComparePersistence.UserOrGroup(Type.group, UsersAndGroups.GROUPID_ALLUSERS));
                            this.bB.c("share.groups", new Json().toJson(this.bw));
                        }
                    }
                    if (this.bw != null && !this.bw.isEmpty() && (object5 = this.bw.stream().findAny().get()) instanceof String) {
                        object4 = new c();
                        for (Object e2 : this.bw) {
                            ((HashSet)object4).add(new ComparePersistence.UserOrGroup(Type.group, new GUID(e2.toString())));
                        }
                        this.bw = object4;
                        object3 = new Json().toJson(this.bw);
                        this.bB.b("share.groups", (String)object3);
                        this.bB.au();
                    }
                }
                this.bb.b(this.e(true).size());
                this.bb.b(this.e(false).size());
                this.bm = this.a(true);
                this.bn = this.a(false);
                object = rootFolder.resolve("compare.state");
                object5 = object.getBytes();
                if (object5 == null) break block41;
                try {
                    object4 = new ByteArrayInputStream((byte[])object5);
                    try {
                        this.bc = (CompareState)new Bon().fromBinary((InputStream)object4, CompareState.class);
                    }
                    finally {
                        ((InputStream)object4).close();
                    }
                }
                catch (Throwable throwable) {
                    try {
                        object3 = new ByteArrayInputStream((byte[])object5);
                        try {
                            this.bc = (CompareState)new Json().fromJson((InputStream)object3, CompareState.class);
                        }
                        finally {
                            ((InputStream)object3).close();
                        }
                    }
                    catch (Throwable throwable2) {
                        PDFCCore.LOGGER_CORE.warn((Object)("Unable to parse state data in persistence " + String.valueOf(this.getGUID())));
                        PDFCCore.LOGGER_CORE.warn((Object)throwable);
                        this.bc = new CompareState();
                        this.ak();
                    }
                }
                switch (this.bc.getState()) {
                    case CANCELING: 
                    case COMPARING: 
                    case PAUSED: 
                    case QUEUED: 
                    case START: {
                        boolean bl = false;
                        object3 = Persistence.getInstance().tryWriteLock(this.getGUID().toString());
                        try {
                            bl = object3 == null;
                        }
                        finally {
                            if (object3 != null) {
                                object3.close();
                            }
                        }
                        if (bl) {
                            this.bc.setState(State.CLOUDCOMPARE);
                            this.af();
                            break;
                        }
                        this.bc.setState(State.CANCELED);
                        this.ak();
                        break;
                    }
                }
                break block40;
            }
            this.bc = new CompareState();
        }
        this.bx = new com.inet.pdfc.server.persistence.impl.file.g(this, rootFolder);
        this.by = new com.inet.pdfc.server.persistence.impl.file.f(this, rootFolder);
        this.bz = new h(this);
        object2 = null;
        if (Persistence.isFilePersistence() && Persistence.getInstance() instanceof FilePersistence) {
            object = ((FilePersistence)Persistence.getInstance()).getPersistenceFolder();
            object2 = new File(object.toFile(), rootFolder.getPath().substring(1) + "/search");
        }
        this.bA = new TextSearchHandler((ComparePersistence)this, (File)object2);
    }

    private void Q() {
        this.bs = this.R();
    }

    private int R() {
        String string = this.aX.resolve("result.version").getString();
        try {
            return string != null ? Integer.parseInt(string) : 0;
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
    }

    private void S() {
        this.Q();
        ++this.bs;
        this.aX.resolve("result.version").setString(Integer.toString(this.bs));
    }

    ContingentManager T() {
        if (this.bq == null) {
            this.bq = (ContingentManager)ServerPluginManager.getInstance().getSingleInstance(ContingentManager.class);
        }
        return this.bq;
    }

    private URL a(boolean bl) {
        String string = this.bB.getProperty(bl ? "first.url" : "second.url");
        if (string != null) {
            try {
                return new URL(string);
            }
            catch (MalformedURLException malformedURLException) {
                return null;
            }
        }
        return null;
    }

    synchronized PdfcSession U() throws IOException {
        if (this.bg == null && MaintenanceMode.getState() != MaintenanceMode.IN_PROGRESS) {
            try {
                PdfcRenderCache pdfcRenderCache = this.V();
                RunnableSession runnableSession = SessionLocator.exists() ? SessionLocator.getCurrent() : new BaseRunnableSession();
                this.bg = PdfcSession.createSession((PdfcRenderCache)pdfcRenderCache);
                try {
                    this.bg.setThreadLocal();
                    pdfcRenderCache.initFontMap();
                }
                finally {
                    this.bg.resetThreadLocal();
                    runnableSession.setThreadLocal();
                }
            }
            catch (IllegalStateException illegalStateException) {
                PDFCCore.LOGGER_CORE.error((Throwable)illegalStateException);
                throw new IllegalStateException(Msg.getMsg((String)"Server.nospace"));
            }
        }
        return this.bg;
    }

    protected PdfcRenderCache V() throws IOException {
        PersistenceStoreMap persistenceStoreMap = new PersistenceStoreMap(this.aX.getPath() + "/data");
        PdfcRenderCache pdfcRenderCache = new PdfcRenderCache((AbstractMap)persistenceStoreMap);
        return pdfcRenderCache;
    }

    void clearForFinalize(boolean swapFirst) throws IOException {
        this.by.close();
        if (this.bg != null) {
            PdfcRenderCache pdfcRenderCache = this.bg.getStoreMap();
            pdfcRenderCache.clearForFinalize(swapFirst);
            this.ag();
        }
        if (!swapFirst) {
            this.a(PersistenceObserver.EventType.REMOVED, this.ownerID);
        }
    }

    public void notifyUserAccess(UserSession user, UserState newSate) throws IOException {
        boolean bl = this.bC.a(user, newSate);
        if (bl) {
            this.W();
        }
    }

    private void W() throws IOException {
        if (((Boolean)PDFCServerPlugin.COMPARISON_DELETE_VALUE.get()).booleanValue() && com.inet.pdfc.server.persistence.impl.b.a(null, this)) {
            PersistenceFactory persistenceFactory = (PersistenceFactory)ServerPluginManager.getInstance().getSingleInstance(PersistenceFactory.class);
            try (UserAccountScope userAccountScope = UserAccountScope.createPrivileged();){
                persistenceFactory.remove(this.getGUID(), false);
            }
        }
    }

    protected static String t(GUID gUID) {
        Object object = "user #" + String.valueOf(gUID);
        UserAccount userAccount = UserManager.getRecoveryEnabledInstance().getUserAccount(gUID);
        if (userAccount != null) {
            object = userAccount.getDisplayName();
        }
        return object;
    }

    public GUID getGUID() {
        return this.aY;
    }

    public void setDocument(URL source, boolean first, boolean renderPreview) throws IOException, QuotaExceededException {
        switch (this.getCompareState().getState()) {
            case CANCELING: 
            case COMPARING: 
            case PAUSED: 
            case QUEUED: 
            case START: 
            case CLOUDCOMPARE: {
                throw new ClientMessageException(Msg.getMsg((String)"error.comparisonrunning"));
            }
        }
        StorageEntry storageEntry = this.c(source);
        if (storageEntry == null) {
            this.a(source, first);
            this.a(source, first, false, -1L);
        } else {
            PersistenceEntry persistenceEntry = this.e(first);
            if (persistenceEntry.exists()) {
                this.bb.c(-persistenceEntry.size());
                persistenceEntry.deleteValue();
            }
            this.by.h(first);
            this.bx.ax();
            if (first) {
                this.bo = null;
            } else {
                this.bp = null;
            }
            this.an();
            this.b((Chunk)new ProgressState(State.IDLE));
            String string = Long.toString(storageEntry.lastModified());
            this.bB.b(first ? "first.lastmodified" : "second.lastmodified", string);
            this.bB.b(first ? "first.size" : "second.size", Long.toString(this.bb.aq()));
            this.a(this.getCompareState(), false);
            this.a(source, first);
        }
        this.by.a(first, renderPreview, ComparePersistence.PREVIEW_SIZE.XL, ComparePersistence.PREVIEW_SIZE.S);
    }

    @SuppressFBWarnings(value={"URLCONNECTION_SSRF_FD"}, justification="URL is filtered to allow only external connections (web API)")
    private void a(URL uRL, boolean bl, boolean bl2, long l) throws IOException, QuotaExceededException {
        String string = this.a(uRL);
        URLConnection uRLConnection = uRL.openConnection();
        if (l < 0L) {
            l = uRLConnection.getLastModified();
        }
        CompareState compareState = this.getCompareState();
        try (InputStream inputStream = uRLConnection.getInputStream();){
            this.clearDocument(bl);
            ProgressState progressState = new ProgressState(State.UPDATE_DOCUMENT, 0.0f);
            this.b((Chunk)progressState);
            this.a(PersistenceObserver.EventType.PROGRESS, new ProgressState(this.bc.getState(), this.bc.getProgress()));
            this.a(string, l, inputStream, bl, bl2);
        }
        catch (FileNotFoundException fileNotFoundException) {
            String string2 = bl ? "pdfc.comparison.missingfirst" : "pdfc.comparison.missingsecond";
            throw new FileNotFoundException(PDFCServerPlugin.MSG.getMsg(string2, new Object[]{this.getTagValue(bl ? PersistenceFactory.TAG.DOCUMENT_1 : PersistenceFactory.TAG.DOCUMENT_2), this.getGUID()}));
        }
        this.bc = compareState;
        this.a(compareState, false);
    }

    private void a(CompareState compareState, boolean bl) {
        Chunk chunk = compareState.toChunk();
        if (chunk.getType() == Chunk.ChunkType.error) {
            this.a(PersistenceObserver.EventType.ERROR, (ErrorData)chunk);
        } else {
            this.a(PersistenceObserver.EventType.PROGRESS, (ProgressState)chunk);
        }
    }

    @Nonnull
    private String a(@Nonnull URL uRL) {
        StorageEntry storageEntry = StorageEntry.resolve((URL)uRL);
        if (storageEntry != null) {
            return storageEntry.getName();
        }
        String string = uRL.getPath();
        if (StringFunctions.isEmpty((String)string)) {
            string = uRL.toString();
        }
        try {
            string = URLDecoder.decode(string, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        int n = string.lastIndexOf(47);
        if (n >= 0 && n < string.length() - 1) {
            string = string.substring(n + 1);
        }
        return string;
    }

    @SuppressFBWarnings(value={"URLCONNECTION_SSRF_FD"}, justification="URL is filtered to allow only external connections (web API)")
    private long b(URL uRL) {
        if (uRL == null) {
            return 0L;
        }
        try {
            return uRL.openConnection().getLastModified();
        }
        catch (IOException iOException) {
            return 0L;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private StorageEntry c(URL uRL) {
        StorageEntry storageEntry3 = StorageEntry.resolve((URL)uRL);
        if (storageEntry3 == null) {
            return null;
        }
        try (RandomAccessRead randomAccessRead = storageEntry3.getRandomAccessRead();){
            if (randomAccessRead != null) {
                StorageEntry storageEntry2 = storageEntry3;
                return storageEntry2;
            }
            StorageEntry storageEntry = null;
            return storageEntry;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public void saveDocument(String name, long lastModified, InputStream content, boolean first, boolean renderPreview) throws IOException, QuotaExceededException, IllegalArgumentException {
        if (!SystemPermissionChecker.checkAccess((Permission)PDFCServerPlugin.PERMISSION_OWN_COMPARISONS)) {
            throw new IllegalStateException("User " + UserManager.getRecoveryEnabledInstance().getCurrentUserAccount().getDisplayName() + " does not have the required permission to set the documents of a comparison");
        }
        switch (this.getCompareState().getState()) {
            case CANCELING: 
            case COMPARING: 
            case PAUSED: 
            case QUEUED: 
            case START: 
            case CLOUDCOMPARE: {
                throw new ClientMessageException(Msg.getMsg((String)"error.comparisonrunning"));
            }
        }
        this.a(name, lastModified, content, first, false);
        this.by.a(first, renderPreview, ComparePersistence.PREVIEW_SIZE.XL, ComparePersistence.PREVIEW_SIZE.S);
    }

    private void a(URL uRL, boolean bl) throws IOException {
        String string;
        String string2;
        this.d(uRL);
        if (bl) {
            this.bm = uRL;
            string2 = "first.url";
            string = "first.name";
        } else {
            this.bn = uRL;
            string2 = "second.url";
            string = "second.name";
        }
        this.bB.b(string2, uRL != null ? uRL.toString() : null);
        this.bB.c(string, uRL != null ? this.a(uRL) : null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void a(String string, long l, InputStream inputStream, boolean bl, boolean bl2) throws IOException, QuotaExceededException, IllegalArgumentException {
        if (MaintenanceMode.getState() == MaintenanceMode.IN_PROGRESS) {
            throw new IllegalStateException("The server is currently in maintenance mode. Data manipulation is deactivated.");
        }
        long l2 = inputStream.available();
        GUID gUID = this.al();
        this.bf.F();
        boolean bl3 = false;
        try {
            OutputStream outputStream;
            Object object;
            File file;
            CryptoAlgorithm cryptoAlgorithm;
            PersistenceEntry persistenceEntry2;
            block55: {
                persistenceEntry2 = this.e(bl);
                long l3 = 0L;
                if (persistenceEntry2.exists()) {
                    l3 = persistenceEntry2.size();
                    l2 = (long)inputStream.available() - l3;
                }
                ContingentManager contingentManager = this.T();
                if (l2 > 0L && !contingentManager.hasFreeHDDSpace(gUID)) {
                    UserPersistenceManager userPersistenceManager = (UserPersistenceManager)ServerPluginManager.getInstance().getSingleInstance(UserPersistenceManager.class);
                    long l4 = (userPersistenceManager.getUserContingent(gUID).getUsedHardDiskSpace() + l2 - this.T().getQuotaValue(ContingentManager.QUOTA_TYPE.hdd, gUID)) / 0x100000L;
                    throw new QuotaExceededException(Msg.getMsg((String)"Server.save.successful.not", (Object[])new Object[]{string}) + " " + Msg.getMsg((String)"Server.quotaexceeded.hdd", (Object[])new Object[]{CoreComparePersistence.t(gUID), l4}));
                }
                cryptoAlgorithm = null;
                try {
                    cryptoAlgorithm = Crypto.create((char[])this.X(), (byte[])this.b(bl), (EncryptionData)null);
                }
                catch (GeneralSecurityException generalSecurityException) {
                    PDFCCore.LOGGER_CORE.error((Throwable)generalSecurityException);
                }
                file = File.createTempFile("PDFC_", ".buffer");
                long l5 = this.a(l3);
                object = bl ? this.aR : this.aS;
                synchronized (object) {
                    outputStream = new g(file, false);
                    boolean bl4 = false;
                    try {
                        if (cryptoAlgorithm != null) {
                            outputStream = cryptoAlgorithm.getEncryptingStream(outputStream);
                        }
                        byte[] byArray = new byte[65536];
                        int n = 0;
                        long l6 = 0L;
                        while ((n = inputStream.read(byArray)) >= 0) {
                            outputStream.write(byArray, 0, n);
                            if (l5 == Long.MAX_VALUE || (l6 += (long)n) <= l5) continue;
                            this.bb.c(-l6);
                            throw new QuotaExceededException(Msg.getMsg((String)"Server.save.successful.not", (Object[])new Object[]{string}) + " " + Msg.getMsg((String)"Server.quotaexceeded.hdd.general", (Object[])new Object[]{CoreComparePersistence.t(gUID)}));
                        }
                    }
                    finally {
                        outputStream.close();
                        inputStream.close();
                        if (bl4) {
                            file.delete();
                        }
                    }
                }
                object = cryptoAlgorithm != null ? cryptoAlgorithm.getDecryptRA((RandomAccessRead)new FileRandomAccessRead(file)) : new FileRandomAccessRead(file);
                try {
                    if (!DocumentReader.getInstance().canRead(string, (RandomAccessRead)object)) {
                        long l7 = file.length();
                        this.bb.c(-l7);
                        file.delete();
                        throw new IllegalArgumentException(Msg.getMsg((String)"Server.error.invaliddocument", (Object[])new Object[]{this.getGUID(), string, l7}));
                    }
                }
                finally {
                    if (object != null) {
                        object.close();
                    }
                }
                try {
                    object = cryptoAlgorithm != null ? cryptoAlgorithm.getDecryptRA((RandomAccessRead)new FileRandomAccessRead(file)) : new FileRandomAccessRead(file);
                    try {
                        outputStream = bl2 && this.g(bl) != null ? new String(this.g(bl)) : null;
                        Document document = DocumentReader.getInstance().readDocumentReduced(string, (RandomAccessRead)object, (String)((Object)outputStream), new DocumentFactory.FEATURE[]{DocumentFactory.FEATURE.text, DocumentFactory.FEATURE.meta, DocumentFactory.FEATURE.shapes});
                        if (document != null) {
                            document.close();
                        }
                    }
                    finally {
                        if (object != null) {
                            object.close();
                        }
                    }
                }
                catch (PdfcException pdfcException) {
                    if (pdfcException instanceof DocumentFactory.PasswordException) break block55;
                    long l8 = file.length();
                    this.bb.c(-l8);
                    file.delete();
                    PDFCCore.LOGGER_CORE.error((Throwable)pdfcException);
                    throw new IllegalArgumentException(Msg.getMsg((String)"Server.error.readdocument", (Object[])new Object[]{this.getGUID(), string, l8, pdfcException.getMessage()}));
                }
            }
            this.b((Chunk)new ProgressState(State.IDLE));
            this.a(this.getCompareState(), false);
            this.by.h(bl);
            bl3 = true;
            this.bB.b(bl ? "first.lastmodified" : "second.lastmodified", Long.toString(l));
            this.bB.b(bl ? "first.size" : "second.size", Long.toString(this.bb.aq()));
            this.bB.b(bl ? "first.name" : "second.name", string);
            this.bB.b(bl ? "first.passwordrequired" : "second.passwordrequired", null);
            if (this.bg != null) {
                this.bg.getStoreMap().clear();
            } else {
                object = this.aX.resolve("data");
                object.getChildren().forEach(persistenceEntry -> persistenceEntry.deleteTree());
                this.bj = 0L;
            }
            this.bb.c(-persistenceEntry2.size());
            persistenceEntry2.deleteValue();
            object = new FileInputStream(file);
            try {
                outputStream = persistenceEntry2.getOutputStream();
                try {
                    if (cryptoAlgorithm != null) {
                        byte[] byArray = cryptoAlgorithm.getEncryptionData().getFileHeader();
                        this.bb.c(byArray.length);
                        outputStream.write(byArray);
                    }
                    IOFunctions.copyData((InputStream)object, (OutputStream)outputStream);
                }
                finally {
                    if (outputStream != null) {
                        outputStream.close();
                    }
                }
            }
            finally {
                ((InputStream)object).close();
            }
            file.delete();
            if (bl) {
                this.bo = new PersistencePdfSource(string, l, persistenceEntry2, this.getOwnerID(), this.getGUID(), bl);
            } else {
                this.bp = new PersistencePdfSource(string, l, persistenceEntry2, this.getOwnerID(), this.getGUID(), bl);
            }
            if (!bl2) {
                if (bl) {
                    this.bk = null;
                } else {
                    this.bl = null;
                }
            }
        }
        finally {
            this.bf.G();
            this.bx.ax();
            this.a(PersistenceObserver.EventType.DOCUMENT_CHANGED, Boolean.valueOf(bl));
            if (bl3) {
                this.bB.at();
            }
        }
        com.inet.pdfc.server.a.h.a(this.aY, bl ? "first" : "second");
    }

    byte[] b(boolean bl) {
        byte[] byArray = this.getGUID().toString().getBytes();
        return bl ? byArray : CoreComparePersistence.a(byArray);
    }

    private static byte[] a(byte[] byArray) {
        for (int k = 0; k < byArray.length / 2; ++k) {
            byte by = byArray[k];
            byArray[k] = byArray[byArray.length - k - 1];
            byArray[byArray.length - k - 1] = by;
        }
        return byArray;
    }

    char[] X() {
        return this.getOwnerID().toString().toCharArray();
    }

    private long a(long l) {
        UserPersistenceManager userPersistenceManager = (UserPersistenceManager)ServerPluginManager.getInstance().getSingleInstance(UserPersistenceManager.class);
        long l2 = this.T().getQuotaValue(ContingentManager.QUOTA_TYPE.hdd, this.ownerID);
        if (l2 < 0L) {
            return Long.MAX_VALUE;
        }
        long l3 = userPersistenceManager.getUserContingent(this.ownerID).getUsedHardDiskSpace();
        return l2 - l3 + l;
    }

    public void clearDocument(boolean first) throws IOException {
        if (MaintenanceMode.getState() == MaintenanceMode.IN_PROGRESS) {
            return;
        }
        this.al();
        PersistenceEntry persistenceEntry = this.e(first);
        this.by.h(first);
        if (first && this.bo != null) {
            this.bo.cleanUp();
            this.bo = null;
        }
        if (!first && this.bp != null) {
            this.bp.cleanUp();
            this.bp = null;
        }
        this.bb.c(-persistenceEntry.size());
        persistenceEntry.deleteTree();
        if (first) {
            this.bm = null;
            this.bk = null;
        } else {
            this.bn = null;
            this.bl = null;
        }
        this.bB.b(first ? "first.name" : "second.name", null);
        this.bB.c(first ? "first.passwordrequired" : "second.passwordrequired", null);
        this.bx.ax();
        this.a(PersistenceObserver.EventType.DOCUMENT_CHANGED, Boolean.valueOf(first));
    }

    void c(boolean bl) throws IOException {
        if (bl) {
            this.bk = null;
        } else {
            this.bl = null;
        }
        this.setMetaProperty(bl ? "first.passwordrequired" : "second.passwordrequired", Boolean.TRUE.toString());
    }

    @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"}, justification="File references are available for administrators only and required to support local batch comparisons")
    public PdfSource getDocument(boolean first) throws IOException {
        com.inet.pdfc.server.persistence.impl.file.c c2;
        PersistenceEntry persistenceEntry;
        URL uRL;
        if (MaintenanceMode.getState() == MaintenanceMode.IN_PROGRESS) {
            return null;
        }
        if (first && this.bo != null) {
            this.a(this.bo);
            return this.bo;
        }
        if (!first && this.bp != null) {
            this.a(this.bp);
            return this.bp;
        }
        URL uRL2 = uRL = first ? this.bm : this.bn;
        if (uRL != null) {
            long l;
            this.d(uRL);
            persistenceEntry = this.c(uRL);
            if (persistenceEntry != null) {
                StorageEntryPdfSource storageEntryPdfSource = new StorageEntryPdfSource((StorageEntry)persistenceEntry, uRL);
                this.a((PdfSource)storageEntryPdfSource);
                return storageEntryPdfSource;
            }
            c2 = this.e(first);
            if (!c2.exists()) {
                try {
                    this.a(uRL, first, true, -1L);
                }
                catch (QuotaExceededException quotaExceededException) {
                    throw new IOException(quotaExceededException);
                }
            }
            long l2 = this.d(first);
            if (System.currentTimeMillis() - 60L > l2 && ((l = this.b(uRL)) <= 0L || l != l2)) {
                try {
                    this.a(uRL, first, true, l > 0L ? l : System.currentTimeMillis());
                }
                catch (QuotaExceededException quotaExceededException) {
                    if (first && this.bo != null) {
                        this.bo.cleanUp();
                    }
                    if (!first && this.bp != null) {
                        this.bp.cleanUp();
                    }
                    throw new IOException(quotaExceededException);
                }
            }
        }
        if ((persistenceEntry = this.e(first)).exists()) {
            c2 = this.ab();
            String string = c2.getProperty(first ? "first.name" : "second.name", first ? "first.pdf" : "second.pdf");
            long l = this.d(first);
            PersistencePdfSource persistencePdfSource = new PersistencePdfSource(string, l, this.e(first), this.getOwnerID(), this.getGUID(), first);
            if (first) {
                this.bo = persistencePdfSource;
            } else {
                this.bp = persistencePdfSource;
            }
            this.a(persistencePdfSource);
            return persistencePdfSource;
        }
        return null;
    }

    private void a(PdfSource pdfSource) {
        long l = ((ContingentManager)ServerPluginManager.getInstance().getSingleInstance(ContingentManager.class)).getQuotaValue(ContingentManager.QUOTA_TYPE.pages, this.ownerID);
        pdfSource.setPageLimit((int)l);
    }

    private void d(URL uRL) {
        String string = uRL.getProtocol();
        if ("file".equalsIgnoreCase(string) && !SystemPermissionChecker.checkHostingAccess((Permission)Permission.CONFIGURATION)) {
            throw new AccessForbiddenException("Only administrators are allowed to compare local files. Please use a procotol for external files or upload the document for the comparison.");
        }
        if ("persistence".equalsIgnoreCase(string) && !SystemPermissionChecker.isAdministrator()) {
            throw new AccessForbiddenException("Only administrators are allowed to compare local files. Please use a procotol for external files or upload the document for the comparison.");
        }
    }

    private long d(boolean bl) {
        String string = this.getMetaProperty(bl ? "first.lastmodified" : "second.lastmodified");
        try {
            return string != null ? Long.parseLong(string) : 0L;
        }
        catch (NumberFormatException numberFormatException) {
            return 0L;
        }
    }

    private PersistenceEntry e(boolean bl) {
        String string = bl ? "first.pdf" : "second.pdf";
        return this.aX.resolve(string);
    }

    public ResultModel getResult() throws IOException {
        return this.f(true);
    }

    synchronized ResultModel f(boolean bl) throws IOException {
        PersistenceEntry persistenceEntry;
        if (this.aZ != null || MaintenanceMode.getState() == MaintenanceMode.IN_PROGRESS || this.bc.getState() == State.CLOUDCOMPARE) {
            return this.aZ;
        }
        ResultModelContainer resultModelContainer = null;
        boolean bl2 = false;
        try {
            persistenceEntry = this.aX.resolve("data");
            if (this.bg == null || !this.U().getStoreMap().isInMemory((Object)aU)) {
                if (!bl) {
                    if (PDFCCore.LOGGER_COMPARE.isDebug()) {
                        PDFCCore.LOGGER_COMPARE.debug((Object)(String.valueOf(this.getGUID()) + ": getResult() - no result found, data folder " + (persistenceEntry.exists() ? "exists" : "does not exist")));
                    }
                    return null;
                }
                bl2 = true;
            }
            if (persistenceEntry.exists()) {
                PdfcRenderCache pdfcRenderCache;
                if (bl2) {
                    MemoryObserver.checkMemory();
                }
                if (PDFCCore.LOGGER_COMPARE.isDebug()) {
                    PDFCCore.LOGGER_COMPARE.debug((Object)(String.valueOf(this.getGUID()) + ": getResult() - reading from persistence map"));
                }
                bl2 = !(pdfcRenderCache = this.U().getStoreMap()).isInMemory((Object)aU);
                resultModelContainer = (ResultModelContainer)pdfcRenderCache.getCacheContent(aU);
                if (PDFCCore.LOGGER_COMPARE.isDebug()) {
                    PDFCCore.LOGGER_COMPARE.debug((Object)(String.valueOf(this.getGUID()) + ": getResult() - reading from persistence map " + (resultModelContainer != null ? "SUCCESS" : "FAILED")));
                }
            } else if (PDFCCore.LOGGER_COMPARE.isDebug()) {
                PDFCCore.LOGGER_COMPARE.debug((Object)(String.valueOf(this.getGUID()) + ": getResult() - no result folder found"));
            }
        }
        catch (Throwable throwable) {
            PDFCCore.LOGGER_CORE.error((Object)("Could not load result model of GUID " + String.valueOf(this.getGUID())));
            PDFCCore.LOGGER_CORE.error(throwable);
        }
        if (resultModelContainer != null) {
            if (bl2) {
                resultModelContainer.model.setSetting(this.getSettings());
                resultModelContainer.model.addChangeListener((ResultModel.ResultModelChangeListener)new e());
                this.bx.b(resultModelContainer.model);
            }
            persistenceEntry = new ResultModelUpdater(resultModelContainer.model);
            persistenceEntry.setComparisonID(this.aY);
            persistenceEntry.setImageCache((PageImageCache)this.U().getStoreMap());
            return resultModelContainer.model;
        }
        return null;
    }

    public ResultFilter getResultFilter(String filterName) {
        return this.bx.getResultFilter(filterName);
    }

    public void removeResultFilter(String filterName) {
        this.bx.removeResultFilter(filterName);
    }

    public boolean hasPassword(boolean first) {
        return (first ? this.bk : this.bl) != null;
    }

    char[] g(boolean bl) {
        return bl ? this.bk : this.bl;
    }

    public boolean setPassword(boolean first, char[] password) throws IOException {
        boolean bl = this.a(first, password);
        boolean bl2 = false;
        if (bl) {
            if (first) {
                bl2 = !Objects.equals(password, this.bk);
                this.bk = password;
            } else {
                bl2 = !Objects.equals(password, this.bl);
                this.bl = password;
            }
            if (bl2) {
                boolean bl3 = !this.hasPreviewImage(first);
                this.by.a(first, bl3, ComparePersistence.PREVIEW_SIZE.XL, ComparePersistence.PREVIEW_SIZE.S);
            }
            this.setMetaProperty(first ? "first.passwordrequired" : "second.passwordrequired", Boolean.FALSE.toString());
        } else {
            this.setMetaProperty(first ? "first.passwordrequired" : "second.passwordrequired", Boolean.TRUE.toString());
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean a(boolean bl, char[] cArray) {
        PdfSource pdfSource;
        GUID gUID = UserManager.getRecoveryEnabledInstance().getCurrentUserAccountID();
        boolean bl2 = SessionLocator.exists();
        RunnableSession runnableSession = bl2 ? SessionLocator.getCurrent() : null;
        PdfcSession pdfcSession = PdfcSession.createSession(() -> new PdfcRenderCache((AbstractMap)new MemoryStoreMap(0, true)));
        try {
            if (runnableSession != null) {
                runnableSession.resetThreadLocal();
            } else {
                runnableSession = new BaseRunnableSession();
            }
            pdfcSession.setThreadLocal();
            pdfSource = this.getDocument(bl);
            String string = pdfSource.getPassword();
            pdfSource.setPassword(String.valueOf(cArray));
            try (Document document = DocumentReader.getInstance().readDocumentReduced(pdfSource.getName(), pdfSource.getContent(), String.valueOf(cArray), new DocumentFactory.FEATURE[]{DocumentFactory.FEATURE.text, DocumentFactory.FEATURE.meta, DocumentFactory.FEATURE.shapes});){
                EnumerationProgress enumerationProgress = document.getPages(null, 0, 1);
                if (enumerationProgress.hasMoreElements()) {
                    enumerationProgress.nextElement();
                }
            }
            finally {
                pdfSource.setPassword(string);
            }
        }
        catch (DocumentFactory.PasswordException passwordException) {
            boolean bl3 = false;
            return bl3;
        }
        catch (Throwable throwable) {
            PDFCCore.LOGGER_CORE.error(throwable);
        }
        finally {
            pdfcSession.cleanUp();
            pdfcSession.resetThreadLocal();
            if (runnableSession != null) {
                runnableSession.setThreadLocal();
            }
        }
        pdfSource = UserManager.getRecoveryEnabledInstance().getCurrentUserAccountID();
        if (!Objects.equals(pdfSource, gUID)) {
            throw new IllegalStateException("Consistency error in comparison '" + String.valueOf(this.aY) + "': User access account has switched from " + String.valueOf(gUID) + " to " + String.valueOf(pdfSource) + ". Session was " + (bl2 ? "re-used" : "new"));
        }
        return true;
    }

    public InputStream getPreviewImage(boolean first, ComparePersistence.PREVIEW_SIZE size) throws IOException {
        return this.by.getPreviewImage(first, size);
    }

    public boolean hasPreviewImage(boolean first) {
        return this.by.a(first, ComparePersistence.PREVIEW_SIZE.S);
    }

    public boolean Y() {
        return this.bg != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BufferedImage getPageImage(int page, boolean first, double scale) {
        RunnableSession runnableSession = SessionLocator.exists() ? SessionLocator.getCurrent() : null;
        try {
            BufferedImage bufferedImage;
            RunnableSession runnableSession2 = SessionLocator.exists() ? SessionLocator.getCurrent() : new BaseRunnableSession();
            PdfcSession pdfcSession = this.U();
            try {
                pdfcSession.setThreadLocal();
                bufferedImage = pdfcSession.getStoreMap().getPageImage(first, page, scale, scale);
            }
            catch (Throwable throwable) {
                try {
                    pdfcSession.resetThreadLocal();
                    runnableSession2.setThreadLocal();
                    throw throwable;
                }
                catch (IllegalStateException illegalStateException) {
                    pdfcSession = null;
                    return pdfcSession;
                }
                catch (Exception exception) {
                    if (this.Z()) {
                        PDFCCore.LOGGER_CORE.error((Throwable)exception);
                    }
                    pdfcSession = null;
                    return pdfcSession;
                }
            }
            pdfcSession.resetThreadLocal();
            runnableSession2.setThreadLocal();
            return bufferedImage;
        }
        finally {
            if (runnableSession != null) {
                runnableSession.setThreadLocal();
            }
        }
    }

    public PageGraphicsData getPageGraphicsData(int page, boolean first, double scale, boolean enableAnnotation) {
        return this.bz.a(page, first, scale, enableAnnotation, false);
    }

    boolean Z() {
        return this.bs == this.R();
    }

    public List<UserSession> getViewers() {
        return this.bC.getViewers();
    }

    public void aa() {
        this.bC.az();
    }

    public GUID getOwnerID() {
        return this.ownerID;
    }

    public ComparePersistence.PUBLICATION_MODE getPublicationMode() {
        return this.aW;
    }

    public Set<ComparePersistence.UserOrGroup> getAllowedUsersOrGroups() {
        return this.aW != ComparePersistence.PUBLICATION_MODE.none ? this.bw : new HashSet<ComparePersistence.UserOrGroup>();
    }

    private void a(ComparePersistence.PUBLICATION_MODE pUBLICATION_MODE, Set<ComparePersistence.UserOrGroup> set) throws IOException {
        if (!SystemPermissionChecker.checkAccess((Permission)PDFCServerPlugin.PERMISSION_PUBLISH)) {
            throw new AccessDeniedException(PDFCServerPlugin.PERMISSION_PUBLISH);
        }
        this.al();
        this.aW = pUBLICATION_MODE;
        try {
            this.bB.b("share.mode", pUBLICATION_MODE.toString());
            this.bw.clear();
            if (pUBLICATION_MODE != ComparePersistence.PUBLICATION_MODE.none) {
                this.bw.addAll(set);
            }
            this.bB.c("share.groups", new Json().toJson(this.bw));
        }
        finally {
            this.a(PersistenceObserver.EventType.PUBLISHING_CHANGED, pUBLICATION_MODE);
        }
    }

    public void publish(ComparePersistence.PUBLICATION_MODE mode, Set<ComparePersistence.UserOrGroup> allowedGroups) throws IOException {
        this.a(mode, allowedGroups);
        com.inet.pdfc.server.a.c.a(this.aY, new Object[0]);
    }

    public void unpublish() throws IOException {
        this.a(ComparePersistence.PUBLICATION_MODE.none, null);
        com.inet.pdfc.server.a.d.a(this.aY, new Object[0]);
    }

    public com.inet.pdfc.server.persistence.impl.file.c ab() {
        return this.bB;
    }

    @Nonnull
    com.inet.pdfc.server.persistence.impl.file.f ac() {
        return this.by;
    }

    public void ad() {
        UserAccount userAccount = UserManager.getRecoveryEnabledInstance().getCurrentUserAccount();
        if (userAccount != null) {
            GUID gUID = this.getOwnerID();
            if (Objects.equals(userAccount.getID(), gUID) || userAccount.getAccountType() == UserAccountType.Administrator) {
                return;
            }
            if (this.getPublicationMode() != ComparePersistence.PUBLICATION_MODE.none) {
                Set set = UserGroupManager.getInstance().getGroupsForUser(userAccount.getID()).stream().map(userGroupInfo -> userGroupInfo.getID()).collect(Collectors.toSet());
                Set<ComparePersistence.UserOrGroup> set2 = this.getAllowedUsersOrGroups();
                for (ComparePersistence.UserOrGroup userOrGroup : set2) {
                    if ((userOrGroup.getType() != Type.user || !userAccount.getID().equals((Object)userOrGroup.getId())) && (userOrGroup.getType() != Type.group || !set.contains(userOrGroup.getId()))) continue;
                    return;
                }
            }
        }
        throw new AccessForbiddenException("User '" + (userAccount != null ? userAccount.getDisplayName() : "<none>") + "' is not the owner of the private session '" + String.valueOf(this.aY) + "'");
    }

    public void setMetaProperty(String key, String value) throws IOException {
        this.al();
        this.bB.c(key, value);
    }

    void a(String string, String string2) throws IOException {
        this.ad();
        this.bB.c(string, string2);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public DefaultProfile getProfile() throws IOException {
        Object object = this.aT;
        synchronized (object) {
            try (InputStream inputStream = this.aX.resolve("configuration.xml").getInputStream();){
                if (inputStream == null) {
                    DefaultProfile defaultProfile = null;
                    return defaultProfile;
                }
                SourceProfile sourceProfile = new SourceProfile(inputStream, "configuration.xml");
                return sourceProfile;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setProfile(DefaultProfile configuration) throws IOException {
        this.al();
        if (!SystemPermissionChecker.checkAccess((Permission)PDFCServerPlugin.PERMISSION_OWN_COMPARISONS)) {
            throw new IllegalStateException("User " + UserManager.getRecoveryEnabledInstance().getCurrentUserAccount().getDisplayName() + " does not have the required permission to set the profile of a comparison");
        }
        this.bB.c("configuration.guid", null);
        Object object = this.aT;
        synchronized (object) {
            try (OutputStream outputStream = this.aX.resolve("configuration.xml").getOutputStream();){
                configuration.getProperties().storeToXML(outputStream, "");
            }
        }
        object = configuration.getString("PROFIL_NAME");
        com.inet.pdfc.server.a.i.a(this.aY, object != null ? object : "<unnamed configuration>");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setProfile(GUID profileGUID) throws IOException {
        this.al();
        if (!SystemPermissionChecker.checkAccess((Permission)PDFCServerPlugin.PERMISSION_OWN_COMPARISONS)) {
            throw new IllegalStateException("User " + UserManager.getRecoveryEnabledInstance().getCurrentUserAccount().getDisplayName() + " does not have the required permission to set the profile of a comparison");
        }
        List list = ((ProfilePersistenceManager)PluginManager.getSingleInstance(ProfilePersistenceManager.class)).getAllProfiles(this.ownerID);
        if (list != null) {
            for (ProfilePersistence profilePersistence : list) {
                Object object;
                if (!profilePersistence.getGUID().equals((Object)profileGUID)) continue;
                Object object2 = this.aT;
                synchronized (object2) {
                    object = this.aX.resolve("configuration.xml").getOutputStream();
                    try {
                        profilePersistence.getProfile().getProperties().storeToXML((OutputStream)object, "");
                    }
                    finally {
                        if (object != null) {
                            ((OutputStream)object).close();
                        }
                    }
                }
                object2 = profilePersistence.getName();
                object = this.ab().getProperty("configuration.guid");
                if (Objects.equals(object2, object)) {
                    return;
                }
                com.inet.pdfc.server.a.i.a(this.aY, object2 != null ? object2 : "<unnamed configuration>");
                this.bB.c("configuration.guid", profileGUID.toString());
                break;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Settings getSettings() {
        if (this.aZ != null) {
            return this.aZ.getSettings();
        }
        PersistenceEntry persistenceEntry = this.aX.resolve("settings.json");
        try (InputStream inputStream = persistenceEntry.getInputStream();){
            if (inputStream == null) return new UserSettingsImpl(this.ownerID);
            Settings settings = (Settings)new Json().fromJson(inputStream, DefaultSetting.class);
            return settings;
        }
        catch (IOException iOException) {
            PDFCCore.LOGGER_CORE.error((Throwable)iOException);
        }
        return new UserSettingsImpl(this.ownerID);
    }

    public void setSettings(Settings settings) {
        if (settings == null) {
            settings = new UserSettingsImpl(this.ownerID);
        }
        if (this.aZ != null) {
            this.aZ.setSetting(settings);
            return;
        }
        try {
            ResultModel resultModel = this.f(false);
            if (resultModel == null) {
                resultModel = new ResultModel();
                resultModel.setSetting(this.getSettings());
                resultModel.addChangeListener((ResultModel.ResultModelChangeListener)new e());
            }
            resultModel.setSetting(settings);
        }
        catch (IOException iOException) {
            PDFCCore.LOGGER_CORE.error((Throwable)iOException);
        }
        this.a(settings);
    }

    private void a(Settings settings) {
        if (settings.getClass() != DefaultSetting.class) {
            settings = settings.copy();
        }
        try (OutputStream outputStream = this.aX.resolve("settings.json").getOutputStream();){
            new Json().toJson((Object)settings, outputStream);
        }
        catch (IOException iOException) {
            PDFCCore.LOGGER_CORE.error((Throwable)iOException);
        }
        try {
            this.a("modified", String.valueOf(System.currentTimeMillis()));
        }
        catch (IOException iOException) {
            PDFCCore.LOGGER_CORE.error((Throwable)iOException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletableFuture<Void> comparePersistence(CompareRunner runner) throws IOException, QuotaExceededException {
        ThreadPool.Work<Object> work;
        PdfcSession pdfcSession;
        if (!SystemPermissionChecker.checkAccess((Permission)PDFCServerPlugin.PERMISSION_OWN_COMPARISONS)) {
            UserAccount userAccount = UserManager.getRecoveryEnabledInstance().getCurrentUserAccount();
            if (userAccount != null) {
                throw new IllegalStateException("User " + userAccount.getDisplayName() + " does not have the required permission to run a comparison");
            }
            throw new IllegalStateException("A user account is required to run a comparison");
        }
        if (!this.bf.y()) {
            throw new IllegalStateException("Comparison " + String.valueOf(this.getGUID()) + " is already running. Terminate the existing job to start a new one!");
        }
        this.bi = null;
        this.bh = runner;
        Object object = this;
        synchronized (object) {
            pdfcSession = this.bg != null ? PdfcSession.createSession((PdfcRenderCache)this.bg.getStoreMap()) : null;
        }
        this.a(PersistenceObserver.EventType.COMPARISON_RESET, Boolean.TRUE);
        try {
            long l;
            object = this.T();
            work = object.getUserContingent(this.getOwnerID());
            if (!object.hasFreeHDDSpace(this.getOwnerID()) && (l = work.getUsedHardDiskSpace() - this.getSwapSize() - this.T().getQuotaValue(ContingentManager.QUOTA_TYPE.hdd, this.getOwnerID()) / 0x100000L) > 0L) {
                throw new QuotaExceededException(Msg.getMsg((String)"Server.quotaexceeded.hdd", (Object[])new Object[]{CoreComparePersistence.t(this.getOwnerID()), l}));
            }
        }
        catch (QuotaExceededException | Error | RuntimeException throwable) {
            this.bf.E();
            throw throwable;
        }
        object = new CompletableFuture<Void>(){

            @Override
            public boolean cancel(boolean mayInterruptIfRunning) {
                CoreComparePersistence.this.cancel(null, false);
                return super.cancel(mayInterruptIfRunning);
            }
        };
        work = this.a(() -> this.a(pdfcSession, runner, (CompletableFuture)object));
        if (work == null) {
            this.bf.E();
            ((CompletableFuture)object).completeExceptionally(new IllegalStateException("Failed to start comparison since no session was set."));
        }
        return object;
    }

    Version ae() {
        return ((ApplicationDescription)ServerPluginManager.getInstance().getSingleInstance(ApplicationDescription.class)).getVersion();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel(Consumer<GUID> action, boolean waitForCompletion) {
        this.bf.D();
        switch (this.getCompareState().getState()) {
            case CLOUDCOMPARE: 
            case CANCELED: 
            case ERROR: 
            case FINISHED: 
            case IDLE: {
                return;
            }
        }
        if (this.bi == null) {
            CoreComparePersistence coreComparePersistence = this;
            synchronized (coreComparePersistence) {
                if (this.bh != null) {
                    this.bh.cancel();
                } else {
                    switch (this.getCompareState().getState()) {
                        case CANCELING: 
                        case COMPARING: 
                        case PAUSED: 
                        case QUEUED: 
                        case START: {
                            this.a(State.CANCELED);
                            break;
                        }
                    }
                }
            }
            if (action != null) {
                action.accept(this.aY);
            }
        } else {
            this.a(State.CANCELING);
            AtomicBoolean atomicBoolean = new AtomicBoolean(false);
            Object object = this;
            synchronized (object) {
                if (this.bi != null) {
                    this.bi.whenComplete((resultModel, throwable) -> {
                        AtomicBoolean atomicBoolean2 = atomicBoolean;
                        synchronized (atomicBoolean2) {
                            atomicBoolean.set(true);
                            atomicBoolean.notifyAll();
                        }
                    });
                    if (action != null) {
                        this.bi.whenComplete((resultModel, throwable) -> action.accept(this.aY));
                    }
                } else {
                    waitForCompletion = false;
                    if (this.getCompareState().getState() == State.CANCELING) {
                        this.a(State.CANCELED);
                    }
                }
            }
            object = this;
            synchronized (object) {
                if (this.bh != null) {
                    this.bh.cancel();
                } else {
                    waitForCompletion = false;
                    if (this.getCompareState().getState() == State.CANCELING) {
                        this.a(State.CANCELED);
                    }
                }
            }
            if (waitForCompletion) {
                object = atomicBoolean;
                synchronized (object) {
                    while (!atomicBoolean.get()) {
                        try {
                            atomicBoolean.wait(500L);
                        }
                        catch (InterruptedException interruptedException) {
                            PDFCCore.LOGGER_CORE.debug((Object)interruptedException);
                        }
                    }
                }
            }
        }
    }

    private void a(State state) {
        try {
            this.b((Chunk)new ProgressState(state));
            this.a(this.getCompareState(), false);
        }
        catch (IOException iOException) {
            PDFCCore.LOGGER_CORE.warn((Object)iOException);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean canExecute() {
        switch (this.getCompareState().getState()) {
            case CANCELED: 
            case ERROR: 
            case IDLE: {
                return true;
            }
            case FINISHED: {
                boolean bl;
                if (this.Y()) {
                    return true;
                }
                ServerLock serverLock = this.bf.A();
                try {
                    bl = true;
                    if (serverLock == null) return bl;
                }
                catch (Throwable throwable) {
                    try {
                        if (serverLock == null) throw throwable;
                        try {
                            serverLock.close();
                            throw throwable;
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                    catch (IllegalStateException illegalStateException) {
                        return false;
                    }
                }
                serverLock.close();
                return bl;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(Consumer<ResultModel> work, boolean inPool) {
        block8: {
            try {
                ServerLock serverLock = this.bf.A();
                ResultModel resultModel = this.getResult();
                PdfcSession pdfcSession = this.U();
                if (inPool) {
                    ThreadPool.DEFAULT.startSubThread(() -> {
                        try {
                            work.accept(resultModel);
                        }
                        catch (Exception exception) {
                            PDFCCore.LOGGER_CORE.error((Throwable)exception);
                        }
                        finally {
                            serverLock.close();
                        }
                    }, (RunnableSession)pdfcSession);
                    break block8;
                }
                RunnableSession runnableSession = SessionLocator.exists() ? SessionLocator.getCurrent() : null;
                try {
                    pdfcSession.setThreadLocal();
                    work.accept(resultModel);
                }
                finally {
                    if (runnableSession != pdfcSession) {
                        pdfcSession.resetThreadLocal();
                        if (runnableSession != null) {
                            runnableSession.setThreadLocal();
                        }
                    }
                    serverLock.close();
                }
            }
            catch (IOException iOException) {
                throw new IllegalStateException(iOException);
            }
        }
    }

    public void executeImmediatelyPresenters(Settings customSettings, BasePresenter ... presenters) throws IOException {
        block11: {
            try (ServerLock serverLock = this.bf.A();){
                ThreadPool.Work<Object> work = this.a(() -> {
                    ResultModel resultModel = this.getResult();
                    if (resultModel == null) {
                        return;
                    }
                    ResultModelData resultModelData = new ResultModelUpdater(resultModel).getModelData();
                    if (resultModelData instanceof CollapsePagesModelData) {
                        resultModelData = ((CollapsePagesModelData)resultModelData).getOriginalData();
                    }
                    resultModel = new ResultModel(resultModelData.createCopy());
                    resultModel.setSetting(customSettings);
                    InfoData infoData = resultModel.getComparisonParameters();
                    final long l = this.e(true).size();
                    final long l2 = this.e(false).size();
                    new ResultModelUpdater(resultModel).addData((Chunk)resultModel.getComparisonParameters());
                    ArrayPdfSource arrayPdfSource = new ArrayPdfSource(this.getMetaProperty("first.name"), this.d(true), new byte[0]){

                        public long getSize() {
                            return l;
                        }
                    };
                    ArrayPdfSource arrayPdfSource2 = new ArrayPdfSource(this.getMetaProperty("second.name"), this.d(false), new byte[0]){

                        public long getSize() {
                            return l2;
                        }
                    };
                    new ResultModelUpdater(resultModel).addData((Chunk)new InfoData((PdfSource)arrayPdfSource, (PdfSource)arrayPdfSource2, infoData.getFirstPageCount(), infoData.getSecondPageCount(), infoData.getProfile()));
                    for (BasePresenter basePresenter : presenters) {
                        basePresenter.executeImmediately(resultModel);
                    }
                    arrayPdfSource = null;
                    arrayPdfSource2 = null;
                    resultModel = null;
                });
                if (work == null) break block11;
                try {
                    work.join();
                }
                catch (InterruptedException interruptedException) {
                    if (serverLock != null) {
                        serverLock.close();
                    }
                    return;
                }
            }
            catch (IllegalStateException illegalStateException) {
                return;
            }
        }
    }

    private ThreadPool.Work<Object> a(a a2) throws IOException {
        try {
            return ThreadPool.DEFAULT.startSubThread(() -> {
                try {
                    a2.execute();
                }
                catch (Exception exception) {
                    PDFCCore.LOGGER_CORE.error((Throwable)exception);
                }
            }, (RunnableSession)this.U());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            PDFCCore.LOGGER_CORE.error((Throwable)illegalArgumentException);
            return null;
        }
    }

    <T> void a(PersistenceObserver.EventType<T> eventType, T t) {
        this.b(eventType, t, false);
    }

    public Object getTagValue(PersistenceFactory.TAG tag) throws IllegalArgumentException {
        return this.bB.getTagValue(tag);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    <T> void a(PersistenceObserver.EventType<T> eventType, T t, boolean bl) {
        block26: {
            if (this.aC.size() == 0) {
                return;
            }
            if (bl) {
                try {
                    this.bu.set(Boolean.TRUE);
                    if (eventType == PersistenceObserver.EventType.META_CHANGED) {
                        this.aj();
                    }
                    if (eventType == PersistenceObserver.EventType.PROGRESS) {
                        ProgressState progressState = (ProgressState)t;
                        if (progressState.getId() == State.START && this.bv == null) {
                            this.af();
                            this.b(eventType, t, true);
                            ProgressState progressState2 = new ProgressState(State.CLOUDCOMPARE);
                            this.bc.setFromProgressState(progressState2);
                            this.b(PersistenceObserver.EventType.PROGRESS, progressState2, true);
                            return;
                        }
                        if (this.bv != null && (progressState.getId() == State.CANCELED || progressState.getId() == State.ERROR || progressState.getId() == State.FINISHED)) {
                            this.bv.cancel();
                            this.bv = null;
                        }
                        break block26;
                    }
                    if (eventType == PersistenceObserver.EventType.TOTAL_SIZE_CHANGED) {
                        long l = ((Number)t).longValue();
                        boolean bl2 = l != this.br;
                        this.br = -1L;
                        this.bj = -1L;
                        if (bl2) {
                            this.bb.bK.set(0L);
                            this.bb.b(this.e(true).size());
                            this.bb.b(this.e(false).size());
                        }
                        break block26;
                    }
                    if (eventType == PersistenceObserver.EventType.VIEWERS_CHANGED) {
                        this.bC.az();
                        break block26;
                    }
                    if (eventType != PersistenceObserver.EventType.SETTINGS_CHANGED) break block26;
                    ResultModel resultModel = this.aZ;
                    try {
                        if (this.bg != null && this.U().getStoreMap().isInMemory((Object)aU)) {
                            resultModel = ((ResultModelContainer)this.U().getStoreMap().getCacheContent((PersistenceKey)CoreComparePersistence.aU)).model;
                        }
                    }
                    catch (Throwable throwable) {
                        PDFCCore.LOGGER_CORE.error((Object)("Could not load result model of GUID " + String.valueOf(this.getGUID())));
                        PDFCCore.LOGGER_CORE.error(throwable);
                    }
                    if (resultModel == null) return;
                    PersistenceEntry persistenceEntry = this.aX.resolve("settings.json");
                    try {
                        InputStream inputStream;
                        block27: {
                            inputStream = persistenceEntry.getInputStream();
                            try {
                                if (inputStream == null) break block27;
                                DefaultSetting defaultSetting = (DefaultSetting)new Json().fromJson(inputStream, DefaultSetting.class);
                                DefaultSetting defaultSetting2 = (DefaultSetting)resultModel.getSettings();
                                Properties properties = SettingsControl.getRawSettings((DefaultSetting)defaultSetting);
                                Properties properties2 = SettingsControl.getRawSettings((DefaultSetting)defaultSetting2);
                                if (!properties2.equals(properties)) {
                                    resultModel.setSetting((Settings)defaultSetting);
                                }
                                if (inputStream == null) return;
                            }
                            catch (Throwable throwable) {
                                if (inputStream == null) throw throwable;
                                try {
                                    inputStream.close();
                                    throw throwable;
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                                throw throwable;
                            }
                            inputStream.close();
                            return;
                        }
                        if (inputStream != null) {
                            inputStream.close();
                        }
                    }
                    catch (IOException iOException) {
                        PDFCCore.LOGGER_CORE.error((Throwable)iOException);
                    }
                }
                finally {
                    this.bu.set(Boolean.FALSE);
                }
            }
        }
        this.b(eventType, t, bl);
    }

    private synchronized void af() {
        if (this.bv != null) {
            return;
        }
        this.bv = new DefaultTimerTask(){

            public void runImpl() throws Throwable {
                try (ServerLock serverLock = Persistence.getInstance().tryWriteLock(CoreComparePersistence.this.getGUID().toString());){
                    if (serverLock == null) {
                        return;
                    }
                    CoreComparePersistence.this.ah();
                    CompareState compareState = CoreComparePersistence.this.getCompareState();
                    switch (compareState.getState()) {
                        case CANCELED: 
                        case ERROR: 
                        case FINISHED: {
                            CoreComparePersistence.this.a(compareState, true);
                            break;
                        }
                        case CANCELING: 
                        case COMPARING: 
                        case QUEUED: 
                        case START: {
                            ProgressState progressState = new ProgressState(State.CANCELED, compareState.getProgress());
                            CoreComparePersistence.this.b((Chunk)progressState);
                            CoreComparePersistence.this.a(compareState, false);
                            break;
                        }
                    }
                    this.cancel();
                    CoreComparePersistence.this.bv = null;
                }
                catch (Exception exception) {
                    this.cancel();
                    CoreComparePersistence.this.bv = null;
                }
            }
        };
        DefaultTimer.getInstance().schedule(this.bv, 180000L, 180000L);
    }

    public void setLocalRenderingBlocked(boolean first, boolean blocked) {
        this.by.setLocalRenderingBlocked(first, blocked);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> void b(PersistenceObserver.EventType<T> eventType, T t, boolean bl) {
        ArrayList<PersistenceObserver> arrayList;
        if (this.aC.size() == 0) {
            return;
        }
        List<PersistenceObserver> list = this.aC;
        synchronized (list) {
            arrayList = new ArrayList<PersistenceObserver>(this.aC);
        }
        if (eventType == PersistenceObserver.EventType.DOCUMENT_CHANGED) {
            this.setLocalRenderingBlocked((Boolean)t, bl);
        }
        if (eventType == PersistenceObserver.EventType.CREATED) {
            this.setLocalRenderingBlocked(true, bl);
            this.setLocalRenderingBlocked(false, bl);
        }
        list = null;
        for (PersistenceObserver object : arrayList) {
            if (bl && object == this.bt) continue;
            try {
                if (object.isValid()) {
                    object.changed(eventType, t, bl);
                    continue;
                }
                if (list == null) {
                    list = new ArrayList<PersistenceObserver>();
                }
                list.add(object);
            }
            catch (Throwable persistenceObserver) {
                if (!object.isValid()) {
                    if (list == null) {
                        list = new ArrayList<PersistenceObserver>();
                    }
                    list.add(object);
                    continue;
                }
                PDFCCore.LOGGER_CORE.error(persistenceObserver);
            }
        }
        if (list != null) {
            List<PersistenceObserver> list2 = this.aC;
            synchronized (list2) {
                for (PersistenceObserver persistenceObserver : list) {
                    this.aC.remove(persistenceObserver);
                }
            }
        }
    }

    public long getTotalSize() {
        return this.bb.aq() + this.getSwapSize();
    }

    void ag() {
        long l = this.getTotalSize();
        if (l != this.br) {
            boolean bl = this.br >= 0L;
            this.br = l;
            if (bl) {
                this.a(PersistenceObserver.EventType.TOTAL_SIZE_CHANGED, this.br);
            }
        }
    }

    private long getSwapSize() {
        if (this.bg != null) {
            PdfcRenderCache pdfcRenderCache = this.bg.getStoreMap();
            return pdfcRenderCache.getSwapSize();
        }
        if (this.bj < 0L && MaintenanceMode.getState() != MaintenanceMode.IN_PROGRESS) {
            PersistenceEntry persistenceEntry2 = this.aX.resolve("data");
            List list = persistenceEntry2.getChildren();
            this.bj = !list.isEmpty() ? list.stream().mapToLong(persistenceEntry -> persistenceEntry.size()).sum() : 0L;
        }
        return this.bj;
    }

    public CompareState getCompareState() {
        return this.bd != null ? this.bd : this.bc;
    }

    void ah() {
        this.bc = this.ai();
        this.bd = null;
        this.be = null;
    }

    private CompareState ai() {
        CompareState compareState = null;
        PersistenceEntry persistenceEntry = this.aX.resolve("compare.state");
        byte[] byArray = persistenceEntry.getBytes();
        if (byArray != null) {
            try (ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);){
                compareState = (CompareState)new Bon().fromBinary((InputStream)byteArrayInputStream, CompareState.class);
            }
            catch (Throwable throwable) {
                try (ByteArrayInputStream byteArrayInputStream2 = new ByteArrayInputStream(byArray);){
                    compareState = (CompareState)new Json().fromJson((InputStream)byteArrayInputStream2, CompareState.class);
                }
                catch (Throwable throwable2) {
                    PDFCCore.LOGGER_CORE.warn((Object)("Unable to parse state data in persistence " + String.valueOf(this.getGUID())));
                    PDFCCore.LOGGER_CORE.warn((Object)throwable);
                    compareState = new CompareState();
                    try {
                        this.ak();
                    }
                    catch (IOException iOException) {
                        PDFCCore.LOGGER_CORE.warn((Object)iOException);
                    }
                }
            }
        } else {
            compareState = new CompareState();
        }
        return compareState;
    }

    void aj() {
        if (this.bB.av()) {
            this.aW = ComparePersistence.PUBLICATION_MODE.getMode((String)this.bB.getProperty("share.mode"));
            String string = this.bB.getProperty("share.groups");
            if (string != null) {
                this.bw = (Set)new Json().fromJson(string, c.class);
            }
        }
    }

    private synchronized void ak() throws FileNotFoundException, IOException {
        if (MaintenanceMode.getState() == MaintenanceMode.IN_PROGRESS) {
            return;
        }
        if (this.bc.getState() == State.CLOUDCOMPARE) {
            return;
        }
        try (OutputStream outputStream = this.aX.resolve("compare.state").getOutputStream();){
            new Bon().toBinary((Object)this.bc, outputStream);
        }
    }

    GUID al() {
        UserAccount userAccount = UserManager.getRecoveryEnabledInstance().getCurrentUserAccount();
        if (!(userAccount != null && Objects.equals(userAccount.getID(), this.ownerID) || SystemPermissionChecker.isAdministrator())) {
            throw new AccessForbiddenException("Cannot modify session '" + String.valueOf(this.aY) + "' since the current user '" + (userAccount != null ? userAccount.getDisplayName() : "<none>") + "' is not the owner.");
        }
        return this.ownerID;
    }

    protected ResultModel a(ResultModelData resultModelData) throws IOException {
        ResultModel resultModel = new ResultModel(resultModelData);
        Settings settings = this.getSettings();
        resultModel.setSetting(settings.copy());
        resultModel.addChangeListener((ResultModel.ResultModelChangeListener)new e());
        this.ba = this.a(resultModel);
        this.bx.b(resultModel);
        return resultModel;
    }

    protected ResultModelUpdater a(ResultModel resultModel) throws IOException {
        ResultModelUpdater resultModelUpdater = new ResultModelUpdater(resultModel);
        resultModelUpdater.setImageCache((PageImageCache)this.U().getStoreMap());
        resultModelUpdater.setComparisonID(this.aY);
        return resultModelUpdater;
    }

    public synchronized void am() {
        boolean bl = this.bi != null || this.bh != null;
        this.bh = null;
        this.bi = null;
        this.aZ = null;
        this.ba = null;
        if (bl) {
            this.bf.B();
        }
    }

    protected void finalize() throws Throwable {
        this.am();
        if (this.bg != null) {
            this.bg.cleanUp();
            this.bg.getStoreMap().clearForFinalize(true);
            this.bg = null;
        }
        if (this.bo != null) {
            this.bo.cleanUp();
        }
        if (this.bp != null) {
            this.bp.cleanUp();
        }
    }

    void an() {
        this.aZ = null;
        this.ba = null;
        if (this.bg != null) {
            this.bg.cleanUp();
            this.bg = null;
        }
        if (this.bo != null) {
            this.bo.cleanUp();
        }
        if (this.bp != null) {
            this.bp.cleanUp();
        }
    }

    void ao() {
        this.bA.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addObserver(PersistenceObserver observer) {
        List<PersistenceObserver> list = this.aC;
        synchronized (list) {
            if (observer != null && !this.aC.contains(observer)) {
                this.aC.add(observer);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void a(PersistenceObserver persistenceObserver) {
        List<PersistenceObserver> list = this.aC;
        synchronized (list) {
            if (this.bt != null) {
                this.aC.remove(this.bt);
            }
            this.bt = persistenceObserver;
            if (persistenceObserver != null && !this.aC.contains(persistenceObserver)) {
                this.aC.add(persistenceObserver);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeObserver(PersistenceObserver observer) {
        if (observer != null) {
            List<PersistenceObserver> list = this.aC;
            synchronized (list) {
                this.aC.remove(observer);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<PersistenceObserver> getObservers() {
        List<PersistenceObserver> list = this.aC;
        synchronized (list) {
            return new ArrayList<PersistenceObserver>(this.aC);
        }
    }

    public void searchText(String query, CompletableFuture<List<ComparePersistence.SearchResultChunk>> resultHandler) {
        ThreadPool.DEFAULT.startSubThread(() -> {
            ResultModel resultModel;
            List list;
            try {
                list = this.bA.search(query);
            }
            catch (Throwable throwable) {
                PDFCCore.LOGGER_CORE.error(throwable);
                resultHandler.completeExceptionally(throwable);
                return;
            }
            ArrayList<i> arrayList = new ArrayList<i>();
            if (list.isEmpty()) {
                resultHandler.complete(arrayList);
                return;
            }
            try {
                resultModel = this.getResult();
            }
            catch (IOException iOException) {
                resultHandler.completeExceptionally(iOException);
                return;
            }
            int n = -1;
            boolean bl = true;
            List list2 = null;
            for (List list3 : list) {
                ResultPage resultPage;
                TextSearchHandler.TextID textID = (TextSearchHandler.TextID)list3.get(0);
                TextSearchHandler.TextID textID2 = (TextSearchHandler.TextID)list3.get(list3.size() - 1);
                if (textID2.getPageIndex() != n || textID2.isFirst() != bl) {
                    resultPage = resultModel.getPage(textID2.getPageIndex(), textID2.isFirst());
                    list2 = TextSelectionUtil.getTextInfos((ResultPage)resultPage);
                }
                if (list2 == null) continue;
                resultPage = (TextInfo)list2.get(textID2.getWordIndex());
                i i2 = new i(textID.getPageIndex(), textID.isFirst(), textID.getWordIndex(), list3.size(), resultPage.getCharWidth().length);
                arrayList.add(i2);
            }
            resultHandler.complete(arrayList);
        }, (RunnableSession)new BaseRunnableSession());
    }

    public List<SuggestedValue> getSuggestedValues(String phrase) {
        return this.bA.getSuggestedValues(phrase);
    }

    boolean b(Chunk chunk) throws IOException {
        boolean bl = true;
        boolean bl2 = true;
        if (chunk.getClass() == ErrorData.class) {
            if (this.be == null) {
                this.be = new CompareState();
            }
            this.be.setProgress(this.bc.getProgress());
            this.be.setFromErrorData((ErrorData)chunk);
        } else if (chunk.getClass() == ProgressState.class) {
            ProgressState progressState = (ProgressState)chunk;
            switch (progressState.getId()) {
                case QUEUED: {
                    if (this.bd == null) {
                        this.bd = new CompareState();
                    }
                    this.bd.setFromProgressState(progressState);
                    bl = false;
                    bl2 = false;
                    break;
                }
                case CANCELING: 
                case PAUSED: {
                    bl = false;
                    bl2 = false;
                    this.bc.setFromProgressState(progressState);
                    break;
                }
                case CANCELED: {
                    if (this.bd != null) {
                        this.bd = null;
                        bl = false;
                        bl2 = false;
                    }
                    this.bc.setFromProgressState(progressState);
                    break;
                }
                case CLOUDCOMPARE: {
                    return false;
                }
                case FINISHED: {
                    if (this.be == null) {
                        this.be = new CompareState();
                    }
                    this.be.setFromProgressState(progressState);
                    return false;
                }
                default: {
                    this.bc.setFromProgressState(progressState);
                    this.bd = null;
                    break;
                }
            }
        } else {
            return true;
        }
        if (bl) {
            this.ak();
        }
        return bl2;
    }

    public /* synthetic */ Properties getMetaData() {
        return this.ab();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private /* synthetic */ void a(PdfcSession pdfcSession, CompareRunner compareRunner, CompletableFuture completableFuture) throws Exception {
        b b2 = new b();
        try {
            DefaultProfile defaultProfile;
            if (pdfcSession != null) {
                pdfcSession.setThreadLocal();
            }
            PdfSource pdfSource = this.getDocument(true);
            PdfSource pdfSource2 = this.getDocument(false);
            if (pdfSource == null) {
                throw new FileNotFoundException(PDFCServerPlugin.MSG.getMsg("pdfc.comparison.missingfirst", new Object[]{this.getTagValue(PersistenceFactory.TAG.DOCUMENT_1), this.getGUID()}));
            }
            if (pdfSource2 == null) {
                throw new FileNotFoundException(PDFCServerPlugin.MSG.getMsg("pdfc.comparison.missingsecond", new Object[]{this.getTagValue(PersistenceFactory.TAG.DOCUMENT_2), this.getGUID()}));
            }
            if (this.bk != null) {
                pdfSource.setPassword(String.valueOf(this.bk));
            }
            if (this.bl != null) {
                pdfSource2.setPassword(String.valueOf(this.bl));
            }
            if ((defaultProfile = this.getProfile()) == null) {
                defaultProfile = new DefaultProfile();
            }
            compareRunner.setProfile((IProfile)defaultProfile);
            compareRunner.overrideDataGeneratorListener((DataGeneratorListener)b2);
            if (!this.bf.z()) {
                this.am();
                return;
            }
            PdfcSession pdfcSession2 = (PdfcSession)SessionLocator.getCurrent();
            PdfcRenderCache pdfcRenderCache = pdfcSession2.getStoreMap();
            this.S();
            if (pdfcRenderCache.size() > 0L) {
                pdfcRenderCache.clearForFinalize(false);
                pdfcRenderCache = null;
                pdfcSession2.replaceStoreMap(this.V());
            }
            CoreComparePersistence coreComparePersistence = this;
            synchronized (coreComparePersistence) {
                this.bg = pdfcSession2;
            }
            com.inet.pdfc.server.a.e.a(this.aY, new Object[0]);
            this.bi = compareRunner.compare(pdfSource, pdfSource2);
        }
        catch (IOException | Error | RuntimeException throwable2) {
            completableFuture.completeExceptionally(throwable2);
            this.am();
            this.be = null;
            ErrorData errorData = new ErrorData(ExceptionDataFactory.createExceptionData((Throwable)throwable2), 0, true);
            this.bc.setFromErrorData(errorData);
            this.a(this.getCompareState(), false);
            try {
                this.ak();
            }
            catch (IOException iOException) {
                PDFCCore.LOGGER_CORE.warn((Object)iOException);
            }
            throw throwable2;
        }
        if (this.bi == null) {
            this.am();
            return;
        }
        this.bi = this.bi.whenComplete((resultModel, throwable) -> {
            CompletableFuture<ResultModel> completableFuture2 = this.bi;
            String string = Long.toString((long)Math.ceil((double)(System.currentTimeMillis() - b2.bH) / 1000.0));
            String string2 = Long.toString(this.bg.getConsumedCpuTime() / 1000000L);
            com.inet.pdfc.server.a.f.a(this.aY, string, string2);
            try {
                if (this.aZ != null) {
                    if (this.bg != null) {
                        this.bg.getStoreMap().putData(aU, (InetSerializable)new ResultModelContainer(this.aZ));
                        this.bg.getStoreMap().putData(aV, (InetSerializable)new VersionSerializable(this.ae()));
                    }
                    this.setMetaProperty("differences.count", String.valueOf(this.aZ.getDifferencesCount(false)));
                }
            }
            catch (IOException iOException) {
                PDFCCore.LOGGER_CORE.error((Throwable)iOException);
            }
            catch (Throwable throwable2) {
                try {
                    completableFuture2.completeExceptionally(throwable2);
                }
                catch (Throwable throwable3) {
                    PDFCCore.LOGGER_CORE.error(throwable3);
                }
                try {
                    completableFuture.completeExceptionally(throwable2);
                }
                catch (Throwable throwable4) {
                    PDFCCore.LOGGER_CORE.error(throwable4);
                }
                return;
            }
            finally {
                this.am();
                if (this.be != null) {
                    this.a(this.be, false);
                    this.bc = this.be;
                    try {
                        this.ak();
                    }
                    catch (IOException iOException) {
                        PDFCCore.LOGGER_COMPARE.error((Throwable)iOException);
                    }
                }
                PdfcRenderCache pdfcRenderCache = this.bg.getStoreMap();
                new Thread(() -> {
                    try {
                        if (PDFCCore.LOGGER_COMPARE.isDebug()) {
                            PDFCCore.LOGGER_COMPARE.debug((Object)(String.valueOf(this.getGUID()) + ": Start final swapping of " + pdfcRenderCache.size() + " elements"));
                        }
                        pdfcRenderCache.swapAll();
                        if (PDFCCore.LOGGER_COMPARE.isDebug()) {
                            PDFCCore.LOGGER_COMPARE.debug((Object)(String.valueOf(this.getGUID()) + ": Comparison data written"));
                        }
                    }
                    catch (IOException iOException) {
                        PDFCCore.LOGGER_COMPARE.error((Throwable)iOException);
                    }
                    this.bf.C();
                    this.a(PersistenceObserver.EventType.COMPARISON_SERIALIZED, Boolean.TRUE);
                }, "Cloud sync " + String.valueOf(this.getGUID())).start();
            }
            if (throwable != null) {
                completableFuture2.completeExceptionally((Throwable)throwable);
                completableFuture.completeExceptionally((Throwable)throwable);
            } else {
                completableFuture2.complete(null);
                completableFuture.complete(null);
            }
        });
    }

    private class f {
        private AtomicLong bK = new AtomicLong();

        private f() {
        }

        private void b(long l) {
            this.bK.addAndGet(l);
        }

        private void c(long l) {
            this.bK.addAndGet(l);
        }

        private long aq() {
            return this.bK.get();
        }
    }

    @JsonData
    private static class PersistencePdfSource
    extends PdfSource {
        private transient boolean copied;
        private transient File tempFile;
        private transient PersistenceEntry document;
        private transient GUID ownerID;
        private transient GUID persistenceID;
        private transient boolean first;

        public PersistencePdfSource(String name, long lastModified, PersistenceEntry document, GUID ownerID, GUID persistenceID, boolean first) {
            super(name, document.getPath(), lastModified, document.size());
            this.document = document;
            this.ownerID = ownerID;
            this.persistenceID = persistenceID;
            this.first = first;
        }

        public String getPath() {
            return this.document.getPath();
        }

        public long getSize() {
            return Long.parseLong(this.getMetaProperties().getOrDefault("size", "0"));
        }

        public long getLastModified() {
            return Long.parseLong(this.getMetaProperties().getOrDefault("lastModified", "0"));
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public RandomAccessRead getContent() throws IOException {
            if (this.copied) {
                return this.readerFromTempFile();
            }
            if (!this.document.exists()) {
                return null;
            }
            try {
                return this.getCryptoDocument().getRandomAccessRead();
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                if (this.document.size() <= 1000000L) return RandomAccessRead.wrap((byte[])this.getCryptoDocument().getBytes());
                try (InputStream inputStream = this.document.getInputStream();){
                    if (inputStream == null) {
                        RandomAccessRead randomAccessRead = null;
                        return randomAccessRead;
                    }
                    this.tempFile = File.createTempFile("PDFC_", ".temp");
                    try (FileOutputStream fileOutputStream = new FileOutputStream(this.tempFile, false);){
                        IOFunctions.copyData((InputStream)inputStream, (OutputStream)fileOutputStream);
                    }
                    this.tempFile.setLastModified(this.getLastModified());
                }
                catch (IOException iOException) {
                    PDFCCore.LOGGER_CORE.error((Throwable)iOException);
                }
                this.copied = true;
                return this.readerFromTempFile();
            }
        }

        private PersistenceEntry getCryptoDocument() {
            byte[] byArray = this.persistenceID.toString().getBytes();
            return this.document.getCryptoInstance(this.ownerID.toString().toCharArray(), this.first ? byArray : CoreComparePersistence.a(byArray));
        }

        private RandomAccessRead readerFromTempFile() throws IOException, FileNotFoundException {
            EncryptionData encryptionData = null;
            try (Object object = new FileInputStream(this.tempFile);){
                encryptionData = EncryptionData.get((InputStream)object);
            }
            object = new FileRandomAccessRead(this.tempFile);
            if (encryptionData != null && encryptionData.isEncrypted()) {
                object = new d((RandomAccessRead)object, encryptionData.getHeaderSize());
                try {
                    object = Crypto.create((char[])this.ownerID.toString().toCharArray(), (byte[])this.persistenceID.toString().getBytes(), (EncryptionData)encryptionData).getDecryptRA((RandomAccessRead)object);
                }
                catch (GeneralSecurityException generalSecurityException) {
                    object.close();
                    throw new IOException(generalSecurityException);
                }
            }
            return object;
        }

        private void writeObject(ObjectOutputStream out) throws IOException {
            out.defaultWriteObject();
            out.writeObject(this.document.getPath());
        }

        private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
            stream.defaultReadObject();
            String string = (String)stream.readObject();
            this.document = Persistence.getInstance().resolve(string);
        }

        public void cleanUp() {
            if (this.tempFile != null) {
                this.tempFile.delete();
            }
        }
    }

    static class c
    extends HashSet<ComparePersistence.UserOrGroup> {
        c() {
        }
    }

    private class g
    extends FileOutputStream {
        private File bL;
        private boolean bM;
        private long bN;

        public g(File file, boolean bl) throws FileNotFoundException {
            this(file, bl, file.length());
        }

        private g(File file, boolean bl, long l) throws FileNotFoundException {
            super(file, bl);
            this.bM = true;
            this.bN = 0L;
            this.bL = file;
            this.bN = l;
        }

        @Override
        public void close() throws IOException {
            super.close();
            if (this.bM) {
                this.bM = false;
                long l = this.bL.length();
                if (l != this.bN) {
                    CoreComparePersistence.this.bb.c(l - this.bN);
                }
            }
        }
    }

    private final class e
    implements ResultModel.ResultModelChangeListener {
        private e() {
        }

        public void modelChanged(ResultModel.ChangeInfo change) {
            if (MaintenanceMode.getState() == MaintenanceMode.IN_PROGRESS) {
                return;
            }
            if (change.getType() == ResultModel.STATE_CHANGE_TYPE.FILTER_CHANGE) {
                if (CoreComparePersistence.this.bu.get() != Boolean.TRUE) {
                    CoreComparePersistence.this.a(change.getSource().getSettings());
                }
                CoreComparePersistence.this.a(PersistenceObserver.EventType.SETTINGS_CHANGED, change.getChangedSettings());
            }
            if (change.getType() == ResultModel.STATE_CHANGE_TYPE.VISIBILITY_CHANGE) {
                Map map = change.getVisibilityChanges();
                List list = change.getSource().getDifferences(true);
                ArrayList<PersistenceObserver.VisiblityUpdate> arrayList = new ArrayList<PersistenceObserver.VisiblityUpdate>();
                if (map != null) {
                    for (int k = 0; k < list.size(); ++k) {
                        DiffGroup diffGroup = (DiffGroup)list.get(k);
                        Set set = (Set)map.get(diffGroup);
                        if (set == null) continue;
                        List list2 = diffGroup.getModifications();
                        for (int i2 = 0; i2 < list2.size(); ++i2) {
                            Modification modification = (Modification)list2.get(i2);
                            if (!set.contains(modification)) continue;
                            arrayList.add(new PersistenceObserver.VisiblityUpdate(k, i2, modification.isVisible()));
                        }
                    }
                }
                CoreComparePersistence.this.a(PersistenceObserver.EventType.VISIBILITY_CHANGED, arrayList);
            }
        }

        public boolean errorOcurred(ExceptionData error, boolean interrupted, BasePresenter.ERROR_SOURCE source) {
            return false;
        }
    }

    private static interface a {
        public void execute() throws Exception;
    }

    private class b
    implements DataGeneratorListener {
        private long bH;

        private b() {
        }

        public void addData(Chunk chunk) {
            ErrorData errorData;
            block25: {
                if (CoreComparePersistence.this.aZ == null) {
                    try {
                        CoreComparePersistence.this.aZ = CoreComparePersistence.this.a(new ResultModelData());
                    }
                    catch (IOException iOException) {
                        PDFCCore.LOGGER_CORE.error((Throwable)iOException);
                    }
                }
                ResultModelData resultModelData = CoreComparePersistence.this.ba.getModelData();
                if (chunk.getType() == Chunk.ChunkType.progress) {
                    try {
                        CoreComparePersistence.this.b(chunk);
                        if (CoreComparePersistence.this.getCompareState().getState() == State.START && ((ProgressState)chunk).getValue() == 0.0f) {
                            this.bH = System.currentTimeMillis();
                            CoreComparePersistence.this.bc.resetError();
                            resultModelData.clear();
                        }
                        if (((ProgressState)chunk).getId() == State.ERROR) break block25;
                        if (CoreComparePersistence.this.be != null) {
                            chunk = CoreComparePersistence.this.be.toChunk();
                            break block25;
                        }
                        chunk = CoreComparePersistence.this.getCompareState().toChunk();
                    }
                    catch (IOException iOException) {
                        PDFCCore.LOGGER_CORE.error((Throwable)iOException);
                    }
                } else if (chunk.getType() == Chunk.ChunkType.error && (errorData = (ErrorData)chunk).isInterrupt()) {
                    try {
                        CoreComparePersistence.this.b(chunk);
                    }
                    catch (IOException iOException) {
                        PDFCCore.LOGGER_CORE.error((Throwable)iOException);
                    }
                }
            }
            if (CoreComparePersistence.this.ba != null) {
                CoreComparePersistence.this.ba.addData(chunk);
            }
            switch (chunk.getType()) {
                case error: {
                    CoreComparePersistence.this.a(PersistenceObserver.EventType.ERROR, (ErrorData)chunk);
                    break;
                }
                case highlight: {
                    CoreComparePersistence.this.a(PersistenceObserver.EventType.HIGHLIGHT, (HighlightData)chunk);
                    break;
                }
                case info: {
                    CoreComparePersistence.this.a(PersistenceObserver.EventType.COMPARISON_INFO, (InfoData)chunk);
                    break;
                }
                case pageAnalyzed: {
                    CoreComparePersistence.this.a(PersistenceObserver.EventType.PAGE_ANALYZED, (PageReadDone)chunk);
                    break;
                }
                case pageFiltered: {
                    CoreComparePersistence.this.a(PersistenceObserver.EventType.PAGE_FILTERED, (PageFilterDone)chunk);
                    break;
                }
                case pageParsed: {
                    CoreComparePersistence.this.a(PersistenceObserver.EventType.PAGE_PARSED, (PageDataImpl)chunk);
                    break;
                }
                case partialDiffs: {
                    CoreComparePersistence.this.a(PersistenceObserver.EventType.PARTIAL_DIFFS, (PartialDiffs)chunk);
                    break;
                }
                case progress: {
                    CoreComparePersistence.this.a(PersistenceObserver.EventType.PROGRESS, (ProgressState)chunk);
                    break;
                }
                case textInfoUpdate: {
                    CoreComparePersistence.this.a(PersistenceObserver.EventType.TEXTINFO_UPDATE, (PageDataImpl)chunk);
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown chunk type: " + String.valueOf(chunk.getType()));
                }
            }
            if (chunk.getType() == Chunk.ChunkType.error && ((ErrorData)chunk).isInterrupt()) {
                errorData = CoreComparePersistence.this.be != null ? CoreComparePersistence.this.be : CoreComparePersistence.this.bc;
                CoreComparePersistence.this.a(PersistenceObserver.EventType.PROGRESS, new ProgressState(errorData.getState(), errorData.getProgress(), errorData.getStartTime()));
            }
        }
    }

    private static class d
    extends RandomAccessRead {
        private RandomAccessRead bI;
        private long bJ;

        public d(RandomAccessRead randomAccessRead, long l) {
            this.bI = randomAccessRead;
            this.bJ = l;
            try {
                randomAccessRead.seek(l);
            }
            catch (IOException iOException) {
                ErrorCode.throwAny((Throwable)iOException);
            }
        }

        public void close() throws IOException {
            this.bI.close();
        }

        public long length() throws IOException {
            return this.bI.length() - this.bJ;
        }

        public int read(byte[] b2, int off, int len) throws IOException {
            return this.bI.read(b2, off, len);
        }

        public int read() throws IOException {
            return this.bI.read();
        }

        public void seek(long pos) throws IOException {
            if (pos < 0L) {
                throw new IOException("Negative seek offset");
            }
            this.bI.seek(pos + this.bJ);
        }
    }
}

