/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfc.results.painter;

import com.inet.annotations.InternalApi;
import com.inet.pdfc.config.Settings;
import com.inet.pdfc.error.ExceptionData;
import com.inet.pdfc.generator.model.DiffGroup;
import com.inet.pdfc.generator.model.Modification;
import com.inet.pdfc.i18n.Msg;
import com.inet.pdfc.presenter.BasePresenter;
import com.inet.pdfc.results.ResultModel;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;

@InternalApi
public class MarkerManager {
    private List<Marker> sy = new ArrayList<Marker>();
    private ResultModel model;
    private ResultModel.ResultModelChangeListener sz = new ResultModel.ResultModelChangeListener(){

        @Override
        public void modelChanged(ResultModel.ChangeInfo change) {
            switch (change.getType()) {
                case CLEARED: 
                case COMPLETED: 
                case INCREMENTAL: 
                case FILTER_CHANGE: 
                case VISIBILITY_CHANGE: {
                    MarkerManager.this.update();
                    break;
                }
            }
        }

        @Override
        public boolean errorOcurred(ExceptionData error, boolean interrupted, BasePresenter.ERROR_SOURCE source) {
            return false;
        }
    };

    public MarkerManager(ResultModel model) {
        this.model = model;
        model.addChangeListener(this.sz);
        if (!model.isEmpty()) {
            this.update();
        }
    }

    public List<Marker> getMarkers() {
        return this.sy;
    }

    public static List<Marker> joinMarkers(List<? extends DiffGroup> diffs, boolean hideInvisible, Settings settings) {
        ArrayList<Marker> arrayList = new ArrayList<Marker>();
        if (diffs.size() == 0) {
            return arrayList;
        }
        Marker marker = null;
        for (int i = 0; i < diffs.size(); ++i) {
            DiffGroup diffGroup = diffs.get(i);
            if (!diffGroup.getType().isTypePainted()) continue;
            Marker marker2 = diffGroup.getBounds(true) != null ? diffGroup.getBounds(true).getBounds() : null;
            Rectangle rectangle = diffGroup.getBounds(false) != null ? diffGroup.getBounds(false).getBounds() : null;
            DiffGroup.GroupType groupType = diffGroup.getType();
            if (!diffGroup.isVisible() && hideInvisible) continue;
            if (groupType == DiffGroup.GroupType.AddedOrRemoved) {
                if (!settings.isEnabled(Modification.ModificationType.add)) {
                    rectangle = null;
                }
                if (!settings.isEnabled(Modification.ModificationType.remove)) {
                    marker2 = null;
                }
            }
            if (marker == null) {
                marker = new Marker((Rectangle)((Object)marker2), rectangle, groupType, diffGroup);
                continue;
            }
            if (MarkerManager.a((Rectangle)((Object)marker2), marker.sB) && MarkerManager.a(rectangle, marker.sC) && (marker2 != null || marker.sC != null) && (marker.sB != null || rectangle != null)) {
                if (marker2 != null) {
                    Object object = marker.sB = marker.sB != null ? marker.sB.union((Rectangle)((Object)marker2)) : marker2;
                }
                if (rectangle != null) {
                    marker.sC = marker.sC != null ? marker.sC.union(rectangle) : rectangle;
                }
                marker.d(diffGroup);
                if (groupType.ordinal() >= marker.type.ordinal()) continue;
                marker.type = groupType;
                continue;
            }
            arrayList.add(marker);
            if (marker.type != groupType && groupType.ordinal() > marker.type.ordinal()) {
                MarkerManager.a(marker, (Rectangle)((Object)marker2), true);
                MarkerManager.a(marker, rectangle, false);
            }
            marker = new Marker((Rectangle)((Object)marker2), rectangle, groupType, diffGroup);
        }
        if (marker != null) {
            arrayList.add(marker);
        }
        Marker marker3 = null;
        for (Marker marker2 : arrayList) {
            if (marker3 != null) {
                MarkerManager.a(marker3.getBoundsLeft(), marker2.getBoundsLeft(), marker2.getType());
                MarkerManager.a(marker3.getBoundsRight(), marker2.getBoundsRight(), marker2.getType());
            }
            marker3 = marker2;
        }
        return arrayList;
    }

    public void update() {
        this.sy = this.model.isEmpty() ? new ArrayList<Marker>() : MarkerManager.joinMarkers(this.model.getDifferences(true), true, this.model.getSettings());
    }

    private static void a(Marker marker, Rectangle rectangle, boolean bl) {
        Rectangle rectangle2;
        if (rectangle == null) {
            return;
        }
        Rectangle rectangle3 = rectangle2 = bl ? marker.sB : marker.sC;
        if (rectangle2 == null || !MarkerManager.a(rectangle2, rectangle)) {
            return;
        }
        int n = rectangle.y - (int)rectangle2.getMaxY();
        if (n < 0 && rectangle.x == 0) {
            if (-n > rectangle.height) {
                rectangle.height = 0;
            } else {
                rectangle.y -= n;
                rectangle.height += n;
            }
        }
    }

    private static boolean a(Rectangle rectangle, Rectangle rectangle2) {
        if (rectangle == null && rectangle2 == null) {
            return false;
        }
        if (rectangle == null || rectangle2 == null) {
            return true;
        }
        return rectangle.y >= rectangle2.y - 5 && rectangle.y <= rectangle2.y + rectangle2.height + 5 || rectangle2.y >= rectangle.y - 5 && rectangle2.y <= rectangle.y + rectangle.height + 5;
    }

    private static void a(Rectangle rectangle, Rectangle rectangle2, DiffGroup.GroupType groupType) {
        if (rectangle2 != null && rectangle != null && rectangle.getMaxY() > (double)rectangle2.y && (groupType != DiffGroup.GroupType.AddedOrRemoved || rectangle2.x == 0)) {
            rectangle.height = Math.max(1, rectangle2.y - rectangle.y);
        }
    }

    @InternalApi
    public static class Marker {
        private Rectangle sB;
        private Rectangle sC;
        private DiffGroup.GroupType type;
        private final List<DiffGroup> sD = new ArrayList<DiffGroup>();
        private String sE;

        private Marker(Rectangle left, Rectangle right, DiffGroup.GroupType type, DiffGroup initGroup) {
            this.sB = left;
            this.sC = right;
            this.type = type;
            this.sD.add(initGroup);
        }

        public Rectangle getBoundsLeft() {
            return this.sB;
        }

        public Rectangle getBoundsRight() {
            return this.sC;
        }

        public DiffGroup.GroupType getType() {
            return this.type;
        }

        public boolean isVisible() {
            for (int i = 0; i < this.sD.size(); ++i) {
                if (!this.sD.get(i).isVisible()) continue;
                return true;
            }
            return false;
        }

        private void d(DiffGroup diffGroup) {
            this.sD.add(diffGroup);
        }

        public String getDefaultTooltip() {
            if (this.sE != null) {
                return this.sE;
            }
            int n = 0;
            int n2 = 0;
            int n3 = 0;
            int n4 = 0;
            int n5 = 0;
            int n6 = 0;
            for (DiffGroup diffGroup : this.sD) {
                switch (diffGroup.getType()) {
                    case AddedOrRemoved: {
                        n2 += diffGroup.getRemovedElements().size();
                        n += diffGroup.getAddedElements().size();
                        break;
                    }
                    case Replaced: {
                        n3 += diffGroup.getDifferencesCount();
                        break;
                    }
                    case Modified: {
                        n4 += diffGroup.getDifferencesCount();
                        break;
                    }
                    case MetadataChanged: {
                        n5 += diffGroup.getDifferencesCount();
                        break;
                    }
                    case ValidationError: {
                        n6 += diffGroup.getDifferencesCount();
                        break;
                    }
                }
            }
            StringBuilder stringBuilder = new StringBuilder();
            this.a(stringBuilder, "Tooltip.Remove", n2);
            this.a(stringBuilder, "Tooltip.Add", n);
            this.a(stringBuilder, "Tooltip." + String.valueOf(DiffGroup.GroupType.Replaced), n3);
            this.a(stringBuilder, "Tooltip." + String.valueOf(DiffGroup.GroupType.Modified), n4);
            this.a(stringBuilder, "Tooltip." + String.valueOf(DiffGroup.GroupType.MetadataChanged), n5);
            this.a(stringBuilder, "Tooltip." + String.valueOf(DiffGroup.GroupType.ValidationError), n6);
            this.sE = stringBuilder.toString();
            return this.sE;
        }

        private void a(StringBuilder stringBuilder, String string, int n) {
            if (n == 0) {
                return;
            }
            if (stringBuilder.length() > 0) {
                stringBuilder.append("<br>");
            }
            stringBuilder.append(Msg.getMsg(string, Integer.toString(n)));
        }

        public List<DiffGroup> getMarkedGroups() {
            return this.sD;
        }
    }
}

