/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfc.results.painter;

import com.inet.annotations.InternalApi;
import com.inet.pdfc.config.PDFCProperty;
import com.inet.pdfc.config.Settings;
import com.inet.pdfc.error.ExceptionData;
import com.inet.pdfc.generator.model.CompareDiffGroup;
import com.inet.pdfc.generator.model.DiffGroup;
import com.inet.pdfc.model.PagedElement;
import com.inet.pdfc.presenter.BasePresenter;
import com.inet.pdfc.results.CollapsePagesModelData;
import com.inet.pdfc.results.ResultModel;
import com.inet.pdfc.results.ResultModelData;
import com.inet.pdfc.results.ResultPage;
import com.inet.pdfc.results.painter.ScrollController;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@InternalApi
public class LayerManager
implements ScrollController {
    private ResultModel model;
    private List<Layer> sb = new ArrayList<Layer>();
    private int sc;
    private int sd;
    private int se;
    private int sf;
    private InfoColumnGenerator sg;

    public LayerManager(@Nonnull ResultModel model) {
        this(model, new InfoColumnGenerator(){}, false);
    }

    public LayerManager(@Nonnull ResultModel model, @Nonnull InfoColumnGenerator columnGenerator, boolean addUpdatelistener) {
        this.model = model;
        this.sg = columnGenerator;
        if (addUpdatelistener) {
            model.addChangeListener(new ResultModel.ResultModelChangeListener(){

                @Override
                public void modelChanged(ResultModel.ChangeInfo change) {
                    if (change.getType() == ResultModel.STATE_CHANGE_TYPE.CLEARED || change.getChangedSettings().containsValue(Settings.OPTION.ONLYPAGESWITHDIFFS)) {
                        LayerManager.this.updateLayers(true, false);
                    }
                    if (change.getType() == ResultModel.STATE_CHANGE_TYPE.PROGRESS_UPDATE && change.getProgress() == 1.0f) {
                        LayerManager.this.updateLayers(true, true);
                    }
                }

                @Override
                public boolean errorOcurred(ExceptionData error, boolean interrupted, BasePresenter.ERROR_SOURCE source) {
                    return false;
                }
            });
        }
    }

    public synchronized void updateLayers(int startIndex, int diffCount, int lastTotal, boolean addFillUpLayer) {
        if (diffCount == 0 && !addFillUpLayer) {
            return;
        }
        List<DiffGroup> list = new ArrayList<DiffGroup>(ResultModelData.getDifferences(true, true, this.model));
        Layer layer = null;
        boolean bl = false;
        diffCount = Math.max(0, Math.min(diffCount, list.size() - startIndex));
        if (startIndex > 0 || diffCount + startIndex < list.size()) {
            Object object;
            int n = 0;
            int n2 = 0;
            int n3 = 0;
            if (startIndex > 0) {
                object = (CompareDiffGroup)list.get(startIndex - 1);
                Rectangle rectangle = ((CompareDiffGroup)object).getBounds(true);
                Rectangle rectangle2 = ((CompareDiffGroup)object).getBounds(false);
                n = LayerManager.a(((CompareDiffGroup)object).getAfterFirst(), this.model, true, rectangle != null ? rectangle.y + rectangle.height : 0);
                n2 = LayerManager.a(((CompareDiffGroup)object).getAfterSecond(), this.model, false, rectangle2 != null ? rectangle2.y + rectangle2.height : 0);
                n3 = this.sg.getIncrementalStart(this.model, startIndex - 1);
            }
            list = list.subList(startIndex, startIndex + diffCount);
            layer = new Layer(0, n, 0, n2, 0, n3, lastTotal);
            if (this.sb.size() == 0) {
                bl = true;
                object = new Layer(0, n, 0, n2, 0, n3, lastTotal){

                    @Override
                    public boolean tryMerge(int endF, int endS, int endI) {
                        return false;
                    }
                };
                ((Layer)object).sq = lastTotal - ((Layer)object).getMaxHeight();
                this.sb.add((Layer)object);
            }
        }
        this.a(list, layer);
        if (addFillUpLayer) {
            this.db();
        }
        if (bl) {
            this.sb.remove(0);
        }
    }

    public void setInfoColumnGenerator(InfoColumnGenerator generator) {
        this.sg = generator != null ? generator : new InfoColumnGenerator(){};
        this.updateLayers(true, false);
    }

    private void a(List<DiffGroup> list, Layer layer) {
        int n = 0;
        int n2 = 0;
        boolean bl = "STRICT".equalsIgnoreCase(this.model.getComparisonParameters().getProfile().getString(PDFCProperty.CONTINUOUS_COMPARE));
        int n3 = Math.max(this.model.getPageCount(true), this.model.getPageCount(false));
        if (n3 > 0) {
            for (int i = 0; i < n3; ++i) {
                float f2;
                ResultPage resultPage = this.model.getPage(i, true);
                ResultPage resultPage2 = this.model.getPage(i, false);
                float f3 = resultPage != null ? (float)resultPage.getHeight() : 0.0f;
                float f4 = f2 = resultPage2 != null ? (float)resultPage2.getHeight() : 0.0f;
                if (bl) {
                    float f5 = Math.max(f3, f2);
                    if (f3 > 0.0f) {
                        n = (int)((float)n + f5);
                    }
                    if (!(f2 > 0.0f)) continue;
                    n2 = (int)((float)n2 + f5);
                    continue;
                }
                n = (int)((float)n + f3);
                n2 = (int)((float)n2 + f2);
            }
            this.sc = n;
            this.sd = n2;
        } else {
            this.sc = 0;
            this.sd = 0;
        }
        if (list.size() > 0) {
            if (layer != null) {
                this.a(this.sb, layer.sl, layer.sn, layer.sp, list, this.model, layer.sq);
            } else {
                this.a(this.sb, 0, 0, 0, list, this.model, 0);
            }
            if (this.sb.size() > 0) {
                this.se = this.sb.get((int)(this.sb.size() - 1)).sp;
            }
        }
    }

    @Override
    public synchronized void updateLayers(boolean fromScratch, boolean finalize) {
        boolean bl;
        if (fromScratch) {
            this.sf = 0;
            this.sb.clear();
        }
        List<DiffGroup> list = new ArrayList<DiffGroup>(ResultModelData.getDifferences(false, true, this.model));
        Layer layer = null;
        boolean bl2 = bl = this.sf < list.size();
        if (bl) {
            int n = list.size();
            if (this.sf > 0) {
                list = list.subList(this.sf, list.size());
            }
            if (this.sb.size() > 0) {
                layer = this.sb.get(this.sb.size() - 1);
            }
            this.sf = n;
        }
        if (bl || fromScratch || this.sf == 0) {
            this.a(list, layer);
        }
        if (finalize) {
            this.db();
        }
    }

    private void db() {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        if (this.sb.size() > 0) {
            Layer layer = this.sb.get(this.sb.size() - 1);
            n = layer.sl;
            n2 = layer.sn;
            n3 = layer.sp;
            n4 = layer.sq + layer.getMaxHeight();
        }
        if (n < this.sc || n2 < this.sd) {
            this.a(this.sb, n, n2, n3, this.sc, this.sd, n3 + this.sg.getInfoColumnSize(null, this.sc - n, this.sd - n2), n4);
        }
    }

    @Override
    public int getTotalScrollHeight() {
        if (this.sb.size() > 0) {
            Layer layer = this.sb.get(this.sb.size() - 1);
            int n = layer.sq + layer.getMaxHeight();
            if (layer.sl < this.sc || layer.sn < this.sd) {
                n += Math.max(this.sc - layer.sl, this.sd - layer.sn);
            }
            return n;
        }
        return Math.max(this.sc, this.sd);
    }

    @Override
    public int getScrollPositionForDrawPosition(int drawPosition, ScrollController.Column column) {
        a a2 = a.sr;
        switch (column) {
            case first: {
                a2 = a.sr;
                break;
            }
            case second: {
                a2 = a.ss;
                break;
            }
            case info: {
                a2 = a.st;
            }
        }
        int n = Collections.binarySearch(this.sb, new b(drawPosition, a2));
        if (n < 0) {
            if (n == -this.sb.size() - 1 && this.sb.size() > 0) {
                Layer layer = this.sb.get(this.sb.size() - 1);
                int n2 = drawPosition - layer.getStartY(column) - layer.getMaxHeight();
                return layer.sq + n2;
            }
            return 0;
        }
        Layer layer = this.sb.get(n);
        int n3 = layer.getHeight(column);
        int n4 = drawPosition - layer.getStartY(column);
        double d2 = (double)n4 / (double)n3;
        return (int)((long)layer.sq + Math.round(d2 * (double)layer.getMaxHeight()));
    }

    @Override
    public Rectangle getScrollAreaForDiffGroup(DiffGroup diffGroup, int recentDiffGroupIndex) {
        Rectangle rectangle = diffGroup.getBounds(true);
        Rectangle rectangle2 = diffGroup.getBounds(false);
        if (rectangle == null && rectangle2 == null) {
            return null;
        }
        int n = Integer.MAX_VALUE;
        int n2 = 0;
        if (rectangle != null) {
            n = this.getScrollPositionForDrawPosition(rectangle.y, ScrollController.Column.first);
            n2 = rectangle.height;
        }
        if (rectangle2 != null) {
            n = Math.max(n != Integer.MAX_VALUE ? n : 0, this.getScrollPositionForDrawPosition(rectangle2.y, ScrollController.Column.second));
            n2 = Math.max(n2, rectangle2.height);
        }
        n = Math.max(n, this.getScrollPositionForDrawPosition(this.sg.getIncrementalStart(this.model, recentDiffGroupIndex - 1), ScrollController.Column.info));
        n2 = Math.max(n2, this.sg.getInfoColumnSize(diffGroup, n2, n2));
        return new Rectangle(0, n, 0, n2);
    }

    @Override
    public int getTotalDrawHeight(ScrollController.Column column) {
        switch (column) {
            case first: {
                return this.sc;
            }
            case second: {
                return this.sd;
            }
            case info: {
                return this.se;
            }
        }
        return 0;
    }

    @Nonnull
    public List<Layer> getLayers() {
        return Collections.unmodifiableList(this.sb);
    }

    private void a(List<Layer> list, int n, int n2, int n3, @Nullable List<DiffGroup> list2, @Nonnull ResultModel resultModel, int n4) {
        if (list2 != null) {
            AtomicInteger atomicInteger = new AtomicInteger(n);
            AtomicInteger atomicInteger2 = new AtomicInteger(n2);
            AtomicInteger atomicInteger3 = new AtomicInteger(n3);
            for (DiffGroup diffGroup : list2) {
                this.a(list, atomicInteger, atomicInteger2, atomicInteger3, resultModel, (CompareDiffGroup)diffGroup, n4);
            }
        }
    }

    private void a(List<Layer> list, AtomicInteger atomicInteger, AtomicInteger atomicInteger2, AtomicInteger atomicInteger3, ResultModel resultModel, CompareDiffGroup compareDiffGroup, int n) {
        Rectangle rectangle = compareDiffGroup.getBounds(true);
        Rectangle rectangle2 = compareDiffGroup.getBounds(false);
        int n2 = atomicInteger.get();
        int n3 = Math.max(n2, rectangle == null ? 0 : rectangle.y);
        int n4 = Math.max(n3, LayerManager.a(compareDiffGroup.getBeforeFirst(), resultModel, true, n3));
        int n5 = Math.max(n4, rectangle == null ? 0 : rectangle.y + rectangle.height);
        int n6 = Math.max(n5, LayerManager.a(compareDiffGroup.getAfterFirst(), resultModel, true, n5));
        int n7 = atomicInteger2.get();
        int n8 = Math.max(n7, rectangle2 == null ? 0 : rectangle2.y);
        int n9 = Math.max(n8, LayerManager.a(compareDiffGroup.getBeforeSecond(), resultModel, false, n8));
        int n10 = Math.max(n9, rectangle2 == null ? 0 : rectangle2.y + rectangle2.height);
        int n11 = Math.max(n10, LayerManager.a(compareDiffGroup.getAfterSecond(), resultModel, false, n10));
        int n12 = atomicInteger3.get();
        int n13 = n12 + this.sg.getInfoColumnSize(null, n4 - n2, n9 - n7);
        int n14 = n13 + this.sg.getInfoColumnSize(null, n3 - n4, n8 - n9);
        int n15 = n14 + this.sg.getInfoColumnSize(compareDiffGroup, n5 - n3, n10 - n8);
        int n16 = n15 + this.sg.getInfoColumnSize(null, n6 - n5, n11 - n10);
        atomicInteger.set(n6);
        atomicInteger2.set(n11);
        atomicInteger3.set(n16);
        if (compareDiffGroup.getType() == DiffGroup.GroupType.Sync) {
            this.a(this.sb, n2, n7, n12, n4, n9, n13, n);
            this.a(this.sb, n4, n9, n13, n6, n11, n16, n);
        } else {
            this.a(this.sb, n2, n7, n12, n4, n9, n13, n);
            this.a(this.sb, n4, n9, n13, n3, n8, n14, n);
            this.a(this.sb, n3, n8, n14, n5, n10, n15, n);
            this.a(this.sb, n5, n10, n16, n6, n11, n16, n);
        }
    }

    private int a(List<Layer> list, int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        if (n == n4 && n2 == n5 && n3 == n6) {
            return list.size() == 0 ? 0 : list.get((int)(list.size() - 1)).sq;
        }
        if (list.size() == 0) {
            list.add(new Layer(n, n4, n2, n5, n3, n6, n7));
            return n7;
        }
        Layer layer = list.get(list.size() - 1);
        if (n4 <= layer.sl && n5 <= layer.sn && n6 <= layer.sp) {
            return this.getScrollPositionForDrawPosition(Math.min(n, n4), ScrollController.Column.first);
        }
        int n8 = layer.getMaxHeight();
        if (layer.tryMerge(n4, n5, n6)) {
            return layer.sq + n8;
        }
        Layer layer2 = new Layer(layer.sl, Math.max(layer.sl, n4), layer.sn, Math.max(layer.sn, n5), layer.sp, Math.max(layer.sp, n6), layer.sq + layer.getMaxHeight());
        list.add(layer2);
        return layer2.sq;
    }

    private static int a(PagedElement pagedElement, ResultModel resultModel, boolean bl, int n) {
        if (pagedElement == null) {
            return n;
        }
        ResultPage resultPage = resultModel.getPage(pagedElement.getPageIndex(), bl);
        if (!CollapsePagesModelData.isRealPage(resultPage)) {
            return n;
        }
        return Math.min(resultPage.getHeight(), (int)Math.ceil(pagedElement.getBounds().getY())) + resultPage.getPageOffset();
    }

    @InternalApi
    public static interface InfoColumnGenerator {
        default public int getInfoColumnSize(@Nullable DiffGroup diff, int firstHeight, int secondHeight) {
            return firstHeight;
        }

        default public int getIncrementalStart(@Nonnull ResultModel model, int recentDiffGroupIndex) {
            if (recentDiffGroupIndex < 0) {
                return 0;
            }
            CompareDiffGroup compareDiffGroup = (CompareDiffGroup)ResultModelData.getDifferences(true, true, model).get(recentDiffGroupIndex);
            Rectangle rectangle = compareDiffGroup.getBounds(true);
            return rectangle != null ? rectangle.y : 0;
        }
    }

    @InternalApi
    public static class Layer
    implements Comparable<b> {
        private int sk;
        private int sl;
        private int sm;
        private int sn;
        private int so;
        private int sp;
        private int sq;

        public Layer(Layer prev, int ... offsets) {
            this.sk = prev != null ? prev.sk : 0;
            this.sm = prev != null ? prev.sm : 0;
            this.so = prev != null ? prev.so : 0;
            this.sl = offsets[ScrollController.Column.first.ordinal()];
            this.sn = offsets[ScrollController.Column.second.ordinal()];
            this.sp = offsets[ScrollController.Column.info.ordinal()];
            this.sq = (prev != null ? prev.sq : 0) + this.getMaxHeight();
        }

        public Layer(int yF1, int yF2, int yS1, int yS2, int yI1, int yI2, int total) {
            this.sk = Math.min(yF1, yF2);
            this.sl = Math.max(yF1, yF2);
            this.sm = Math.min(yS1, yS2);
            this.sn = Math.max(yS1, yS2);
            this.so = Math.min(yI1, yI2);
            this.sp = Math.max(yI1, yI2);
            this.sq = total;
        }

        public boolean tryMerge(int endF, int endS, int endI) {
            int[] nArray = new int[]{this.sl - this.sk, this.sn - this.sm, this.sp - this.so};
            int[] nArray2 = new int[]{endF - this.sl, endS - this.sn, endI - this.sp};
            double d2 = Math.max(Math.max(nArray[0], nArray[1]), nArray[2]);
            if (d2 == 0.0) {
                return true;
            }
            double d3 = Math.max(Math.max(nArray2[0], nArray2[1]), nArray2[2]);
            if (d3 == 0.0) {
                return true;
            }
            for (int i = 0; i < nArray.length; ++i) {
                int n = nArray[i];
                int n2 = nArray2[i];
                if (n == 0 || n2 == 0) {
                    if (n == 0 && n2 == 0) continue;
                    return false;
                }
                double d4 = 1.0 + Math.max(1.0 / (double)n, 1.0 / (double)n2);
                double d5 = (double)n / d2;
                double d6 = (double)n2 / d3;
                double d7 = Math.max(d5, d6) / Math.min(d5, d6);
                if (!(d7 > d4)) continue;
                return false;
            }
            this.sl = endF;
            this.sn = endS;
            this.sp = endI;
            return true;
        }

        public boolean isSynchron() {
            int n = this.sl - this.sk;
            return n == this.sn - this.sm && n == this.sp - this.so;
        }

        public int getHeight(ScrollController.Column col) {
            switch (col) {
                case first: {
                    return Math.abs(this.sl - this.sk);
                }
                case second: {
                    return Math.abs(this.sn - this.sm);
                }
                case info: {
                    return Math.abs(this.sp - this.so);
                }
            }
            return 0;
        }

        public int getMaxHeight() {
            return Math.max(Math.max(this.getHeight(ScrollController.Column.first), this.getHeight(ScrollController.Column.second)), this.getHeight(ScrollController.Column.info));
        }

        @Override
        public int compareTo(b o) {
            switch (o.sx) {
                case sr: {
                    if (o.sw < this.sk) {
                        return 1;
                    }
                    if (o.sw > this.sl) {
                        return -1;
                    }
                    return 0;
                }
                case ss: {
                    if (o.sw < this.sm) {
                        return 1;
                    }
                    if (o.sw > this.sn) {
                        return -1;
                    }
                    return 0;
                }
                case st: {
                    if (o.sw < this.so) {
                        return 1;
                    }
                    if (o.sw > this.sp) {
                        return -1;
                    }
                    return 0;
                }
                case su: {
                    if (o.sw < this.sq) {
                        return 1;
                    }
                    if (o.sw > this.sq + this.getMaxHeight()) {
                        return -1;
                    }
                    return 0;
                }
            }
            return 0;
        }

        public int getScrollOffset() {
            return this.sq;
        }

        public int getStartY(ScrollController.Column col) {
            switch (col) {
                case first: {
                    return this.sk;
                }
                case second: {
                    return this.sm;
                }
                case info: {
                    return this.so;
                }
            }
            return 0;
        }

        public String toString() {
            return "Layer " + this.sk + "-" + this.sl + " | " + this.sm + "-" + this.sn + " | " + this.so + "-" + this.sp + " || " + this.sq;
        }
    }

    private static final class a
    extends Enum<a> {
        public static final /* enum */ a sr = new a();
        public static final /* enum */ a ss = new a();
        public static final /* enum */ a st = new a();
        public static final /* enum */ a su = new a();
        private static final /* synthetic */ a[] sv;

        public static a[] values() {
            return (a[])sv.clone();
        }

        public static a valueOf(String name) {
            return Enum.valueOf(a.class, name);
        }

        private static /* synthetic */ a[] dc() {
            return new a[]{sr, ss, st, su};
        }

        static {
            sv = a.dc();
        }
    }

    private static class b {
        private int sw;
        private a sx;

        public b(int n, a a2) {
            this.sw = n;
            this.sx = a2;
        }
    }
}

