/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfc.plugin.persistence;

import com.inet.annotations.InternalApi;
import com.inet.annotations.JsonData;
import com.inet.id.GUID;
import com.inet.pdfc.config.DefaultProfile;
import com.inet.pdfc.config.PdfSource;
import com.inet.pdfc.config.Settings;
import com.inet.pdfc.pagegraphics.PageGraphicsData;
import com.inet.pdfc.plugin.interfaces.CompareRunner;
import com.inet.pdfc.plugin.persistence.CompareState;
import com.inet.pdfc.plugin.persistence.PersistenceFactory;
import com.inet.pdfc.plugin.persistence.PersistenceObserver;
import com.inet.pdfc.plugin.persistence.QuotaExceededException;
import com.inet.pdfc.plugin.persistence.UserSession;
import com.inet.pdfc.plugin.persistence.UserState;
import com.inet.pdfc.presenter.BasePresenter;
import com.inet.pdfc.results.ResultModel;
import com.inet.pdfc.results.filter.ResultFilter;
import com.inet.search.SuggestedValue;
import com.inet.usersandgroups.api.ui.Type;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@InternalApi
public interface ComparePersistence {
    public static final String KEY_FIRST = "first.name";
    public static final String KEY_SECOND = "second.name";
    public static final String KEY_FIRST_URL = "first.url";
    public static final String KEY_SECOND_URL = "second.url";
    public static final String KEY_FIRST_MODIFIED = "first.lastmodified";
    public static final String KEY_SECOND_MODIFIED = "second.lastmodified";
    public static final String KEY_FIRST_SIZE = "first.size";
    public static final String KEY_SECOND_SIZE = "second.size";
    public static final String KEY_FIRST_PASSWORDREQUIRED = "first.passwordrequired";
    public static final String KEY_SECOND_PASSWORDREQUIRED = "second.passwordrequired";
    public static final String KEY_OWNER_ID = "owner.id";
    public static final String KEY_CREATED = "created";
    public static final String KEY_MODIFIED = "modified";
    public static final String KEY_TITLE = "title";
    public static final String KEY_SHARE_MODE = "share.mode";
    public static final String KEY_SHARE_GROUPS = "share.groups";
    public static final String KEY_DIFFERENCES_COUNT = "differences.count";
    public static final String KEY_CONFIGURATION_GUID = "configuration.guid";
    public static final String KEY_CONFIGURATION_FILENAME = "configuration.filename";
    public static final String KEY_CREATOR = "creator";
    public static final String KEY_FIRST_PREVIEW_MODIFIED = "_first.preview.modified";
    public static final String KEY_SECOND_PREVIEW_MODIFIED = "_second.preview.modified";
    public static final int IMAGE_SCALE = 2;

    public GUID getGUID();

    public void saveDocument(String var1, long var2, InputStream var4, boolean var5, boolean var6) throws IOException, QuotaExceededException;

    public void setDocument(URL var1, boolean var2, boolean var3) throws IOException, QuotaExceededException;

    public void setLocalRenderingBlocked(boolean var1, boolean var2);

    public void clearDocument(boolean var1) throws IOException;

    public PdfSource getDocument(boolean var1) throws IOException;

    public ResultModel getResult() throws IOException;

    public InputStream getPreviewImage(boolean var1, PREVIEW_SIZE var2) throws IOException;

    public boolean hasPreviewImage(boolean var1);

    public List<UserSession> getViewers();

    public void notifyUserAccess(UserSession var1, UserState var2) throws IOException;

    public GUID getOwnerID();

    public PUBLICATION_MODE getPublicationMode();

    public Set<UserOrGroup> getAllowedUsersOrGroups();

    public void unpublish() throws IOException;

    public void publish(PUBLICATION_MODE var1, Set<UserOrGroup> var2) throws IOException;

    @Nonnull
    public Properties getMetaData();

    @Nullable
    default public String getMetaProperty(@Nullable String key) {
        return this.getMetaData().getProperty(key);
    }

    public void setMetaProperty(String var1, String var2) throws IOException;

    public void setProfile(DefaultProfile var1) throws IOException;

    public void setProfile(GUID var1) throws IOException;

    public DefaultProfile getProfile() throws IOException;

    public Settings getSettings();

    public void setSettings(Settings var1);

    public long getTotalSize();

    public CompareState getCompareState();

    public BufferedImage getPageImage(int var1, boolean var2, double var3);

    public PageGraphicsData getPageGraphicsData(int var1, boolean var2, double var3, boolean var5);

    public CompletableFuture<Void> comparePersistence(CompareRunner var1) throws IOException, IllegalStateException, QuotaExceededException;

    public void cancel(Consumer<GUID> var1, boolean var2);

    public void executeImmediatelyPresenters(Settings var1, BasePresenter ... var2) throws IOException;

    public void execute(Consumer<ResultModel> var1, boolean var2);

    public boolean canExecute();

    public boolean hasPassword(boolean var1);

    public boolean setPassword(boolean var1, char[] var2) throws IOException;

    public void addObserver(PersistenceObserver var1);

    public void removeObserver(PersistenceObserver var1);

    public ResultFilter getResultFilter(String var1);

    public void removeResultFilter(String var1);

    public List<PersistenceObserver> getObservers();

    public Object getTagValue(PersistenceFactory.TAG var1);

    public void searchText(@Nonnull String var1, @Nonnull CompletableFuture<List<SearchResultChunk>> var2);

    default public List<SuggestedValue> getSuggestedValues(String phrase) {
        return new ArrayList<SuggestedValue>();
    }

    @InternalApi
    public static interface SearchResultChunk {
        public int getPageIndex();

        public boolean isFirst();

        public int getTextInfoStartIndex();

        public int getChunkLength();

        public int getEndIndexInLastTextInfo();
    }

    @JsonData
    public static class ComparePersistenceMetaData {
        private long lastModified;
        private long size = 0L;
        private boolean isPublic;
        private long differences;

        public ComparePersistenceMetaData() {
        }

        public ComparePersistenceMetaData(long lastModified, long size, boolean isPublic, long differences) {
            this.lastModified = lastModified;
            this.size = size;
            this.isPublic = isPublic;
            this.differences = differences;
        }

        public void updateFromPersistence(ComparePersistence persistence) throws IOException {
            long l;
            this.size = l = persistence.getTotalSize();
            this.isPublic = persistence.getPublicationMode() != PUBLICATION_MODE.none;
            try {
                this.lastModified = Long.valueOf(persistence.getMetaProperty(ComparePersistence.KEY_MODIFIED));
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.differences = Long.valueOf(persistence.getMetaProperty(ComparePersistence.KEY_DIFFERENCES_COUNT));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public long getLastModified() {
            return this.lastModified;
        }

        public long getSize() {
            return this.size;
        }

        public long getDifferences() {
            return this.differences;
        }

        public boolean isPublic() {
            return this.isPublic;
        }

        public String toString() {
            return "LastModified: " + String.valueOf(new Date(this.lastModified)) + ", Size: " + this.size + ", Diffs: " + this.differences + ", " + (this.isPublic ? "public" : "private");
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof ComparePersistenceMetaData)) {
                return false;
            }
            ComparePersistenceMetaData comparePersistenceMetaData = (ComparePersistenceMetaData)obj;
            return comparePersistenceMetaData.isPublic == this.isPublic && comparePersistenceMetaData.differences == this.differences && comparePersistenceMetaData.size == this.size && comparePersistenceMetaData.lastModified == this.lastModified;
        }
    }

    @JsonData
    public static class UserOrGroup {
        private Type type;
        private GUID id;

        private UserOrGroup() {
        }

        public UserOrGroup(Type type, GUID id) {
            this.type = type;
            this.id = id;
        }

        public GUID getId() {
            return this.id;
        }

        public Type getType() {
            return this.type;
        }

        public int hashCode() {
            return Objects.hash(this.id, this.type);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof UserOrGroup)) {
                return false;
            }
            UserOrGroup userOrGroup = (UserOrGroup)obj;
            return Objects.equals(this.id, userOrGroup.id) && this.type == userOrGroup.type;
        }
    }

    @InternalApi
    public static final class PREVIEW_SIZE
    extends Enum<PREVIEW_SIZE> {
        public static final /* enum */ PREVIEW_SIZE S = new PREVIEW_SIZE(0.25, "small");
        public static final /* enum */ PREVIEW_SIZE M = new PREVIEW_SIZE(0.5, "medium");
        public static final /* enum */ PREVIEW_SIZE L = new PREVIEW_SIZE(1.0, "large");
        public static final /* enum */ PREVIEW_SIZE XL = new PREVIEW_SIZE(2.0, "");
        private double nu;
        private String nv;
        private static final /* synthetic */ PREVIEW_SIZE[] nw;

        public static PREVIEW_SIZE[] values() {
            return (PREVIEW_SIZE[])nw.clone();
        }

        public static PREVIEW_SIZE valueOf(String name) {
            return Enum.valueOf(PREVIEW_SIZE.class, name);
        }

        private PREVIEW_SIZE(double scale, String namePart) {
            this.nu = scale;
            this.nv = namePart;
        }

        public double getScale() {
            return this.nu;
        }

        public String getNamePart() {
            return this.nv;
        }

        private static /* synthetic */ PREVIEW_SIZE[] bV() {
            return new PREVIEW_SIZE[]{S, M, L, XL};
        }

        static {
            nw = PREVIEW_SIZE.bV();
        }
    }

    @InternalApi
    public static final class PUBLICATION_MODE
    extends Enum<PUBLICATION_MODE> {
        public static final /* enum */ PUBLICATION_MODE none = new PUBLICATION_MODE();
        public static final /* enum */ PUBLICATION_MODE onetime = new PUBLICATION_MODE();
        public static final /* enum */ PUBLICATION_MODE persistent_public = new PUBLICATION_MODE();
        public static final /* enum */ PUBLICATION_MODE persistent_hidden = new PUBLICATION_MODE();
        private static final /* synthetic */ PUBLICATION_MODE[] nx;

        public static PUBLICATION_MODE[] values() {
            return (PUBLICATION_MODE[])nx.clone();
        }

        public static PUBLICATION_MODE valueOf(String name) {
            return Enum.valueOf(PUBLICATION_MODE.class, name);
        }

        public static PUBLICATION_MODE getMode(String mode) {
            if (mode == null) {
                return none;
            }
            try {
                return PUBLICATION_MODE.valueOf(mode);
            }
            catch (Exception exception) {
                return "true".equalsIgnoreCase(mode) || "persistent".equalsIgnoreCase(mode) ? persistent_hidden : none;
            }
        }

        private static /* synthetic */ PUBLICATION_MODE[] bW() {
            return new PUBLICATION_MODE[]{none, onetime, persistent_public, persistent_hidden};
        }

        static {
            nx = PUBLICATION_MODE.bW();
        }
    }
}

