/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfc.ocr;

import com.inet.annotations.InternalApi;
import com.inet.http.servlet.ClientLocale;
import com.inet.pdfc.PDFCCore;
import com.inet.pdfc.config.LanguageValues;
import com.inet.pdfc.i18n.Msg;
import com.inet.pdfc.ocr.Language;
import com.inet.pdfc.ocr.LanguageDetection;
import com.inet.pdfc.plugin.PluginManager;
import com.inet.pdfc.thread.PdfcSession;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Scanner;

@InternalApi
public class LanguageManager {
    private static LanguageManager lA = null;
    private HashMap<String, Language> lB = new HashMap();
    private static LanguageDetection lC = null;

    private LanguageManager() {
        try {
            InputStream inputStream = LanguageManager.class.getResource("SupportedLanguages").openStream();
            try (Scanner scanner = new Scanner(inputStream);){
                while (scanner.hasNextLine()) {
                    String string = scanner.nextLine();
                    String[] stringArray = string.split(";");
                    if (stringArray.length != 3) continue;
                    a a2 = new a(stringArray[0], stringArray[1], stringArray[2]);
                    for (String string2 : stringArray) {
                        this.lB.put(string2, a2);
                    }
                }
            }
        }
        catch (IOException iOException) {
            PDFCCore.LOGGER_CORE.error((Object)Msg.getMsg("Error.loading.language"));
        }
    }

    public static LanguageDetection getLanguageDetection() {
        if (lC == null) {
            lC = PluginManager.getOptional(LanguageDetection.class);
        }
        return lC;
    }

    public static LanguageManager getInstance() {
        if (lA == null) {
            lA = new LanguageManager();
        }
        return lA;
    }

    public Language getLanguage(String language) {
        if (this.lB.containsKey(language)) {
            return this.lB.get(language);
        }
        if (language != null && this.lB.containsKey(language.toLowerCase())) {
            return this.lB.get(language.toLowerCase());
        }
        return null;
    }

    public Language getLanguage(boolean first) {
        Optional<Map.Entry> optional;
        Language language;
        String string;
        Object object;
        if (LanguageManager.getLanguageDetection() != null && PdfcSession.hasSession()) {
            object = PdfcSession.getSession().getSessionProperties().getProperty("document.first.tess");
            string = PdfcSession.getSession().getSessionProperties().getProperty("document.second.tess");
            if (first && object != null && this.getLanguage((String)object) != null) {
                return this.getLanguage((String)object);
            }
            if (!first && string != null && this.getLanguage(string) != null) {
                return this.getLanguage(string);
            }
        }
        if ((language = this.getLanguage(string = LanguageValues.ISO_TO_TESS.get(((Locale)(object = ClientLocale.getThreadLocale())).getLanguage()))) == null && string != null && (optional = LanguageValues.TESS_MAP.entrySet().stream().filter(entry -> ((String)entry.getValue()).equals(string)).findFirst()).isPresent()) {
            language = this.getLanguage((String)optional.get().getKey());
        }
        if (language != null) {
            return language;
        }
        return this.getLanguage("eng");
    }

    private static class a
    implements Language {
        private String lD;
        private String lE;
        private String lF;

        public a(String string, String string2, String string3) {
            this.lD = string;
            this.lE = string2;
            this.lF = string3;
        }

        @Override
        public String getCountry() {
            return this.lD;
        }

        @Override
        public String getTesseract() {
            return this.lE;
        }

        @Override
        public String getOptimize() {
            return this.lF;
        }

        public String toString() {
            return "country = '" + this.getCountry() + "'\tTesseract = '" + this.getTesseract() + "'\t\tDetection = '" + this.getOptimize() + "'";
        }
    }
}

