/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfc.generator.model.forms;

import com.inet.annotations.InternalApi;
import com.inet.annotations.JsonData;
import com.inet.pdfc.generator.model.forms.IPDFCShape;
import com.inet.pdfc.generator.model.forms.TwoSidedPaint;
import com.inet.pdfc.model.ElementID;
import com.inet.pdfc.model.ShapeElement;
import com.inet.pdfc.model.Visitable;
import com.inet.pdfc.model.Visitor;
import com.inet.pdfc.model.i18n.a;
import java.awt.BasicStroke;
import java.awt.Paint;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import javax.annotation.Nonnull;

@JsonData
@InternalApi
public abstract class GeomShape
extends IPDFCShape
implements Visitable {
    private transient BasicStroke stroke;
    private transient Paint strokePaint;
    private transient Paint fillPaint;
    @Nonnull
    private transient ShapeElement source;

    protected GeomShape(Paint strokeColor, Paint fillColor, BasicStroke stroke, int pageIndex, @Nonnull ShapeElement source, @Nonnull ElementID id) {
        super(pageIndex, id);
        this.setFillPaint(fillColor);
        this.setStrokePaint(strokeColor);
        this.stroke = stroke;
        this.source = source;
    }

    @Nonnull
    public ShapeElement getSource() {
        return this.source;
    }

    public BasicStroke getStroke() {
        return this.stroke;
    }

    public void setStroke(BasicStroke stroke) {
        this.stroke = stroke;
    }

    public void setStrokePaint(Paint paint) {
        this.strokePaint = paint;
    }

    public void setFillPaint(Paint paint) {
        this.fillPaint = paint;
    }

    @Override
    public Paint getStrokePaint() {
        return this.strokePaint;
    }

    @Override
    public Paint getFillPaint() {
        return this.fillPaint;
    }

    public abstract double getX1();

    public abstract double getY1();

    public abstract double getX2();

    public abstract double getY2();

    @Override
    public String getLabel() {
        Rectangle2D rectangle2D = this.getBounds();
        String string = Long.toString(Math.round(rectangle2D.getWidth()));
        String string2 = Long.toString(Math.round(rectangle2D.getHeight()));
        return a.getMsg("ElementType." + String.valueOf(this.getType().getBaseType()), string, string2);
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        out.writeBoolean(this.stroke != null);
        if (this.stroke != null) {
            out.writeFloat(this.stroke.getLineWidth());
            out.writeFloat(this.stroke.getMiterLimit());
            out.writeFloat(this.stroke.getDashPhase());
            out.writeInt(this.stroke.getEndCap());
            out.writeInt(this.stroke.getLineJoin());
            out.writeObject(this.stroke.getDashArray());
        }
        TwoSidedPaint.writePaint(this.strokePaint, out);
        TwoSidedPaint.writePaint(this.fillPaint, out);
    }

    private void readObject(ObjectInputStream in) throws ClassNotFoundException, IOException {
        in.defaultReadObject();
        if (in.readBoolean()) {
            float f2 = in.readFloat();
            float f3 = in.readFloat();
            float f4 = in.readFloat();
            int n = in.readInt();
            int n2 = in.readInt();
            float[] fArray = (float[])in.readObject();
            this.stroke = new BasicStroke(f2, n, n2, f3, fArray, f4);
        }
        this.strokePaint = TwoSidedPaint.readPaint(in);
        this.fillPaint = TwoSidedPaint.readPaint(in);
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visit(this);
    }
}

