/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfc.generator.filter;

import com.inet.annotations.InternalApi;
import com.inet.classloader.I18nMessages;
import com.inet.pdfc.PDFCCore;
import com.inet.pdfc.config.ColorSetting;
import com.inet.pdfc.results.painter.Painter;
import com.inet.plugin.NamedExtension;
import java.awt.Color;
import java.util.MissingResourceException;

@InternalApi
public class SortFilterVisualization
implements NamedExtension {
    private String eZ = "pdfc.filter.visualize.";
    private String aH;
    private I18nMessages eX;
    private I18nMessages eY;
    private ColorSetting fe;
    private Color ff;

    public SortFilterVisualization(String filterKey, Color defaultColor, Class<?> filterClass) {
        this.aH = filterKey;
        this.ff = defaultColor;
        this.fe = new Painter.HighlightColorSetting(this.aH);
        this.eX = new I18nMessages(filterClass.getPackage().getName() + ".structure.i18n.ConfigStructure", filterClass);
        this.eY = new I18nMessages(filterClass.getPackage().getName() + ".structure.i18n.LanguageResources", filterClass);
        try {
            this.eX.getBundle();
        }
        catch (MissingResourceException missingResourceException) {
            this.eX = null;
        }
        try {
            this.eY.getBundle();
        }
        catch (MissingResourceException missingResourceException) {
            this.eY = null;
        }
        if (this.eX == null && this.eY == null) {
            PDFCCore.LOGGER_CORE.debug((Object)("No translations found for filter '" + this.aH + "', implementation class " + filterClass.getName()));
        }
    }

    public ColorSetting getSettingsKey() {
        return this.fe;
    }

    public Color getDefaultHighlightColor() {
        return this.ff;
    }

    public String getVisualizationName() {
        return this.n(this.eZ + this.aH.toLowerCase());
    }

    public String getVisualizationDescription() {
        return this.n(this.eZ + this.aH.toLowerCase() + ".tooltip");
    }

    public String getExtensionName() {
        return this.aH;
    }

    private String n(String string) {
        Object object = "$" + string + "$";
        if (this.eX != null && this.eX.getBundle().containsKey(string)) {
            object = this.eX.getMsg(string, new Object[0]);
        }
        if (this.eY != null && this.eY.getBundle().containsKey(string)) {
            object = this.eY.getMsg(string, new Object[0]);
        }
        if (((String)object).contains("$")) {
            PDFCCore.LOGGER_CORE.debug((Object)("Class " + this.aH + " doesn't found translate for key => " + string));
        }
        return object;
    }
}

