/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfc.generator.filter;

import com.inet.annotations.InternalApi;
import com.inet.cache.PersistenceKey;
import com.inet.pdfc.PDFCCorePlugin;
import com.inet.pdfc.config.CompareType;
import com.inet.pdfc.config.DefaultProfile;
import com.inet.pdfc.config.IProfile;
import com.inet.pdfc.config.PDFCProperty;
import com.inet.pdfc.config.SettingUtil;
import com.inet.pdfc.config.TextStyleType;
import com.inet.pdfc.generator.analysis.FeatureKey;
import com.inet.pdfc.generator.continuous.structure.StructureElement;
import com.inet.pdfc.generator.filter.AnnotationHighlightData;
import com.inet.pdfc.generator.filter.SortFilterBase;
import com.inet.pdfc.generator.filter.convert.a;
import com.inet.pdfc.generator.filter.convert.b;
import com.inet.pdfc.generator.filter.line.LineCombineSorter;
import com.inet.pdfc.generator.filter.line.LineCombineSorterOld;
import com.inet.pdfc.generator.message.AnnotationHighlight;
import com.inet.pdfc.generator.message.HighlightData;
import com.inet.pdfc.generator.model.CompareDiffGroup;
import com.inet.pdfc.generator.model.forms.CubicCurveShape;
import com.inet.pdfc.generator.model.forms.GeomShape;
import com.inet.pdfc.generator.model.forms.LineShape;
import com.inet.pdfc.generator.model.forms.QuadCurveShape;
import com.inet.pdfc.generator.model.forms.TwoSidedPaint;
import com.inet.pdfc.generator.model.text.TextModuleUtils;
import com.inet.pdfc.generator.model.text.TextStyle;
import com.inet.pdfc.generator.model.text.WordElement;
import com.inet.pdfc.generator.postcompare.PaintComparator;
import com.inet.pdfc.generator.rendercache.PdfcRenderCache;
import com.inet.pdfc.model.AdditionalBoundsInfo;
import com.inet.pdfc.model.AnnotationElement;
import com.inet.pdfc.model.DrawableElement;
import com.inet.pdfc.model.ElementID;
import com.inet.pdfc.model.ElementType;
import com.inet.pdfc.model.ImageElement;
import com.inet.pdfc.model.PagedElement;
import com.inet.pdfc.model.ShapeElement;
import com.inet.pdfc.model.TextElement;
import com.inet.pdfc.ocr.LanguageManager;
import com.inet.pdfc.thread.PdfcSession;
import com.inet.pdfc.util.ElementCluster;
import com.inet.pdfc.util.ElementSearch;
import com.inet.pdfc.util.ElementSorter;
import com.inet.pdfc.util.EnumParser;
import com.inet.pdfc.util.LocationUtils;
import com.inet.plugin.ServerPluginManager;
import com.inet.search.utils.UmlautsUtils;
import com.inet.thread.SessionLocator;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.CubicCurve2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.QuadCurve2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;

@InternalApi
public class ConvertFilter
extends SortFilterBase {
    public static final String FILTER_NAME = "convert";
    public static final String ANNOTATIONS_KEY = "ANNOTATION";
    public static final double DOUBLE_TOLERANCE = 0.05;
    private double ex;
    private double ey;
    private LineCombineSorter ez;
    private boolean eA;
    private AnnotationHighlightData eB = new AnnotationHighlightData();
    private transient PdfcRenderCache bt;
    private boolean eC;
    private boolean eD;
    private boolean eE;
    private boolean eF;
    private boolean eG;
    private boolean eH;
    private boolean eI;
    private boolean eJ;

    public ConvertFilter(IProfile config, PdfcRenderCache storeMap) {
        super(FILTER_NAME);
        this.bt = storeMap;
        this.ex = config.getDouble(PDFCProperty.TOLERANCE_LINE_SIZE);
        this.ey = config.getDouble(PDFCProperty.TEXT_ALIGN_RATIO);
        this.eA = "STRICT".equalsIgnoreCase(config.getString(PDFCProperty.CONTINUOUS_COMPARE));
        this.eC = !config.getBool(PDFCProperty.COMPARE_TEXT_CASE_SENSITIVE);
        List<@Nonnull CompareType> list = EnumParser.getConfiguredValues(config, PDFCProperty.COMPARE_TYPES, CompareType.class);
        List<@Nonnull TextStyleType> list2 = EnumParser.getConfiguredValues(config, PDFCProperty.COMPARE_TEXT_STYLES, TextStyleType.class);
        this.eD = list.contains((Object)CompareType.IMAGE);
        this.eI = list.contains((Object)CompareType.LINE);
        this.eF = list.contains((Object)CompareType.ANNOTATION);
        this.eE = list.contains((Object)CompareType.LINE) || list2.contains((Object)TextStyleType.STYLES) && list.contains((Object)CompareType.TEXT) || config.getString(PDFCProperty.FILTERS).contains("BASELINETABLE");
        this.eJ = SettingUtil.isUseStructureInFilters(config);
        this.eG = ServerPluginManager.getInstance().isPluginLoaded("filter.invisibleelements");
        this.eG &= config.getString(PDFCProperty.FILTERS).contains("INVISIBLEELEMENTS");
        this.ez = "old".equals(config.getString("LineCombineSorter")) ? new LineCombineSorterOld() : new LineCombineSorter();
        this.ez.setCombineFilledShapes(false);
    }

    @Override
    public List<FeatureKey> getAcceptedPreAnalyzeFeatures() {
        ArrayList<FeatureKey> arrayList = new ArrayList<FeatureKey>();
        if (ServerPluginManager.getInstance().isPluginLoaded("analysis.language")) {
            arrayList.add(PDFCCorePlugin.FEATURE_LANGUAGE_DETECTION);
        }
        return arrayList;
    }

    public void setTextSelectionMode() {
        this.eH = true;
    }

    @Override
    public void analyze(int pageNr, Dimension size, List<@Nonnull DrawableElement> pageElements, boolean first) {
        super.analyze(pageNr, size, pageElements, first);
        this.ez.analyze(pageNr, size, pageElements, first);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public List<@Nonnull DrawableElement> sortOrFilterPage(int pageNr, List<DrawableElement> pageElements, boolean first, List<CompareDiffGroup> diffGroups) {
        void var10_19;
        String string;
        if (!this.eJ) {
            pageElements = StructureElement.unpack(pageElements);
        }
        HashMap<TextStyle, List> hashMap = new HashMap<TextStyle, List>();
        pageElements.stream().filter(drawableElement -> drawableElement.getType() == ElementType.Text).forEach(drawableElement -> {
            TextElement textElement = (TextElement)drawableElement;
            ArrayList<TextElement> arrayList = (ArrayList<TextElement>)hashMap.get(textElement.getStyle());
            if (arrayList == null) {
                arrayList = new ArrayList<TextElement>();
                hashMap.put(textElement.getStyle(), arrayList);
            }
            arrayList.add(textElement);
        });
        hashMap.forEach((textStyle, list) -> {
            TextModuleUtils.calculateAverageKerning(list);
            TextModuleUtils.calculateActualSpaceWidth(list);
        });
        List<@Nonnull DrawableElement> list3 = new ArrayList<DrawableElement>(pageElements.size());
        HashMap<Double, b> hashMap2 = new HashMap<Double, b>();
        ArrayList<AnnotationHighlight> arrayList = null;
        for (DrawableElement list22 : pageElements) {
            List<TextElement> list2;
            double d2 = list22.getRotation();
            if (list22.getType() == ElementType.Text) {
                if (d2 != 0.0 && Math.abs((d2 + Math.PI) % Math.PI) > 0.01 && list22 instanceof TextElement) {
                    list2 = (b)hashMap2.get(d2);
                    if (list2 == null) {
                        list2 = new b((TextElement)list22);
                        hashMap2.put(d2, (b)((Object)list2));
                    } else {
                        ((b)((Object)list2)).a((TextElement)list22);
                    }
                } else if (list22 instanceof TextElement) {
                    list2 = TextModuleUtils.splitByKerning((TextElement)list22);
                    if (list2 != null) {
                        list3.addAll((Collection<DrawableElement>)list2);
                    } else {
                        list3.add(list22);
                    }
                } else {
                    list3.add(list22);
                }
            } else {
                list3.add(list22);
            }
            if (!(list22 instanceof AnnotationElement)) continue;
            list2 = (AnnotationElement)list22;
            HighlightData.Highlight.Appearance appearance = ConvertFilter.getHighlightAppearance((AnnotationElement)((Object)list2));
            if ("Popup".equals(((AnnotationElement)((Object)list2)).getSubtype()) || appearance == null) continue;
            Rectangle rectangle = LocationUtils.getOutline(list22);
            AnnotationHighlight annotationHighlight = new AnnotationHighlight(rectangle, (AnnotationElement)((Object)list2));
            annotationHighlight.setType(((AnnotationElement)((Object)list2)).getSubtype());
            if (arrayList == null) {
                arrayList = new ArrayList<AnnotationHighlight>();
            }
            if (appearance == HighlightData.Highlight.Appearance.CUSTOM && ((AnnotationElement)((Object)list2)).hasAppearance() && this.bt != null) {
                PersistenceKey persistenceKey = this.bt.putCustomPage(((AnnotationElement)((Object)list2)).getAppearance());
                annotationHighlight.setRenderCacheKey(persistenceKey.keyValue());
            }
            arrayList.add(annotationHighlight);
        }
        if (arrayList != null) {
            this.eB.put(pageNr, first, arrayList);
        }
        if (this.eD) {
            list3 = this.e(list3);
        }
        ElementSorter.alignAndSort(list3, this.ey, true);
        boolean bl = true;
        if (SessionLocator.exists() && SessionLocator.getCurrent() instanceof PdfcSession && (string = PdfcSession.getSession().getSessionProperties().getProperty("filter.nobreakiterator")) != null) {
            bl = Boolean.valueOf(string) == false;
        }
        @Nonnull List<@Nonnull DrawableElement> list4 = this.a(list3, pageNr, first, bl);
        if (this.eE) {
            void var10_16;
            List<DrawableElement> list5;
            if (list4.size() > 1000000 && this.eG) {
                @Nonnull List<@Nonnull DrawableElement> list6 = this.removeTinyLines(list4);
            }
            if ((list5 = this.ez.sortOrFilterPage(pageNr, (List<DrawableElement>)var10_16, first, null)).size() > 0 && this.eG) {
                @Nonnull List<@Nonnull DrawableElement> list7 = this.removeTinyLines(list5);
            }
        }
        @Nonnull List<@Nonnull DrawableElement> list9 = this.g((List<DrawableElement>)var10_19);
        list9 = this.d(list9);
        ElementSorter.alignAndSort(list9, this.ey, this.eH);
        if (hashMap2.size() > 0) {
            this.a(hashMap2, list9, pageNr, first, bl);
        }
        return list9;
    }

    @Nonnull
    public List<DrawableElement> finalizeFilterPage(int pageNr, @Nonnull List<DrawableElement> pageElements, boolean first) {
        if (!this.eI) {
            return pageElements;
        }
        ArrayList<DrawableElement> arrayList = new ArrayList<DrawableElement>(pageElements.size());
        block3: for (DrawableElement drawableElement : pageElements) {
            switch (drawableElement.getType()) {
                case Line: 
                case LineHorizontal: 
                case LineVertical: 
                case Curve: {
                    Paint paint;
                    GeomShape geomShape = (GeomShape)drawableElement;
                    if ((geomShape.getStroke() == null || geomShape.getStrokePaint() == null) && (paint = geomShape.getFillPaint()) instanceof TwoSidedPaint) {
                        TwoSidedPaint twoSidedPaint = (TwoSidedPaint)paint;
                        Paint paint2 = twoSidedPaint.getPaint(true);
                        Paint paint3 = twoSidedPaint.getPaint(false);
                        if (paint2 != null && paint3 != null && paint2.equals(paint3)) continue block3;
                    }
                    arrayList.add(drawableElement);
                    continue block3;
                }
            }
            arrayList.add(drawableElement);
        }
        return arrayList;
    }

    @Nonnull
    private @Nonnull List<@Nonnull DrawableElement> d(@Nonnull @Nonnull List<@Nonnull DrawableElement> list) {
        if (!this.eF) {
            return list;
        }
        ElementCluster elementCluster = null;
        block0: for (int i = 0; i < list.size(); ++i) {
            AnnotationElement annotationElement;
            DrawableElement drawableElement = list.get(i);
            if (drawableElement.getType().isStructuralType()) {
                this.d(((StructureElement)drawableElement).getChildren());
            }
            if (drawableElement.getType() != ElementType.Annotation || !(annotationElement = (AnnotationElement)drawableElement).isLinkedToText()) continue;
            Rectangle2D rectangle2D = LocationUtils.getNormedBounds(annotationElement);
            Rectangle2D rectangle2D2 = LocationUtils.resize(rectangle2D, rectangle2D.getHeight() / 8.0);
            double d2 = rectangle2D2.getY();
            for (int j = i - 1; j >= 0; --j) {
                DrawableElement drawableElement2 = list.get(j);
                if (drawableElement2.getType() != ElementType.TextWord) continue;
                Rectangle2D rectangle2D3 = LocationUtils.getNormedBounds(drawableElement2.getBounds());
                if (rectangle2D3.getMaxY() < d2) continue block0;
                if (!rectangle2D2.contains(rectangle2D3)) continue;
                if (rectangle2D.getHeight() > rectangle2D3.getHeight() * 2.0) {
                    if (elementCluster == null) {
                        elementCluster = new ElementCluster(list, true);
                    }
                    this.a(elementCluster, annotationElement, rectangle2D);
                    continue block0;
                }
                Rectangle2D.Double double_ = new Rectangle2D.Double(rectangle2D.getX() - 0.05, rectangle2D3.getMaxY(), rectangle2D.getWidth(), -(rectangle2D3.getMaxY() - rectangle2D.getY()));
                annotationElement.setBounds(double_);
                continue block0;
            }
        }
        return list;
    }

    private void a(ElementCluster elementCluster, AnnotationElement annotationElement, Rectangle2D rectangle2D2) {
        List<DrawableElement> list = elementCluster.getElementsInArea(rectangle2D2, false);
        Collections.sort(list, ElementSorter.YX_COMPARATOR);
        Rectangle2D rectangle2D3 = null;
        ArrayList<Rectangle2D> arrayList = new ArrayList<Rectangle2D>(2);
        for (DrawableElement drawableElement : list) {
            Rectangle2D rectangle2D4;
            if (drawableElement.getType() != ElementType.TextWord && drawableElement.getType() != ElementType.Image || !this.a(rectangle2D2, rectangle2D4 = drawableElement.getBounds())) continue;
            if (rectangle2D3 == null) {
                rectangle2D3 = rectangle2D4;
                continue;
            }
            if (LocationUtils.getMaxY(rectangle2D3) >= LocationUtils.getMaxY(rectangle2D4)) {
                rectangle2D3 = LocationUtils.union(rectangle2D4, rectangle2D3);
                continue;
            }
            arrayList.add(rectangle2D3);
            rectangle2D3 = rectangle2D4;
        }
        if (rectangle2D3 != null) {
            arrayList.add(rectangle2D3);
        }
        if (arrayList.isEmpty()) {
            return;
        }
        if (arrayList.size() > 1) {
            annotationElement.setBounds((Rectangle2D)arrayList.get(0));
            annotationElement.setX(annotationElement.getX() - 0.05);
            annotationElement.setAdditionalBounds((AdditionalBoundsInfo[])arrayList.subList(1, arrayList.size()).stream().map(rectangle2D -> new AdditionalBoundsInfo(LocationUtils.getDoubleBounds(rectangle2D), 0)).toArray(AdditionalBoundsInfo[]::new));
        } else {
            Rectangle2D rectangle2D5 = LocationUtils.getNormedBounds(annotationElement);
            double d2 = LocationUtils.getMaxY((Rectangle2D)arrayList.get(0));
            Rectangle2D.Double double_ = new Rectangle2D.Double(rectangle2D5.getX() - 0.05, d2, rectangle2D5.getWidth(), -(d2 - rectangle2D5.getY()));
            annotationElement.setBounds(double_);
        }
    }

    private boolean a(Rectangle2D rectangle2D, Rectangle2D rectangle2D2) {
        if (rectangle2D.getHeight() < 0.0) {
            rectangle2D = LocationUtils.getNormedBounds(rectangle2D);
        }
        if (rectangle2D2.getHeight() < 0.0) {
            rectangle2D2 = LocationUtils.getNormedBounds(rectangle2D2);
        }
        if (rectangle2D.contains(rectangle2D2)) {
            return true;
        }
        Rectangle2D.Double double_ = new Rectangle2D.Double();
        Rectangle2D.intersect(rectangle2D, rectangle2D2, double_);
        double d2 = rectangle2D2.getWidth() * rectangle2D2.getHeight();
        double d3 = double_.getWidth() * double_.getHeight();
        return d3 > d2 * 0.8;
    }

    @Nonnull
    protected @Nonnull List<@Nonnull DrawableElement> removeTinyLines(@Nonnull @Nonnull List<@Nonnull DrawableElement> converted) {
        ArrayList<@Nonnull DrawableElement> arrayList = null;
        for (int i = 0; i < converted.size(); ++i) {
            double d2;
            DrawableElement drawableElement = converted.get(i);
            if (drawableElement.getType() != ElementType.Curve && drawableElement.getType().getBaseType() != ElementType.Line) {
                if (arrayList == null) continue;
                arrayList.add(drawableElement);
                continue;
            }
            Rectangle2D rectangle2D = LocationUtils.getNormedBounds(drawableElement);
            double d3 = rectangle2D.getWidth();
            double d4 = Math.sqrt(d3 * d3 + (d2 = rectangle2D.getHeight()) * d2);
            if (d4 <= 0.75) {
                GeomShape geomShape = (GeomShape)drawableElement;
                double d5 = geomShape.getStroke() != null && geomShape.getStrokePaint() != null ? (double)geomShape.getStroke().getLineWidth() : 0.0;
                if ((d4 = Math.sqrt((d3 += d5) * d3 + (d2 += d5) * d2)) > 0.75) {
                    if (arrayList == null) continue;
                    arrayList.add(drawableElement);
                    continue;
                }
                if (arrayList != null) continue;
                arrayList = new ArrayList<DrawableElement>(converted.size() - 1);
                if (i <= 0) continue;
                arrayList.addAll(converted.subList(0, i));
                continue;
            }
            if (arrayList == null) continue;
            arrayList.add(drawableElement);
        }
        if (arrayList != null) {
            converted = arrayList;
        }
        return converted;
    }

    private List<@Nonnull DrawableElement> e(List<@Nonnull DrawableElement> list) {
        ArrayList<@Nonnull ImageElement> arrayList = new ArrayList<ImageElement>(64);
        ArrayList<@Nonnull DrawableElement> arrayList2 = null;
        for (int i = 0; i < list.size(); ++i) {
            DrawableElement drawableElement = list.get(i);
            if (drawableElement instanceof ImageElement) {
                if (arrayList2 == null) {
                    arrayList2 = new ArrayList<DrawableElement>(list.size());
                    arrayList2.addAll(list.subList(0, i));
                }
                arrayList.add((ImageElement)drawableElement);
                continue;
            }
            if (arrayList2 == null) continue;
            arrayList2.add(drawableElement);
        }
        if (arrayList2 == null) {
            return list;
        }
        this.f(arrayList, arrayList2);
        return arrayList2;
    }

    private void f(List<@Nonnull ImageElement> list, List<@Nonnull DrawableElement> list2) {
        Collections.sort(list, ElementSorter.YX_COMPARATOR);
        List list3 = list.stream().map(imageElement -> new com.inet.pdfc.generator.filter.convert.a((ImageElement)imageElement)).collect(Collectors.toList());
        int n = 0;
        for (a.a a2 : a.a.values()) {
            do {
                n = 0;
                block2: for (int i = 0; i < list3.size(); ++i) {
                    com.inet.pdfc.generator.filter.convert.a a3 = (com.inet.pdfc.generator.filter.convert.a)list3.get(i);
                    if (a3 == null) continue;
                    for (int j = i + 1; j < list3.size(); ++j) {
                        com.inet.pdfc.generator.filter.convert.a a4 = (com.inet.pdfc.generator.filter.convert.a)list3.get(j);
                        if (a4 != null && a4.a(a3, a2)) {
                            a3.c(a4);
                            list3.set(j, null);
                            ++n;
                            continue;
                        }
                        if (a2 == a.a.fk && a4 != null) continue block2;
                    }
                }
                if (n <= list3.size() * 2 / 3) continue;
                ArrayList arrayList = new ArrayList(list3.size() - n);
                for (int i = 0; i < list3.size(); ++i) {
                    com.inet.pdfc.generator.filter.convert.a a5 = (com.inet.pdfc.generator.filter.convert.a)list3.get(i);
                    if (a5 == null) continue;
                    arrayList.add(a5);
                }
                list3 = arrayList;
            } while (n > 0);
        }
        for (com.inet.pdfc.generator.filter.convert.a a6 : list3) {
            ImageElement imageElement2;
            if (a6 == null || (imageElement2 = a6.a(this.bt)) == null) continue;
            list2.add(imageElement2);
        }
    }

    @Nonnull
    private @Nonnull List<@Nonnull DrawableElement> a(List<@Nonnull DrawableElement> list, int n, boolean bl, boolean bl2) {
        Object object;
        Object object2;
        ArrayList<@Nonnull DrawableElement> arrayList = new ArrayList<DrawableElement>(list.size());
        if (list.size() < 1) {
            return arrayList;
        }
        String string = LanguageManager.getInstance().getLanguage(bl).getCountry();
        TextModuleUtils.StyleState styleState = new TextModuleUtils.StyleState();
        block4: for (int i = 0; i < list.size(); ++i) {
            DrawableElement drawableElement2 = list.get(i);
            switch (drawableElement2.getType()) {
                case Shape: {
                    if (((ShapeElement)drawableElement2).getIsClip()) continue block4;
                    this.a(drawableElement2, this.eE, this.getPageSize(n, bl), arrayList);
                    continue block4;
                }
                case Text: {
                    int n2 = TextModuleUtils.convertText(i, list, arrayList, styleState, string, bl2);
                    i += n2 - 1;
                    continue block4;
                }
                default: {
                    if (drawableElement2.getType().isStructuralType()) {
                        object2 = this.a(((StructureElement)drawableElement2).getChildren(), drawableElement2.getPageIndex(), bl, bl2);
                        object = drawableElement2.getBounds();
                        if (object == null) continue block4;
                        if ((drawableElement2.getType() == ElementType.Paragraph || drawableElement2.getType() == ElementType.TextLine) && ((StructureElement)drawableElement2).getChildren().stream().filter(drawableElement -> drawableElement.getType() == ElementType.Text).findAny().isPresent()) {
                            if (object2.size() == 0) continue block4;
                            object = LocationUtils.getJoinedBounds((List<? extends PagedElement>)object2);
                        }
                        arrayList.add(new StructureElement(drawableElement2.getType(), (Rectangle2D)object, (List<DrawableElement>)object2, drawableElement2.getPageIndex(), drawableElement2.getElementID(), ((StructureElement)drawableElement2).getTagElement()));
                        continue block4;
                    }
                    arrayList.add(drawableElement2);
                }
            }
        }
        for (DrawableElement drawableElement2 : arrayList) {
            WordElement wordElement;
            if (drawableElement2.getType() != ElementType.TextWord) continue;
            if (drawableElement2.getLabel().indexOf(173) >= 0) {
                wordElement = (WordElement)drawableElement2;
                wordElement.setWord(wordElement.getCompareWord().replace('\u00ad', '-'), true);
            }
            if (!this.eC || ((String)(object = ((String)(object2 = UmlautsUtils.replaceUmlauts((String)(wordElement = (WordElement)drawableElement2).getCompareWord()))).toLowerCase())).equals(wordElement.getCompareWord())) continue;
            wordElement.setWord((String)object, true);
        }
        return arrayList;
    }

    private boolean f(List<@Nonnull DrawableElement> list) {
        for (DrawableElement drawableElement : list) {
            if (drawableElement.getType() == ElementType.LineHorizontal && drawableElement.getBounds().getWidth() > 3.0) {
                return true;
            }
            if (!drawableElement.getType().isStructuralType() || !(drawableElement instanceof StructureElement) || !this.f(((StructureElement)drawableElement).getChildren())) continue;
            return true;
        }
        return false;
    }

    @Nonnull
    private @Nonnull List<@Nonnull DrawableElement> g(@Nonnull @Nonnull List<@Nonnull DrawableElement> list) {
        Object object;
        ArrayList<DrawableElement> arrayList;
        Object object2;
        HashSet<Serializable> hashSet;
        if (!this.f(list)) {
            return list;
        }
        List<@Nonnull DrawableElement> list2 = list;
        if (StructureElement.hasStructures(list)) {
            list2 = StructureElement.unpack(list);
        }
        ArrayList<LineShape> arrayList2 = new ArrayList<LineShape>();
        List<@Nonnull LineShape> list3 = list2.stream().filter(drawableElement -> drawableElement.getType() == ElementType.LineVertical).map(drawableElement -> (LineShape)drawableElement).collect(Collectors.toList());
        ElementSearch elementSearch = list3.isEmpty() ? null : new ElementSearch<LineShape>(LocationUtils.getJoinedBounds(list3)).addAll(list3);
        ArrayList<@Nonnull DrawableElement> arrayList3 = new ArrayList<DrawableElement>();
        HashSet<DrawableElement> hashSet2 = new HashSet<DrawableElement>();
        for (DrawableElement serializable2 : list2) {
            switch (serializable2.getType()) {
                case LineHorizontal: {
                    boolean lineShape;
                    if (!(serializable2.getBounds().getWidth() > 2.0)) break;
                    hashSet = (LineShape)serializable2;
                    arrayList3.add(serializable2);
                    if ((((GeomShape)((Object)hashSet)).getStroke() == null || ((GeomShape)((Object)hashSet)).getStrokePaint() == null) && (object2 = ((GeomShape)((Object)hashSet)).getFillPaint()) instanceof TwoSidedPaint && (object2 = ((TwoSidedPaint)((Object)(arrayList = (TwoSidedPaint)object2))).getPaint(lineShape = ((LineShape)((Object)hashSet)).getLine().getX1() > ((LineShape)((Object)hashSet)).getLine().getX2())) == null || elementSearch != null && (this.a(((LineShape)((Object)hashSet)).getLine().getP1(), elementSearch) || this.a(((LineShape)((Object)hashSet)).getLine().getP2(), elementSearch))) break;
                    arrayList2.add((LineShape)((Object)hashSet));
                    break;
                }
                case Line: {
                    hashSet = serializable2.getBounds();
                    if (((RectangularShape)((Object)hashSet)).getWidth() != 0.0 || ((RectangularShape)((Object)hashSet)).getHeight() != 0.0) break;
                    hashSet2.add(serializable2);
                    break;
                }
                case TextWord: {
                    arrayList3.add(serializable2);
                    break;
                }
            }
        }
        if (arrayList2.isEmpty()) {
            return list;
        }
        ElementSearch elementSearch2 = new ElementSearch(LocationUtils.getJoinedBounds(arrayList3));
        elementSearch2.addAll(arrayList3);
        ArrayList<a> arrayList4 = new ArrayList<a>();
        hashSet = new HashSet<Serializable>();
        object2 = null;
        for (LineShape a2 : arrayList2) {
            if (hashSet.contains(a2)) continue;
            Rectangle2D rectangle2D = a2.getBounds();
            Rectangle2D.Double double_ = new Rectangle2D.Double(rectangle2D.getMinX() - this.ex, rectangle2D.getY() - 6.0, rectangle2D.getWidth() + this.ex * 2.0, 12.0);
            List list4 = elementSearch2.getElementsInAreaAsList(double_, true);
            boolean bl = false;
            boolean bl2 = false;
            boolean bl3 = false;
            boolean bl4 = false;
            boolean bl5 = false;
            for (Serializable serializable3 : list4) {
                double d2;
                if (serializable3 == a2) continue;
                if (serializable3.getType() == ElementType.LineHorizontal) {
                    Serializable serializable2;
                    object = serializable3.getBounds();
                    if (!(Math.abs(((RectangularShape)object).getMinX() - rectangle2D.getMinX()) < this.ex) || !(Math.abs(((RectangularShape)object).getMaxX() - rectangle2D.getMaxX()) < this.ex) || !(Math.abs(((RectangularShape)object).getY() - rectangle2D.getY()) < 6.0)) continue;
                    if (object2 == null) {
                        serializable2 = new DefaultProfile();
                        serializable2.putValue(PDFCProperty.TOLERANCE_COLOR, "0");
                        object2 = new PaintComparator((IProfile)serializable2);
                    }
                    serializable2 = (LineShape)serializable3;
                    if (((PaintComparator)object2).isEqual(a2.getFillPaint(), ((GeomShape)serializable2).getFillPaint()) && ((PaintComparator)object2).isEqual(a2.getStrokePaint(), ((GeomShape)serializable2).getStrokePaint())) continue;
                    if (!bl4) {
                        hashSet.add(a2);
                    }
                    hashSet.add(serializable2);
                    bl4 = true;
                    continue;
                }
                if (hashSet2.contains(serializable3) || bl4 || bl && bl2) continue;
                object = serializable3.getBounds();
                double d3 = rectangle2D.getY() - LocationUtils.getMaxY((Rectangle2D)object) + 0.001;
                double d4 = Math.abs(((RectangularShape)object).getHeight());
                if (d3 >= 0.0 && d3 < d4 / 3.0) {
                    bl5 = true;
                } else {
                    if (!(d3 < -d4 * 0.25) || !(d3 > -0.7 * d4)) continue;
                    bl5 = false;
                }
                if (!bl) {
                    if (Math.abs(rectangle2D.getMinX() - ((RectangularShape)object).getMinX()) < this.ex) {
                        bl = true;
                    } else {
                        d2 = ((WordElement)serializable3).getStyle().getWsWidthScaled();
                        if (Math.abs(rectangle2D.getMinX() - ((RectangularShape)object).getMaxX()) < Math.min(this.ex, 3.0) && rectangle2D.getWidth() < d2 * 2.0) {
                            bl = true;
                            bl3 = true;
                        }
                    }
                }
                if (!bl) continue;
                d2 = Math.max(((WordElement)serializable3).getStyle().getWsWidthScaled(), this.ex);
                double d5 = (bl3 ? rectangle2D.getMinX() : rectangle2D.getMaxX()) - d4 / 2.0 - d2;
                double d6 = rectangle2D.getMaxX() + d4 / 2.0 + d2;
                double d7 = ((RectangularShape)object).getMaxX();
                if (!(d5 < d7) || !(d6 > d7)) continue;
                bl2 = true;
            }
            if (!bl || !bl2 || bl4) continue;
            a2.setUnderline(true);
            arrayList4.add(new a(a2, bl5));
        }
        block8: for (a a2 : arrayList4) {
            Serializable serializable4;
            boolean bl;
            Serializable serializable3;
            LineShape lineShape = a2.eK;
            boolean bl6 = lineShape.isUnderline();
            boolean bl7 = bl = hashSet2.contains(lineShape) || hashSet.contains(lineShape);
            if (!bl6 || bl) continue;
            double d8 = 0.0;
            List<LineShape> list5 = this.a(lineShape, arrayList2, list3);
            if (list5 != null) {
                for (Serializable serializable4 : list5) {
                    d8 = Math.max(d8, serializable4.getBounds().getHeight());
                    double d9 = lineShape.getBounds().getMinY();
                    if (!(serializable4.getBounds().getMinY() < d9)) continue;
                    lineShape.setUnderline(false);
                    continue block8;
                }
                hashSet2.addAll(list5);
                if (this.eA) {
                    hashSet2.remove(lineShape);
                }
            } else {
                if (lineShape.getStrokePaint() == null || lineShape.getStroke() == null) {
                    lineShape.setUnderline(false);
                    continue;
                }
                d8 = lineShape.getStroke().getLineWidth();
                if (!this.eA) {
                    hashSet2.add(lineShape);
                }
            }
            Rectangle2D rectangle2D = lineShape.getBounds();
            serializable4 = new Rectangle2D.Double(rectangle2D.getMinX() - this.ex, rectangle2D.getY() - 6.0, rectangle2D.getWidth() + this.ex * 2.0, 12.0);
            List list6 = elementSearch2.getElementsInArea((Rectangle2D)((Object)serializable4), false);
            serializable3 = null;
            object = null;
            for (DrawableElement drawableElement2 : list6) {
                if (drawableElement2.getType() != ElementType.TextWord) continue;
                Rectangle2D rectangle2D2 = LocationUtils.getNormedBounds(drawableElement2);
                double d10 = rectangle2D.getY() - LocationUtils.getMaxY(rectangle2D2);
                double d11 = Math.abs(rectangle2D2.getHeight());
                if (!(d10 >= 0.0 && d10 < d11 / 3.0) && (!(d10 < -d11 * 0.25) || !(d10 > -0.7 * d11)) || d8 > rectangle2D2.getHeight() / 2.0 || !(rectangle2D2.getMinX() > rectangle2D.getMinX() - this.ex) || !(rectangle2D2.getMaxX() < rectangle2D.getMaxX() + this.ex)) continue;
                WordElement wordElement = (WordElement)drawableElement2;
                TextStyle textStyle = wordElement.getStyle();
                if (!textStyle.equalsWithColors((TextStyle)serializable3) || object == null) {
                    object = new TextStyle(textStyle);
                    if (a2.isUnderline || textStyle.isSuperscript()) {
                        ((TextStyle)object).setUnderlined();
                    } else {
                        ((TextStyle)object).setStrikethrough();
                    }
                }
                wordElement.setStyle((TextStyle)object);
                serializable3 = textStyle;
            }
            if (object != null) continue;
            lineShape.setUnderline(false);
        }
        if (hashSet2.size() == 0) {
            return list;
        }
        arrayList = new ArrayList<DrawableElement>(Math.max(16, list.size() - hashSet2.size()));
        for (DrawableElement drawableElement3 : list) {
            if (hashSet2.contains(drawableElement3)) continue;
            if (drawableElement3.getType().isStructuralType()) {
                if (!this.a((StructureElement)drawableElement3, hashSet2)) continue;
                arrayList.add(drawableElement3);
                continue;
            }
            arrayList.add(drawableElement3);
        }
        return arrayList;
    }

    private boolean a(Point2D point2D, ElementSearch<? extends DrawableElement> elementSearch) {
        elementSearch.setSearchAreaTolerance(0.0);
        Rectangle2D.Double double_ = new Rectangle2D.Double(point2D.getX() - 2.0, point2D.getY() - 2.0, 4.0, 4.0);
        List<@Nonnull ? extends DrawableElement> list = elementSearch.getElementsInArea(double_);
        for (DrawableElement drawableElement : list) {
            LineShape lineShape;
            if (drawableElement.getType() != ElementType.LineVertical || !(drawableElement.getBounds().getHeight() > 6.0) || (lineShape = (LineShape)drawableElement).getStroke() != null && lineShape.getStrokePaint() != null && Math.abs(point2D.getX() - lineShape.getX()) > (double)lineShape.getStroke().getLineWidth() * 0.6) continue;
            return true;
        }
        return false;
    }

    private boolean a(StructureElement structureElement, Set<DrawableElement> set) {
        List<@Nonnull DrawableElement> list = structureElement.getChildren();
        if (!list.stream().filter(drawableElement -> set.contains(drawableElement)).findAny().isPresent()) {
            return true;
        }
        List<@Nonnull T> list2 = list.stream().filter(drawableElement -> !set.contains(drawableElement)).collect(Collectors.toList());
        list.clear();
        list.addAll(list2);
        return list.size() > 0;
    }

    private List<LineShape> a(LineShape lineShape, List<LineShape> list, List<LineShape> list2) {
        LineShape lineShape2 = null;
        LineShape lineShape3 = null;
        boolean bl = false;
        Rectangle2D rectangle2D = lineShape.getBounds();
        double d2 = rectangle2D.getMinX();
        double d3 = rectangle2D.getMaxX();
        double d4 = rectangle2D.getY();
        for (LineShape lineShape4 : list2) {
            Rectangle2D rectangle2D2 = lineShape4.getBounds();
            boolean bl2 = false;
            double d5 = LocationUtils.getMinY(rectangle2D2);
            if (ConvertFilter.isSimilar(d5, d4, lineShape4, lineShape)) {
                bl2 = true;
            } else {
                double d6 = LocationUtils.getMaxY(rectangle2D2);
                if (!ConvertFilter.isSimilar(d6, d4, lineShape4, lineShape)) continue;
                bl2 = false;
            }
            if (ConvertFilter.isSimilar(rectangle2D2.getX(), d2, lineShape4, lineShape)) {
                lineShape2 = lineShape4;
                bl = bl2;
                if (lineShape3 == null) continue;
                break;
            }
            if (!ConvertFilter.isSimilar(rectangle2D2.getX(), d3, lineShape4, lineShape)) continue;
            lineShape3 = lineShape4;
            bl = bl2;
            if (lineShape2 == null) continue;
            break;
        }
        if (lineShape2 == null || lineShape3 == null) {
            return null;
        }
        Rectangle2D rectangle2D3 = lineShape2.getBounds();
        if (ConvertFilter.isSimilar(rectangle2D3.getHeight(), lineShape3.getBounds().getHeight(), lineShape2, lineShape3)) {
            double d7 = bl ? LocationUtils.getMaxY(rectangle2D3) : LocationUtils.getMinY(rectangle2D3);
            for (LineShape lineShape5 : list) {
                Rectangle2D rectangle2D4 = lineShape5.getBounds();
                if (lineShape5 == lineShape || !ConvertFilter.isSimilar(rectangle2D4.getMinX(), d2, lineShape5, lineShape) || !ConvertFilter.isSimilar(rectangle2D4.getMaxX(), d3, lineShape5, lineShape) || !ConvertFilter.isSimilar(rectangle2D4.getY(), d7, lineShape5, lineShape)) continue;
                ArrayList<LineShape> arrayList = new ArrayList<LineShape>();
                arrayList.add(bl ? lineShape : lineShape5);
                arrayList.add(lineShape2);
                arrayList.add(bl ? lineShape5 : lineShape);
                arrayList.add(lineShape3);
                return arrayList;
            }
        }
        return null;
    }

    public static boolean isSimilar(double d1, double d2, LineShape l1, LineShape l2) {
        double d3 = 0.05;
        if (l1.getStroke() != null) {
            d3 = Math.max(d3, (double)l1.getStroke().getLineWidth());
        }
        if (l2.getStroke() != null) {
            d3 = Math.max(d3, (double)l2.getStroke().getLineWidth());
        }
        return Math.abs(d1 - d2) <= (d3 *= 1.5);
    }

    public static boolean isSimilar(double d1, double d2) {
        return Math.abs(d1 - d2) <= 0.05;
    }

    private void a(DrawableElement drawableElement, boolean bl, Dimension dimension, List<DrawableElement> list) {
        if (drawableElement instanceof ImageElement) {
            ImageElement imageElement = (ImageElement)drawableElement;
            Rectangle rectangle = LocationUtils.getBounds(imageElement);
            if (rectangle.width > 0 && rectangle.height > 0) {
                list.add(imageElement);
            }
        } else if (drawableElement instanceof ShapeElement) {
            Shape shape;
            ShapeElement shapeElement = (ShapeElement)drawableElement;
            if (shapeElement.getIsClip()) {
                return;
            }
            if (dimension != null && Color.WHITE.equals(shapeElement.getFillPaint()) && ((Rectangle)(shape = shapeElement.getBounds().getBounds())).contains(0, 0, dimension.width, dimension.height)) {
                return;
            }
            shape = shapeElement.getShape();
            if (this.b(shape, shapeElement.getFillPaint() != null)) {
                List<Shape> list2 = this.a(shape, shapeElement.getFillPaint() != null);
                for (int i = 0; i < list2.size(); ++i) {
                    Shape shape2 = list2.get(i);
                    Rectangle2D rectangle2D = shape2.getBounds2D();
                    Point2D.Double double_ = new Point2D.Double(rectangle2D.getX(), rectangle2D.getY());
                    ShapeElement shapeElement2 = new ShapeElement(false, shapeElement.getPageIndex(), double_, shape2, shapeElement.getStroke(), shapeElement.getStrokePaint(), shapeElement.getFillPaint(), drawableElement.getElementID().getDescendant(i));
                    if (bl) {
                        list.addAll(this.a(shapeElement2));
                        continue;
                    }
                    list.add(shapeElement2);
                }
            } else if (bl) {
                list.addAll(this.a(shapeElement));
            } else {
                list.add(shapeElement);
            }
        }
    }

    @Nonnull
    @Nonnull List<@Nonnull DrawableElement> a(ShapeElement shapeElement) {
        Object object;
        boolean bl;
        Paint paint = shapeElement.getStrokePaint();
        Paint paint2 = shapeElement.getFillPaint();
        BasicStroke basicStroke = paint != null ? shapeElement.getStroke() : null;
        boolean bl2 = bl = paint == null || basicStroke == null;
        if (bl) {
            if (paint2 == null) {
                return new ArrayList<DrawableElement>();
            }
            object = shapeElement.getBounds();
            double d2 = ((RectangularShape)object).getWidth();
            double d3 = ((RectangularShape)object).getHeight();
            if (d2 == 0.0 && d3 == 0.0) {
                return new ArrayList<DrawableElement>();
            }
            if (d2 == 0.0 || d3 == 0.0) {
                Line2D.Double double_ = new Line2D.Double(((RectangularShape)object).getX(), ((RectangularShape)object).getY(), ((RectangularShape)object).getX() + d2, ((RectangularShape)object).getY() + d3);
                ArrayList<@Nonnull DrawableElement> arrayList = new ArrayList<DrawableElement>(1);
                arrayList.add(new LineShape(double_, paint2, null, new BasicStroke(0.0f), shapeElement.getPageIndex(), shapeElement, shapeElement.getElementID().getDescendant()));
                return arrayList;
            }
        }
        if ((object = shapeElement.getShapeSegments()) == null) {
            return new ArrayList<DrawableElement>();
        }
        List<@Nonnull DrawableElement> list = new ArrayList<DrawableElement>(object.size());
        ArrayList<Point2D> arrayList = null;
        Point2D point2D = null;
        if (paint2 != null) {
            arrayList = new ArrayList<Point2D>(object.size() + 2);
        }
        boolean bl3 = true;
        ElementID elementID = shapeElement.getElementID();
        GeomShape geomShape = null;
        Point2D point2D2 = null;
        LineShape lineShape = null;
        int n = 0;
        Iterator iterator = object.iterator();
        while (iterator.hasNext()) {
            LineShape lineShape2;
            GeomShape geomShape2;
            Serializable serializable;
            Object object2;
            Object e2 = iterator.next();
            ElementID elementID2 = elementID.getDescendant(list.size());
            geomShape = null;
            if (e2 instanceof Line2D) {
                object2 = (Line2D)e2;
                geomShape = new LineShape((Line2D)object2, shapeElement, elementID2);
                if (point2D == null) {
                    point2D = ((Line2D)object2).getP1();
                    if (arrayList != null) {
                        arrayList.add(point2D);
                    } else {
                        n = list.size();
                    }
                }
                point2D2 = ((Line2D)object2).getP2();
                if (lineShape != null && lineShape.getLine().getP2().equals(((Line2D)object2).getP1()) && lineShape.canMergeByAngle((LineShape)geomShape, true)) {
                    if (lineShape.isParallel((LineShape)geomShape) && !lineShape.hasSameDirection((LineShape)geomShape)) {
                        geomShape = null;
                    } else {
                        list.remove(list.size() - 1);
                        if (arrayList != null) {
                            arrayList.remove(arrayList.size() - 1);
                        }
                        geomShape = new LineShape(new Line2D.Double(lineShape.getLine().getP1(), ((Line2D)object2).getP2()), shapeElement, elementID2);
                    }
                } else {
                    lineShape = geomShape;
                }
            } else if (e2 instanceof CubicCurve2D) {
                CubicCurve2D cubicCurve2D = (CubicCurve2D)e2;
                geomShape = new CubicCurveShape(cubicCurve2D, shapeElement, elementID2);
                if (point2D == null) {
                    point2D = cubicCurve2D.getP1();
                    if (arrayList != null) {
                        arrayList.add(point2D);
                    } else {
                        n = list.size();
                    }
                }
                point2D2 = cubicCurve2D.getP2();
                lineShape = null;
                bl3 = false;
            } else if (e2 instanceof QuadCurve2D) {
                QuadCurve2D quadCurve2D = (QuadCurve2D)e2;
                geomShape = new QuadCurveShape(quadCurve2D, shapeElement, elementID2);
                if (point2D == null) {
                    point2D = quadCurve2D.getP1();
                    if (arrayList != null) {
                        arrayList.add(point2D);
                    } else {
                        n = list.size();
                    }
                }
                point2D2 = quadCurve2D.getP2();
                lineShape = null;
                bl3 = false;
            }
            if (geomShape == null) continue;
            list.add(geomShape);
            if (arrayList != null) {
                if (point2D != null && point2D.equals(point2D2)) {
                    arrayList.add(point2D2);
                    boolean bl4 = this.h(arrayList);
                    serializable = new TwoSidedPaint(paint2, elementID2, bl4);
                    for (int i = list.size() - 1; i >= 0 && !((geomShape2 = (GeomShape)list.get(i)).getFillPaint() instanceof TwoSidedPaint); --i) {
                        geomShape2.setFillPaint((Paint)((Object)serializable));
                    }
                    point2D = null;
                    arrayList.clear();
                    continue;
                }
                arrayList.add(point2D2);
                continue;
            }
            if (point2D == null || !point2D.equals(point2D2) || n >= list.size() - 1) continue;
            object2 = list.get(n);
            serializable = list.get(list.size() - 1);
            if (object2 instanceof LineShape && serializable instanceof LineShape && (lineShape2 = (LineShape)object2).canMergeByAngle((LineShape)(geomShape2 = (LineShape)serializable), true)) {
                lineShape2.getLine().setLine(((LineShape)geomShape2).getLine().getP1(), lineShape2.getLine().getP2());
                list.remove(list.size() - 1);
            }
            point2D = null;
        }
        if (bl3) {
            list = this.a(shapeElement, list);
        }
        return list;
    }

    private boolean h(List<Point2D> list) {
        double d2 = 0.0;
        for (int i = 0; i < list.size() - 2; ++i) {
            d2 += ConvertFilter.a(list.get(i), list.get(i + 1), list.get(i + 2));
        }
        double d3 = (double)(list.size() - 3) * Math.PI;
        return Math.abs(d3 - (d2 += ConvertFilter.a(list.get(list.size() - 2), list.get(0), list.get(1)))) > 0.05;
    }

    static double a(Point2D point2D, Point2D point2D2, Point2D point2D3) {
        double d2 = point2D.getX() - point2D2.getX();
        double d3 = point2D3.getX() - point2D2.getX();
        double d4 = point2D.getY() - point2D2.getY();
        double d5 = point2D3.getY() - point2D2.getY();
        double d6 = d2 * d3 + d4 * d5;
        double d7 = d2 * d5 - d3 * d4;
        double d8 = point2D.distance(point2D2) * point2D3.distance(point2D2);
        double d9 = Math.acos(d6 / d8);
        return (d7 > 0.0 ? Math.PI * 2 - d9 : d9) % (Math.PI * 2);
    }

    private List<Shape> a(Shape shape, boolean bl) {
        ArrayList<Shape> arrayList = new ArrayList<Shape>();
        PathIterator pathIterator = shape.getPathIterator(new AffineTransform());
        GeneralPath generalPath = new GeneralPath(pathIterator.getWindingRule());
        double[] dArray = new double[6];
        boolean bl2 = false;
        Point2D.Double double_ = null;
        boolean bl3 = false;
        while (!pathIterator.isDone()) {
            int n = pathIterator.currentSegment(dArray);
            switch (n) {
                case 4: {
                    if (!bl2) break;
                    generalPath.closePath();
                    arrayList.add(generalPath);
                    generalPath = new GeneralPath(pathIterator.getWindingRule());
                    bl2 = false;
                    bl3 = false;
                    break;
                }
                case 3: {
                    if (!bl3 && double_ != null) {
                        generalPath.moveTo(double_.getX(), double_.getY());
                        bl3 = true;
                    }
                    bl2 = true;
                    generalPath.curveTo(dArray[0], dArray[1], dArray[2], dArray[3], dArray[4], dArray[5]);
                    break;
                }
                case 1: {
                    if (!bl3 && double_ != null) {
                        generalPath.moveTo(double_.getX(), double_.getY());
                        bl3 = true;
                    }
                    bl2 = true;
                    generalPath.lineTo(dArray[0], dArray[1]);
                    break;
                }
                case 2: {
                    if (!bl3 && double_ != null) {
                        generalPath.moveTo(double_.getX(), double_.getY());
                        bl3 = true;
                    }
                    bl2 = true;
                    generalPath.quadTo(dArray[0], dArray[1], dArray[2], dArray[3]);
                    break;
                }
                case 0: {
                    if (bl2 && !bl) {
                        generalPath.closePath();
                        arrayList.add(generalPath);
                        generalPath = new GeneralPath(pathIterator.getWindingRule());
                        bl2 = false;
                    }
                    generalPath.moveTo(dArray[0], dArray[1]);
                    double_ = new Point2D.Double(dArray[0], dArray[1]);
                    bl3 = true;
                }
            }
            pathIterator.next();
        }
        if (bl2) {
            arrayList.add(generalPath);
        }
        return arrayList;
    }

    private boolean b(Shape shape, boolean bl) {
        PathIterator pathIterator = shape.getPathIterator(new AffineTransform());
        boolean bl2 = false;
        boolean bl3 = false;
        double[] dArray = new double[6];
        while (!pathIterator.isDone()) {
            int n = pathIterator.currentSegment(dArray);
            pathIterator.next();
            if (bl && n == 0) continue;
            if (n == 4 || n == 0) {
                if (!bl2) continue;
                bl3 = true;
                continue;
            }
            if (bl3) {
                return true;
            }
            bl2 = true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    @Nonnull
    private @Nonnull List<@Nonnull DrawableElement> a(ShapeElement shapeElement, @Nonnull @Nonnull List<@Nonnull DrawableElement> list) {
        boolean bl;
        if (list.size() != 4 || shapeElement.getFillPaint() != null && shapeElement.getStrokePaint() != null) {
            return list;
        }
        Rectangle2D rectangle2D = shapeElement.getBounds();
        double d2 = rectangle2D.getWidth();
        double d3 = rectangle2D.getHeight();
        if (d3 > 5.0 && d2 > 5.0 || d3 / d2 < 10.0 && d2 / d3 < 10.0) {
            return list;
        }
        if (shapeElement.getFillPaint() != null) {
            bl = false;
        } else if (shapeElement.getStrokePaint() != null && shapeElement.getStroke() != null && shapeElement.getStroke().getDashArray() == null) {
            float f2 = shapeElement.getStroke().getLineWidth();
            if ((double)f2 < d2 && (double)f2 < d3) {
                return list;
            }
            bl = true;
        } else {
            return list;
        }
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        block4: for (DrawableElement object2 : list) {
            if (!(object2 instanceof LineShape)) {
                return list;
            }
            Line2D line2D = ((LineShape)object2).getLine();
            switch (object2.getType()) {
                case LineHorizontal: {
                    if (!ConvertFilter.isSimilar(Math.abs(line2D.getX1() - line2D.getX2()), d2)) {
                        return list;
                    }
                    if (!ConvertFilter.isSimilar(line2D.getY1(), rectangle2D.getMinY())) {
                        bl2 = true;
                        continue block4;
                    }
                    if (!ConvertFilter.isSimilar(line2D.getY1(), rectangle2D.getMaxY())) {
                        bl3 = true;
                        continue block4;
                    }
                    return list;
                }
                case LineVertical: {
                    if (!ConvertFilter.isSimilar(Math.abs(line2D.getY1() - line2D.getY2()), d3)) {
                        return list;
                    }
                    if (!ConvertFilter.isSimilar(line2D.getX1(), rectangle2D.getMinX())) {
                        bl4 = true;
                        continue block4;
                    }
                    if (!ConvertFilter.isSimilar(line2D.getX1(), rectangle2D.getMaxX())) {
                        bl5 = true;
                        continue block4;
                    }
                    return list;
                }
            }
            return list;
        }
        if (bl2 && bl3 && bl4 && bl5) {
            void var14_16;
            Object object;
            list = new ArrayList<DrawableElement>();
            if (bl) {
                rectangle2D = shapeElement.getStroke().createStrokedShape(rectangle2D).getBounds2D();
                d2 = rectangle2D.getWidth();
                d3 = rectangle2D.getHeight();
            }
            if (d2 > d3) {
                object = new Line2D.Double(rectangle2D.getMinX(), rectangle2D.getCenterY(), rectangle2D.getMaxX(), rectangle2D.getCenterY());
                BasicStroke basicStroke = new BasicStroke((float)d3);
            } else {
                object = new Line2D.Double(rectangle2D.getCenterX(), rectangle2D.getMinY(), rectangle2D.getCenterX(), rectangle2D.getMaxY());
                BasicStroke basicStroke = new BasicStroke((float)d2);
            }
            list.add(new LineShape((Line2D)object, shapeElement.getFillPaint(), null, (BasicStroke)var14_16, shapeElement.getPageIndex(), shapeElement, shapeElement.getElementID().getDescendant()));
        }
        return list;
    }

    private static HighlightData.Highlight.Appearance getHighlightAppearance(AnnotationElement anno) {
        if (LocationUtils.getNormedBounds(anno).isEmpty()) {
            return null;
        }
        String string = anno.getSubtype();
        if (string.equals("Highlight")) {
            return HighlightData.Highlight.Appearance.FILLED_RECTANGLE;
        }
        if (string.equals("StrikeOut")) {
            return HighlightData.Highlight.Appearance.STRIKEOUT;
        }
        if (string.equals("Underline")) {
            return HighlightData.Highlight.Appearance.UNDERLINE;
        }
        if (string.equals("Text") || string.equals("FreeText") || string.equals("Line") || string.equals("Circle") || string.equals("Square") || string.equals("Polygon") || string.equals("Caret") || string.equals("Stamp") || string.equals("Ink") || string.equals("PolyLine") || string.equals("Squiggly")) {
            return HighlightData.Highlight.Appearance.CUSTOM;
        }
        return null;
    }

    @Override
    public HighlightData getHighlightProvider() {
        return this.eB;
    }

    /*
     * WARNING - void declaration
     */
    private void a(Map<Double, b> map, List<@Nonnull DrawableElement> list, int n, boolean bl, boolean bl2) {
        boolean bl3 = true;
        for (DrawableElement object : list) {
            if (object.getType() != ElementType.Text && object.getType() != ElementType.TextWord || object.getRotation() != 0.0) continue;
            bl3 = false;
            break;
        }
        for (Map.Entry entry : map.entrySet()) {
            void var14_15;
            DrawableElement drawableElement;
            Object object;
            Serializable serializable;
            AffineTransform affineTransform = new AffineTransform();
            double d2 = (Double)entry.getKey();
            affineTransform.rotate(d2);
            List<DrawableElement> list2 = ((b)entry.getValue()).getElements();
            for (DrawableElement drawableElement2 : list2) {
                serializable = (TextElement)drawableElement2;
                object = new AffineTransform(((TextElement)serializable).getTransformMatrix());
                ConvertFilter.a((AffineTransform)object);
                ((TextElement)serializable).calculateBounds((AffineTransform)object, ((TextElement)serializable).getTextWidth(), ((TextElement)serializable).getTextHeight());
            }
            ElementSorter.alignAndSort(list2, 0.15, true, true);
            Collections.sort(list2, ElementSorter.YX_COMPARATOR);
            Object object2 = null;
            ArrayList arrayList = new ArrayList();
            serializable = new ArrayList();
            for (DrawableElement drawableElement3 : list2) {
                drawableElement = (TextElement)drawableElement3;
                if (object2 != null && !this.a((TextElement)object2, (TextElement)drawableElement, !bl3)) {
                    StructureElement structureElement = this.b((List<DrawableElement>)var14_15, n, bl, bl2);
                    if (structureElement != null) {
                        serializable.add(structureElement);
                    }
                    ArrayList arrayList2 = new ArrayList();
                }
                var14_15.add(drawableElement3);
                object2 = drawableElement;
            }
            object = this.b((List<DrawableElement>)var14_15, n, bl, bl2);
            if (object != null) {
                serializable.add(object);
            }
            for (int i = 0; i < serializable.size(); ++i) {
                DrawableElement drawableElement4;
                drawableElement = (StructureElement)serializable.get(i);
                int n2 = Collections.binarySearch(list, drawableElement, ElementSorter.YX_COMPARATOR);
                if (n2 < 0) {
                    n2 = -n2 - 1;
                }
                while (n2 < list.size() && (drawableElement4 = list.get(n2)).getType().isStructuralType() && serializable.indexOf(drawableElement4) >= 0) {
                    ++n2;
                }
                list.add(n2, drawableElement);
            }
        }
    }

    private boolean a(TextElement textElement, TextElement textElement2, boolean bl) {
        if (textElement.getY() != textElement2.getY() || textElement.getX() > textElement2.getX()) {
            return false;
        }
        if (!bl) {
            return true;
        }
        double d2 = (textElement.getStyle().getWsWidthScaled() + textElement2.getStyle().getWsWidthScaled()) / 2.0;
        double d3 = textElement2.getX() - textElement.getBounds().getMaxX();
        return d3 < d2 * 2.5;
    }

    private StructureElement b(List<@Nonnull DrawableElement> list, int n, boolean bl, boolean bl2) {
        TextElement textElement;
        DrawableElement drawableElement2;
        if (list.size() == 0) {
            return null;
        }
        AffineTransform affineTransform = new AffineTransform(((TextElement)list.get(0)).getTransformMatrix());
        HashMap<DrawableElement, double[]> hashMap = new HashMap<DrawableElement, double[]>(list.size());
        for (DrawableElement drawableElement2 : list) {
            textElement = (TextElement)drawableElement2;
            double[] dArray = textElement.getTransformMatrix();
            hashMap.put(drawableElement2, dArray);
            double d2 = Math.sqrt(dArray[0] * dArray[0] + dArray[2] * dArray[2]);
            textElement.setClip(null);
            textElement.setTransformMatrix(new double[]{d2, 0.0, 0.0, -d2, drawableElement2.getX(), drawableElement2.getY()});
        }
        List<DrawableElement> list2 = this.a(list, n, bl, bl2);
        if (list2.size() == 0) {
            return null;
        }
        drawableElement2 = (TextElement)list.get(0);
        textElement = (TextElement)list.get(list.size() - 1);
        double d3 = Math.sqrt(affineTransform.getScaleX() * affineTransform.getScaleX() + affineTransform.getShearX() * affineTransform.getShearX());
        affineTransform.scale(1.0 / d3, 1.0 / d3);
        double d4 = textElement.getBounds().getMaxX() - ((TextElement)drawableElement2).getBounds().getMinX();
        if (list2.size() == 1) {
            TextElement textElement2 = (TextElement)list.get(0);
            WordElement wordElement = (WordElement)list2.get(0);
            Rectangle2D.Double double_ = LocationUtils.createTransformedBounds(affineTransform, new Rectangle2D.Double(0.0, 0.0, d4, textElement2.getTextHeight() * d3));
            wordElement.setBounds(double_);
            wordElement.setStartPointX(new Point2D.Double(affineTransform.getTranslateX(), affineTransform.getTranslateY()));
            this.a(list, hashMap);
            return new StructureElement(ElementType.TextLine, LocationUtils.getNormedBounds(wordElement), list2, ((DrawableElement)list2.get(0)).getPageIndex(), ((DrawableElement)list2.get(0)).getElementID().getDescendant());
        }
        double d5 = 0.0;
        Rectangle2D rectangle2D = ((TextElement)drawableElement2).getBounds();
        for (DrawableElement drawableElement3 : list2) {
            WordElement wordElement = (WordElement)drawableElement3;
            Rectangle2D.Double double_ = wordElement.getBounds();
            d5 = Math.max(d5, Math.abs(double_.getHeight()));
            double d6 = double_.getMinX() - rectangle2D.getMinX();
            double d7 = -(double_.getY() - rectangle2D.getY());
            double_ = LocationUtils.createTransformedBounds(affineTransform, new Rectangle2D.Double(d6, d7, double_.getWidth(), -double_.getHeight()));
            wordElement.setBounds(double_);
            Point2D point2D = new Point2D.Double(d6, d7);
            point2D = affineTransform.transform(point2D, point2D);
            wordElement.setStartPointX(point2D);
        }
        Rectangle2D.Double double_ = LocationUtils.createTransformedBounds(affineTransform, new Rectangle2D.Double(0.0, d5, d4, -d5));
        this.a(list, hashMap);
        return new StructureElement(ElementType.TextLine, double_, list2, ((DrawableElement)list2.get(0)).getPageIndex(), ((DrawableElement)list2.get(0)).getElementID().getDescendant());
    }

    private void a(List<@Nonnull DrawableElement> list, Map<DrawableElement, double[]> map) {
        for (DrawableElement drawableElement : list) {
            TextElement textElement = (TextElement)drawableElement;
            double[] dArray = map.get(drawableElement);
            textElement.setTransformMatrix(dArray);
            textElement.calculateBounds(new AffineTransform(dArray), textElement.getTextWidth(), textElement.getTextHeight());
        }
    }

    private static void a(AffineTransform affineTransform) {
        double[] dArray = new double[6];
        affineTransform.getMatrix(dArray);
        double d2 = dArray[0];
        double d3 = -dArray[1];
        double d4 = d2 != 0.0 ? d3 / d2 : (d3 < 0.0 && d2 > 0.0 || d3 > 0.0 && d2 < 0.0 ? Double.NEGATIVE_INFINITY : Double.POSITIVE_INFINITY);
        d4 = Math.atan(d4);
        if (d2 < 0.0 || d2 == 0.0 && d3 < 0.0) {
            d4 = Math.PI + d4;
        }
        double d5 = affineTransform.getTranslateX();
        double d6 = affineTransform.getTranslateY();
        affineTransform.rotate(-d4);
        double d7 = affineTransform.getScaleX();
        double d8 = affineTransform.getScaleY();
        AffineTransform affineTransform2 = new AffineTransform();
        affineTransform2.rotate(d4);
        Point2D point2D = affineTransform2.transform(new Point2D.Double(d5, d6), null);
        affineTransform.setToTranslation(point2D.getX(), point2D.getY());
        affineTransform.scale(d7, d8);
    }

    public void init(PdfcRenderCache storeMap) {
        this.bt = storeMap;
    }

    private static class a {
        private LineShape eK;
        private boolean isUnderline;

        public a(LineShape lineShape, boolean bl) {
            this.eK = lineShape;
            this.isUnderline = bl;
        }
    }
}

