/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfc;

import com.inet.annotations.InternalApi;
import com.inet.config.ConfigKey;
import com.inet.config.ConfigKeyParser;
import com.inet.config.ConfigValue;
import com.inet.config.Configuration;
import com.inet.config.ConfigurationManager;
import com.inet.config.LicenseInfo;
import com.inet.config.LicenseManager;
import com.inet.config.SystemID;
import com.inet.config.structure.core.CoreSystemStructureProvider;
import com.inet.config.structure.core.license.LicenseConfigProperty;
import com.inet.config.structure.core.license.LicenseEntry;
import com.inet.config.structure.provider.ConfigStructureSettings;
import com.inet.http.servlet.ClientLocale;
import com.inet.lib.util.NetworkFunctions;
import com.inet.pdfc.LicenseModel;
import com.inet.pdfc.PDFCCore;
import com.inet.pdfc.PDFCCorePlugin;
import com.inet.pdfc.plugin.PluginManager;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Enumeration;
import java.util.List;
import java.util.prefs.BackingStoreException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.SuppressFBWarnings;

@InternalApi
public class PDFCLicenseChecker {
    private static final ConfigValue<String> as;
    private static final PDFCLicenseChecker at;
    protected static final String TRIAL_ACTIVATION = "TRIAL_ACTIVATION";
    private static boolean au;
    private static String[] av;

    public static PDFCLicenseChecker getInstance() {
        return at;
    }

    public static LicenseModel getCurrentLicenseModel() {
        return PDFCLicenseChecker.a(ConfigKeyParser.getCurrent());
    }

    protected static void checkSystemImport(LicenseInfo info) {
        LicenseModel licenseModel = new LicenseModel(info);
        if (!licenseModel.isValid() && !au) {
            String string;
            LicenseModel licenseModel2;
            au = true;
            Configuration configuration = null;
            try {
                configuration = ConfigurationManager.getInstance().get(1, "i-net PDFC");
            }
            catch (Throwable throwable) {
                PDFCCore.LOGGER_CORE.debug("Could not check for valid license in system scope. ", (Object)throwable);
                return;
            }
            if (configuration != null && (licenseModel2 = PDFCLicenseChecker.createModelFromEncryptedLicenseKey(string = configuration.get(ConfigKey.LICENSEKEY.getKey()))).isValid()) {
                PDFCLicenseChecker.storeLicense(string);
            }
        }
    }

    public static boolean storeLicense(@Nonnull String key) {
        boolean bl;
        LicenseModel licenseModel;
        String string = as != null ? (String)as.get() : "";
        String string2 = "i-net PDFC";
        ConfigurationManager configurationManager = ConfigurationManager.getInstance();
        Configuration configuration = configurationManager.getCurrent();
        if (!string.contains(key)) {
            configuration.put(ConfigKey.LICENSEKEY.getKey(), key + (String)(string.isEmpty() ? "" : "," + string));
            try {
                configuration.flush();
            }
            catch (BackingStoreException backingStoreException) {
                PDFCCore.LOGGER_CORE.error((Throwable)backingStoreException);
            }
        }
        boolean bl2 = ((licenseModel = PDFCLicenseChecker.createModelFromEncryptedLicenseKey(key)).isServer() || licenseModel.isAPI() || licenseModel.isCommandLine()) && !licenseModel.isTrial();
        boolean bl3 = bl = configuration.getScope() == 1 || !bl2;
        if (bl2 && configuration.getScope() != 1) {
            PDFCCore.LOGGER_CORE.debug((Object)"Attempt so store multi-user license in system-scope");
            try {
                Configuration configuration2 = configurationManager.get(1, string2);
                if (configuration2 == null) {
                    PDFCCore.LOGGER_CORE.debug((Object)"There is no configuration in the system scope, creating a new one.");
                    configuration2 = configurationManager.create(1, string2);
                } else {
                    PDFCCore.LOGGER_CORE.debug((Object)("Using existing configuration '" + configuration2.getName() + "'"));
                }
                string = configuration2.get(ConfigKey.LICENSEKEY.getKey(), "");
                if (!string.contains(key)) {
                    PDFCCore.LOGGER_CORE.debug((Object)"Adding license to configuration");
                    try {
                        configuration2.put(ConfigKey.LICENSEKEY.getKey(), key + "," + string);
                        PDFCCore.LOGGER_CORE.debug((Object)"Storing configuration to the backing store.");
                        configuration2.flush();
                    }
                    catch (SecurityException | BackingStoreException exception) {
                        PDFCCore.LOGGER_CORE.debug((Object)"License not stored due to an access restriction:");
                        PDFCCore.LOGGER_CORE.debug((Object)exception);
                        return bl;
                    }
                    PDFCCore.LOGGER_CORE.debug((Object)"The license is set to the system configuration.");
                } else {
                    PDFCCore.LOGGER_CORE.debug((Object)"This license is already set in the system configuration.");
                }
                bl = true;
            }
            catch (SecurityException securityException) {
                return bl;
            }
        }
        return bl;
    }

    public static LicenseModel createModelFromEncryptedLicenseKey(String licenseKey) {
        LicenseInfo licenseInfo = new ConfigKeyParser().getLicenseInfo(licenseKey).getCurrent();
        return PDFCLicenseChecker.a(licenseInfo);
    }

    @Nonnull
    private static final LicenseModel a(@Nullable LicenseInfo licenseInfo) {
        return new LicenseModel(licenseInfo);
    }

    @Nonnull
    public static String getHashedHardwareKey() {
        String[] stringArray = PDFCLicenseChecker.C();
        StringBuilder stringBuilder = new StringBuilder();
        int n = 0;
        for (String string : stringArray) {
            stringBuilder.append(string);
            if (++n == 10) break;
        }
        stringBuilder.append(PDFCLicenseChecker.B());
        return stringBuilder.toString();
    }

    @SuppressFBWarnings(value={"WEAK_MESSAGE_DIGEST_MD5"}, justification="Only values hashes, not security relevant")
    private static String B() {
        Object object = "";
        try {
            object = NetworkFunctions.getLocalHostName();
            object = (String)object + "_" + Runtime.getRuntime().availableProcessors();
            byte[] byArray = ((String)object).getBytes("utf-8");
            byArray = MessageDigest.getInstance("MD5").digest(byArray);
            object = Base64.getEncoder().encodeToString(byArray);
        }
        catch (Exception exception) {
            PDFCCore.LOGGER_CORE.warn((Object)exception);
        }
        return object;
    }

    @SuppressFBWarnings(value={"WEAK_MESSAGE_DIGEST_MD5"}, justification="Only values hashes, not security relevant")
    private static String[] C() {
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("MD5");
            List list = SystemID.get();
            list.addAll(Arrays.asList(PDFCLicenseChecker.D()));
            for (String string : list) {
                byte[] byArray = string.getBytes(StandardCharsets.UTF_8);
                byArray = messageDigest.digest(byArray);
                string = Base64.getEncoder().encodeToString(byArray);
                arrayList.add(string);
            }
        }
        catch (Exception exception) {
            PDFCCore.LOGGER_CORE.warn((Object)exception);
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public static boolean isValidHardwareHash(String hash) {
        String[] stringArray = PDFCLicenseChecker.C();
        if (hash == null) {
            return false;
        }
        String[] stringArray2 = new String[hash.length() / 24];
        for (int i = 0; i < hash.length() / 24; ++i) {
            stringArray2[i] = hash.substring(i * 24, i * 24 + 24);
        }
        for (String string : stringArray) {
            for (String string2 : stringArray2) {
                if (!MessageDigest.isEqual(string.getBytes(), string2.getBytes())) continue;
                return true;
            }
        }
        if (stringArray.length == 0) {
            String string = PDFCLicenseChecker.B();
            for (String string3 : stringArray2) {
                if (!MessageDigest.isEqual(string.getBytes(), string3.getBytes())) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean testForCorrectHardwareHash(String hwID) {
        try {
            return PDFCLicenseChecker.isValidHardwareHash(hwID);
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    private static String[] D() throws SocketException {
        if (av != null) {
            return av;
        }
        ArrayList<CallSite> arrayList = new ArrayList<CallSite>();
        String string = null;
        Enumeration<NetworkInterface> enumeration = NetworkInterface.getNetworkInterfaces();
        while (enumeration.hasMoreElements()) {
            byte[] byArray;
            NetworkInterface networkInterface = enumeration.nextElement();
            if (networkInterface.isVirtual() || networkInterface.isLoopback() || (byArray = networkInterface.getHardwareAddress()) == null || byArray.length == 0 || byArray.length > 4 && byArray[0] == 0 && byArray[1] == 0 && byArray[2] == 0 && byArray[3] == 0 && byArray[4] == 0 || byArray.length > 5 && byArray[0] == 2 && byArray[1] == 0 && byArray[2] == 84 && byArray[3] == 85 && byArray[4] == 78 && byArray[5] == 1) continue;
            StringBuilder stringBuilder = new StringBuilder();
            for (byte by : byArray) {
                stringBuilder.append(by);
                stringBuilder.append(":");
            }
            if (stringBuilder.length() > 0) {
                stringBuilder.setLength(stringBuilder.length() - 1);
            }
            if (arrayList.contains(string = stringBuilder.toString() + "_" + Runtime.getRuntime().availableProcessors())) continue;
            arrayList.add((CallSite)((Object)string));
        }
        av = arrayList.toArray(new String[arrayList.size()]);
        return av;
    }

    public static void requestAndStoreTrialLicense(ConfigStructureSettings settings) {
        PDFCCorePlugin.r();
        CoreSystemStructureProvider.requestTrialLicense((ConfigStructureSettings)settings);
    }

    public static String requestTrialKeyAndWait(boolean force) throws IOException {
        if (force) {
            PDFCCorePlugin.r();
        }
        return at.h(TRIAL_ACTIVATION);
    }

    private String h(String string) throws IOException {
        PDFCCorePlugin.e(string);
        try {
            String string2 = CoreSystemStructureProvider.requestTrialLicenseKey();
            return string2;
        }
        finally {
            PDFCCorePlugin.e(null);
        }
    }

    public static String requestLicenseKeyAndWait(String text) throws Exception {
        return at.h(text);
    }

    @Nonnull
    public static List<LicenseEntry> getLicenseList() {
        ConfigStructureSettings configStructureSettings = new ConfigStructureSettings(ConfigurationManager.getInstance().getCurrent(), ClientLocale.getThreadLocale(), null);
        ArrayList<LicenseEntry> arrayList = new ArrayList<LicenseEntry>();
        LicenseConfigProperty.addLicensesTo(arrayList, (String)configStructureSettings.getLicenseKey(), (ConfigStructureSettings)configStructureSettings);
        return arrayList;
    }

    static {
        PluginManager.initConditionally();
        LicenseManager.getInstance().addLicenseListener(licenseInfo -> PDFCLicenseChecker.checkSystemImport(licenseInfo));
        as = new ConfigValue(ConfigKey.LICENSEKEY);
        at = new PDFCLicenseChecker();
        au = false;
        av = null;
    }
}

