/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfc.presenter;

import com.inet.annotations.JsonData;
import com.inet.annotations.PublicApi;
import com.inet.lib.io.FastBufferedOutputStream;
import com.inet.lib.io.SupplierWithIOException;
import com.inet.lib.json.Json;
import com.inet.pdfc.PDFCCore;
import com.inet.pdfc.config.PdfSource;
import com.inet.pdfc.error.ExceptionData;
import com.inet.pdfc.generator.message.InfoData;
import com.inet.pdfc.generator.model.DiffGroup;
import com.inet.pdfc.generator.model.Modification;
import com.inet.pdfc.presenter.BasePresenter;
import com.inet.pdfc.util.FileNameUtil;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.SuppressFBWarnings;

@PublicApi
public class JsonSummaryPresenter
extends BasePresenter {
    private JsonSummaryPresenter pt;
    private SummaryJsonResult pu = new SummaryJsonResult();
    private SupplierWithIOException<OutputStream> pv;
    private String pw;
    private String px;

    public JsonSummaryPresenter(@Nonnull File rootFolder) {
        this.pv = new a(rootFolder);
    }

    public JsonSummaryPresenter(@Nonnull SupplierWithIOException<OutputStream> streamProvider) {
        this.pv = streamProvider;
    }

    @Override
    public void onComparisonDone() throws Exception {
        SingleJsonResult singleJsonResult = new SingleJsonResult();
        singleJsonResult.firstName = this.getModel().getComparisonParameters().getFirstFile().getName();
        singleJsonResult.secondName = this.getModel().getComparisonParameters().getSecondFile().getName();
        this.a(this.getModel().getComparisonParameters().getFirstFile(), true);
        this.a(this.getModel().getComparisonParameters().getSecondFile(), false);
        singleJsonResult.pagesFirst = this.getModel().getPageCount(true);
        singleJsonResult.pagesSecond = this.getModel().getPageCount(false);
        singleJsonResult.totalDifferences = this.getModel().getDifferencesCount(true);
        block5: for (DiffGroup diffGroup : this.getModel().getDifferences(true)) {
            switch (diffGroup.getType()) {
                case AddedOrRemoved: {
                    for (Modification modification : diffGroup.getModifications()) {
                        if (modification.getAffectedElements(true).size() > 0) {
                            ++singleJsonResult.removed;
                            continue;
                        }
                        ++singleJsonResult.added;
                    }
                    continue block5;
                }
                case Modified: {
                    singleJsonResult.modified += diffGroup.getDifferencesCount();
                    break;
                }
                case Replaced: {
                    singleJsonResult.replaced += diffGroup.getDifferencesCount();
                    break;
                }
            }
        }
        this.cC().addResult(singleJsonResult);
        if (this.pt == null) {
            this.onFinish();
        }
    }

    @Override
    @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"}, justification="Only admin has access to taskplanner,")
    public void onFinish() {
        if (this.pv == null || this.pt != null) {
            return;
        }
        SummaryJsonResult summaryJsonResult = this.cB();
        try (FastBufferedOutputStream fastBufferedOutputStream = new FastBufferedOutputStream((OutputStream)this.pv.get(), 32768);){
            new Json().toJson((Object)summaryJsonResult, (OutputStream)fastBufferedOutputStream);
        }
        catch (FileNotFoundException fileNotFoundException) {
            PDFCCore.LOGGER_PRESENTER.error((Throwable)fileNotFoundException);
        }
        catch (IOException iOException) {
            PDFCCore.LOGGER_PRESENTER.error((Throwable)iOException);
        }
    }

    @Nonnull
    public String getJson() {
        return new Json().toJson((Object)this.cB());
    }

    @Nonnull
    private SummaryJsonResult cB() {
        SummaryJsonResult summaryJsonResult = this.cC();
        summaryJsonResult.endTimestamp = System.currentTimeMillis();
        if (summaryJsonResult.startTimestamp == 0L) {
            summaryJsonResult.startTimestamp = summaryJsonResult.endTimestamp;
        }
        summaryJsonResult.jobDuration = (summaryJsonResult.endTimestamp - summaryJsonResult.startTimestamp) / 1000L;
        for (SingleJsonResult singleJsonResult : summaryJsonResult.results) {
            summaryJsonResult.pagesFirst += singleJsonResult.pagesFirst;
            summaryJsonResult.pagesSecond += singleJsonResult.pagesSecond;
            summaryJsonResult.pagesTotal += Math.max(singleJsonResult.pagesFirst, singleJsonResult.pagesSecond);
        }
        return summaryJsonResult;
    }

    private String e(String string, String string2) {
        int n;
        if (string == null) {
            string = string2;
        }
        if (string == null) {
            string = Long.toString(System.currentTimeMillis());
        }
        if ((n = (string = string.replace('\\', '/')).lastIndexOf(47)) >= 0 && n < string.length() - 2) {
            return string.substring(n + 1);
        }
        return string;
    }

    @Override
    public void onError(ExceptionData error, boolean interrupted, BasePresenter.ERROR_SOURCE source) {
        SingleJsonResult singleJsonResult = new SingleJsonResult();
        InfoData infoData = this.getModel().getComparisonParameters();
        if (infoData != null) {
            this.a(infoData.getFirstFile(), true);
            this.a(infoData.getSecondFile(), true);
            singleJsonResult.firstName = infoData.getFirstFile() != null ? infoData.getFirstFile().getName() : null;
            singleJsonResult.secondName = infoData.getSecondFile() != null ? infoData.getSecondFile().getName() : null;
        }
        singleJsonResult.comparisonFailed = true;
        this.cC().addResult(singleJsonResult);
    }

    private void a(PdfSource pdfSource, boolean bl) {
        JsonSummaryPresenter jsonSummaryPresenter;
        if (pdfSource == null || pdfSource.getPath() == null) {
            return;
        }
        String string = pdfSource.getPath();
        if (!string.endsWith(pdfSource.getName())) {
            int n = (string = string.replace('\\', '/')).lastIndexOf(47);
            if (n < 0 || n == string.length() - 1) {
                return;
            }
            string = string.substring(0, n);
        } else if ((string = string.substring(0, string.length() - pdfSource.getName().length() - 1)).length() == 0) {
            return;
        }
        JsonSummaryPresenter jsonSummaryPresenter2 = jsonSummaryPresenter = this.pt != null ? this.pt : this;
        if (bl) {
            jsonSummaryPresenter.pw = string;
        } else {
            jsonSummaryPresenter.px = string;
        }
    }

    private SummaryJsonResult cC() {
        SummaryJsonResult summaryJsonResult = this.pt != null ? this.pt.pu : this.pu;
        return summaryJsonResult;
    }

    @Override
    public void onInit() throws Exception {
        if (this.cC().startTimestamp == 0L) {
            this.cC().startTimestamp = System.currentTimeMillis();
        }
    }

    @Override
    public BasePresenter spawn(boolean spawnWithParent) {
        JsonSummaryPresenter jsonSummaryPresenter = new JsonSummaryPresenter(this.pv);
        if (spawnWithParent) {
            jsonSummaryPresenter.pt = this;
        }
        return jsonSummaryPresenter;
    }

    @Nonnull
    public String getExtensionName() {
        return "Presenter_Json_Summary";
    }

    @Nonnull
    public String getExportFileName() {
        String string = this.e(this.pw, this.px);
        String string2 = this.e(this.px, this.pw);
        return FileNameUtil.createExportFilename((this.cC().numberOfComparisons > 1 ? "batch_" : "") + "differences", string, string2) + ".json";
    }

    @JsonData
    private static class SummaryJsonResult {
        private int numberOfComparisons;
        private int numberOfDifferentDocuments;
        private long startTimestamp;
        private long endTimestamp;
        private long jobDuration;
        private int pagesFirst;
        private int pagesSecond;
        private int pagesTotal;
        private List<SingleJsonResult> results = new ArrayList<SingleJsonResult>();

        private SummaryJsonResult() {
        }

        private synchronized void addResult(SingleJsonResult result) {
            this.results.add(result);
            ++this.numberOfComparisons;
            if (result.totalDifferences > 0) {
                ++this.numberOfDifferentDocuments;
            }
        }
    }

    private class a
    implements SupplierWithIOException<OutputStream> {
        private File s;

        public a(File file) {
            this.s = file;
        }

        @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"}, justification="Path and file name are generated")
        public OutputStream cD() throws IOException {
            if (!(this.s.exists() || this.s.mkdirs() || this.s.isDirectory())) {
                PDFCCore.LOGGER_PRESENTER.error((Object)("Could not create output folder '" + this.s.getAbsolutePath() + "'"));
            }
            String string = JsonSummaryPresenter.this.e(JsonSummaryPresenter.this.pw, JsonSummaryPresenter.this.px);
            String string2 = JsonSummaryPresenter.this.e(JsonSummaryPresenter.this.px, JsonSummaryPresenter.this.pw);
            String string3 = FileNameUtil.createExportFilename((JsonSummaryPresenter.this.cC().numberOfComparisons > 1 ? "batch_" : "") + "differences", string, string2) + ".json";
            File file = new File(this.s, string3);
            PDFCCore.LOGGER_PRESENTER.info((Object)("Writing JSON result to: " + file.getAbsolutePath()));
            return new FileOutputStream(file);
        }

        @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"}, justification="Path and file name are generated")
        public /* synthetic */ Object get() throws IOException {
            return this.cD();
        }
    }

    @JsonData
    private static class SingleJsonResult {
        private String firstName;
        private String secondName;
        private int totalDifferences;
        private int added;
        private int removed;
        private int replaced;
        private int modified;
        private int pagesFirst;
        private int pagesSecond;
        private boolean comparisonFailed;

        private SingleJsonResult() {
        }
    }
}

