/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfc.generator.continuous.structure;

import com.inet.annotations.InternalApi;
import com.inet.annotations.JsonData;
import com.inet.pdfc.i18n.Msg;
import com.inet.pdfc.model.DrawableElement;
import com.inet.pdfc.model.DrawableElementXY;
import com.inet.pdfc.model.ElementID;
import com.inet.pdfc.model.ElementType;
import com.inet.pdfc.model.TagElement;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@JsonData
@InternalApi
public class StructureElement
extends DrawableElementXY {
    private Rectangle2D bounds;
    @Nonnull
    private final @Nonnull List<@Nonnull DrawableElement> children;
    private ElementType type;
    @Nullable
    private TagElement tagElement;

    public StructureElement(@Nonnull ElementType type, Rectangle2D bounds, @Nullable List<@Nonnull DrawableElement> children, int pageIndex, @Nonnull ElementID id) {
        super(pageIndex, id);
        this.type = type;
        this.bounds = bounds;
        ArrayList arrayList = this.children = children != null ? children : new ArrayList();
        if (bounds != null) {
            this.setX(bounds.getMinX());
            this.setY(bounds.getY());
        }
    }

    public StructureElement(@Nonnull ElementType type, Rectangle2D bounds, @Nullable List<@Nonnull DrawableElement> children, int pageIndex, @Nonnull ElementID id, @Nullable TagElement tagElement) {
        this(type, bounds, children, pageIndex, id);
        this.tagElement = tagElement;
    }

    public TagElement getTagElement() {
        return this.tagElement;
    }

    @Override
    public Rectangle2D getBounds() {
        return this.bounds;
    }

    public void setBounds(@Nonnull Rectangle2D bounds) {
        this.bounds = bounds;
        this.setX(bounds.getX());
        this.setY(bounds.getY());
        if (this.tagElement != null) {
            this.tagElement.setBounds(bounds);
        }
    }

    @Nonnull
    public @Nonnull List<@Nonnull DrawableElement> getChildren() {
        return this.children;
    }

    public void serialize(@Nonnull @Nonnull List<@Nonnull DrawableElement> elements) {
        for (DrawableElement drawableElement : this.children) {
            if (drawableElement instanceof StructureElement) {
                StructureElement structureElement = (StructureElement)drawableElement;
                TagElement tagElement = structureElement.getTagElement();
                if (tagElement != null && (tagElement.getActualText() != null && !tagElement.getActualText().isBlank() || tagElement.getAltText() != null && !tagElement.getAltText().isBlank())) {
                    elements.add(tagElement);
                }
                structureElement.serialize(elements);
                continue;
            }
            elements.add(drawableElement);
        }
    }

    public static boolean hasStructures(@Nonnull @Nonnull List<@Nonnull DrawableElement> elements) {
        for (DrawableElement drawableElement : elements) {
            if (!drawableElement.getType().isStructuralType() || !(drawableElement instanceof StructureElement)) continue;
            return true;
        }
        return false;
    }

    @Nonnull
    public static @Nonnull List<@Nonnull DrawableElement> unpack(@Nonnull @Nonnull List<@Nonnull DrawableElement> elements) {
        @Nonnull ArrayList<@Nonnull DrawableElement> arrayList = new ArrayList<DrawableElement>(elements.size() * 2);
        new StructureElement(ElementType.Page, null, elements, 0, ElementID.DUMMY).serialize(arrayList);
        return arrayList;
    }

    @Nonnull
    public String toString() {
        return String.valueOf(this.getType()) + ": " + this.children.size() + " children";
    }

    @Override
    public String getLabel() {
        return Msg.getMsg("ElementType." + String.valueOf(this.getType()));
    }

    @Override
    public int getCompareHash() {
        return 7;
    }

    @Override
    public ElementType getType() {
        return this.type;
    }
}

