/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfc.util;

import com.inet.annotations.InternalApi;
import com.inet.pdfc.generator.message.AnnotationHighlight;
import com.inet.pdfc.generator.message.HighlightData;
import com.inet.pdfc.generator.model.forms.LineShape;
import com.inet.pdfc.model.AnnotationElement;
import com.inet.pdfc.model.ElementType;
import com.inet.pdfc.model.HasBounds;
import com.inet.pdfc.model.PagedElement;
import com.inet.pdfc.model.ShapeElement;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.List;

@InternalApi
public class LocationUtils {
    public static Rectangle scaleRect(double scale, Rectangle rightRect) {
        if (rightRect == null) {
            return null;
        }
        rightRect = rightRect.getBounds();
        rightRect.x = (int)Math.round((double)rightRect.x * scale);
        rightRect.y = (int)Math.round((double)rightRect.y * scale);
        rightRect.width = (int)Math.round((double)rightRect.width * scale);
        rightRect.height = (int)Math.round((double)rightRect.height * scale);
        return rightRect;
    }

    public static Rectangle2D scaleRect(double scale, Rectangle2D rect) {
        return new Rectangle2D.Double(rect.getX() * scale, rect.getY() * scale, rect.getWidth() * scale, rect.getHeight() * scale);
    }

    public static Rectangle2D resize(Rectangle2D rect, double offset) {
        double d2 = Math.max(0.001, rect.getWidth() + 2.0 * offset);
        double d3 = Math.max(0.001, rect.getHeight() + 2.0 * offset);
        return new Rectangle2D.Double(rect.getX() - offset, rect.getY() - offset, d2, d3);
    }

    public static Rectangle scaleRect(double scaleX, double scaleY, Rectangle rightRect) {
        rightRect = rightRect.getBounds();
        rightRect.x = (int)((double)rightRect.x * scaleX);
        rightRect.y = (int)((double)rightRect.y * scaleY);
        rightRect.width = (int)((double)rightRect.width * scaleX);
        rightRect.height = (int)((double)rightRect.height * scaleY);
        return rightRect;
    }

    public static Rectangle getBounds(HasBounds element) {
        if (element == null) {
            return null;
        }
        Rectangle2D rectangle2D = element.getBounds();
        if (rectangle2D == null) {
            return null;
        }
        return LocationUtils.getBounds(rectangle2D);
    }

    public static Rectangle2D getNormedBounds(HasBounds element) {
        if (element == null) {
            return null;
        }
        return LocationUtils.getNormedBounds(element.getBounds());
    }

    public static Rectangle2D getNormedBounds(Rectangle2D rect) {
        if (rect == null) {
            return null;
        }
        if (rect.getWidth() >= 0.0 && rect.getHeight() >= 0.0) {
            return rect;
        }
        double d2 = LocationUtils.getMinX(rect);
        double d3 = LocationUtils.getMinY(rect);
        double d4 = LocationUtils.getMaxX(rect);
        double d5 = LocationUtils.getMaxY(rect);
        return new Rectangle2D.Double(d2, d3, d4 - d2, d5 - d3);
    }

    public static Rectangle2D.Double getDoubleBounds(Rectangle2D rect) {
        if (rect instanceof Rectangle2D.Double) {
            return (Rectangle2D.Double)rect;
        }
        return new Rectangle2D.Double(rect.getX(), rect.getY(), rect.getWidth(), rect.getHeight());
    }

    public static Rectangle getBounds(Rectangle2D rect) {
        int n = (int)LocationUtils.getMinX(rect);
        int n2 = (int)LocationUtils.getMinY(rect);
        int n3 = (int)Math.ceil(LocationUtils.getMaxX(rect));
        int n4 = (int)Math.ceil(LocationUtils.getMaxY(rect));
        return new Rectangle(n, n2, n3 - n, n4 - n2);
    }

    public static double getMaxX(Rectangle2D rect) {
        return rect.getWidth() > 0.0 ? rect.getMaxX() : rect.getX();
    }

    public static double getMaxY(Rectangle2D rect) {
        return rect.getHeight() > 0.0 ? rect.getMaxY() : rect.getY();
    }

    public static double getMinX(Rectangle2D rect) {
        return rect.getWidth() < 0.0 ? rect.getMaxX() : rect.getX();
    }

    public static double getMinY(Rectangle2D rect) {
        return rect.getHeight() < 0.0 ? rect.getMaxY() : rect.getY();
    }

    public static Rectangle2D.Double union(Rectangle2D source, Rectangle2D joinToSource) {
        double d2 = Math.min(LocationUtils.getMinX(source), LocationUtils.getMinX(joinToSource));
        double d3 = Math.min(LocationUtils.getMinY(source), LocationUtils.getMinY(joinToSource));
        double d4 = Math.max(LocationUtils.getMaxX(source), LocationUtils.getMaxX(joinToSource));
        double d5 = Math.max(LocationUtils.getMaxY(source), LocationUtils.getMaxY(joinToSource));
        if (source.getHeight() < 0.0) {
            return new Rectangle2D.Double(d2, d5, d4 - d2, d3 - d5);
        }
        return new Rectangle2D.Double(d2, d3, d4 - d2, d5 - d3);
    }

    public static Rectangle getOutline(PagedElement element) {
        if (element == null) {
            return null;
        }
        Rectangle rectangle = LocationUtils.getBounds(element);
        if (rectangle == null) {
            return null;
        }
        if (element instanceof LineShape) {
            int n = 1;
            if (((LineShape)element).getStroke() != null) {
                n = Math.max(1, Math.round(((LineShape)element).getStroke().getLineWidth()));
            }
            if (element.getType() == ElementType.LineHorizontal) {
                rectangle.y -= n / 2;
                rectangle.height = n - n / 2 + (n + 1) % 2;
            }
            if (element.getType() == ElementType.LineVertical) {
                rectangle.x -= n / 2;
                rectangle.width = n - n / 2 + (n + 1) % 2;
            }
        }
        if (rectangle.width == 0) {
            rectangle.width = 1;
        }
        if (rectangle.height == 0) {
            rectangle.height = 1;
        }
        return rectangle;
    }

    public static Rectangle2D getJoinedBounds(List<? extends PagedElement> elements) {
        return LocationUtils.getJoinedBounds(elements, false);
    }

    /*
     * Unable to fully structure code
     */
    public static Rectangle2D getJoinedBounds(List<? extends PagedElement> elements, boolean skipEmptyText) {
        if (elements == null || elements.size() == 0) {
            return null;
        }
        var2_2 = null;
        block3: for (var3_3 = 0; var3_3 < elements.size(); ++var3_3) {
            var4_4 = elements.get(var3_3);
            if (var4_4 == null || var4_4.getType() == ElementType.Shape && ((ShapeElement)var4_4).getIsClip() || var4_4.getType() == ElementType.Annotation && ((var6_6 = AnnotationHighlight.getHighlightAppearance((AnnotationElement)(var5_5 = (AnnotationElement)var4_4))) == null || var6_6 == HighlightData.Highlight.Appearance.CUSTOM && !var5_5.hasAppearance())) continue;
            if (!skipEmptyText) ** GOTO lbl-1000
            switch (1.dg[var4_4.getType().ordinal()]) {
                case 1: 
                case 2: {
                    if (var4_4.getLabel().trim().length() == 0) continue block3;
                }
                default: lbl-1000:
                // 2 sources

                {
                    if ((var5_5 = LocationUtils.getNormedBounds(var4_4)) == null) continue block3;
                    var2_2 = var2_2 == null ? var5_5 : LocationUtils.union((Rectangle2D)var2_2, (Rectangle2D)var5_5);
                }
            }
        }
        return var2_2;
    }

    public static boolean intersects(Rectangle r1, Rectangle r2) {
        if (r1.width < 0 || r1.height < 0) {
            r1 = LocationUtils.getBounds(r1);
        }
        if (r2.width < 0 || r2.height < 0) {
            r2 = LocationUtils.getBounds(r2);
        }
        int n = r1.width;
        int n2 = r1.height;
        int n3 = r2.width;
        int n4 = r2.height;
        int n5 = r1.x;
        int n6 = r1.y;
        int n7 = r2.x;
        int n8 = r2.y;
        n4 += n8;
        n += n5;
        n2 += n6;
        return !((n3 += n7) >= n7 && n3 <= n5 || n4 >= n8 && n4 <= n6 || n >= n5 && n <= n7 || n2 >= n6 && n2 <= n8);
    }

    public static boolean intersects(Rectangle2D r1, Rectangle2D r2) {
        if (r1.getWidth() < 0.0 || r1.getHeight() < 0.0) {
            r1 = LocationUtils.getBounds(r1);
        }
        if (r2.getWidth() < 0.0 || r2.getHeight() < 0.0) {
            r2 = LocationUtils.getBounds(r2);
        }
        double d2 = r1.getWidth();
        double d3 = r1.getHeight();
        double d4 = r2.getWidth();
        double d5 = r2.getHeight();
        double d6 = r1.getX();
        double d7 = r1.getY();
        double d8 = r2.getX();
        double d9 = r2.getY();
        return ((d4 += d8) < d8 || d4 > d6) && ((d5 += d9) < d9 || d5 > d7) && ((d2 += d6) < d6 || d2 > d8) && ((d3 += d7) < d7 || d3 > d9);
    }

    public static boolean contains(Rectangle2D r1, Rectangle2D r2) {
        if (r1.getWidth() < 0.0 || r1.getHeight() < 0.0) {
            r1 = LocationUtils.getBounds(r1);
        }
        if (r2.getWidth() < 0.0 || r2.getHeight() < 0.0) {
            r2 = LocationUtils.getBounds(r2);
        }
        double d2 = r1.getX();
        double d3 = r1.getY();
        double d4 = r1.getWidth() + d2;
        double d5 = r1.getHeight() + d3;
        double d6 = r2.getX();
        double d7 = r2.getY();
        double d8 = r2.getWidth() + d6;
        double d9 = r2.getHeight() + d7;
        return d6 >= d2 && d8 <= d4 && d7 >= d3 && d9 <= d5;
    }

    public static Rectangle2D.Double createTransformedBounds(AffineTransform at, Rectangle2D.Double rect) {
        boolean bl;
        Point2D.Double double_ = (Point2D.Double)at.transform(new Point2D.Double(rect.x, rect.y), new Point2D.Double());
        Point2D.Double double_2 = new Point2D.Double();
        Rectangle2D.Double double_3 = new Rectangle2D.Double(double_.x, double_.y, 0.0, 0.0);
        double_3.add(at.transform(new Point2D.Double(rect.x + rect.width, rect.y), double_2));
        double_3.add(at.transform(new Point2D.Double(rect.x + rect.width, rect.y + rect.height), double_2));
        double_3.add(at.transform(new Point2D.Double(rect.x, rect.y + rect.height), double_2));
        boolean bl2 = double_.x == double_3.x + double_3.width;
        boolean bl3 = bl = double_.y == double_3.y + double_3.height;
        if (bl2 || bl) {
            double_3 = new Rectangle2D.Double(bl2 ? double_.x : double_3.x, bl ? double_.y : double_3.y, bl2 ? -double_3.width : double_3.width, bl ? -double_3.height : double_3.height);
        }
        return double_3;
    }

    public static double getSize(Rectangle2D rectangle) {
        return rectangle.getWidth() * rectangle.getHeight();
    }
}

