/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfc.results.painter;

import com.inet.annotations.InternalApi;
import com.inet.pdfc.generator.model.DiffGroup;
import com.inet.pdfc.generator.model.Modification;
import java.awt.Color;
import java.io.File;
import java.io.FileInputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.annotation.Nonnull;

@InternalApi
public class DiffConstants {
    private static final Map<DiffGroup.GroupType, a> gS = new HashMap<DiffGroup.GroupType, a>();
    private static final Map<Modification.ModificationType, a> rP = new HashMap<Modification.ModificationType, a>();

    @Deprecated
    public static Color getMarkerColor(DiffGroup.GroupType t) {
        return DiffConstants.gS.get((Object)t).rQ;
    }

    @Deprecated
    public static Color getOutlineColor(DiffGroup.GroupType t) {
        return DiffConstants.gS.get((Object)t).rR;
    }

    @Deprecated
    public static Color getScrollBarMarkerColor(DiffGroup.GroupType t) {
        return DiffConstants.gS.get((Object)t).rS;
    }

    public static Color getMarkerColor(Modification.ModificationType t) {
        return DiffConstants.rP.get((Object)t).rQ;
    }

    public static Color getOutlineColor(Modification.ModificationType t) {
        return DiffConstants.rP.get((Object)t).rR;
    }

    public static Color getScrollBarMarkerColor(Modification.ModificationType t) {
        return DiffConstants.rP.get((Object)t).rS;
    }

    public static Color changeAlpha(Color baseColor, int addAlpha) {
        int n = baseColor.getAlpha() + addAlpha;
        if (n > 255) {
            n = 255;
        } else if (n < 0) {
            n = 0;
        }
        return new Color(baseColor.getRed(), baseColor.getGreen(), baseColor.getBlue(), n);
    }

    public static void changeColoring(DiffGroup.GroupType groupType, Color color) {
        a a2 = gS.get(groupType);
        if (a2 != null) {
            a2.rR = color;
        }
        for (Modification.ModificationType modificationType : DiffConstants.getModificationType(groupType)) {
            a2 = rP.get(modificationType);
            if (a2 == null) continue;
            a2.rQ = color;
        }
    }

    @Nonnull
    public static Modification.ModificationType[] getModificationType(DiffGroup.GroupType groupType) {
        switch (groupType) {
            case AddedOrRemoved: {
                return new Modification.ModificationType[]{Modification.ModificationType.add, Modification.ModificationType.remove};
            }
            case Replaced: {
                return new Modification.ModificationType[]{Modification.ModificationType.replace};
            }
            case Modified: {
                return new Modification.ModificationType[]{Modification.ModificationType.attributeDifference};
            }
            case ValidationError: {
                return new Modification.ModificationType[]{Modification.ModificationType.validationError};
            }
            case MetadataChanged: {
                return new Modification.ModificationType[]{Modification.ModificationType.metadataChanged};
            }
        }
        return new Modification.ModificationType[0];
    }

    @Nonnull
    public static DiffGroup.GroupType getModificationToGroup(Modification.ModificationType groupType) {
        switch (groupType) {
            case add: {
                return DiffGroup.GroupType.AddedOrRemoved;
            }
            case remove: {
                return DiffGroup.GroupType.AddedOrRemoved;
            }
            case replace: {
                return DiffGroup.GroupType.Replaced;
            }
            case attributeDifference: {
                return DiffGroup.GroupType.Modified;
            }
            case validationError: {
                return DiffGroup.GroupType.ValidationError;
            }
            case metadataChanged: {
                return DiffGroup.GroupType.MetadataChanged;
            }
        }
        throw new IllegalStateException("Unexpected value: " + String.valueOf(groupType));
    }

    static {
        gS.put(DiffGroup.GroupType.AddedOrRemoved, new a(Color.RED, 30, 40));
        gS.put(DiffGroup.GroupType.Replaced, new a(new Color(255, 170, 0), 22, 80));
        gS.put(DiffGroup.GroupType.Modified, new a(new Color(0, 153, 60), 17, 100));
        gS.put(DiffGroup.GroupType.Sync, new a(new Color(0, 255, 0, 0), 0, 0));
        gS.put(DiffGroup.GroupType.MetadataChanged, new a(new Color(0, 128, 196, 255), 10, 40));
        gS.put(DiffGroup.GroupType.ValidationError, new a(new Color(128, 128, 196, 255), 10, 40));
        rP.put(Modification.ModificationType.add, gS.get(DiffGroup.GroupType.AddedOrRemoved));
        rP.put(Modification.ModificationType.remove, gS.get(DiffGroup.GroupType.AddedOrRemoved));
        rP.put(Modification.ModificationType.replace, gS.get(DiffGroup.GroupType.Replaced));
        rP.put(Modification.ModificationType.attributeDifference, gS.get(DiffGroup.GroupType.Modified));
        rP.put(Modification.ModificationType.validationError, gS.get(DiffGroup.GroupType.ValidationError));
        rP.put(Modification.ModificationType.metadataChanged, gS.get(DiffGroup.GroupType.MetadataChanged));
        Properties properties = new Properties();
        try {
            File file = new File("DifferenceColors.properties");
            if (file.exists()) {
                properties.load(new FileInputStream(file));
                for (DiffGroup.GroupType groupType : DiffGroup.GroupType.values()) {
                    try {
                        String string = properties.getProperty("Diff." + groupType.name());
                        if (string == null) continue;
                        Color color = new Color((int)Long.parseLong(string, 16), true);
                        DiffConstants.changeColoring(groupType, color);
                    }
                    catch (NumberFormatException numberFormatException) {
                        System.out.println("Invalid color for Diff." + groupType.name() + ", must be a ARGB value in hexadecimal form like FFFFAA00");
                    }
                }
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace(System.err);
        }
    }

    private static class a {
        private Color rQ;
        private Color rR;
        private Color rS;

        public a(Color color, int n, int n2) {
            this.rQ = new Color(0, 0, 255, n);
            this.rR = new Color(color.getRed(), color.getGreen(), color.getBlue(), n2);
            this.rS = color;
        }
    }
}

