/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfc.results.filter;

import com.inet.annotations.JsonData;
import com.inet.pdfc.generator.model.DiffGroup;
import com.inet.pdfc.generator.model.Modification;
import com.inet.pdfc.results.ResultModel;
import com.inet.pdfc.results.ResultModelData;
import com.inet.pdfc.results.ResultModelUpdater;
import com.inet.plugin.NamedExtension;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;

@JsonData
public abstract class ResultFilter
implements NamedExtension {
    private transient Set<Consumer<Map<DiffGroup, Set<Modification>>>> listeners = new HashSet<Consumer<Map<DiffGroup, Set<Modification>>>>();
    private transient ResultModelData model;

    protected ResultFilter() {
    }

    public final void filterDifferences(List<DiffGroup> differences) {
        HashMap<Modification, Boolean> hashMap = new HashMap<Modification, Boolean>(differences.size());
        for (DiffGroup serializable2 : differences) {
            if (serializable2.getType() == DiffGroup.GroupType.Sync) continue;
            for (Modification modification : serializable2.getModifications()) {
                hashMap.put(modification, modification.isVisible());
            }
        }
        this.filterDifferencesImpl(differences);
        ArrayList arrayList = new ArrayList();
        ArrayList<Modification> arrayList2 = new ArrayList<Modification>();
        for (DiffGroup diffGroup : differences) {
            for (Modification modification : diffGroup.getModifications()) {
                if (((Boolean)hashMap.get(modification)).booleanValue() == modification.isVisible()) continue;
                if (modification.isVisible()) {
                    arrayList.add(modification);
                    continue;
                }
                arrayList2.add(modification);
            }
        }
    }

    public void setResultModel(ResultModel model) {
        this.model = new ResultModelUpdater(model).getModelData();
    }

    protected ResultModelData getModel() {
        return this.model;
    }

    public abstract void filterDifferencesImpl(List<? extends DiffGroup> var1);

    protected void toggleVisibilty(List<Modification> toShow, List<Modification> toHide) {
        if (toShow.size() == 0 && toHide.size() == 0) {
            this.notifyChange(null);
            return;
        }
        if (this.model == null) {
            this.notifyChange(null);
            return;
        }
        HashSet<Modification> hashSet = new HashSet<Modification>(toShow);
        toHide.stream().filter(hashSet::contains).forEach(toShow::remove);
        hashSet = null;
        HashMap<Modification, DiffGroup> hashMap = new HashMap<Modification, DiffGroup>();
        for (DiffGroup diffGroup : this.model.getDiffs(false, false)) {
            for (Modification modification : diffGroup.getModifications()) {
                hashMap.put(modification, diffGroup);
            }
        }
        HashMap hashMap2 = new HashMap();
        toShow.forEach(mod -> {
            if (!mod.isVisible()) {
                this.addToMap((DiffGroup)hashMap.get(mod), mod, hashMap2);
                mod.setVisible(true);
            }
        });
        toHide.forEach(mod -> {
            if (mod.isVisible()) {
                this.addToMap((DiffGroup)hashMap.get(mod), mod, hashMap2);
                mod.setVisible(false);
            }
        });
        this.notifyChange(hashMap2);
    }

    private <K, V> void addToMap(K key, V value, Map<K, Set<V>> map) {
        Set<V> set = map.get(key);
        if (set == null) {
            set = new HashSet<V>();
            map.put(key, set);
        }
        set.add(value);
    }

    public synchronized void addChangeListener(Consumer<Map<DiffGroup, Set<Modification>>> listener) {
        this.listeners.add(listener);
    }

    public synchronized void removeChangeListener(Consumer<Map<DiffGroup, Set<Modification>>> listener) {
        this.listeners.remove(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyChange(Map<DiffGroup, Set<Modification>> changed) {
        ArrayList<Consumer<Map<DiffGroup, Set<Modification>>>> arrayList;
        ResultFilter resultFilter = this;
        synchronized (resultFilter) {
            arrayList = new ArrayList<Consumer<Map<DiffGroup, Set<Modification>>>>(this.listeners);
        }
        arrayList.forEach(l -> l.accept(changed));
    }

    public abstract void clear();

    public abstract boolean isEmpty();
}

