/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfc.plugin.persistence;

import com.inet.annotations.InternalApi;
import com.inet.annotations.JsonData;
import com.inet.http.servlet.ClientLocale;
import com.inet.id.GUID;
import com.inet.pdfc.config.DefaultProfile;
import com.inet.pdfc.config.PDFCProperty;
import com.inet.pdfc.config.ProfileValidator;
import com.inet.pdfc.generator.filter.ISortFilterFactory;
import com.inet.pdfc.generator.resultfilter.IResultFilterFactory;
import com.inet.pdfc.i18n.Msg;
import com.inet.pdfc.plugin.persistence.ComparePersistence;
import com.inet.plugin.ServerPluginManager;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@JsonData
public class ProfilePersistence {
    public static final String KEY_LASTMODIFIED = "lastmodified";
    public static final String KEY_DEFAULT = "default";
    @Nonnull
    private Properties metaData = new Properties();
    @Nonnull
    private DefaultProfile profile;
    @Nonnull
    private GUID guid;
    @Nullable
    private GUID ownerID;
    @Nullable
    private Set<ComparePersistence.UserOrGroup> publishing;
    private transient Boolean hasErrors;
    private transient SCOPE scope = SCOPE.USER;
    private transient Map<Locale, String> descCache = new HashMap<Locale, String>();
    private transient DefaultProfile.ProfileChangeListener listener;

    private ProfilePersistence() {
    }

    public ProfilePersistence(@Nonnull GUID guid, GUID ownerID, @Nonnull DefaultProfile profile) {
        this.setProfile(profile);
        this.guid = guid;
        this.ownerID = ownerID;
    }

    public String getDescription(boolean useAutoDescription) {
        return this.getDescription(ClientLocale.getThreadLocale(), useAutoDescription);
    }

    public String getDescription(@Nonnull Locale locale, boolean useAutoDescription) {
        String string = this.profile.getString("PROFIL_DESCRIPTION");
        if (useAutoDescription && (string == null || string.trim().length() == 0)) {
            if (this.descCache.containsKey(locale)) {
                return this.descCache.get(locale);
            }
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(Msg.getMsg("Settings.Feature", locale)).append(": ");
            this.appendProperty(stringBuilder, PDFCProperty.COMPARE_TYPES, locale);
            stringBuilder.append(" \n").append(Msg.getMsg("Settings.Filters", locale)).append(": ");
            this.appendProperty(stringBuilder, PDFCProperty.FILTERS, locale);
            string = stringBuilder.toString();
            this.descCache.put(locale, string);
        }
        return string;
    }

    private void appendProperty(@Nonnull StringBuilder b2, @Nonnull PDFCProperty<?> key, @Nonnull Locale locale) {
        String string = this.profile.getString(key);
        if (string == null || string.trim().length() == 0) {
            b2.append(Msg.getMsg("Settings.ValueNone", locale));
            return;
        }
        String[] stringArray = string.split(";|,");
        boolean bl = true;
        ServerPluginManager serverPluginManager = ServerPluginManager.getInstance();
        for (String string2 : stringArray) {
            String string3;
            block9: {
                if (string2.length() == 0 || string2.trim().length() == 0) continue;
                string2 = string2.trim();
                try {
                    ISortFilterFactory iSortFilterFactory = (ISortFilterFactory)serverPluginManager.getSingleInstanceByName(ISortFilterFactory.class, string2, false);
                    string3 = iSortFilterFactory.getFilterName();
                }
                catch (IllegalStateException illegalStateException) {
                    if (key == PDFCProperty.FILTERS) {
                        try {
                            serverPluginManager.getSingleInstanceByName(IResultFilterFactory.class, string2, false);
                            continue;
                        }
                        catch (IllegalStateException illegalStateException2) {
                            String string4 = "Settings." + string2;
                            string3 = Msg.hasMsg(string4, locale) ? Msg.getMsg(string4, locale) : string2.toLowerCase();
                            break block9;
                        }
                    }
                    string3 = Msg.getMsg("Settings." + string2, locale);
                }
            }
            if (!bl) {
                b2.append(", ");
            }
            bl = false;
            b2.append(string3);
        }
        if (bl) {
            b2.append(Msg.getMsg("Settings.ValueNone", locale));
        }
    }

    public String getName() {
        return this.getName(ClientLocale.getThreadLocale());
    }

    public String getName(Locale locale) {
        String string = this.profile.getString("PROFIL_NAME");
        return string != null ? string : "<unnamed configuration>";
    }

    @Nonnull
    private Properties getMetaData() {
        return this.metaData;
    }

    public void setMetaData(@Nonnull Properties metaData) {
        this.metaData = metaData;
    }

    public GUID getOwnerID() {
        return this.ownerID;
    }

    public void setOwnerID(GUID id) {
        this.ownerID = id;
    }

    public GUID getGUID() {
        return this.guid;
    }

    @Nonnull
    public DefaultProfile getProfile() {
        return this.profile;
    }

    public void setProfile(@Nonnull DefaultProfile profile) {
        if (this.profile != null && this.listener != null) {
            this.profile.removeProfileChangeListener(this.listener);
        }
        if (this.listener == null) {
            this.listener = new DefaultProfile.ProfileChangeListener(){

                @Override
                public void onPropertyUpdate(String propertyName, Object value) {
                    ProfilePersistence.this.hasErrors = null;
                }

                @Override
                public void onPropertyUpdate(PDFCProperty<?> property, Object value) {
                    ProfilePersistence.this.hasErrors = null;
                }
            };
        }
        profile.addProfileChangeListener(this.listener);
        this.profile = profile;
    }

    public String getMetaValue(@Nonnull String propertyKey) {
        return (String)this.getMetaData().get(propertyKey);
    }

    public void setMetaProperty(@Nonnull String key, @Nonnull String value) {
        this.getMetaData().put(key, value);
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        return this.guid.equals((Object)((ProfilePersistence)o).guid);
    }

    public int hashCode() {
        return this.guid.hashCode();
    }

    public SCOPE getScope() {
        return this.scope;
    }

    void setScope(SCOPE scope) {
        this.scope = scope != null ? scope : SCOPE.USER;
    }

    public Set<ComparePersistence.UserOrGroup> getPublishing() {
        return this.publishing != null ? new HashSet<ComparePersistence.UserOrGroup>(this.publishing) : null;
    }

    void setPublishing(@Nullable Set<ComparePersistence.UserOrGroup> publishing) {
        this.publishing = publishing != null ? new HashSet<ComparePersistence.UserOrGroup>(publishing) : null;
    }

    public boolean hasProblems() {
        if (this.hasErrors == null) {
            Map<String, String> map = new ProfileValidator().verifyConfig(this.profile, this.getScope() == SCOPE.DEFAULT);
            this.hasErrors = !map.isEmpty();
        }
        return this.hasErrors;
    }

    @InternalApi
    public static final class SCOPE
    extends Enum<SCOPE> {
        public static final /* enum */ SCOPE DEFAULT = new SCOPE();
        public static final /* enum */ SCOPE PUBLIC = new SCOPE();
        public static final /* enum */ SCOPE USER = new SCOPE();
        private static final /* synthetic */ SCOPE[] nG;

        public static SCOPE[] values() {
            return (SCOPE[])nG.clone();
        }

        public static SCOPE valueOf(String name) {
            return Enum.valueOf(SCOPE.class, name);
        }

        private static /* synthetic */ SCOPE[] bY() {
            return new SCOPE[]{DEFAULT, PUBLIC, USER};
        }

        static {
            nG = SCOPE.bY();
        }
    }
}

