/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfc.plugin.pdfparser;

import com.inet.annotations.InternalApi;
import com.inet.annotations.JsonData;
import com.inet.cache.font.SerializableGeneralFont;
import com.inet.pdfc.model.FontInfo;
import com.inet.pdfc.util.RattleSort;
import com.inet.pdfview.PDFParser;
import com.inet.pdfview.font.BuiltinFont;
import com.inet.pdfview.font.OutlineFont;
import com.inet.pdfview.font.PDFFont;
import com.inet.pdfview.font.PDFFontDescriptor;
import com.inet.pdfview.font.PDFFontToUnicodeMap;
import com.inet.pdfview.font.PDFGlyph;
import com.inet.pdfview.font.Type0Font;
import com.inet.pdfview.font.Type3Font;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Toolkit;
import java.awt.font.TextAttribute;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;

@JsonData
@InternalApi
public class FontInfoCache {
    private static final Pattern KEY_PATTERN = Pattern.compile("[A-Z]{6}");
    private static final Pattern ENCODED_PATTERN = Pattern.compile("#([0-9A-F]{2})");
    private boolean isCrystalReportsExport;
    private HashMap<PDFFont, PDFFontInfo> cache = new HashMap();
    private Map<Font, Map<Object, Font>> derivedFonts = new ConcurrentHashMap<Font, Map<Object, Font>>();
    private boolean ignoreUnicodeMapping;

    public FontInfoCache(boolean isCrystalReportsExport) {
        this.isCrystalReportsExport = isCrystalReportsExport;
    }

    public void setIgnoreUnicodeMapping(boolean ignoreUnicodeMapping) {
        this.ignoreUnicodeMapping = ignoreUnicodeMapping;
    }

    public FontInfo getFontInfo(PDFFont font) {
        PDFFontInfo pDFFontInfo = this.cache.get(font);
        if (pDFFontInfo == null) {
            pDFFontInfo = new PDFFontInfo(font, this.isCrystalReportsExport);
            this.cache.put(font, pDFFontInfo);
        }
        return pDFFontInfo;
    }

    public void setCrystalReportsExport(boolean isCrystalReportsExport) {
        this.isCrystalReportsExport = isCrystalReportsExport;
    }

    private Font deriveFont(Font font, float size) {
        HashMap<TextAttribute, Object> hashMap = new HashMap<TextAttribute, Object>();
        hashMap.put(TextAttribute.SIZE, Float.valueOf(size));
        return this.deriveFont(font, hashMap);
    }

    public Font deriveFont(Font font, HashMap<TextAttribute, Object> attributes) {
        Map<Object, Font> map = this.derivedFonts.get(font);
        if (this.derivedFonts.size() > 1000) {
            PDFParser.LOGGER.debug((Object)("Many derivated fonts in the cache, currently " + this.derivedFonts.size() + ". This can be a performance issue!"));
        }
        if (map != null) {
            Font font2;
            if (map.size() > 1000) {
                PDFParser.LOGGER.debug((Object)("Many derivated fonts in the cache for one font(" + String.valueOf(font) + "), currently " + map.size() + ". This can be a performance issue!"));
            }
            if ((font2 = map.get(attributes)) == null) {
                font2 = FontInfoCache.addDerivative(font, attributes, map);
            }
            return font2;
        }
        map = new ConcurrentHashMap<Object, Font>();
        this.derivedFonts.put(font, map);
        return FontInfoCache.addDerivative(font, attributes, map);
    }

    private static Font addDerivative(Font font, HashMap<TextAttribute, Object> attributes, Map<Object, Font> derivals) {
        Font font2 = font instanceof SerializableGeneralFont ? ((SerializableGeneralFont)font).deriveSerializableFont(attributes) : font.deriveFont(attributes);
        derivals.put(attributes, font2);
        return font2;
    }

    @JsonData
    @InternalApi
    public class PDFFontInfo
    extends PDFFontInfoSerializable {
        private static final double ITALIC_ANGLE = 0.1;
        @Nonnull
        private static final AffineTransform IDENTITY = new AffineTransform();
        private static final long serialVersionUID = 8592625767968348243L;
        private PDFFont.Subtype type;
        private String fontName;
        private String actualFontName;
        private String familyName;
        private int style;
        private int hashCode;
        private HashMap<Integer, FontMetrics> fontMetricsMap;
        private PDFFont pdfFont;
        private float ascend = Float.NaN;
        private boolean hasWhiteSpace = true;
        private int ws100;
        @Nonnull
        private final @Nonnull String @Nonnull [] FONTSTYLEITALIC = new String[]{"It", "LightItalic", "LtIt", "RomanSCObliqued", "BookIt", "LightIt", "Obl", "LightIta", "LightIt", "CondensedIta", "BookOblique", "MediIta", "LightObl", "MediumItalic", "MdIt", "LightCnObl", "MdObl", "MediumOblique"};
        @Nonnull
        private final @Nonnull String @Nonnull [] FONTSTYLEBOLD = new String[]{"Bold", "SemiBold", "Black", "Heavy", "Bd", "Hvy", "Demi", "BlackCn", "BlkCn", "BdCn", "DemiBold", "BlackSemiExt", "Xbold"};
        @Nonnull
        private final @Nonnull String @Nonnull [] FONTSTYLEBOLDITALIC = new String[]{"Bolditalic", "BoldIt", "BdIt", "SemiBoldIt", "HeavyOblique", "BlackOblique", "HeavyItalic", "BoldIta", "BlackItalic", "BkCdIt", "SemiCnIt"};
        private boolean scanned;

        public PDFFontInfo(PDFFont font, boolean isCrystalReportsExport) {
            BuiltinFont builtinFont;
            this.pdfFont = font;
            PDFFont.Subtype subtype = font.getSubtype();
            String string = font.getBaseFont();
            this.type = subtype;
            this.setWinFontNameAndStyle(string, isCrystalReportsExport);
            int n = font.getStyle();
            if (n > 0) {
                this.style = n;
            }
            this.hashCode = subtype.ordinal() + (this.fontName != null ? this.fontName.hashCode() : 0) + (this.familyName != null ? this.familyName.hashCode() : 0) + this.style;
            if (font instanceof BuiltinFont && (builtinFont = (BuiltinFont)font).getActualFontName() != null) {
                this.actualFontName = this.normalizeName(builtinFont.getActualFontName(), false);
            }
            this.hasWhiteSpace = this.hasWSGlyph();
            this.ws100 = this.hasWhiteSpace ? this.getMetrics(500).charWidth(' ') : (int)(this.getAscent() * 150.0);
        }

        private double getAscent() {
            if (this.pdfFont instanceof OutlineFont) {
                OutlineFont outlineFont = (OutlineFont)this.pdfFont;
                return outlineFont.getAscent();
            }
            if (this.pdfFont.getDescriptor() == null) {
                return 1.0;
            }
            int n = this.pdfFont.getDescriptor().getAscent();
            if (n > 0) {
                return (double)n / 2048.0;
            }
            return 1.0;
        }

        @Override
        public String getActualFontName() {
            return this.actualFontName != null ? this.actualFontName : this.getFontName();
        }

        @Override
        public boolean hasWhiteSpace() {
            return this.hasWhiteSpace;
        }

        public String toString() {
            return this.fontName + (String)(this.actualFontName != null ? "(actual: " + this.actualFontName + ")" : "") + ", type:" + this.pdfFont.getClass().getSimpleName();
        }

        private boolean hasWSGlyph() {
            try {
                PDFFontToUnicodeMap pDFFontToUnicodeMap;
                PDFGlyph pDFGlyph = this.pdfFont.getGlyph(' ', null, false);
                if (!(FontInfoCache.this.ignoreUnicodeMapping || pDFGlyph != null && pDFGlyph.getChar() != ' ' || (pDFFontToUnicodeMap = this.pdfFont.getUnicodeMapping()) == null)) {
                    int n = pDFFontToUnicodeMap.findGlyphCode(' ');
                    pDFGlyph = this.pdfFont.getGlyph((char)n, null, false);
                }
                if (pDFGlyph != null && pDFGlyph.getShape() != null) {
                    double d2 = pDFGlyph.getAdvance().getX();
                    if (d2 <= 0.0) {
                        d2 = pDFGlyph.getShape().getBounds2D().getMaxX();
                    }
                    return d2 > 0.0;
                }
                return false;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return false;
            }
        }

        @Override
        public double getWSWidth(float fontSize) {
            return (float)this.ws100 * fontSize / 25.0f;
        }

        @Override
        public FontMetrics getMetrics(int size) {
            Integer n;
            FontMetrics fontMetrics;
            if (this.fontMetricsMap == null) {
                this.fontMetricsMap = new HashMap();
            }
            if ((fontMetrics = this.fontMetricsMap.get(n = Integer.valueOf(size))) != null) {
                return fontMetrics;
            }
            Font font = this.pdfFont.getAWTFont();
            font = font == null ? new Font(this.getFontName(), this.style, size) : FontInfoCache.this.deriveFont(font, size);
            fontMetrics = Toolkit.getDefaultToolkit().getFontMetrics(font);
            this.fontMetricsMap.put(n, fontMetrics);
            return fontMetrics;
        }

        @Override
        public float getAscend(int size) {
            if (Float.isNaN(this.ascend)) {
                this.ascend = this.getAscend(this.pdfFont);
            }
            return this.ascend * (float)size;
        }

        private float getAscend(PDFFont font) {
            float f2;
            float f3 = 0.0f;
            if (font instanceof OutlineFont) {
                var3_3 = (OutlineFont)font;
                f3 = var3_3.getAscent();
            } else if (font instanceof Type0Font) {
                var3_3 = (Type0Font)font;
                f2 = 0.0f;
                for (int i = 0; i < var3_3.getDescendantCount(); ++i) {
                    PDFFont pDFFont = var3_3.getDescendantFont(i);
                    f2 += this.getAscend(pDFFont);
                }
                f3 = f2 / (float)var3_3.getDescendantCount();
            } else if (font instanceof Type3Font) {
                var3_3 = (Type3Font)font;
                f3 = this.ascend = (float)var3_3.getBaseAscend();
            }
            float f4 = font == this.pdfFont ? (float)this.getMetrics(200).getMaxAscent() / 200.0f : (float)new PDFFontInfo(font, false).getMetrics(200).getMaxAscent() / 200.0f;
            for (f2 = Math.max(f3, f4); f2 > 1.25f; f2 /= 2.0f) {
            }
            return f2;
        }

        private void setWinFontNameAndStyle(String pdfFontName, boolean isCrystalReportsExport) {
            int n;
            this.fontName = this.normalizeName(pdfFontName, isCrystalReportsExport);
            PDFFontDescriptor pDFFontDescriptor = this.pdfFont.getDescriptor();
            String string = this.fontName.toLowerCase();
            this.style |= string.indexOf("bold") > 0 ? 1 : 0;
            this.style |= string.indexOf("italic") > 0 ? 2 : 0;
            this.style |= string.indexOf("oblique") > 0 ? 2 : 0;
            this.familyName = pDFFontDescriptor != null && pDFFontDescriptor.getFontName() != null && !pDFFontDescriptor.getFontName().equals(pDFFontDescriptor.getFontFamilyName()) ? this.normalizeName(pDFFontDescriptor.getFontFamilyName(), isCrystalReportsExport) : this.fontName;
            int n2 = this.familyName.toLowerCase().indexOf("bold");
            if (n2 != -1) {
                this.familyName = this.familyName.substring(0, n2) + this.familyName.substring(n2 + "bold".length());
                this.style |= 1;
            }
            this.familyName = this.familyName.trim();
            if (this.familyName.toLowerCase().endsWith("roman") && !this.familyName.toLowerCase().contains("times")) {
                this.familyName = this.familyName.substring(0, this.familyName.length() - "roman".length()).trim();
            }
            if (this.familyName.toLowerCase().endsWith("regular")) {
                this.familyName = this.familyName.substring(0, this.familyName.length() - "regular".length()).trim();
            }
            if ((n = this.familyName.toLowerCase().indexOf("italic")) != -1) {
                this.familyName = (this.familyName.substring(0, n) + this.familyName.substring(n + "italic".length())).trim();
                this.style |= 2;
            } else {
                int n3 = this.familyName.toLowerCase().indexOf("oblique");
                if (n3 != -1) {
                    this.familyName = (this.familyName.substring(0, n3) + this.familyName.substring(n3 + "oblique".length())).trim();
                    this.style |= 2;
                }
            }
            if (this.familyName.startsWith("Adv")) {
                if (this.familyName.contains(".BI")) {
                    this.style |= 1;
                    this.style |= 2;
                } else if (this.familyName.contains(".B")) {
                    this.style |= 1;
                } else if (this.familyName.contains(".I")) {
                    this.style |= 2;
                }
            }
            if (pdfFontName.contains("-")) {
                String[] stringArray = pdfFontName.split("-");
                String string2 = stringArray[stringArray.length - 1];
                for (String string3 : this.FONTSTYLEBOLDITALIC) {
                    if (!string2.startsWith(string3)) continue;
                    this.style |= 1;
                    this.style |= 2;
                }
                for (String string3 : this.FONTSTYLEBOLD) {
                    if (!string2.startsWith(string3)) continue;
                    this.style |= 1;
                }
                for (String string3 : this.FONTSTYLEITALIC) {
                    if (!string2.startsWith(string3)) continue;
                    this.style |= 2;
                }
            }
            while (this.familyName.matches(".*(MT|PS)$")) {
                this.familyName = this.familyName.substring(0, this.familyName.length() - 2).trim();
            }
            this.familyName = this.familyName.replaceAll("([a-z])([A-Z])(?=[a-z])", "$1 $2").trim();
        }

        private String normalizeName(String fontName, boolean isCrystalReportsExport) {
            int n;
            Matcher matcher = ENCODED_PATTERN.matcher(fontName);
            StringBuffer stringBuffer = null;
            while (matcher.find()) {
                String string;
                if (stringBuffer == null) {
                    stringBuffer = new StringBuffer(fontName.length() - 2);
                }
                if ((string = matcher.group(1)) == null) continue;
                matcher.appendReplacement(stringBuffer, new String(new byte[]{(byte)Integer.parseInt(string, 16)}));
            }
            if (stringBuffer != null) {
                matcher.appendTail(stringBuffer);
                fontName = stringBuffer.toString();
            }
            if ((n = fontName.indexOf(43)) != -1) {
                String string;
                int n2 = fontName.lastIndexOf(43);
                if (n2 != n) {
                    fontName = fontName.substring(0, n2);
                }
                fontName = isCrystalReportsExport ? (n == fontName.length() - 1 ? fontName.substring(0, n) : ((string = fontName.substring(n + 1)).length() == 6 && KEY_PATTERN.matcher(string).matches() && n != 6 ? fontName.substring(0, n) : string)) : (n < fontName.length() - 1 ? fontName.substring(n + 1) : fontName.substring(0, n));
            }
            if (fontName.startsWith("Courier")) {
                fontName = fontName.replaceFirst("Courier\\w+", "Courier");
            }
            if (fontName.indexOf(45) != -1) {
                fontName = fontName.replace('-', ' ');
            }
            if (fontName.indexOf(44) != -1) {
                fontName = fontName.replace(',', ' ');
            }
            return fontName;
        }

        @Override
        public String getFamilyName() {
            return this.familyName;
        }

        @Override
        public int getStyle() {
            if (!this.scanned && (this.style & 2) == 0) {
                this.scanForItalic();
                this.scanned = true;
            }
            return this.style;
        }

        private void scanForItalic() {
            Type0Font type0Font;
            PDFFont pDFFont = this.pdfFont;
            if (pDFFont instanceof Type0Font) {
                type0Font = (Type0Font)pDFFont;
                pDFFont = type0Font.getDescendantFont(0);
            }
            if (pDFFont instanceof OutlineFont) {
                Object object;
                Object object2;
                type0Font = (OutlineFont)pDFFont;
                if (pDFFont instanceof BuiltinFont) {
                    return;
                }
                int n = type0Font.getFirstChar();
                int n2 = type0Font.getLastChar();
                if (n < 0) {
                    n = 0;
                }
                if (n2 < 0) {
                    n2 = 65535;
                }
                if (n2 < n) {
                    return;
                }
                ArrayList<a> arrayList = new ArrayList<a>();
                int n3 = 0;
                for (int i = n; i <= n2 && n3 < 256; ++i) {
                    object2 = type0Font.getGlyph((char)i, null, true);
                    if (object2 == null || (object = object2.getShape()) == null) continue;
                    ++n3;
                    this.getAngles((GeneralPath)object, arrayList);
                }
                if (arrayList.size() == 0) {
                    return;
                }
                RattleSort<a> rattleSort = new RattleSort<a>(s -> s.mt);
                object2 = rattleSort.sort(arrayList, Math.PI / 180);
                if (object2.size() == 0) {
                    return;
                }
                object = object2.stream().map(g2 -> new a(g2.doubleValue(), g2.getOccurrences().stream().mapToDouble(s -> s.mu).sum())).collect(Collectors.toCollection(ArrayList::new));
                object.sort((g1, g2) -> {
                    double d2 = g2.mu - g1.mu;
                    if (d2 != 0.0) {
                        return (int)Math.signum(d2);
                    }
                    return (int)Math.signum(g2.mt - g1.mt);
                });
                a a2 = (a)object.get(0);
                if (this.isItalic(a2)) {
                    a a3 = object.stream().filter(s -> !this.isItalic((a)s)).findFirst().orElse(null);
                    if (a3 != null && a2.mu <= a3.mu * 2.0) {
                        return;
                    }
                    if (object.size() > 1) {
                        a a4 = (a)object.get(1);
                        if (a2.mu <= a4.mu * 2.0) {
                            double d2 = 1.5707963267948966 - a2.mt;
                            double d3 = 1.5707963267948966 - a4.mt;
                            if (Math.signum(d2) != Math.signum(d3) && d2 + d3 < 0.025) {
                                return;
                            }
                        }
                    }
                    this.style |= 2;
                }
            }
        }

        private boolean isItalic(a mainAngle) {
            return Math.abs(mainAngle.mt - 1.5707963267948966) > 0.1;
        }

        private void getAngles(GeneralPath path, List<a> angles) {
            float f2 = 0.0f;
            float f3 = 0.0f;
            float f4 = 0.0f;
            float f5 = 0.0f;
            PathIterator pathIterator = path.getPathIterator(IDENTITY);
            while (!pathIterator.isDone()) {
                float[] fArray = new float[6];
                double d2 = Double.NaN;
                double d3 = Double.NaN;
                switch (pathIterator.currentSegment(fArray)) {
                    case 0: {
                        f2 = fArray[0];
                        f3 = fArray[1];
                        f4 = f2;
                        f5 = f3;
                        break;
                    }
                    case 1: {
                        if (f2 == fArray[0] && f3 == fArray[1]) break;
                        d2 = Math.atan2(fArray[1] - f3, fArray[0] - f2);
                        d3 = Point2D.distance(f2, f3, fArray[0], fArray[1]);
                        f2 = fArray[0];
                        f3 = fArray[1];
                        break;
                    }
                    case 3: {
                        d2 = Math.atan2(fArray[5] - f3, fArray[4] - f2);
                        d3 = Point2D.distance(f2, f3, fArray[4], fArray[5]);
                        f2 = fArray[4];
                        f3 = fArray[5];
                        break;
                    }
                    case 2: {
                        d2 = Math.atan2(fArray[3] - f3, fArray[2] - f2);
                        d3 = Point2D.distance(f2, f3, fArray[2], fArray[3]);
                        f2 = fArray[2];
                        f3 = fArray[3];
                        break;
                    }
                    case 4: {
                        if (f2 != f4 || f3 != f5) {
                            d2 = Math.atan2(f5 - f3, f4 - f2);
                        }
                        f2 = f4;
                        f3 = f5;
                    }
                }
                if (!Double.isNaN(d2) && !Double.isNaN(d3) && Math.abs(d2) > 0.7853981633974483 && Math.abs(d2) < 2.356194490192345) {
                    if (d2 < 0.0) {
                        d2 += Math.PI;
                    }
                    angles.add(new a(d2, d3));
                }
                pathIterator.next();
            }
        }

        public PDFFont.Subtype getType() {
            return this.type;
        }

        @Override
        public String getFontName() {
            return this.fontName;
        }

        @Override
        public boolean equals(Object obj) {
            if (!(obj instanceof PDFFontInfo)) {
                return false;
            }
            PDFFontInfo pDFFontInfo = (PDFFontInfo)obj;
            if (this.fontName != null ? !this.fontName.equals(pDFFontInfo.fontName) : pDFFontInfo.fontName != null) {
                return false;
            }
            if (this.familyName != null ? !this.familyName.equals(pDFFontInfo.familyName) : pDFFontInfo.familyName != null) {
                return false;
            }
            return this.style == pDFFontInfo.style;
        }

        @Override
        public int hashCode() {
            return this.hashCode;
        }

        private Object writeReplace() {
            return new PDFFontInfoSerializable(this);
        }

        private static class a {
            private double mt;
            private double mu;

            public a(double d2, double d3) {
                this.mt = d2;
                this.mu = d3;
            }
        }
    }

    @JsonData
    @InternalApi
    public static class PDFFontInfoSerializable
    implements FontInfo,
    Serializable {
        private static final long serialVersionUID = 5076657757527464481L;
        private String fontName;
        private String actualFontName;
        private String familyName;
        private int style;
        private int hashCode;
        private float ascent = Float.NaN;

        private PDFFontInfoSerializable() {
        }

        public PDFFontInfoSerializable(PDFFontInfo pdfFontInfo) {
            this.fontName = pdfFontInfo.fontName;
            this.familyName = pdfFontInfo.familyName;
            this.style = pdfFontInfo.style;
            this.hashCode = pdfFontInfo.hashCode;
            this.ascent = pdfFontInfo.ascend;
            this.actualFontName = pdfFontInfo.actualFontName;
        }

        @Override
        public double getWSWidth(float fontSize) {
            throw new UnsupportedOperationException("After Serialization/deserialization you cannot invoke this with" + fontSize);
        }

        @Override
        public FontMetrics getMetrics(int size) {
            throw new UnsupportedOperationException("After Serialization/deserialization you cannot invoke this with" + size);
        }

        @Override
        public float getAscend(int size) {
            if (Float.isNaN(this.ascent)) {
                return this.ascent;
            }
            return this.ascent * (float)size;
        }

        @Override
        public String getFamilyName() {
            return this.familyName;
        }

        @Override
        public int getStyle() {
            return this.style;
        }

        @Override
        public String getFontName() {
            return this.fontName;
        }

        @Override
        public String getActualFontName() {
            return this.actualFontName != null ? this.actualFontName : this.getFontName();
        }

        @Override
        public boolean equals(Object obj) {
            if (!(obj instanceof FontInfo)) {
                return false;
            }
            FontInfo fontInfo = (FontInfo)obj;
            if (this.fontName != null ? !this.fontName.equals(fontInfo.getFontName()) : fontInfo.getFontName() != null) {
                return false;
            }
            if (this.familyName != null ? !this.familyName.equals(fontInfo.getFamilyName()) : fontInfo.getFamilyName() != null) {
                return false;
            }
            return this.style == fontInfo.getStyle();
        }

        @Override
        public int hashCode() {
            return this.hashCode;
        }
    }
}

