/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfc.model;

import com.inet.annotations.InternalApi;
import com.inet.annotations.JsonData;
import com.inet.pdfc.model.AdditionalBoundsInfo;
import com.inet.pdfc.model.DrawableElementXY;
import com.inet.pdfc.model.ElementID;
import com.inet.pdfc.model.ElementType;
import com.inet.pdfc.model.HasAdditionalBounds;
import com.inet.pdfc.model.Page;
import com.inet.pdfc.model.PagedElement;
import java.awt.Color;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@JsonData
@InternalApi
public class AnnotationElement
extends DrawableElementXY
implements com.inet.pdfc.generator.model.a,
HasAdditionalBounds {
    public static final String COMMENT_PREFIX = "Comment: ";
    public static final String SUBTYPE_COMMENT = "Comment";
    public static final String SUBTYPE_LINK = "Link";
    public static final String KEY_COMMENT = "Comment";
    public static final String KEY_LINK = "Link";
    private String subtype = a.jO.name();
    private a subtypeEnum = a.jO;
    private Rectangle2D bounds;
    private String contents;
    private Color color;
    private double opacity;
    private String author;
    private String subject;
    private Date creationDate;
    private STATE state;
    private STATE_MODEL stateModel;
    private int reviewID;
    private int replyToReviewID;
    private ACTION_TYPE actionType;
    private String actionTarget;
    private List<AdditionalBoundsInfo> additionalBounds;

    public AnnotationElement(int pageIndex, ElementID id) {
        super(pageIndex, id);
    }

    public String getAuthor() {
        return this.author;
    }

    public String getSubject() {
        return this.subject;
    }

    public Date getCreationDate() {
        return this.creationDate;
    }

    public STATE getReviewState() {
        return this.state;
    }

    public STATE_MODEL getReviewStateModel() {
        return this.stateModel;
    }

    public int getID() {
        return this.reviewID;
    }

    public int getReplyToID() {
        return this.replyToReviewID;
    }

    public String getSubtype() {
        return this.subtype;
    }

    public a getSubtypeEnum() {
        return this.subtypeEnum;
    }

    public boolean isLink() {
        return this.subtypeEnum == a.jr && this.actionTarget != null && !this.actionTarget.isEmpty();
    }

    public boolean isLinkedToText() {
        switch (this.subtypeEnum) {
            case jr: 
            case jy: 
            case jz: 
            case jB: {
                return true;
            }
        }
        return false;
    }

    @Override
    public String getLabel() {
        return this.subtypeEnum != null ? this.subtypeEnum.name() : a.jO.name();
    }

    @Override
    public Map<String, String> getCustomData() {
        Map<String, String> map = null;
        if (this.actionTarget != null) {
            map = this.addToMap("Link", this.actionTarget, map);
        }
        if (this.contents != null) {
            map = this.addToMap("Comment", this.contents, map);
        }
        return map;
    }

    private Map<String, String> addToMap(String key, String value, Map<String, String> map) {
        if (map == null) {
            map = new HashMap<String, String>();
        }
        map.put(key, value);
        return map;
    }

    public String getContents() {
        return this.contents;
    }

    @Override
    public ElementType getType() {
        return ElementType.Annotation;
    }

    @Override
    public Rectangle2D getBounds() {
        return this.bounds;
    }

    @Override
    public double getX() {
        return this.bounds != null ? this.bounds.getX() : 0.0;
    }

    @Override
    public double getY() {
        return this.bounds != null ? this.bounds.getY() : 0.0;
    }

    @Override
    public int getCompareHash() {
        return 4711 + this.subtypeEnum.ordinal();
    }

    public void setSubtype(String subtype) {
        this.subtype = subtype;
        this.subtypeEnum = a.u(subtype);
    }

    public void setBounds(Rectangle2D bounds) {
        this.bounds = this.invertBounds() && bounds.getHeight() > 0.0 ? new Rectangle2D.Double(bounds.getX(), bounds.getMaxY(), bounds.getWidth(), -bounds.getHeight()) : bounds;
    }

    private boolean invertBounds() {
        switch (this.subtypeEnum) {
            case jr: 
            case jy: 
            case jz: 
            case jB: {
                return true;
            }
        }
        return false;
    }

    @Override
    public void setX(double x) {
        if (this.additionalBounds != null) {
            double d2 = x - this.bounds.getX();
            for (AdditionalBoundsInfo additionalBoundsInfo : this.additionalBounds) {
                additionalBoundsInfo.move(d2, 0.0);
            }
        }
        this.bounds = new Rectangle2D.Double(x, this.bounds.getMinY(), this.bounds.getWidth(), this.bounds.getHeight());
    }

    @Override
    public void setY(double y) {
        if (this.additionalBounds != null) {
            double d2 = y - this.getY();
            for (AdditionalBoundsInfo additionalBoundsInfo : this.additionalBounds) {
                additionalBoundsInfo.move(0.0, d2);
            }
        }
        this.bounds = new Rectangle2D.Double(this.bounds.getMinX(), y, this.bounds.getWidth(), this.bounds.getHeight());
    }

    protected void setContents(String contents) {
        this.contents = contents;
    }

    protected void setColor(Color color) {
        this.color = color;
    }

    protected void setOpacity(double opacity) {
        this.opacity = opacity;
    }

    protected void setAuthor(String author) {
        this.author = author;
    }

    protected void setSubject(String subject) {
        this.subject = subject;
    }

    protected void setCreationDate(Date creationDate) {
        this.creationDate = creationDate;
    }

    protected void setState(STATE state) {
        this.state = state;
    }

    protected void setStateModel(STATE_MODEL stateModel) {
        this.stateModel = stateModel;
    }

    protected void setReviewID(int reviewID) {
        this.reviewID = reviewID;
    }

    protected void setReplyToReviewID(int replyToReviewID) {
        this.replyToReviewID = replyToReviewID;
    }

    public Color getColor() {
        return this.color;
    }

    public String toString() {
        return "Annotation: " + this.subtype + "\n" + (String)(this.getAuthor() != null ? "Author    : " + this.getAuthor() + "\n" : "") + (String)(this.getReviewState() != null ? "State     : " + String.valueOf((Object)this.getReviewState()) + "\n" : "") + (String)(this.getReviewStateModel() != null ? "StateModel      : " + String.valueOf((Object)this.getReviewStateModel()) + "\n" : "") + (String)(this.getCreationDate() != null ? "Date      : " + String.valueOf(this.getCreationDate()) + "\n" : "") + "Opacity      : " + this.getOpacity() + "\nID      : " + this.getID() + "\nReplayID      : " + this.getReplyToID() + "\n" + (String)(this.getActionType() != null ? "ActionType      : " + String.valueOf((Object)this.getActionType()) + "\n" : "") + (String)(this.getActionTarget() != null ? "ActionTarget      : " + this.getActionTarget() + "\n" : "") + (String)(this.getColor() != null ? "Color      : " + String.valueOf(this.getColor()) + "\n" : "") + (String)(this.getContents() != null ? "Contents  : " + this.contents + "\n" : "") + (String)(this.getLabel() != null ? "Label  : " + this.getLabel() + "\n" : "") + (String)(this.getBounds() != null ? "(" + this.bounds.getX() + "," + this.bounds.getY() + "," + this.bounds.getWidth() + "," + this.bounds.getHeight() + ")" : "");
    }

    public double getOpacity() {
        return this.opacity;
    }

    public Page getAppearance() {
        return null;
    }

    public boolean hasAppearance() {
        return false;
    }

    protected void setActionType(ACTION_TYPE actionType) {
        this.actionType = actionType;
    }

    public ACTION_TYPE getActionType() {
        return this.actionType;
    }

    protected void setActionTarget(String actionTarget) {
        this.actionTarget = actionTarget;
    }

    public String getActionTarget() {
        return this.actionTarget;
    }

    @Override
    public void setAdditionalBounds(AdditionalBoundsInfo ... additionalBounds) {
        this.additionalBounds = additionalBounds != null && additionalBounds.length > 0 ? new ArrayList<AdditionalBoundsInfo>(Arrays.asList(additionalBounds)) : null;
    }

    @Override
    public List<AdditionalBoundsInfo> getAdditionalBounds() {
        return this.additionalBounds;
    }

    @Override
    public boolean hasAdditionalBounds() {
        return this.additionalBounds != null && !this.additionalBounds.isEmpty();
    }

    @Override
    public void createReplacementElements(List<PagedElement> listToAddTo) {
        if (this.additionalBounds == null || this.additionalBounds.isEmpty()) {
            return;
        }
        ElementID elementID = this.getElementID().getDescendant();
        for (AdditionalBoundsInfo additionalBoundsInfo : this.getAdditionalBounds()) {
            AnnotationElement annotationElement = new AnnotationElement(this.getPageIndex(), elementID);
            annotationElement.setActionTarget(this.actionTarget);
            annotationElement.setActionType(this.actionType);
            annotationElement.setAuthor(this.author);
            annotationElement.setColor(this.color);
            annotationElement.setContents(this.contents);
            annotationElement.setCreationDate(this.creationDate);
            annotationElement.setOpacity(this.opacity);
            annotationElement.setReplyToReviewID(this.replyToReviewID);
            annotationElement.setReviewID(this.reviewID);
            annotationElement.setState(this.state);
            annotationElement.setStateModel(this.stateModel);
            annotationElement.setSubject(this.subject);
            annotationElement.setSubtype(this.subtype);
            annotationElement.setBounds(additionalBoundsInfo.getBounds());
            listToAddTo.add(annotationElement);
            elementID = elementID.getNext();
        }
    }

    public static final class a
    extends Enum<a> {
        public static final /* enum */ a jq = new a();
        public static final /* enum */ a jr = new a();
        public static final /* enum */ a js = new a();
        public static final /* enum */ a jt = new a();
        public static final /* enum */ a ju = new a();
        public static final /* enum */ a jv = new a();
        public static final /* enum */ a jw = new a();
        public static final /* enum */ a jx = new a();
        public static final /* enum */ a jy = new a();
        public static final /* enum */ a jz = new a();
        public static final /* enum */ a jA = new a();
        public static final /* enum */ a jB = new a();
        public static final /* enum */ a jC = new a();
        public static final /* enum */ a jD = new a();
        public static final /* enum */ a jE = new a();
        public static final /* enum */ a jF = new a();
        public static final /* enum */ a jG = new a();
        public static final /* enum */ a jH = new a();
        public static final /* enum */ a jI = new a();
        public static final /* enum */ a jJ = new a();
        public static final /* enum */ a jK = new a();
        public static final /* enum */ a jL = new a();
        public static final /* enum */ a jM = new a();
        public static final /* enum */ a jN = new a();
        public static final /* enum */ a jO = new a();
        private static Map<String, a> jP;
        private static final /* synthetic */ a[] jQ;

        public static a[] values() {
            return (a[])jQ.clone();
        }

        public static a valueOf(String name) {
            return Enum.valueOf(a.class, name);
        }

        public static a u(String string) {
            if (string == null) {
                return null;
            }
            a a2 = jP.get(string.toLowerCase());
            return a2 != null ? a2 : jO;
        }

        private static /* synthetic */ a[] bt() {
            return new a[]{jq, jr, js, jt, ju, jv, jw, jx, jy, jz, jA, jB, jC, jD, jE, jF, jG, jH, jI, jJ, jK, jL, jM, jN, jO};
        }

        static {
            jQ = a.bt();
            jP = new HashMap<String, a>();
            for (a a2 : a.values()) {
                jP.put(a2.name().toLowerCase(), a2);
            }
        }
    }

    @InternalApi
    public static final class STATE
    extends Enum<STATE> {
        public static final /* enum */ STATE Marked = new STATE();
        public static final /* enum */ STATE Unmarked = new STATE();
        public static final /* enum */ STATE Accepted = new STATE();
        public static final /* enum */ STATE Rejected = new STATE();
        public static final /* enum */ STATE Cancelled = new STATE();
        public static final /* enum */ STATE Completed = new STATE();
        public static final /* enum */ STATE None = new STATE();
        private static final /* synthetic */ STATE[] jo;

        public static STATE[] values() {
            return (STATE[])jo.clone();
        }

        public static STATE valueOf(String name) {
            return Enum.valueOf(STATE.class, name);
        }

        public static STATE[] getReviewStates() {
            return new STATE[]{None, Accepted, Cancelled, Completed, Rejected};
        }

        public static STATE[] getMarkedStates() {
            return new STATE[]{Marked, Unmarked};
        }

        private static /* synthetic */ STATE[] br() {
            return new STATE[]{Marked, Unmarked, Accepted, Rejected, Cancelled, Completed, None};
        }

        static {
            jo = STATE.br();
        }
    }

    @InternalApi
    public static final class STATE_MODEL
    extends Enum<STATE_MODEL> {
        public static final /* enum */ STATE_MODEL Marked = new STATE_MODEL();
        public static final /* enum */ STATE_MODEL Review = new STATE_MODEL();
        private static final /* synthetic */ STATE_MODEL[] jp;

        public static STATE_MODEL[] values() {
            return (STATE_MODEL[])jp.clone();
        }

        public static STATE_MODEL valueOf(String name) {
            return Enum.valueOf(STATE_MODEL.class, name);
        }

        private static /* synthetic */ STATE_MODEL[] bs() {
            return new STATE_MODEL[]{Marked, Review};
        }

        static {
            jp = STATE_MODEL.bs();
        }
    }

    @InternalApi
    public static final class ACTION_TYPE
    extends Enum<ACTION_TYPE> {
        public static final /* enum */ ACTION_TYPE GoTo = new ACTION_TYPE();
        public static final /* enum */ ACTION_TYPE URI = new ACTION_TYPE();
        private static final /* synthetic */ ACTION_TYPE[] jn;

        public static ACTION_TYPE[] values() {
            return (ACTION_TYPE[])jn.clone();
        }

        public static ACTION_TYPE valueOf(String name) {
            return Enum.valueOf(ACTION_TYPE.class, name);
        }

        private static /* synthetic */ ACTION_TYPE[] bq() {
            return new ACTION_TYPE[]{GoTo, URI};
        }

        static {
            jn = ACTION_TYPE.bq();
        }
    }
}

