/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfc.config;

import com.inet.annotations.JsonData;
import com.inet.annotations.PublicApi;
import com.inet.pdfc.config.ColorSetting;
import com.inet.pdfc.config.ObjectSetting;
import com.inet.pdfc.config.Settings;
import com.inet.pdfc.config.SettingsControl;
import com.inet.pdfc.config.VisibilitySetting;
import com.inet.pdfc.generator.model.DiffGroup;
import com.inet.pdfc.generator.model.Modification;
import com.inet.pdfc.print.DefaultColorProvider;
import com.inet.pdfc.results.painter.DiffConstants;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@JsonData
@PublicApi
public class DefaultSetting
implements Settings {
    private Properties settings = new Properties();
    private static List<ObjectSetting<?>> OBJECT_SETTINGS;

    static synchronized void addObjectSetting(ObjectSetting<?> objectSetting) {
        if (OBJECT_SETTINGS == null) {
            OBJECT_SETTINGS = new ArrayList();
        }
        OBJECT_SETTINGS.add(objectSetting);
    }

    public DefaultSetting() {
        DefaultColorProvider defaultColorProvider = new DefaultColorProvider();
        for (Modification.ModificationType modificationType : Modification.ModificationType.values()) {
            this.setMarkerColor(defaultColorProvider.getMarkerColor(modificationType), modificationType);
            this.setColor(defaultColorProvider.getOutlineColor(modificationType), modificationType);
        }
        this.setColor(Color.blue, Settings.METAOPTION.ALLOUTLINEMARKER);
        this.setEnabled(false, Settings.EXPORT.values());
        this.setEnabled(true, Settings.EXPORT.HEADER, Settings.EXPORT.FOOTER, Settings.EXPORT.COMMENTS);
        this.setEnabled(true, Modification.ModificationType.values());
        this.setEnabled(false, Settings.OPTION.values());
    }

    @Override
    public synchronized List<ObjectSetting<?>> getAllObjectSettingNames() {
        return new ArrayList(OBJECT_SETTINGS);
    }

    @Override
    @Deprecated
    public void setMarkerColor(Color color, @Nonnull DiffGroup.GroupType content) {
        for (Modification.ModificationType modificationType : DiffConstants.getModificationType(content)) {
            this.setMarkerColor(color, modificationType);
        }
    }

    @Override
    public void setColor(Color color, @Nonnull ColorSetting setting) {
        if (setting instanceof DiffGroup.GroupType) {
            DiffGroup.GroupType groupType = (DiffGroup.GroupType)setting;
            for (Modification.ModificationType modificationType : DiffConstants.getModificationType(groupType)) {
                this.setColor(color, modificationType);
            }
            return;
        }
        String string = SettingsControl.getKey(setting, SettingsControl.PURPOSE.color);
        if (color != null) {
            this.settings.put(string, Integer.toString(color.getRGB()));
        } else {
            this.settings.remove(string);
        }
    }

    @Override
    public void setEnabled(boolean isVisible, VisibilitySetting ... visibles) {
        for (VisibilitySetting visibilitySetting : visibles) {
            if (visibilitySetting instanceof DiffGroup.GroupType) {
                DiffGroup.GroupType groupType = (DiffGroup.GroupType)visibilitySetting;
                for (Modification.ModificationType modificationType : DiffConstants.getModificationType(groupType)) {
                    this.setEnabled(isVisible, modificationType);
                }
                continue;
            }
            this.settings.put(SettingsControl.getKey(visibilitySetting, SettingsControl.PURPOSE.visibility), Boolean.toString(isVisible));
        }
    }

    @Override
    public boolean isEnabled(VisibilitySetting content) {
        DiffGroup.GroupType groupType;
        Modification.ModificationType[] modificationTypeArray;
        int n;
        int n2;
        if (content instanceof DiffGroup.GroupType && (n2 = 0) < (n = (modificationTypeArray = DiffConstants.getModificationType(groupType = (DiffGroup.GroupType)content)).length)) {
            Modification.ModificationType modificationType = modificationTypeArray[n2];
            return this.isEnabled(modificationType);
        }
        return this.settings.getProperty(SettingsControl.getKey(content, SettingsControl.PURPOSE.visibility), "" + !content.getTyp().equals("OPTION")).equalsIgnoreCase("true");
    }

    @Override
    @Nonnull
    @Deprecated
    public Color getMarkerColor(@Nonnull DiffGroup.GroupType content) {
        int n = 0;
        Modification.ModificationType[] modificationTypeArray = DiffConstants.getModificationType(content);
        int n2 = modificationTypeArray.length;
        if (n < n2) {
            Modification.ModificationType modificationType = modificationTypeArray[n];
            return this.getMarkerColor(modificationType);
        }
        return new Color(Integer.parseInt(this.settings.getProperty(SettingsControl.getKey(content, SettingsControl.PURPOSE.marker), "0")), true);
    }

    @Override
    public Color getColor(@Nonnull ColorSetting colorSetting) {
        DiffGroup.GroupType groupType;
        Modification.ModificationType[] modificationTypeArray;
        int n;
        int n2;
        if (colorSetting instanceof DiffGroup.GroupType && (n2 = 0) < (n = (modificationTypeArray = DiffConstants.getModificationType(groupType = (DiffGroup.GroupType)colorSetting)).length)) {
            Modification.ModificationType modificationType = modificationTypeArray[n2];
            return this.getColor(modificationType);
        }
        int n3 = Integer.parseInt(this.settings.getProperty(SettingsControl.getKey(colorSetting, SettingsControl.PURPOSE.color), "-1"));
        return n3 == -1 ? null : new Color(n3, true);
    }

    @Override
    @Nullable
    public Object getSetting(String setting) {
        for (ObjectSetting<?> objectSetting : this.getAllObjectSettingNames()) {
            String string;
            if (!objectSetting.name().equalsIgnoreCase(setting)) continue;
            String string2 = SettingsControl.getKey(objectSetting, SettingsControl.PURPOSE.object);
            String string3 = this.settings.getProperty(string2);
            if (string3 == null && (string3 = this.settings.getProperty(string = objectSetting.getTyp() + objectSetting.name())) != null) {
                this.settings.remove(string);
                this.settings.setProperty(string2, string3);
            }
            return objectSetting.getObject(string3);
        }
        throw new IllegalArgumentException("Missing Plugins or invalid Setting");
    }

    @Override
    public void setSetting(@Nullable Object value, String setting) {
        List<ObjectSetting<?>> list = this.getAllObjectSettingNames();
        for (ObjectSetting<?> objectSetting : list) {
            try {
                ObjectSetting<?> objectSetting2 = objectSetting;
                if (!objectSetting.name().equalsIgnoreCase(setting)) continue;
                String string = SettingsControl.getKey(objectSetting, SettingsControl.PURPOSE.object);
                if (value == null) {
                    this.settings.remove(objectSetting.getTyp() + objectSetting.name());
                    this.settings.remove(string);
                } else {
                    this.settings.put(string, objectSetting2.getAsString(value));
                }
                return;
            }
            catch (ClassCastException classCastException) {
                throw new IllegalArgumentException(classCastException.getMessage());
            }
        }
        throw new IllegalArgumentException("Missing Plugins or invalid Setting. Current setting = " + setting);
    }

    @Override
    @Nonnull
    public Settings copy() {
        DefaultSetting defaultSetting = new DefaultSetting();
        defaultSetting.settings.putAll((Map<?, ?>)this.settings);
        return defaultSetting;
    }

    @Override
    @Nonnull
    @Deprecated
    public Color getOutlineColor(DiffGroup.GroupType content) {
        int n = 0;
        Modification.ModificationType[] modificationTypeArray = DiffConstants.getModificationType(content);
        int n2 = modificationTypeArray.length;
        if (n < n2) {
            Modification.ModificationType modificationType = modificationTypeArray[n];
            return this.getOutlineColor(modificationType);
        }
        return this.getColor(content);
    }

    @Override
    @Nonnull
    public Color getMarkerColor(@Nonnull Modification.ModificationType modificationType) {
        return new Color(Integer.parseInt(this.settings.getProperty(SettingsControl.getKey(modificationType, SettingsControl.PURPOSE.marker), "0")), true);
    }

    @Override
    @Nonnull
    public Color getOutlineColor(@Nonnull Modification.ModificationType modificationType) {
        return this.getColor(modificationType);
    }

    @Override
    public void setMarkerColor(@Nullable Color color, @Nonnull Modification.ModificationType modificationType) {
        String string = SettingsControl.getKey(modificationType, SettingsControl.PURPOSE.marker);
        if (color != null) {
            this.settings.put(string, Integer.toString(color.getRGB()));
        } else {
            this.settings.remove(string);
        }
    }

    Properties getSettings() {
        return this.settings;
    }
}

