/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfc.util;

import com.inet.annotations.InternalApi;
import com.inet.lib.core.OS;
import com.inet.pdfc.generator.message.InfoData;
import com.inet.pdfc.presenter.BasePresenter;
import com.inet.pdfc.results.ResultModel;
import java.io.File;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.SuppressFBWarnings;

@InternalApi
public class FileNameUtil {
    public static final int MAX_FILENAME_LENGTH = 201;

    public static String getDefaultExportName(String presenterType, ResultModel model, BasePresenter basePresenter) {
        if (model == null || model.getComparisonParameters() == null) {
            return null;
        }
        InfoData infoData = model.getComparisonParameters();
        String string = infoData.getFirstFile().getName();
        String string2 = infoData.getSecondFile().getName();
        return FileNameUtil.a(presenterType, string, string2, basePresenter);
    }

    private static String a(String string, String string2, String string3, BasePresenter basePresenter) {
        if (string2.endsWith(".pdf")) {
            string2 = string2.substring(0, string2.length() - 4);
        }
        if (string3.endsWith(".pdf")) {
            string3 = string3.substring(0, string3.length() - 4);
        }
        string2 = FileNameUtil.normalizeName(string2);
        string3 = FileNameUtil.normalizeName(string3);
        String string4 = FileNameUtil.f(string3, string2);
        int n = (basePresenter != null ? basePresenter.createExportFilename(string, string2, string4) : FileNameUtil.a(string, string2, string4)).length();
        n = n - string2.length() - string4.length();
        int n2 = string2.length() + string4.length() + n;
        if (n2 <= 201) {
            return basePresenter != null ? basePresenter.createExportFilename(string, string2, string4) : FileNameUtil.a(string, string2, string4);
        }
        int n3 = n2 - 201;
        int n4 = string2.length() - string4.length();
        if (n4 > 0) {
            string2 = string2.substring(0, string2.length() - Math.min(n4, n3));
        } else if (n4 < 0) {
            string4 = string4.substring(0, string4.length() - Math.min(-n4, n3));
        }
        n3 = string2.length() + string4.length() + n - 201;
        if (n3 > 0) {
            int n5 = n3 / 2;
            string2 = string2.substring(0, string2.length() - n5);
            string4 = string4.substring(0, string4.length() - (n3 - n5));
        }
        return basePresenter != null ? basePresenter.createExportFilename(string, string2, string4) : FileNameUtil.a(string, string2, string4);
    }

    public static String normalizeName(String name) {
        StringBuilder stringBuilder = new StringBuilder(name.length());
        for (int i = 0; i < name.length(); ++i) {
            char c2 = name.charAt(i);
            if (c2 < ' ' || c2 == '<' || c2 == '>' || c2 == ':' || c2 == '\"' || c2 == '/' || c2 == '\\' || c2 == '|' || c2 == '?' || c2 == '*') {
                stringBuilder.append('_');
                continue;
            }
            stringBuilder.append(c2);
        }
        return stringBuilder.toString();
    }

    public static String createExportFilename(@Nullable String presenterType, @Nonnull String n1, @Nonnull String n2) {
        return FileNameUtil.a(presenterType, n1, n2, null);
    }

    private static String a(@Nullable String string, @Nonnull String string2, @Nonnull String string3) {
        return (String)(string != null ? "PDFC_" + string + "_" : "") + string2 + (String)(!string3.isEmpty() ? "_" + string3 : "");
    }

    private static String f(String string, String string2) {
        int n;
        int n2 = -1;
        while (++n2 > -2 && n2 < string.length()) {
            int n3 = string.charAt(n2);
            if (n2 < string2.length() && n3 == (n = (int)string2.charAt(n2))) continue;
            break;
        }
        if (string.equals(string2)) {
            return "";
        }
        Matcher matcher = Pattern.compile("[-_ ][^-_ ]+").matcher(string);
        n = -1;
        while (matcher.find() && matcher.start() <= n2) {
            n = matcher.start();
        }
        if (n != -1 && n2 > 5) {
            return string.substring(n + 1, string.length());
        }
        if (n2 < string.length() && string.length() > 30 && n2 > 5) {
            return string.substring(n2, string.length());
        }
        return string;
    }

    @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"}, justification="user have no access to this")
    public static String getDocIndexURI(String filename, Class clazz, String clazzname) throws URISyntaxException {
        File file = new File(filename);
        if (!file.exists()) {
            File file2 = null;
            if (OS.isMac()) {
                String string = clazz.getResource(clazzname).toURI().toString().replaceAll("%20", " ");
                int n = string.indexOf(".jar");
                if (n != -1) {
                    if ((string = string.substring(0, string.lastIndexOf(47) + 1)).startsWith("jar:file:")) {
                        string = string.substring(9);
                    }
                    file2 = new File(string);
                }
            } else {
                file2 = new File(clazz.getProtectionDomain().getCodeSource().getLocation().toURI());
            }
            while (!(file2 == null || "Java".equals(file2.getName()) || "dotnet".equals(file2.getName()) || "bin".equals(file2.getName()) || file2.list() == null || Arrays.asList(file2.list()).contains("startHelp.sh"))) {
                file2 = file2.getParentFile();
            }
            if (file2 != null) {
                return new File(file2, filename).getAbsolutePath();
            }
        }
        return filename;
    }

    @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"}, justification="internal API")
    public static File getUserFile(String path) {
        if (path.startsWith("~")) {
            path = path.replaceFirst("~", System.getProperty("user.home"));
        }
        return new File(path);
    }
}

