/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfc.util;

import com.inet.annotations.InternalApi;
import com.inet.pdfc.model.AdditionalBoundsInfo;
import com.inet.pdfc.model.DrawableElement;
import com.inet.pdfc.model.ElementType;
import com.inet.pdfc.model.HasAdditionalBounds;
import com.inet.pdfc.model.ShapeElement;
import com.inet.pdfc.util.LocationUtils;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

@InternalApi
public class ElementCluster {
    public static final int DEFAULT_ELEMENTS_PER_NODE = 25;
    private int tk = 25;
    private List<DrawableElement> fo;
    private Rectangle2D bounds;
    private a[][] tl;
    private Map<DrawableElement, Rectangle2D> tm;
    private boolean tn;
    private boolean to;

    public ElementCluster(List<DrawableElement> elements, boolean skipBogusElements) {
        this(elements, skipBogusElements, false);
    }

    public ElementCluster(List<DrawableElement> elements, boolean skipBogusElements, boolean includeAdditionalBounds) {
        this.fo = elements;
        this.tn = skipBogusElements;
        this.to = includeAdditionalBounds;
    }

    private void de() {
        Rectangle2D rectangle2D;
        if (this.bounds != null) {
            return;
        }
        if (this.fo.size() == 0) {
            this.bounds = new Rectangle2D.Double();
            return;
        }
        this.tm = this.fo.stream().collect(Collectors.toMap(Function.identity(), LocationUtils::getNormedBounds));
        this.bounds = this.tm.get(this.fo.get(0)).getBounds2D();
        this.fo.forEach(drawableElement -> Rectangle2D.union(this.tm.get(drawableElement), this.bounds, this.bounds));
        if (this.to) {
            for (DrawableElement drawableElement2 : this.fo) {
                if (!(drawableElement2 instanceof HasAdditionalBounds) || !((HasAdditionalBounds)((Object)drawableElement2)).hasAdditionalBounds()) continue;
                ((HasAdditionalBounds)((Object)drawableElement2)).getAdditionalBounds().forEach(additionalBoundsInfo -> Rectangle2D.union(additionalBoundsInfo.getBounds(), this.bounds, this.bounds));
            }
        }
        if (this.bounds.getHeight() == 0.0 || this.bounds.getWidth() == 0.0) {
            this.tl = new a[1][];
            this.tl[0] = new a[1];
            this.tl[0][0] = new a(this.bounds);
            for (DrawableElement drawableElement2 : this.fo) {
                if (this.tn && this.isBogusElement(drawableElement2)) continue;
                this.tl[0][0].add(drawableElement2);
            }
            return;
        }
        double d2 = this.bounds.getHeight() / this.bounds.getWidth();
        int n = (int)Math.ceil((double)this.fo.size() / (double)this.tk);
        int n2 = (int)Math.ceil(Math.sqrt((double)n / d2));
        int n3 = (int)Math.ceil(Math.sqrt((double)n / d2) * d2);
        double d3 = this.bounds.getWidth() / (double)n2;
        double d4 = this.bounds.getHeight() / (double)n3;
        double d5 = this.bounds.getX();
        double d6 = this.bounds.getY();
        this.tl = new a[n3][];
        for (int i = 0; i < n3; ++i) {
            this.tl[i] = new a[n2];
            for (int j = 0; j < n2; ++j) {
                rectangle2D = new Rectangle2D.Double(d5 + d3 * (double)j, d6 + d4 * (double)i, d3, d4);
                this.tl[i][j] = new a(rectangle2D);
            }
        }
        for (DrawableElement drawableElement3 : this.fo) {
            if (this.tn && this.isBogusElement(drawableElement3)) continue;
            rectangle2D = this.tm.get(drawableElement3);
            this.a(n2, n3, d3, d4, d5, d6, drawableElement3, rectangle2D);
            if (!this.to || !(drawableElement3 instanceof HasAdditionalBounds) || !((HasAdditionalBounds)((Object)drawableElement3)).hasAdditionalBounds()) continue;
            for (AdditionalBoundsInfo additionalBoundsInfo2 : ((HasAdditionalBounds)((Object)drawableElement3)).getAdditionalBounds()) {
                this.a(n2, n3, d3, d4, d5, d6, drawableElement3, additionalBoundsInfo2.getBounds());
            }
        }
    }

    private void a(int n, int n2, double d2, double d3, double d4, double d5, DrawableElement drawableElement, Rectangle2D rectangle2D) {
        int n3 = (int)((rectangle2D.getX() - d4) / d2);
        int n4 = (int)((rectangle2D.getY() - d5) / d3);
        int n5 = Math.min((int)Math.ceil((rectangle2D.getX() + rectangle2D.getWidth() - d4) / d2), n);
        int n6 = Math.min((int)Math.ceil((rectangle2D.getY() + rectangle2D.getHeight() - d5) / d3), n2);
        for (int i = n3; i < n5; ++i) {
            for (int j = n4; j < n6; ++j) {
                this.tl[j][i].add(drawableElement);
            }
        }
    }

    private boolean isBogusElement(DrawableElement e2) {
        switch (e2.getType()) {
            case Shape: {
                Paint paint;
                ShapeElement shapeElement = (ShapeElement)e2;
                if (shapeElement.getIsClip()) {
                    return true;
                }
                if (shapeElement.getStroke() != null && shapeElement.getStrokePaint() != null || !Color.WHITE.equals(paint = shapeElement.getFillPaint()) && (!(paint instanceof Color) || ((Color)paint).getAlpha() >= 5)) break;
                return true;
            }
            case TextWord: 
            case Text: {
                return e2.getLabel() == null || e2.getLabel().trim().length() == 0;
            }
        }
        return false;
    }

    public List<DrawableElement> getElementsInArea(Rectangle2D requestArea, boolean textOnly) {
        this.de();
        if (this.tl == null || this.tl.length == 0) {
            return new ArrayList<DrawableElement>();
        }
        Rectangle2D rectangle2D = requestArea.createIntersection(this.bounds);
        double d2 = this.bounds.getWidth() / (double)this.tl[0].length;
        double d3 = this.bounds.getHeight() / (double)this.tl.length;
        double d4 = this.bounds.getX();
        double d5 = this.bounds.getY();
        int n = (int)((rectangle2D.getX() - d4) / d2);
        int n2 = (int)((rectangle2D.getY() - d5) / d3);
        int n3 = Math.min(this.tl[0].length, (int)Math.ceil((rectangle2D.getX() + rectangle2D.getWidth() - d4) / d2));
        int n4 = Math.min(this.tl.length, (int)Math.ceil((rectangle2D.getY() + rectangle2D.getHeight() - d5) / d3));
        HashSet<DrawableElement> hashSet = new HashSet<DrawableElement>();
        for (int i = n; i < n3; ++i) {
            for (int j = n2; j < n4; ++j) {
                List<DrawableElement> list;
                List<DrawableElement> list2 = list = textOnly ? this.tl[j][i].tp : this.tl[j][i].tq;
                if (list == null) continue;
                hashSet.addAll(list);
            }
        }
        return hashSet.stream().filter(drawableElement -> {
            if (LocationUtils.intersects(this.tm.get(drawableElement), rectangle2D)) {
                if (drawableElement instanceof ShapeElement) {
                    return ((ShapeElement)drawableElement).getShape().intersects(rectangle2D);
                }
                return true;
            }
            if (drawableElement instanceof HasAdditionalBounds && ((HasAdditionalBounds)((Object)drawableElement)).hasAdditionalBounds()) {
                for (AdditionalBoundsInfo additionalBoundsInfo : ((HasAdditionalBounds)((Object)drawableElement)).getAdditionalBounds()) {
                    if (!LocationUtils.intersects(additionalBoundsInfo.getBounds(), rectangle2D)) continue;
                    return true;
                }
            }
            return false;
        }).collect(Collectors.toList());
    }

    public Rectangle2D getBounds(DrawableElement e2) {
        this.de();
        Rectangle2D rectangle2D = this.tm.get(e2);
        if (rectangle2D == null) {
            rectangle2D = LocationUtils.getNormedBounds(e2);
            this.tm.put(e2, rectangle2D);
        }
        return rectangle2D;
    }

    private static class a {
        private Rectangle2D bounds;
        private List<DrawableElement> tp;
        private List<DrawableElement> tq;

        public a(Rectangle2D rectangle2D) {
            this.bounds = rectangle2D;
        }

        public void add(DrawableElement e2) {
            if (e2 instanceof ShapeElement) {
                ShapeElement shapeElement = (ShapeElement)e2;
                if (shapeElement.getIsClip() || shapeElement.getShape() == null) {
                    return;
                }
                Shape shape = shapeElement.getShape();
                if (shape.intersects(this.bounds)) {
                    if (this.tq == null) {
                        this.tq = new ArrayList<DrawableElement>();
                    }
                    this.tq.add(e2);
                }
            } else {
                if (this.tq == null) {
                    this.tq = new ArrayList<DrawableElement>();
                }
                this.tq.add(e2);
            }
            if (e2.getType() == ElementType.Text || e2.getType() == ElementType.TextWord || e2.getType() == ElementType.TextLine) {
                if (this.tp == null) {
                    this.tp = new ArrayList<DrawableElement>();
                }
                this.tp.add(e2);
            }
        }
    }
}

