/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfc.print;

import com.inet.annotations.InternalApi;
import com.inet.pdfc.generator.message.InfoData;
import com.inet.pdfc.i18n.Msg;
import com.inet.pdfc.print.PrintPainter;
import com.inet.pdfc.print.ProgressListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

@InternalApi
public abstract class PrintToX {
    private PrintPainter re;
    private List<ProgressListener> rf = new ArrayList<ProgressListener>();

    public PrintToX(PrintPainter painter) {
        this.re = painter;
    }

    public PrintPainter getPainter() {
        return this.re;
    }

    public abstract void export() throws IOException;

    public String getResultDocumentName() {
        InfoData infoData = this.re.getModel().getComparisonParameters();
        return Msg.getMsg("Export.file.title", infoData.getFirstFile().getName(), infoData.getSecondFile().getName());
    }

    public abstract boolean cancel();

    public void addProgressListener(ProgressListener listener) {
        this.rf.add(listener);
    }

    public void removeProgressListener(ProgressListener listener) {
        this.rf.remove(listener);
    }

    public void fireNextPage(int pageIndex, int pageCount, int docPageIndex, int docPageCount) {
        for (ProgressListener progressListener : this.rf) {
            progressListener.onNextPage(pageIndex, pageCount, docPageIndex, docPageCount);
        }
    }

    public void fireFinish() {
        for (ProgressListener progressListener : new ArrayList<ProgressListener>(this.rf)) {
            progressListener.onFinish();
        }
    }
}

