/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfc.generator.rendercache;

import com.inet.annotations.InternalApi;
import com.inet.graphics.buffered.BufferedGraphics2D;
import com.inet.graphics.buffered.BufferedGraphicsProvider;
import com.inet.pdfc.generator.rendercache.PdfcRenderCache;
import com.inet.pdfc.generator.rendercache.RenderCacheBufferedGraphicsProvider;
import com.inet.pdfc.plugin.PluginManager;
import com.inet.pdfc.plugin.interfaces.PaintConverterFactory;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;

@InternalApi
public class RenderCacheBufferedGraphics
extends BufferedGraphics2D {
    private Map<Class<? extends Paint>, PaintConverterFactory.PaintConverter<?>> ik = RenderCacheBufferedGraphics.bk();
    private PdfcRenderCache bt;

    public RenderCacheBufferedGraphics(PdfcRenderCache storeMap) {
        super((BufferedGraphicsProvider)new RenderCacheBufferedGraphicsProvider(storeMap));
        this.bt = storeMap;
    }

    public RenderCacheBufferedGraphicsProvider getGraphicsProvider() {
        return (RenderCacheBufferedGraphicsProvider)super.getGraphicsProvider();
    }

    public void drawTo(Graphics2D graphics) {
        if (this.bt == null) {
            throw new IllegalStateException("RenderCacheBufferedGraphics must only be used with a backing persistence store map instance");
        }
        super.drawTo(graphics);
    }

    public void setStoreMap(PdfcRenderCache storeMap) {
        this.bt = storeMap;
        this.getGraphicsProvider().setStoreMap(storeMap);
    }

    private static Map<Class<? extends Paint>, PaintConverterFactory.PaintConverter<?>> bk() {
        HashMap hashMap = new HashMap();
        for (PaintConverterFactory paintConverterFactory : PluginManager.get(PaintConverterFactory.class)) {
            hashMap.put(paintConverterFactory.getConvertableClass(), paintConverterFactory.createConverter());
        }
        return hashMap;
    }

    public void setPaint(Paint paint) {
        try {
            PaintConverterFactory.PaintConverter<?> paintConverter;
            PaintConverterFactory.PaintConverter<?> paintConverter2 = paintConverter = paint != null ? this.ik.get(paint.getClass()) : null;
            if (paintConverter != null) {
                paint = paintConverter.createReplacement(paint, this.bt);
            }
            super.setPaint(paint);
        }
        catch (Exception exception) {
            Logger.getLogger(((Object)((Object)this)).getClass().getName()).warning("Null paint " + exception.getMessage());
        }
    }
}

