/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfc.generator.model.text;

import com.inet.annotations.InternalApi;
import com.inet.annotations.JsonData;
import com.inet.pdfc.PDFCCore;
import com.inet.pdfc.generator.comparator.c;
import com.inet.pdfc.generator.model.text.TextStyle;
import com.inet.pdfc.model.AdditionalBoundsInfo;
import com.inet.pdfc.model.DrawableElement;
import com.inet.pdfc.model.ElementID;
import com.inet.pdfc.model.ElementType;
import com.inet.pdfc.model.HasAdditionalBounds;
import com.inet.pdfc.model.PagedElement;
import com.inet.pdfc.model.Visitable;
import com.inet.pdfc.model.Visitor;
import com.inet.pdfc.util.CollectionUtils;
import com.inet.pdfc.util.LocationUtils;
import java.awt.Paint;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnull;

@JsonData
@InternalApi
public class WordElement
extends DrawableElement
implements HasAdditionalBounds,
Visitable {
    @Nonnull
    private String compareWord;
    @Nonnull
    private String originalWord;
    private double[] charWidths;
    private Point2D startPointX;
    @Nonnull
    private Rectangle2D.Double bounds;
    private List<AdditionalBoundsInfo> additionalBounds = null;
    private TextStyle style;
    private List<StyledSectionInternal> styleSections = null;

    public WordElement(@Nonnull String word, @Nonnull Rectangle2D.Double bounds, double @Nonnull [] charWidths, int pageIndex, TextStyle style, @Nonnull ElementID id) {
        super(pageIndex, id);
        this.originalWord = word;
        this.compareWord = word;
        this.bounds = bounds;
        this.charWidths = charWidths;
        this.style = style;
        this.startPointX = new Point2D.Double(bounds.getX(), bounds.getY() + Math.max(0.0, bounds.getHeight()));
    }

    @Override
    public double getX() {
        return this.bounds.getMinX();
    }

    @Override
    public double getY() {
        return this.bounds.getMinY();
    }

    @Override
    public void setX(double x) {
        if (this.additionalBounds != null) {
            double d2 = x - this.bounds.getX();
            for (AdditionalBoundsInfo additionalBoundsInfo : this.additionalBounds) {
                additionalBoundsInfo.move(d2, 0.0);
            }
        }
        this.bounds = new Rectangle2D.Double(x, this.bounds.getMinY(), this.bounds.getWidth(), this.bounds.getHeight());
    }

    @Override
    public void setY(double y) {
        if (this.additionalBounds != null) {
            double d2 = y - this.bounds.getY();
            for (AdditionalBoundsInfo additionalBoundsInfo : this.additionalBounds) {
                additionalBoundsInfo.move(0.0, d2);
            }
        }
        this.bounds = new Rectangle2D.Double(this.bounds.getMinX(), y, this.bounds.getWidth(), this.bounds.getHeight());
    }

    @Nonnull
    public String getCompareWord() {
        return this.compareWord;
    }

    public void setWord(@Nonnull String word, boolean isInternal) {
        if (this.styleSections != null) {
            if (!isInternal) {
                PDFCCore.LOGGER_COMPARE.warn((Object)("Compare word change after filter-stage is not supported for word '" + word + "' on page " + (this.getPageIndex() + 1)));
                this.styleSections = null;
            } else {
                this.updateStyleSections(this.compareWord, word);
            }
        }
        this.compareWord = word;
        if (isInternal) {
            return;
        }
        this.originalWord = word;
    }

    private void updateStyleSections(String originalWord, String compareWord) {
        if (compareWord == originalWord) {
            return;
        }
        List<c.a> list = new c().c(originalWord, compareWord);
        if (list == null) {
            return;
        }
        Iterator<StyledSectionInternal> iterator = this.styleSections.iterator();
        StyledSectionInternal styledSectionInternal = iterator.next();
        for (c.a a2 : list) {
            int n = a2.as() + a2.ax();
            int n2 = a2.au() + a2.aw();
            int n3 = a2.au() - a2.as();
            int n4 = n2 - n;
            while (n >= styledSectionInternal.startOffsetCompare) {
                if (styledSectionInternal.startOffsetCompare <= a2.as()) {
                    styledSectionInternal.startOffsetCompare += n3;
                    assert (styledSectionInternal.startOffsetCompare >= 0) : "Start offset of a section must be positive";
                } else {
                    styledSectionInternal.startOffsetCompare += n4;
                    assert (styledSectionInternal.startOffsetCompare >= 0) : "Start offset of a section must be positive";
                }
                if (iterator.hasNext()) {
                    styledSectionInternal = iterator.next();
                    continue;
                }
                return;
            }
        }
    }

    @Override
    public Rectangle2D.Double getBounds() {
        return this.bounds;
    }

    public void setBounds(Rectangle2D.Double bounds) {
        this.bounds = bounds;
        this.additionalBounds = null;
    }

    @Override
    public void setAdditionalBounds(AdditionalBoundsInfo ... additionalBounds) {
        this.additionalBounds = additionalBounds != null && additionalBounds.length > 0 ? CollectionUtils.toList(additionalBounds) : null;
    }

    @Override
    public List<AdditionalBoundsInfo> getAdditionalBounds() {
        return this.additionalBounds;
    }

    @Override
    public boolean hasAdditionalBounds() {
        return this.additionalBounds != null && !this.additionalBounds.isEmpty();
    }

    @Override
    public void createReplacementElements(List<PagedElement> listToAddTo) {
        if (this.additionalBounds == null || this.additionalBounds.isEmpty()) {
            return;
        }
        ElementID elementID = this.getElementID().getDescendant();
        for (AdditionalBoundsInfo additionalBoundsInfo : this.getAdditionalBounds()) {
            WordElement wordElement = new WordElement("", additionalBoundsInfo.getBounds(), new double[0], this.getPageIndex(), this.getStyle(), elementID);
            listToAddTo.add(wordElement);
            elementID = elementID.getNext();
        }
    }

    public String getDescription() {
        return "'" + this.originalWord + "'";
    }

    public Point2D getStartPoint() {
        return new Point2D.Double(this.bounds.getX(), LocationUtils.getMaxY(this.bounds));
    }

    public Point2D getEndPoint() {
        if (this.style.getRotation() != 0.0) {
            double d2 = 0.0;
            for (double d3 : this.charWidths) {
                d2 += d3;
            }
            return WordElement.computeEndPosition(this.startPointX.getX(), this.startPointX.getY(), d2, this.style.getRotation());
        }
        return new Point2D.Double(this.bounds.getMaxX(), LocationUtils.getMaxY(this.bounds));
    }

    public TextStyle getStyle() {
        return this.style;
    }

    public void setStyle(@Nonnull TextStyle style) {
        this.style = style;
    }

    public String toString() {
        return this.originalWord;
    }

    public static Point2D computeEndPosition(double x, double y, double width, double tanAlpa) {
        if (tanAlpa == Double.POSITIVE_INFINITY) {
            y -= width;
        } else if (tanAlpa == Double.NEGATIVE_INFINITY) {
            y += width;
        } else {
            double d2 = Math.atan(tanAlpa);
            x += width * Math.cos(d2);
            y -= width * Math.sin(d2);
        }
        return new Point2D.Double(x, y);
    }

    @Override
    public int getCompareHash() {
        return this.compareWord.hashCode();
    }

    @Override
    public double getRotation() {
        return this.style.getRotation();
    }

    @Override
    public ElementType getType() {
        return ElementType.TextWord;
    }

    @Override
    public Paint getStrokePaint() {
        return this.style.getStrokePaint();
    }

    @Override
    public Paint getFillPaint() {
        return this.style.getFillPaint();
    }

    public double @Nonnull [] getCharWidths() {
        if (this.charWidths == null) {
            this.charWidths = new double[this.compareWord.length()];
            if (this.compareWord.length() >= 0) {
                Arrays.fill(this.charWidths, this.bounds.getWidth() / (double)this.compareWord.length());
            }
        }
        return this.charWidths;
    }

    public void setCharWidths(double @Nonnull [] charWidths) {
        if (charWidths.length != this.originalWord.length()) {
            throw new IllegalArgumentException("CharWidth length does not match: " + this.originalWord + Arrays.toString(charWidths));
        }
        this.charWidths = charWidths;
    }

    public void setStartPointX(Point2D startPoint) {
        this.startPointX = startPoint;
    }

    public Point2D getStartPointX() {
        return this.startPointX;
    }

    @Override
    @Nonnull
    public String getLabel() {
        return this.originalWord;
    }

    public WordElement subText(int startIndex, int endIndex) {
        Serializable serializable;
        Rectangle2D.Double double_;
        double d2;
        String string = this.getLabel().substring(startIndex, endIndex);
        double[] dArray = new double[endIndex - startIndex];
        System.arraycopy(this.getCharWidths(), startIndex, dArray, 0, endIndex - startIndex);
        double d3 = Arrays.stream(dArray).sum();
        double d4 = d2 = startIndex > 0 ? Arrays.stream(this.getCharWidths(), 0, startIndex).sum() : 0.0;
        if (this.getStyle().getRotation() == 0.0) {
            double_ = new Rectangle2D.Double(this.getX() + d2, this.getY(), d3, -this.getStyle().getTextHeight());
        } else {
            serializable = new AffineTransform();
            ((AffineTransform)serializable).translate(this.getX(), this.getY());
            ((AffineTransform)serializable).rotate(this.getStyle().getRotation());
            ((AffineTransform)serializable).translate(d2, 0.0);
            double_ = new Rectangle2D.Double(0.0, 0.0, d3, -this.getStyle().getTextHeight());
            Rectangle2D rectangle2D = ((AffineTransform)serializable).createTransformedShape(double_).getBounds2D();
            double_ = new Rectangle2D.Double(rectangle2D.getX(), rectangle2D.getY(), rectangle2D.getWidth(), rectangle2D.getHeight());
        }
        serializable = new WordElement(string, double_, dArray, this.getPageIndex(), this.style, this.getElementID().getDescendant());
        if (this.compareWord != null && startIndex < this.compareWord.length()) {
            ((WordElement)serializable).setWord(this.compareWord.substring(startIndex, Math.min(endIndex, this.compareWord.length())), true);
        }
        return serializable;
    }

    public void append(WordElement word) {
        TextStyle textStyle;
        double d2;
        if (this.getCharWidths().length > 0 && word.getCharWidths().length > 0 && Math.abs(d2 = word.getBounds().getX() - this.getBounds().getX() - this.getBounds().getWidth()) > 0.01) {
            double[] dArray = this.getCharWidths();
            int n = this.getCharWidths().length - 1;
            dArray[n] = dArray[n] + d2 / 2.0;
            double[] dArray2 = word.getCharWidths();
            dArray2[0] = dArray2[0] + d2 / 2.0;
        }
        TextStyle textStyle2 = textStyle = this.styleSections == null ? this.style : this.styleSections.get((int)(this.styleSections.size() - 1)).style;
        if (!textStyle.equalsWithColors(word.style)) {
            if (this.styleSections == null) {
                this.styleSections = new ArrayList<StyledSectionInternal>();
            }
            this.styleSections.add(new StyledSectionInternal(word.style, this.compareWord.length()));
        }
        if (this.compareWord != this.originalWord || word.compareWord != word.originalWord) {
            this.compareWord = this.compareWord.concat(word.compareWord);
            this.originalWord = this.originalWord.concat(word.originalWord);
        } else {
            this.compareWord = this.originalWord = this.originalWord.concat(word.originalWord);
        }
        this.setBounds(LocationUtils.union(this.getBounds(), word.getBounds()));
        double[] dArray = new double[this.getCharWidths().length + word.getCharWidths().length];
        System.arraycopy(this.getCharWidths(), 0, dArray, 0, this.getCharWidths().length);
        System.arraycopy(word.getCharWidths(), 0, dArray, this.getCharWidths().length, word.getCharWidths().length);
        this.setCharWidths(dArray);
    }

    public boolean hasStyleSections() {
        return this.styleSections != null;
    }

    public List<StyledSection> getStyleSections() {
        ArrayList<StyledSection> arrayList = new ArrayList<StyledSection>();
        int n = 0;
        TextStyle textStyle = this.style;
        if (this.styleSections != null) {
            for (StyledSectionInternal styledSectionInternal : this.styleSections) {
                arrayList.add(new StyledSection(textStyle, styledSectionInternal.startOffsetCompare));
                n = styledSectionInternal.startOffsetCompare;
                textStyle = styledSectionInternal.style;
            }
        }
        if (n < this.compareWord.length()) {
            arrayList.add(new StyledSection(textStyle, this.compareWord.length()));
        }
        return arrayList;
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visit(this);
    }

    @JsonData
    private static class StyledSectionInternal
    implements Serializable {
        private int startOffsetCompare;
        private TextStyle style;

        public StyledSectionInternal(TextStyle style, int startOffsetCompare) {
            this.style = style;
            this.startOffsetCompare = startOffsetCompare;
        }
    }

    @JsonData
    @InternalApi
    public static class StyledSection
    implements Serializable {
        private int endOffsetCompare;
        private TextStyle style;

        public StyledSection(TextStyle style, int endOffsetCompare) {
            this.style = style;
            this.endOffsetCompare = endOffsetCompare;
        }

        public TextStyle getStyle() {
            return this.style;
        }

        public int getEndOffset() {
            return this.endOffsetCompare;
        }
    }
}

