/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfc.util;

import com.inet.annotations.InternalApi;
import com.inet.pdfc.generator.continuous.structure.StructureElement;
import com.inet.pdfc.generator.model.text.WordElement;
import com.inet.pdfc.model.DrawableElement;
import com.inet.pdfc.model.ElementType;
import java.util.ArrayList;
import java.util.List;

@InternalApi
public class ElementUtils {
    public static List<WordElement> getAllText(List<DrawableElement> elements) {
        return ElementUtils.getAllText(elements, null);
    }

    public static List<WordElement> getAllText(List<DrawableElement> elements, List<WordElement> collector) {
        if (collector == null) {
            collector = new ArrayList<WordElement>();
        }
        for (DrawableElement drawableElement : elements) {
            if (drawableElement.getType().isStructuralType()) {
                ElementUtils.getAllText(((StructureElement)drawableElement).getChildren(), collector);
                continue;
            }
            if (drawableElement.getType() != ElementType.TextWord) continue;
            collector.add((WordElement)drawableElement);
        }
        return collector;
    }

    public static List<DrawableElement> getElementsOfType(List<DrawableElement> elements, ElementType type) {
        return ElementUtils.getElementsOfType(elements, type, null);
    }

    public static List<DrawableElement> getElementsOfType(List<DrawableElement> elements, ElementType type, List<DrawableElement> collector) {
        if (collector == null) {
            collector = new ArrayList<DrawableElement>();
        }
        for (DrawableElement drawableElement : elements) {
            if (drawableElement.getType().isStructuralType()) {
                ElementUtils.getElementsOfType(((StructureElement)drawableElement).getChildren(), type, collector);
                continue;
            }
            if (drawableElement.getType() != type) continue;
            collector.add(drawableElement);
        }
        return collector;
    }
}

