/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfc.results.painter;

import com.inet.annotations.InternalApi;
import com.inet.pdfc.config.DefaultSetting;
import com.inet.pdfc.error.ExceptionData;
import com.inet.pdfc.generator.model.DiffGroup;
import com.inet.pdfc.generator.model.Modification;
import com.inet.pdfc.model.PagedElement;
import com.inet.pdfc.presenter.BasePresenter;
import com.inet.pdfc.print.ColorProvider;
import com.inet.pdfc.results.ResultModel;
import com.inet.pdfc.results.ResultPage;
import com.inet.pdfc.results.painter.DiffConstants;
import com.inet.pdfc.util.LocationUtils;
import com.inet.pdfc.util.Pair;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;

@InternalApi
public class DifferenceImageCache {
    private ResultModel model;
    private Pair<Map<Modification.ModificationType, List<PagedElement>[]>> rT = new Pair();
    private ColorProvider rU = new DefaultSetting();
    private ResultModel.ResultModelChangeListener rV = new ResultModel.ResultModelChangeListener(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void modelChanged(ResultModel.ChangeInfo change) {
            switch (change.getType()) {
                case CLEARED: 
                case COMPLETED: 
                case FILTER_CHANGE: 
                case INCREMENTAL: 
                case VISIBILITY_CHANGE: {
                    Pair<Map<Modification.ModificationType, List<PagedElement>[]>> pair = DifferenceImageCache.this.rT;
                    synchronized (pair) {
                        DifferenceImageCache.this.rT.set(true, null);
                        DifferenceImageCache.this.rT.set(false, null);
                        break;
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean errorOcurred(ExceptionData error, boolean interrupted, BasePresenter.ERROR_SOURCE source) {
            Pair<Map<Modification.ModificationType, List<PagedElement>[]>> pair = DifferenceImageCache.this.rT;
            synchronized (pair) {
                DifferenceImageCache.this.rT.set(true, null);
                DifferenceImageCache.this.rT.set(false, null);
            }
            return false;
        }
    };

    public DifferenceImageCache(ResultModel model) {
        this.model = model;
        model.addChangeListener(this.rV);
    }

    public void setResultModel(ResultModel model) {
        if (this.model != null) {
            this.model.removeChangeListener(this.rV);
        }
        this.model = model;
        model.addChangeListener(this.rV);
    }

    public void setColorProvider(ColorProvider colorProvider) {
        this.rU = colorProvider;
    }

    public Image getImageFromCache(boolean first, int pageIndex) {
        ResultPage resultPage = this.model.getPage(pageIndex, first);
        if (resultPage == null) {
            return null;
        }
        return this.a(first, resultPage, resultPage.getSize());
    }

    public Image getScaledImageFromCache(boolean first, int pageIndex, Dimension size) {
        if (size.getWidth() <= 0.0 || size.getHeight() <= 0.0) {
            return null;
        }
        ResultPage resultPage = this.model.getPage(pageIndex, first);
        if (resultPage == null || resultPage.getWidth() <= 0) {
            return null;
        }
        return this.a(first, resultPage, size);
    }

    private BufferedImage a(boolean bl, ResultPage resultPage, Dimension dimension) {
        double d2;
        double d3 = (double)dimension.width / (double)resultPage.getWidth();
        BufferedImage bufferedImage = resultPage.getPageImage(d3, d2 = (double)dimension.height / (double)resultPage.getHeight());
        if (bufferedImage == null) {
            return null;
        }
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.scale(d3, d2);
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        for (Modification.ModificationType modificationType : Modification.ModificationType.values()) {
            this.a(graphics2D, bl, this.model, resultPage.getPageIndex(), modificationType);
        }
        return bufferedImage;
    }

    private void a(@Nonnull Graphics2D graphics2D, boolean bl, @Nonnull ResultModel resultModel, int n, Modification.ModificationType modificationType) {
        if (!resultModel.getSettings().isEnabled(modificationType)) {
            return;
        }
        List<PagedElement> list = this.a(n, resultModel, bl, modificationType);
        graphics2D.setColor(this.rU.getOutlineColor(modificationType));
        Rectangle rectangle = graphics2D.getClipBounds();
        if (rectangle == null) {
            ResultPage resultPage = resultModel.getPage(n, bl);
            if (resultPage == null) {
                return;
            }
            rectangle = new Rectangle(resultPage.getWidth(), resultPage.getHeight());
        }
        for (PagedElement pagedElement : list) {
            Rectangle rectangle2 = LocationUtils.getOutline(pagedElement);
            if (!rectangle.intersects(rectangle2)) continue;
            graphics2D.fill(rectangle2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<PagedElement> a(int n, ResultModel resultModel, boolean bl, Modification.ModificationType modificationType) {
        Pair<Map<Modification.ModificationType, List<PagedElement>[]>> pair = this.rT;
        synchronized (pair) {
            List<PagedElement>[] listArray;
            Map<Modification.ModificationType, List<PagedElement>[]> map = this.rT.get(bl);
            if (map == null) {
                int n2 = resultModel.getPageCount(bl);
                map = new HashMap<Modification.ModificationType, List<PagedElement>[]>();
                this.rT.set(bl, map);
                for (Modification.ModificationType modificationTypeArray : Modification.ModificationType.values()) {
                    listArray = new List[n2];
                    for (int i = 0; i < n2; ++i) {
                        listArray[i] = new ArrayList<PagedElement>();
                    }
                    map.put(modificationTypeArray, listArray);
                }
                List<DiffGroup> list = resultModel.getDifferences(true);
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    Modification.ModificationType[] modificationTypeArray;
                    DiffGroup diffGroup = (DiffGroup)iterator.next();
                    for (Modification.ModificationType modificationType2 : modificationTypeArray = DiffConstants.getModificationType(diffGroup.getType())) {
                        List<Modification> list2;
                        listArray = map.get(modificationType2);
                        if (listArray == null || modificationType2 == Modification.ModificationType.add && bl || modificationType2 == Modification.ModificationType.remove && !bl || (list2 = diffGroup.getModifications()) == null || list2.isEmpty()) continue;
                        for (Modification modification : list2) {
                            List<PagedElement> list3;
                            if (!modification.isVisible() || (list3 = modification.getAffectedElements(bl)).isEmpty()) continue;
                            for (PagedElement pagedElement : list3) {
                                listArray[pagedElement.getPageIndex()].add(pagedElement);
                            }
                        }
                    }
                }
            }
            // MONITOREXIT @DISABLED, blocks:[0, 1] lbl43 : MonitorExitStatement: MONITOREXIT : pair
            listArray = map.get(modificationType);
            return listArray != null && n < listArray.length ? listArray[n] : new ArrayList<PagedElement>();
        }
    }

    public void renderPage(boolean first, int pageIndex, double scale, Graphics2D g2, boolean outlineDiffs) {
        ResultPage resultPage = this.model.getPage(pageIndex, first);
        if (resultPage == null) {
            return;
        }
        Graphics2D graphics2D = (Graphics2D)g2.create();
        resultPage.renderPage(scale, graphics2D);
        graphics2D.dispose();
        graphics2D = (Graphics2D)g2.create();
        graphics2D.scale(scale, scale);
        if (outlineDiffs) {
            for (Modification.ModificationType modificationType : Modification.ModificationType.values()) {
                this.a(graphics2D, first, this.model, pageIndex, modificationType);
            }
        }
        graphics2D.dispose();
    }
}

