/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfc.reporting;

import com.inet.annotations.InternalApi;
import com.inet.font.truetype.SessionFontFactoryCache;
import com.inet.logging.LogManager;
import com.inet.logging.Logger;
import com.inet.pdfc.plugin.interfaces.DocumentFontListener;
import java.awt.Font;
import java.io.IOException;
import java.util.Map;

@InternalApi
public class FontGenerationCtrl
implements DocumentFontListener {
    private Logger ma = LogManager.getLogger((String)"Reporting");

    @Override
    public void fontGenerated(Font font, byte[] fontFileData, Map<Character, char[]> cmapAddition) {
        try {
            if (this.ma.isDebug()) {
                this.ma.debug((Object)("Register font in session: " + String.valueOf(font) + "; size=" + (fontFileData != null ? fontFileData.length : 0) + "bytes"));
            }
            SessionFontFactoryCache.addTempFont((Font)font, (byte[])fontFileData, cmapAddition);
        }
        catch (IOException iOException) {
            this.ma.error((Object)("Unable to register font '" + font.getName() + "' for the PDF export."));
            this.ma.debug((Object)iOException);
        }
        catch (IllegalStateException illegalStateException) {
            this.ma.error((Object)("Unable to register font '" + font.getName() + "' for the PDF export since there is no session object."));
            this.ma.debug((Object)illegalStateException);
        }
    }
}

