/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfc.parser;

import com.inet.annotations.InternalApi;
import com.inet.classloader.LoaderUtils;
import com.inet.logging.LogManager;
import com.inet.logging.Logger;
import com.inet.pdfc.parser.HocrDocument;
import com.inet.pdfc.parser.b;
import com.inet.pdfc.parser.c;
import com.inet.pdfc.parser.d;
import com.inet.pdfc.parser.e;
import com.inet.pdfc.parser.f;
import com.inet.pdfc.parser.g;
import com.inet.pdfc.parser.h;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import javax.annotation.SuppressFBWarnings;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

@InternalApi
public class HocrReader {
    private SAXParserFactory lY = LoaderUtils.newSaxParserFactory();
    private b lZ = null;
    private Logger ma = LogManager.getLogger((String)"hOCR Parser");
    private File mb;

    public HocrReader(File hOCRFile) throws IllegalArgumentException {
        this.mb = hOCRFile;
        if (hOCRFile == null || !hOCRFile.exists() || hOCRFile.length() == 0L) {
            throw new IllegalArgumentException("File can not be empty! " + hOCRFile.getAbsolutePath());
        }
    }

    public void isInnternalUsage() {
        try {
            this.lY.setFeature("http://apache.org/xml/features/disallow-doctype-decl", false);
        }
        catch (Throwable throwable) {
            LogManager.getConfigLogger().error(throwable);
        }
    }

    @SuppressFBWarnings(value={"XXE_SAXPARSER", "URLCONNECTION_SSRF_FD"}, justification="The option for prevent XXE Injection is deactivate, see few line above. This function is only for the inernal use with tesseract,")
    public HocrDocument parse() throws ParserConfigurationException, SAXException, IOException {
        SAXParser sAXParser = this.lY.newSAXParser();
        a a2 = new a();
        BufferedInputStream bufferedInputStream = new BufferedInputStream(this.mb.toURI().toURL().openStream());
        sAXParser.getXMLReader().setErrorHandler(new ErrorHandler(){

            @Override
            public void warning(SAXParseException exception) throws SAXException {
                HocrReader.this.ma.warn((Object)exception);
            }

            @Override
            public void error(SAXParseException exception) throws SAXException {
                HocrReader.this.ma.error((Throwable)exception);
            }

            @Override
            public void fatalError(SAXParseException exception) throws SAXException {
                HocrReader.this.ma.fatal((Object)exception);
            }
        });
        sAXParser.parse((InputStream)bufferedInputStream, (DefaultHandler)a2);
        return this.lZ;
    }

    private class a
    extends DefaultHandler {
        private f md = null;
        private com.inet.pdfc.parser.a me = null;
        private g mf = null;
        private c mg = null;
        private h mh = null;

        private a() {
        }

        @Override
        public InputSource resolveEntity(String publicId, String systemId) {
            HocrReader.this.ma.debug((Object)("resolve: " + systemId));
            return new InputSource(this.getClass().getResourceAsStream("ressource/xhtml1-transitional.dtd"));
        }

        @Override
        public void startDocument() {
            HocrReader.this.lZ = new b();
        }

        @Override
        public void startElement(String namespaceURI, String localName, String qName, Attributes atts) {
            String string;
            HashMap<String, String> hashMap = new HashMap<String, String>();
            for (int i = 0; i < atts.getLength(); ++i) {
                hashMap.put(atts.getQName(i), atts.getValue(i).toLowerCase());
            }
            if ("meta".equalsIgnoreCase(qName) && atts.getValue("name") != null && atts.getValue("content") != null) {
                ((d)HocrReader.this.lZ.getMeta()).d(atts.getValue("name"), atts.getValue("content"));
            }
            if ((string = (String)hashMap.get("class")) != null) {
                String string2;
                e e2 = null;
                if (string.equals("ocr_page")) {
                    this.md = new f();
                    e2 = this.md;
                    HocrReader.this.lZ.a(this.md);
                    string2 = (String)hashMap.get("title");
                    for (String string3 : string2.split(";")) {
                        if (!string3.contains("ppageno")) continue;
                        String string4 = string3.replace("ppageno", "").trim();
                        if (string4.matches("\\d+")) {
                            this.md.h(Integer.parseInt(string4));
                            continue;
                        }
                        HocrReader.this.ma.error((Object)("hOCR Parser Error, konnte ppageno nicht auswerten!\nValue = " + string3));
                    }
                } else if (string.equals("ocr_carea")) {
                    this.me = new com.inet.pdfc.parser.a();
                    e2 = this.me;
                    this.md.a(this.me);
                } else if (string.equals("ocr_par")) {
                    this.mf = new g();
                    e2 = this.mf;
                    this.me.a(this.mf);
                } else if (string.equals("ocr_line") || string.equals("ocr_caption")) {
                    this.mg = new c();
                    e2 = this.mg;
                    this.mf.a(this.mg);
                    string2 = (String)hashMap.get("title");
                    for (String string5 : string2.split(";")) {
                        if (!string5.contains("baseline")) continue;
                        String string6 = string5.replace("baseline", "").trim();
                        if (string6.contains(" ")) {
                            String[] stringArray = string6.split(" ");
                            if (stringArray.length == 2) {
                                double d2 = Double.parseDouble(stringArray[0]);
                                double d3 = Double.parseDouble(stringArray[1]);
                                this.mg.b(new Point2D.Double(d2, d3));
                                continue;
                            }
                            HocrReader.this.ma.error((Object)("hOCR Parser Error, konnte positionen der baseline nicht auswerten!\nValue = " + string5));
                            continue;
                        }
                        HocrReader.this.ma.error((Object)("hOCR Parser Error, konnte baseline nicht auswerten!\nValue = " + string5));
                    }
                } else if (string.equals("ocrx_word")) {
                    this.mh = new h();
                    e2 = this.mh;
                    if (this.mg == null) {
                        HocrReader.this.ma.warn((Object)("Keine Line Definiert " + (String)hashMap.get("id")));
                    } else {
                        this.mg.a(this.mh);
                        string2 = (String)hashMap.get("title");
                        if (string2 != null) {
                            this.mh.setFont(this.A(string2));
                        }
                    }
                }
                if (e2 != null) {
                    e2.y((String)hashMap.get("id"));
                }
                if ((string2 = (String)hashMap.get("title")) != null && e2 != null) {
                    Rectangle rectangle = this.z(string2);
                    e2.a(rectangle);
                }
            }
        }

        @Override
        public void characters(char[] buf, int offset, int len) throws SAXException {
            String string = new String(buf, offset, len).trim();
            if (!string.isEmpty()) {
                this.mh.setText(string);
            }
        }

        private Rectangle z(String string) {
            String[] stringArray;
            for (String string2 : stringArray = string.split(";")) {
                if (!string2.contains("bbox")) continue;
                String[] stringArray2 = string2.trim().split(" ");
                int n = Integer.parseInt(stringArray2[1]);
                int n2 = Integer.parseInt(stringArray2[2]);
                int n3 = Integer.parseInt(stringArray2[3]) - n;
                int n4 = Integer.parseInt(stringArray2[4]) - n2;
                return new Rectangle(n, n2, n3, n4);
            }
            return null;
        }

        private Font A(String string) {
            String[] stringArray = string.split(";");
            String string2 = "";
            int n = 0;
            int n2 = 0;
            for (String string3 : stringArray) {
                String[] stringArray2;
                if (string3.contains("x_font")) {
                    stringArray2 = string3.trim().split(" ");
                    string2 = stringArray2[1];
                    continue;
                }
                if (!string3.contains("x_fsize")) continue;
                stringArray2 = string3.trim().split(" ");
                n = Integer.parseInt(stringArray2[1]);
            }
            if (string2.toLowerCase().contains("bold") && string2.toLowerCase().contains("italic")) {
                n2 = 3;
            } else if (string2.toLowerCase().contains("bold")) {
                n2 = 1;
            } else if (string2.toLowerCase().contains("italic")) {
                n2 = 2;
            }
            if (string2.isEmpty()) {
                string2 = "Default";
            }
            return new Font(string2, n2, n);
        }
    }
}

