/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfc.generator.rendercache;

import com.inet.annotations.InternalApi;
import com.inet.graphics.buffered.BufferedGraphics2D;
import com.inet.pdfc.generator.rendercache.RenderCacheBufferedGraphics;
import com.inet.pdfc.thread.PdfcSession;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.PaintContext;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.TexturePaint;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

@InternalApi
public class BufferedGraphicsTexturePaint
implements Paint,
Serializable {
    private BufferedGraphics2D hY;
    private float hZ;
    private float ia;
    private AffineTransform ib;
    private int ic;
    private boolean ie;

    public BufferedGraphicsTexturePaint(BufferedGraphics2D bufferedGraphics2D, float xstep, float ystep, AffineTransform transform, int sizeLimit, boolean hasImage) {
        this.hY = bufferedGraphics2D;
        this.hZ = xstep;
        this.ia = ystep;
        this.ib = transform;
        this.ic = sizeLimit;
        this.ie = hasImage;
    }

    @Override
    public PaintContext createContext(ColorModel cm, Rectangle deviceBounds, Rectangle2D userBounds, AffineTransform xform, RenderingHints hints) {
        AffineTransform affineTransform = new AffineTransform(xform);
        affineTransform.concatenate(this.ib);
        double d2 = deviceBounds.width;
        double d3 = deviceBounds.height;
        if (this.ie && (this.hZ > (float)(4 * this.ic) || this.ia > (float)(4 * this.ic))) {
            double d4 = (double)this.hZ > d2 ? d2 + 1000.0 : (double)this.hZ;
            double d5 = (double)this.ia > d3 ? d3 + 1000.0 : (double)this.ia;
            double d6 = (double)this.hZ <= d2 ? deviceBounds.getX() : this.ib.getTranslateX();
            double d7 = (double)this.ia <= d3 ? deviceBounds.getY() : this.ib.getTranslateY();
            BufferedImage bufferedImage = new BufferedImage((int)d4, (int)d5, 2);
            Graphics2D graphics2D = bufferedImage.createGraphics();
            Color color = new Color(255, 255, 255, 1);
            graphics2D.setColor(color);
            graphics2D.fillRect(0, 0, (int)d4, (int)d5);
            this.hY.drawTo(graphics2D);
            graphics2D.dispose();
            Rectangle2D.Double double_ = new Rectangle2D.Double(d6, d7, d4, d5);
            return new TexturePaint(bufferedImage, double_).createContext(cm, deviceBounds, userBounds, xform, hints);
        }
        double d8 = (float)this.ic / this.hZ;
        double d9 = (double)((int)Math.round(Math.abs(affineTransform.getScaleX()) * 1000000.0)) / 1000000.0;
        if (d9 < 1.0E-6) {
            d9 = 1.0E-6;
        }
        if (d9 > d8) {
            d9 = d8;
        }
        while ((int)Math.round(Math.max((double)this.hZ * d9, 1.0)) > this.ic) {
            this.hZ /= 2.0f;
            d8 = (float)this.ic / this.hZ;
            if (!(d9 > d8)) continue;
            d9 = d8;
        }
        while (d9 < d8 / 2.0 && (double)this.hZ * d9 < (double)this.ic && (double)this.hZ * d9 < d2 * 4.0) {
            d9 *= 2.0;
        }
        double d10 = (float)this.ic / this.ia;
        double d11 = (double)((int)Math.round(Math.abs(affineTransform.getScaleY()) * 1000000.0)) / 1000000.0;
        if (d11 < 1.0E-6) {
            d11 = 1.0E-6;
        }
        if (d11 > d10) {
            d11 = d10;
        }
        while ((int)Math.round(Math.max((double)this.ia * d11, 1.0)) > this.ic) {
            this.ia /= 2.0f;
            d10 = (float)this.ic / this.ia;
            if (!(d11 > d10)) continue;
            d11 = d10;
        }
        while (d11 < d10 / 2.0 && (double)this.ia * d11 < (double)this.ic && (double)this.ia * d11 < d3 * 4.0) {
            d11 *= 2.0;
        }
        affineTransform.scale(1.0 / d9, 1.0 / d11);
        int n = (int)Math.floor(Math.max((double)this.hZ * d9, 1.0));
        int n2 = (int)Math.floor(Math.max((double)this.ia * d11, 1.0));
        BufferedImage bufferedImage = new BufferedImage(n, n2, 2);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.scale(d9, d11);
        this.hY.drawTo(graphics2D);
        Rectangle2D.Double double_ = new Rectangle2D.Double(0.0, 0.0, bufferedImage.getWidth(), bufferedImage.getHeight());
        return new TexturePaint(bufferedImage, double_).createContext(cm, deviceBounds, userBounds, affineTransform, hints);
    }

    @Override
    public int getTransparency() {
        return 3;
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        this.hY.writeTo((DataOutput)oos);
        oos.writeFloat(this.hZ);
        oos.writeFloat(this.ia);
        oos.writeInt(this.ic);
        oos.writeObject(this.ib);
        oos.writeBoolean(this.ie);
    }

    private void readObject(ObjectInputStream ois) throws ClassNotFoundException, IOException {
        this.hY = new RenderCacheBufferedGraphics(PdfcSession.getSession().getStoreMap());
        this.hY.readFrom((DataInput)new DataInputStream(ois));
        this.hZ = ois.readFloat();
        this.ia = ois.readFloat();
        this.ic = ois.readInt();
        this.ib = (AffineTransform)ois.readObject();
        this.ie = ois.readBoolean();
    }
}

