/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfc.generator.model;

import com.inet.annotations.InternalApi;
import com.inet.annotations.JsonData;
import com.inet.pdfc.generator.model.DiffGroup;
import com.inet.pdfc.generator.model.IDiffGroupBounds;
import com.inet.pdfc.generator.model.MinifiedDrawableElement;
import com.inet.pdfc.generator.model.MinifiedElement;
import com.inet.pdfc.generator.model.Modification;
import com.inet.pdfc.generator.model.MutableDiffGroup;
import com.inet.pdfc.model.DrawableElement;
import com.inet.pdfc.model.ElementID;
import com.inet.pdfc.model.ElementType;
import com.inet.pdfc.model.PagedElement;
import com.inet.pdfc.util.Pair;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;

@JsonData
@InternalApi
public class CompareDiffGroup
extends MutableDiffGroup
implements IDiffGroupBounds {
    private transient List<PagedElement> list1;
    private transient List<PagedElement> list2;
    private List<Modification> modifications;
    private Rectangle r1;
    private Rectangle r2;
    private PagedElement elementAfter1;
    private PagedElement elementAfter2;
    private PagedElement lastElement1;
    private PagedElement lastElement2;

    private CompareDiffGroup() {
    }

    public CompareDiffGroup(List<PagedElement> list1, List<PagedElement> list2, PagedElement lastElement1, PagedElement lastElement2, PagedElement nextElement1, PagedElement nextElement2, DiffGroup.GroupType type) {
        super(type);
        this.lastElement1 = lastElement1;
        this.lastElement2 = lastElement2;
        this.elementAfter1 = nextElement1;
        this.elementAfter2 = nextElement2;
        this.createModificationsFromAddedRemovedLists(list1, list2);
    }

    protected void createModificationsFromAddedRemovedLists(List<PagedElement> list1, List<PagedElement> list2) {
        this.modifications = new ArrayList<Modification>();
        ElementType elementType = null;
        int n = 0;
        switch (this.getType()) {
            case Sync: {
                break;
            }
            case Replaced: {
                this.modifications.add(new Modification(this.getType(), list1, list2, null));
                break;
            }
            case AddedOrRemoved: {
                PagedElement pagedElement;
                int n2;
                for (n2 = 0; n2 < list1.size(); ++n2) {
                    pagedElement = list1.get(n2);
                    if (elementType != null && elementType != pagedElement.getType().getBaseType()) {
                        this.modifications.add(new Modification(this.getType(), new ArrayList<PagedElement>(list1.subList(n, n2)), new ArrayList<PagedElement>(), null));
                        n = n2;
                    }
                    elementType = pagedElement.getType().getBaseType();
                }
                if (list1.size() > 0) {
                    this.modifications.add(new Modification(this.getType(), new ArrayList<PagedElement>(list1.subList(n, list1.size())), new ArrayList<PagedElement>(), null));
                }
                n = 0;
                elementType = null;
                for (n2 = 0; n2 < list2.size(); ++n2) {
                    pagedElement = list2.get(n2);
                    if (elementType != null && elementType != pagedElement.getType().getBaseType()) {
                        this.modifications.add(new Modification(this.getType(), new ArrayList<PagedElement>(), new ArrayList<PagedElement>(list2.subList(n, n2)), null));
                        n = n2;
                    }
                    elementType = pagedElement.getType().getBaseType();
                }
                if (list2.size() <= 0) break;
                this.modifications.add(new Modification(this.getType(), new ArrayList<PagedElement>(), new ArrayList<PagedElement>(list2.subList(n, list2.size())), null));
                break;
            }
            case Modified: 
            case MetadataChanged: {
                throw new IllegalStateException("Cannot create a 'style change' modification instance wihtout any actual modifications!");
            }
            default: {
                throw new IllegalStateException("Cannot derive modifications from a '" + String.valueOf(this.getType()) + "' differences group.");
            }
        }
    }

    public CompareDiffGroup(List<Modification> modifications, PagedElement lastElement1, PagedElement lastElement2, PagedElement nextElement1, PagedElement nextElement2, DiffGroup.GroupType type) {
        super(type);
        this.modifications = modifications;
        this.lastElement1 = lastElement1;
        this.lastElement2 = lastElement2;
        this.elementAfter1 = nextElement1;
        this.elementAfter2 = nextElement2;
    }

    public CompareDiffGroup(@Nonnull List<? extends PagedElement> list1, @Nonnull List<? extends PagedElement> list2) {
        super(null);
        this.list1 = new ArrayList<PagedElement>(list1);
        this.list2 = new ArrayList<PagedElement>(list2);
        this.modifications = new ArrayList<Modification>();
        this.modifications.add(new Modification(null, this.list1, this.list2, null));
    }

    public CompareDiffGroup(Modification modification, DiffGroup.GroupType type) {
        super(type);
        if (modification == null) {
            throw new IllegalArgumentException("Cannot instantiate a DiffGroup without any modification or bounds");
        }
        this.modifications = new ArrayList<Modification>();
        this.modifications.add(modification);
    }

    @Nonnull
    private @Nonnull Pair<@Nonnull List<@Nonnull PagedElement>> getElementsFromModifications(List<Modification> modifications) {
        ArrayList<@Nonnull PagedElement> arrayList = new ArrayList<PagedElement>();
        ArrayList<@Nonnull PagedElement> arrayList2 = new ArrayList<PagedElement>();
        if (modifications != null) {
            for (Modification modification : modifications) {
                List<PagedElement> list;
                List<PagedElement> list2 = modification.getAffectedElements(true);
                if (list2 != null) {
                    arrayList.addAll(list2);
                }
                if ((list = modification.getAffectedElements(false)) == null) continue;
                arrayList2.addAll(list);
            }
        }
        return new Pair<List<PagedElement>>(arrayList, arrayList2);
    }

    @Override
    public void setType(DiffGroup.GroupType type) {
        DiffGroup.GroupType groupType = this.getType();
        super.setType(type);
        if (groupType == DiffGroup.GroupType.AddedOrRemoved && type == DiffGroup.GroupType.Replaced) {
            Pair<List<PagedElement>> pair = this.getElementsFromModifications(this.getModifications());
            this.resetCache();
            this.modifications.clear();
            Modification modification = new Modification(DiffGroup.GroupType.Replaced, pair.get(true), pair.get(false), null);
            this.modifications.add(modification);
        }
    }

    @Override
    @Nonnull
    public @Nonnull List<@Nonnull PagedElement> getRemovedElements() {
        if (this.list1 == null && this.list2 == null) {
            Pair<@Nonnull List<@Nonnull PagedElement>> pair = this.getElementsFromModifications(this.modifications);
            this.list1 = Collections.unmodifiableList(pair.get(true));
            this.list2 = Collections.unmodifiableList(pair.get(false));
        }
        return this.list1;
    }

    @Override
    @Nonnull
    public @Nonnull List<@Nonnull PagedElement> getAddedElements() {
        if (this.list1 == null && this.list2 == null) {
            Pair<@Nonnull List<@Nonnull PagedElement>> pair = this.getElementsFromModifications(this.modifications);
            this.list1 = Collections.unmodifiableList(pair.get(true));
            this.list2 = Collections.unmodifiableList(pair.get(false));
        }
        return this.list2;
    }

    @Override
    public void setBounds(Rectangle bounds, boolean first) {
        if (first) {
            this.r1 = bounds;
        } else {
            this.r2 = bounds;
        }
    }

    @Override
    public Rectangle getBounds(boolean first) {
        return first ? this.r1 : this.r2;
    }

    @Override
    public int getDifferencesCount() {
        switch (this.getType()) {
            case Sync: {
                return 0;
            }
        }
        return this.getModifications().size();
    }

    public void minifyDiffs() {
        for (Modification modification : this.modifications) {
            this.minifyList(modification.getAffectedElements(true));
            this.minifyList(modification.getAffectedElements(false));
        }
        if (this.list1 != null || this.list2 != null) {
            Pair<List<PagedElement>> pair = this.getElementsFromModifications(this.modifications);
            this.list1 = Collections.unmodifiableList((List)pair.get(true));
            this.list2 = Collections.unmodifiableList((List)pair.get(false));
        }
        this.lastElement1 = this.minifyNoDiff(this.lastElement1);
        this.lastElement2 = this.minifyNoDiff(this.lastElement2);
        this.elementAfter1 = this.minifyNoDiff(this.elementAfter1);
        this.elementAfter2 = this.minifyNoDiff(this.elementAfter2);
    }

    private void minifyList(List<PagedElement> list) {
        if (list != null) {
            for (int i = 0; i < list.size(); ++i) {
                list.set(i, MinifiedElement.minify(list.get(i)));
            }
        }
    }

    private DrawableElement minifyNoDiff(PagedElement element) {
        if (element == null || element instanceof MinifiedDrawableElement) {
            return (DrawableElement)element;
        }
        ElementID elementID = new ElementID(false, element.getPageIndex(), (int)element.getBounds().getX(), (int)element.getBounds().getY());
        return new MinifiedDrawableElement(MinifiedElement.getBoundsFloat(element.getBounds()), element.getType(), element.getPageIndex(), elementID);
    }

    @Override
    public void setElementsAfterGroup(PagedElement elementFirst, PagedElement elementSecond) {
        this.elementAfter1 = elementFirst;
        this.elementAfter2 = elementSecond;
    }

    @Override
    public void setElementsInFrontOfGroup(PagedElement elementFirst, PagedElement elementSecond) {
        this.lastElement1 = elementFirst;
        this.lastElement2 = elementSecond;
    }

    @Override
    public PagedElement getBeforeFirst() {
        return this.lastElement1;
    }

    @Override
    public PagedElement getBeforeSecond() {
        return this.lastElement2;
    }

    @Override
    public PagedElement getAfterFirst() {
        return this.elementAfter1;
    }

    @Override
    public PagedElement getAfterSecond() {
        return this.elementAfter2;
    }

    @Override
    public IDiffGroupBounds getBoundingElements() {
        return this;
    }

    @Override
    public List<Modification> getModifications() {
        if (this.modifications == null && this.list1 != null && this.list2 != null) {
            this.createModificationsFromAddedRemovedLists(this.list1, this.list2);
        }
        return this.modifications;
    }

    private static <T> boolean isEqual(T a2, T b2) {
        if (a2 == null) {
            return b2 == null;
        }
        return a2.equals(b2);
    }

    public boolean equals(Object other) {
        if (!(other instanceof CompareDiffGroup)) {
            return false;
        }
        CompareDiffGroup compareDiffGroup = (CompareDiffGroup)other;
        return CompareDiffGroup.isEqual(this.list1, compareDiffGroup.list1) && CompareDiffGroup.isEqual(this.list2, compareDiffGroup.list2) && CompareDiffGroup.isEqual(this.modifications, compareDiffGroup.modifications) && CompareDiffGroup.isEqual(this.r1, compareDiffGroup.r1) && CompareDiffGroup.isEqual(this.r2, compareDiffGroup.r2) && CompareDiffGroup.isEqual(this.elementAfter1, compareDiffGroup.elementAfter1) && CompareDiffGroup.isEqual(this.elementAfter2, compareDiffGroup.elementAfter2) && CompareDiffGroup.isEqual(this.lastElement1, compareDiffGroup.lastElement1) && CompareDiffGroup.isEqual(this.lastElement2, compareDiffGroup.lastElement2);
    }

    @Override
    public void resetCache() {
        this.list1 = null;
        this.list2 = null;
    }

    @Override
    public boolean isVisible() {
        for (int i = 0; i < this.modifications.size(); ++i) {
            if (!this.modifications.get(i).isVisible()) continue;
            return true;
        }
        return false;
    }
}

