/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfc.generator.filter.bidi;

import com.inet.annotations.InternalApi;
import com.inet.pdfc.PDFCCore;
import com.inet.pdfc.generator.continuous.structure.StructureElement;
import com.inet.pdfc.generator.filter.SortFilterBase;
import com.inet.pdfc.generator.model.CompareDiffGroup;
import com.inet.pdfc.generator.model.text.WordElement;
import com.inet.pdfc.model.DrawableElement;
import com.inet.pdfc.model.ElementType;
import com.inet.pdfc.model.PagedElement;
import com.inet.pdfc.util.LocationUtils;
import com.inet.pdfc.util.Pair;
import com.inet.shared.bidi.BidiString;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import javax.annotation.Nullable;

@InternalApi
public class BidiSortFilter
extends SortFilterBase {
    public static final String FILTER_NAME = "BIDI";

    public BidiSortFilter() {
        super(FILTER_NAME);
    }

    @Override
    public List<DrawableElement> sortOrFilterPage(int pageNr, List<DrawableElement> pageElements, boolean first, @Nullable List<CompareDiffGroup> diffGroups) {
        boolean bl;
        Pair<Integer> pair = this.j(pageElements);
        int n = pair.get(false);
        if (n == 0) {
            return pageElements;
        }
        int n2 = pair.get(true);
        boolean bl2 = bl = n > n2;
        if (bl) {
            PDFCCore.LOGGER_CORE.debug((Object)("Page " + pageNr + " is RTL Page for " + (first ? "first" : "second") + " document"));
        }
        return this.a(pageElements, pageNr, bl);
    }

    private List<DrawableElement> a(List<DrawableElement> list, int n, boolean bl) {
        ArrayList<DrawableElement> arrayList = new ArrayList<DrawableElement>();
        ArrayList<DrawableElement> arrayList2 = new ArrayList<DrawableElement>();
        double d2 = Double.MIN_VALUE;
        for (DrawableElement drawableElement : list) {
            if (drawableElement.getType() == ElementType.Page || drawableElement.getType() == ElementType.Paragraph) {
                List<DrawableElement> list2 = this.a(((StructureElement)drawableElement).getChildren(), n, bl);
                drawableElement = new StructureElement(drawableElement.getType(), drawableElement.getBounds(), list2, drawableElement.getPageIndex(), drawableElement.getElementID());
            }
            if (drawableElement.getY() != d2) {
                if (!arrayList2.isEmpty()) {
                    arrayList.addAll(this.sortSingleLine(arrayList2, n, bl));
                    arrayList2.clear();
                }
                d2 = drawableElement.getY();
            }
            arrayList2.add(drawableElement);
        }
        if (!arrayList2.isEmpty()) {
            arrayList.addAll(this.sortSingleLine(arrayList2, n, bl));
        }
        return arrayList;
    }

    private Pair<Integer> j(List<DrawableElement> list) {
        int n = 0;
        int n2 = 0;
        for (DrawableElement drawableElement : list) {
            Object object;
            if (drawableElement.getType() == ElementType.Page || drawableElement.getType() == ElementType.Paragraph) {
                object = this.j(((StructureElement)drawableElement).getChildren());
                n += ((Pair)object).get(true).intValue();
                n2 += ((Integer)((Pair)object).get(false)).intValue();
                continue;
            }
            if (drawableElement.getType() != ElementType.Text && drawableElement.getType() != ElementType.TextWord) continue;
            object = drawableElement.getLabel();
            n = (int)((long)n + BidiString.getNumberOfLeftChar((String)object));
            n2 = (int)((long)n2 + BidiString.getNumberOfRightChar((String)object));
        }
        return new Pair<Integer>(n, n2);
    }

    public void sortLine(List<DrawableElement> line, boolean isRTL) {
        List<DrawableElement> list = this.sortSingleLine(line, line.isEmpty() ? 0 : line.get(0).getPageIndex(), isRTL);
        line.clear();
        line.addAll(list);
    }

    public List<DrawableElement> sortSingleLine(List<DrawableElement> elements, int pageNr, boolean isRTL) {
        Serializable serializable;
        int n;
        int n2;
        boolean bl = false;
        if (isRTL) {
            elements.sort((drawableElement, drawableElement2) -> Double.compare(drawableElement2.getX(), drawableElement.getX()));
        } else {
            boolean bl2 = false;
            elements.sort(Comparator.comparingDouble(DrawableElement::getX));
            n2 = -1;
            n = -1;
            for (int i = 0; i < elements.size(); ++i) {
                serializable = elements.get(i);
                if (serializable.getType() != ElementType.Text && serializable.getType() != ElementType.TextWord) continue;
                bl2 = true;
                String string = serializable.getLabel();
                if (BidiString.hasRightToLeftChars((String)string)) {
                    if (n2 == -1) {
                        n2 = i;
                    }
                    n = i;
                    continue;
                }
                if (n2 == -1) continue;
                BidiSortFilter.swapElements(n2, n, elements);
                n2 = -1;
                n = -1;
            }
            if (n2 != -1) {
                BidiSortFilter.swapElements(n2, n, elements);
            }
            if (!bl2) {
                return elements;
            }
        }
        if (bl) {
            ArrayList<DrawableElement> arrayList = new ArrayList<DrawableElement>(elements.size() / 2);
            n2 = 0;
            for (n = 0; n < elements.size(); ++n) {
                DrawableElement drawableElement3 = elements.get(n);
                if (drawableElement3.getType() == ElementType.Text || drawableElement3.getType() == ElementType.TextWord) continue;
                if (n - n2 > 0) {
                    if (n - n2 == 1) {
                        arrayList.add(elements.get(n2));
                    } else {
                        serializable = new ArrayList<DrawableElement>(elements.subList(n2, n));
                        arrayList.add(new StructureElement(ElementType.TextLine, LocationUtils.getJoinedBounds((List<? extends PagedElement>)((Object)serializable)), (List<DrawableElement>)((Object)serializable), pageNr, drawableElement3.getElementID().getDescendant()));
                    }
                }
                n2 = n + 1;
            }
            if (arrayList.size() - n2 > 0) {
                if (arrayList.size() - n2 == 1) {
                    arrayList.add(elements.get(n2));
                } else {
                    ArrayList<DrawableElement> arrayList2 = new ArrayList<DrawableElement>(elements.subList(n2, arrayList.size()));
                    arrayList.add(new StructureElement(ElementType.TextLine, LocationUtils.getJoinedBounds(arrayList2), arrayList2, pageNr, elements.get(n2).getElementID().getDescendant()));
                }
            }
            return arrayList;
        }
        ArrayList<DrawableElement> arrayList = new ArrayList<DrawableElement>();
        ArrayList<DrawableElement> arrayList3 = new ArrayList<DrawableElement>();
        for (DrawableElement drawableElement4 : elements) {
            if (drawableElement4.getType() == ElementType.Text || drawableElement4.getType() == ElementType.TextWord) {
                arrayList3.add(drawableElement4);
                continue;
            }
            if (arrayList3.isEmpty()) {
                arrayList.add(drawableElement4);
                continue;
            }
            arrayList.add(new StructureElement(ElementType.TextLine, LocationUtils.getJoinedBounds(arrayList3), new ArrayList<DrawableElement>(arrayList3), pageNr, ((DrawableElement)arrayList3.get(0)).getElementID().getDescendant()));
            arrayList.add(drawableElement4);
            arrayList3 = new ArrayList();
        }
        if (!arrayList3.isEmpty()) {
            arrayList.add(new StructureElement(ElementType.TextLine, LocationUtils.getJoinedBounds(arrayList3), new ArrayList<DrawableElement>(arrayList3), pageNr, ((DrawableElement)arrayList3.get(0)).getElementID().getDescendant()));
        }
        return arrayList;
    }

    public static void swapElements(int startIndex, int endIndex, List<DrawableElement> list) {
        if (startIndex >= endIndex) {
            return;
        }
        DrawableElement drawableElement = list.get(startIndex);
        list.set(startIndex, list.get(endIndex));
        list.set(endIndex, drawableElement);
        BidiSortFilter.swapElements(startIndex + 1, endIndex - 1, list);
    }

    public static void swapElementsBounds(int startIndex, int endIndex, List<DrawableElement> list, double offset) {
        int n;
        if (startIndex > endIndex) {
            return;
        }
        double d2 = Double.MAX_VALUE;
        double d3 = 0.0;
        double[] dArray = new double[endIndex - startIndex];
        for (n = startIndex; n <= endIndex; ++n) {
            double d4 = list.get(n).getX();
            if (!(d2 > d4)) continue;
            d2 = d4;
        }
        for (n = startIndex; n < endIndex; ++n) {
            DrawableElement drawableElement = list.get(n);
            DrawableElement drawableElement2 = list.get(n + 1);
            dArray[n - startIndex] = drawableElement2.getX() - drawableElement.getX() - drawableElement.getBounds().getWidth();
            d3 += dArray[n - startIndex] + drawableElement.getBounds().getWidth();
        }
        double d5 = d2 + (d3 += list.get(list.size() - 1).getBounds().getWidth()) - offset;
        for (int i = startIndex; i <= endIndex; ++i) {
            DrawableElement drawableElement = list.get(i);
            Rectangle2D rectangle2D = drawableElement.getBounds();
            ((WordElement)drawableElement).setBounds(new Rectangle2D.Double(d5 -= rectangle2D.getWidth(), rectangle2D.getY(), rectangle2D.getWidth(), rectangle2D.getHeight()));
            ((WordElement)drawableElement).setStartPointX(new Point2D.Double(d5, rectangle2D.getMaxY()));
            if (i - startIndex >= dArray.length) continue;
            d5 -= dArray[i - startIndex];
        }
    }
}

