/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfc.config;

import com.inet.annotations.PublicApi;
import com.inet.logging.LogManager;
import com.inet.pdfc.PDFCCore;
import com.inet.pdfc.config.SourceProfile;
import com.inet.pdfc.i18n.Msg;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.Arrays;
import java.util.InvalidPropertiesFormatException;
import javax.annotation.SuppressFBWarnings;

@PublicApi
public class XMLProfile
extends SourceProfile {
    @SuppressFBWarnings(value={"URLCONNECTION_SSRF_FD"}, justification="no webserver access here")
    public XMLProfile(File xmlProfileFile) throws IllegalArgumentException, InvalidPropertiesFormatException {
        if (xmlProfileFile != null) {
            if (!xmlProfileFile.exists()) {
                throw new IllegalArgumentException(Msg.getMsg("Config.fileDoesNotExist", xmlProfileFile.getName()));
            }
        } else {
            xmlProfileFile = new File("config.xml");
            if (!xmlProfileFile.exists()) {
                xmlProfileFile = new File("profile.xml");
            }
        }
        if (!xmlProfileFile.exists()) {
            LogManager.getConfigLogger().info((Object)Msg.getMsg("Config.workingWithDefault"));
        } else {
            try {
                this.loadXML(xmlProfileFile.toURI().toURL().openStream(), xmlProfileFile.getName());
            }
            catch (InvalidPropertiesFormatException invalidPropertiesFormatException) {
                throw invalidPropertiesFormatException;
            }
            catch (MalformedURLException malformedURLException) {
                PDFCCore.LOGGER_PRESENTER.fatal((Object)Arrays.toString(malformedURLException.getStackTrace()));
            }
            catch (IOException iOException) {
                PDFCCore.LOGGER_PRESENTER.error((Object)Arrays.toString(iOException.getStackTrace()));
            }
        }
    }
}

