/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfc.util;

import com.inet.annotations.InternalApi;
import com.inet.pdfc.config.IProfile;
import com.inet.pdfc.config.PDFCProperty;
import com.inet.pdfc.generator.continuous.structure.StructureElement;
import com.inet.pdfc.generator.model.text.WordElement;
import com.inet.pdfc.model.DrawableElement;
import java.awt.geom.Point2D;
import java.awt.geom.RectangularShape;
import java.util.ArrayList;
import java.util.List;

@InternalApi
public class TextExtractor {
    private double hH = PDFCProperty.TEXT_ALIGN_RATIO.getDefaultValue();
    private boolean ut = false;

    public TextExtractor(IProfile profile) {
        this.hH = profile.getDouble(PDFCProperty.TEXT_ALIGN_RATIO);
        this.ut = profile.getString(PDFCProperty.FILTERS).contains("HIDEROTATEDTEXT");
    }

    public PageDescription createPageDescription(List<DrawableElement> pageElements) {
        ArrayList<WordEntry> arrayList = new ArrayList<WordEntry>();
        StringBuilder stringBuilder = new StringBuilder();
        Point2D.Double double_ = new Point2D.Double();
        StructureElement structureElement = null;
        this.a(pageElements, arrayList, stringBuilder, double_, structureElement, 0.0, null);
        return new PageDescription(stringBuilder.toString(), arrayList);
    }

    private WordElement a(List<DrawableElement> list, List<WordEntry> list2, StringBuilder stringBuilder, Point2D point2D, StructureElement structureElement, double d2, WordElement object) {
        for (DrawableElement drawableElement : list) {
            Object object2;
            DrawableElement drawableElement2;
            if (drawableElement instanceof StructureElement) {
                drawableElement2 = (StructureElement)drawableElement;
                object2 = this.a(((StructureElement)drawableElement2).getChildren(), list2, stringBuilder, point2D, (StructureElement)drawableElement2, d2, (WordElement)object);
                if (object2 == null) continue;
                object = object2;
                continue;
            }
            if (!(drawableElement instanceof WordElement)) continue;
            drawableElement2 = (WordElement)drawableElement;
            if (this.ut && ((WordElement)drawableElement2).getRotation() != 0.0) continue;
            object2 = drawableElement.getBounds();
            double d3 = ((WordElement)drawableElement2).getStyle().getWsWidthScaled();
            if (d3 == 0.0) {
                d3 = ((RectangularShape)object2).getHeight() / 4.0;
            }
            if (object != null && stringBuilder.length() > 0) {
                if (!this.b((WordElement)object, (WordElement)drawableElement2)) {
                    stringBuilder.append('\n');
                } else {
                    double d4 = Math.max(d2, d3);
                    if (this.c((WordElement)object, (WordElement)drawableElement2) > d4) {
                        stringBuilder.append(' ');
                    }
                }
            }
            int n = stringBuilder.length();
            d2 = d3;
            object = drawableElement2;
            stringBuilder.append(((WordElement)drawableElement2).getLabel());
            list2.add(new WordEntry(structureElement, (WordElement)drawableElement2, n, stringBuilder.length()));
            point2D.setLocation(((RectangularShape)object2).getMaxX(), ((RectangularShape)object2).getMaxY());
        }
        return object;
    }

    private boolean b(WordElement wordElement, WordElement wordElement2) {
        if (Math.abs(wordElement.getRotation() - wordElement2.getRotation()) > 0.05) {
            return false;
        }
        double d2 = this.hH * Math.min(wordElement.getStyle().getTextHeight(), wordElement2.getStyle().getTextHeight());
        Point2D point2D = wordElement.getStartPointX();
        Point2D point2D2 = wordElement2.getStartPointX();
        if (wordElement.getRotation() == 0.0) {
            return Math.abs(point2D.getY() - point2D2.getY()) <= d2;
        }
        double d3 = wordElement.getRotation();
        double d4 = Math.abs(Math.sin(d3 = Math.atan(d3)) * (point2D2.getX() - point2D.getX()) + Math.cos(d3) * (point2D.getY() - point2D2.getY()));
        return d4 < d2;
    }

    private double c(WordElement wordElement, WordElement wordElement2) {
        if (wordElement.getRotation() == 0.0) {
            return Math.abs(wordElement.getEndPoint().getX() - wordElement2.getStartPoint().getX());
        }
        double d2 = wordElement.getEndPoint().distance(wordElement2.getStartPointX());
        return d2;
    }

    @InternalApi
    public static class PageDescription {
        private String uu;
        private List<WordEntry> uv;

        public PageDescription(String content, List<WordEntry> contentRef) {
            this.uu = content;
            this.uv = contentRef;
        }

        public String getContent() {
            return this.uu;
        }

        public List<WordEntry> getContentRef() {
            return this.uv;
        }
    }

    @InternalApi
    public static class WordEntry {
        private WordElement uw;
        private int ed;
        private int ux;
        private StructureElement uy;

        public WordEntry(StructureElement container, WordElement word, int start, int end) {
            this.uy = container;
            this.uw = word;
            this.ed = start;
            this.ux = end;
        }

        public int getStart() {
            return this.ed;
        }

        public int getEnd() {
            return this.ux;
        }

        public StructureElement getContainer() {
            return this.uy;
        }

        public WordElement getWord() {
            return this.uw;
        }

        public String toString() {
            return "Word \"" + this.uw.getLabel() + "\" (" + this.ed + ":" + this.ux + ")";
        }
    }
}

