/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfc.print;

import com.inet.annotations.InternalApi;
import com.inet.pdfc.print.PrintPainter;
import com.inet.pdfc.print.PrintToX;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterAbortException;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.IOException;
import javax.print.PrintService;
import javax.print.attribute.PrintRequestAttributeSet;
import javax.print.attribute.standard.PageRanges;
import javax.print.attribute.standard.PrinterResolution;

@InternalApi
public class PrintToPrinter
extends PrintToX
implements Printable {
    private int qB = -1;
    private int ra;
    private int rb;
    private int rc;
    private PrintRequestAttributeSet pj;
    private PrinterJob rd;

    public PrintToPrinter(PrintPainter painter, PrinterJob job, PrintRequestAttributeSet format) {
        super(painter);
        this.rd = job;
        this.pj = format;
        if (job != null) {
            PrintService printService = job.getPrintService();
            if (this.pj.get(PrinterResolution.class) == null && printService.isAttributeCategorySupported(PrinterResolution.class) && printService.getDefaultAttributeValue(PrinterResolution.class) == null) {
                this.pj.add(new PrinterResolution(600, 600, 100));
            }
        }
    }

    @Override
    public void export() throws IOException {
        this.rd.setPrintable(this);
        this.rd.setJobName(this.getResultDocumentName());
        PageRanges pageRanges = (PageRanges)this.pj.get(PageRanges.class);
        if (pageRanges != null) {
            this.ra = 0;
            int n = -1;
            while ((n = pageRanges.next(n)) != -1) {
                ++this.ra;
            }
        } else {
            this.ra = -1;
        }
        this.rb = -1;
        this.rc = -1;
        try {
            this.rd.print(this.pj);
        }
        catch (PrinterAbortException printerAbortException) {
            return;
        }
        catch (PrinterException printerException) {
            throw new IOException(printerException);
        }
        if (!this.rd.isCancelled()) {
            this.fireFinish();
        }
    }

    @Override
    public int print(Graphics graphics, PageFormat pf, int pageIndex) throws PrinterException {
        if (this.qB == -1) {
            this.qB = this.getPainter().calculatePages((int)pf.getImageableWidth(), (int)pf.getImageableHeight(), ((Graphics2D)graphics).getFontRenderContext());
            if (this.ra == -1) {
                this.ra = this.qB;
            }
        }
        if (pageIndex >= this.qB) {
            return 1;
        }
        if (pageIndex != this.rc) {
            this.rc = pageIndex;
            ++this.rb;
            this.fireNextPage(this.rb, this.ra, this.rc, this.qB);
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.translate(pf.getImageableX(), pf.getImageableY());
        this.getPainter().print(graphics2D, pageIndex);
        return 0;
    }

    @Override
    public boolean cancel() {
        this.rd.cancel();
        return true;
    }
}

