/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfc.presenter.impl.datasource;

import com.inet.id.GUID;
import com.inet.pdfc.config.ArrayPdfSource;
import com.inet.pdfc.config.CompareType;
import com.inet.pdfc.config.DefaultProfile;
import com.inet.pdfc.config.IProfile;
import com.inet.pdfc.config.PDFCProperty;
import com.inet.pdfc.generator.filter.FilterFactory;
import com.inet.pdfc.generator.filter.ISortFilterFactory;
import com.inet.pdfc.generator.message.InfoData;
import com.inet.pdfc.generator.model.CompareDiffGroup;
import com.inet.pdfc.generator.model.DiffGroup;
import com.inet.pdfc.generator.model.DifferencePages;
import com.inet.pdfc.generator.model.Modification;
import com.inet.pdfc.generator.model.text.TextStyle;
import com.inet.pdfc.generator.model.text.WordElement;
import com.inet.pdfc.i18n.Msg;
import com.inet.pdfc.model.AWTFontInfo;
import com.inet.pdfc.model.ElementID;
import com.inet.pdfc.presenter.impl.datasource.IteratorBasedResultSet;
import com.inet.pdfc.presenter.impl.datasource.ReportDataProvider;
import com.inet.pdfc.results.ResultModel;
import com.inet.pdfc.results.ResultModelData;
import com.inet.plugin.ServerPluginManager;
import com.inet.report.DatabaseConfiguration;
import com.inet.report.Datasource;
import com.inet.report.ReportException;
import com.inet.report.TableSource;
import com.inet.report.database.BaseDataFactory;
import com.inet.report.database.ColumnInfo;
import com.inet.report.database.TableData;
import com.inet.report.database.TableSourceInfo;
import java.awt.Font;
import java.awt.font.FontRenderContext;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;

public class ComparisonResultDataFactory
extends BaseDataFactory {
    public static final String CATALOG_NAME = "Comaprison Results";
    public static final String TABLE_RESULT_IDS = "ids";
    public static final String TABLE_RESULT_INFOS = "infos";
    public static final String TABLE_RESULT_FILTERS = "filters";
    public static final String TABLE_RESULT_DIFFERENCES = "differences";
    public static final GUID DEMO_1 = GUID.generateNew();
    public static final GUID DEMO_2 = GUID.generateNew();
    private static FontRenderContext kn = new FontRenderContext(new AffineTransform(), true, true);
    @Nonnull
    private DatabaseConfiguration pP = new DatabaseConfiguration();

    public boolean getReportDataPerInstance() {
        return true;
    }

    @Nonnull
    public TableData getTableSourceData(@Nonnull TableSource ts) throws ReportException {
        String string;
        Map<String, ReportDataProvider.ComparisonDataProvider> map = ReportDataProvider.cJ();
        if (map == null) {
            map = this.cG();
            ReportDataProvider.a(map);
        }
        final Map<String, ReportDataProvider.ComparisonDataProvider> map2 = map;
        ArrayList arrayList = new ArrayList();
        switch (string = this.a(ts)) {
            case "ids": {
                if (map2 == null) break;
                map2.entrySet().forEach(entry -> arrayList.add(new Object[]{entry.getKey(), ((ReportDataProvider.ComparisonDataProvider)entry.getValue()).getTitle(), ((ReportDataProvider.ComparisonDataProvider)entry.getValue()).getDifferencesCount()}));
                break;
            }
            case "differences": {
                IteratorBasedResultSet iteratorBasedResultSet = new IteratorBasedResultSet(ts.getColumnNames(), ts.getColumnTypes(), new Iterator<Object[]>(){
                    private LinkedList<String> pQ;
                    private String lU;
                    private ResultModel pR;
                    private int pS;
                    private DiffGroup pT;
                    private int pU;
                    private Modification pV;
                    {
                        this.pQ = new LinkedList(map2.keySet());
                    }

                    @Override
                    public boolean hasNext() {
                        if (this.pV != null) {
                            return true;
                        }
                        if (this.pR == null && !this.pQ.isEmpty()) {
                            for (String string : this.pQ) {
                                ResultModel resultModel;
                                ReportDataProvider.ComparisonDataProvider comparisonDataProvider = (ReportDataProvider.ComparisonDataProvider)map2.get(string);
                                if (comparisonDataProvider == null || (resultModel = comparisonDataProvider.getResult()).getDifferences(false).size() <= 0) continue;
                                return true;
                            }
                        }
                        return false;
                    }

                    public Object[] cH() {
                        Modification modification = this.pV;
                        String string = this.lU;
                        this.cI();
                        if (modification == null) {
                            modification = this.pV;
                            string = this.lU;
                            this.cI();
                        }
                        if (modification != null) {
                            DifferencePages differencePages = modification.getDifferencePages(true);
                            if (differencePages == null) {
                                differencePages = modification.getDifferencePages(false);
                            }
                            return new Object[]{string, differencePages.getStartPage(), modification.getModificationType().getLocalizedName(), modification.getMessage(), modification.getModificationType().ordinal() + 1};
                        }
                        return null;
                    }

                    private void cI() {
                        block0: do {
                            if (this.pR == null) {
                                if (this.pQ.isEmpty()) {
                                    this.pV = null;
                                    return;
                                }
                                this.lU = this.pQ.pollFirst();
                                ReportDataProvider.ComparisonDataProvider comparisonDataProvider = (ReportDataProvider.ComparisonDataProvider)map2.get(this.lU);
                                if (comparisonDataProvider == null) continue;
                                this.pR = comparisonDataProvider.getResult();
                                this.pS = 0;
                                this.pT = null;
                                this.pV = null;
                                this.pU = 0;
                            }
                            if (this.pR.getDifferences(false).size() == 0) {
                                this.pR = null;
                                continue;
                            }
                            do {
                                if (this.pT == null) {
                                    this.pT = this.pR.getDifferences(false).get(this.pS++);
                                    this.pV = null;
                                    this.pU = 0;
                                }
                                if (this.pT.getDifferencesCount() == 0) {
                                    this.pT = null;
                                    this.pV = null;
                                    this.pU = 0;
                                    continue;
                                }
                                if (this.pU < this.pT.getDifferencesCount()) {
                                    this.pV = this.pT.getModifications().get(this.pU++);
                                    break block0;
                                }
                                this.pT = null;
                                this.pV = null;
                                this.pU = 0;
                            } while (this.pS < this.pR.getDifferences(false).size());
                            this.pR = null;
                        } while (!this.pQ.isEmpty());
                    }

                    @Override
                    public /* synthetic */ Object next() {
                        return this.cH();
                    }
                });
                return new TableData((ResultSet)iteratorBasedResultSet);
            }
            case "infos": {
                IteratorBasedResultSet iteratorBasedResultSet = new IteratorBasedResultSet(ts.getColumnNames(), ts.getColumnTypes(), new Iterator<Object[]>(){
                    private LinkedList<String> pQ;
                    private String lU;
                    {
                        this.pQ = new LinkedList(map2.keySet());
                    }

                    @Override
                    public boolean hasNext() {
                        return !this.pQ.isEmpty();
                    }

                    public Object[] cH() {
                        if (this.pQ.isEmpty()) {
                            return null;
                        }
                        this.lU = this.pQ.pollFirst();
                        ReportDataProvider.ComparisonDataProvider comparisonDataProvider = (ReportDataProvider.ComparisonDataProvider)map2.get(this.lU);
                        if (comparisonDataProvider == null) {
                            return null;
                        }
                        ResultModel resultModel = comparisonDataProvider.getResult();
                        InfoData infoData = resultModel.getComparisonParameters();
                        ArrayList<Object> arrayList = new ArrayList<Object>(30);
                        arrayList.add(this.lU);
                        arrayList.add(infoData.getFirstFile().getName());
                        arrayList.add(infoData.getFirstFile().getSize());
                        arrayList.add(new Timestamp(infoData.getFirstFile().getLastModified()));
                        arrayList.add(infoData.getFirstPageCount());
                        arrayList.add(infoData.getSecondFile().getName());
                        arrayList.add(infoData.getSecondFile().getSize());
                        arrayList.add(new Timestamp(infoData.getSecondFile().getLastModified()));
                        arrayList.add(infoData.getSecondPageCount());
                        arrayList.add(resultModel.getDifferencesCount(false));
                        arrayList.add(resultModel.getDifferencesCount(true));
                        arrayList.add(Boolean.TRUE);
                        ComparisonResultDataFactory.b(resultModel.getComparisonParameters().getProfile(), arrayList);
                        StringBuilder stringBuilder = new StringBuilder();
                        for (Modification.ModificationType modificationType : Modification.ModificationType.values()) {
                            if (resultModel.isVisible(modificationType)) continue;
                            if (!stringBuilder.isEmpty()) {
                                stringBuilder.append(", ");
                            }
                            stringBuilder.append(modificationType.getLocalizedName());
                        }
                        arrayList.add(stringBuilder.length() > 0 ? "\"" + stringBuilder.toString() + "\"" : "");
                        return arrayList.toArray();
                    }

                    @Override
                    public /* synthetic */ Object next() {
                        return this.cH();
                    }
                });
                return new TableData((ResultSet)iteratorBasedResultSet);
            }
            case "filters": {
                IteratorBasedResultSet iteratorBasedResultSet = new IteratorBasedResultSet(ts.getColumnNames(), ts.getColumnTypes(), new Iterator<Object[]>(){
                    private LinkedList<String> pQ;
                    private LinkedList<Object[]> pY = new LinkedList();
                    private String lU;
                    {
                        this.pQ = new LinkedList(map2.keySet());
                    }

                    @Override
                    public boolean hasNext() {
                        return !this.pQ.isEmpty() || !this.pY.isEmpty();
                    }

                    public Object[] cH() {
                        if (this.pQ.isEmpty() && this.pY.isEmpty()) {
                            return null;
                        }
                        while (this.pY.isEmpty() && !this.pQ.isEmpty()) {
                            this.lU = this.pQ.pollFirst();
                            ReportDataProvider.ComparisonDataProvider comparisonDataProvider = (ReportDataProvider.ComparisonDataProvider)map2.get(this.lU);
                            if (comparisonDataProvider == null) continue;
                            IProfile iProfile = comparisonDataProvider.getResult().getComparisonParameters().getProfile();
                            List<String> list = FilterFactory.getConfiguredFilterNames(iProfile);
                            ServerPluginManager serverPluginManager = ServerPluginManager.getInstance();
                            block11: for (String string : list) {
                                Object object;
                                switch (string) {
                                    case "TEXTTRANSFORM": 
                                    case "ANNOTATION": 
                                    case "HEADERFOOTER": {
                                        continue block11;
                                    }
                                }
                                try {
                                    object = (ISortFilterFactory)serverPluginManager.getSingleInstanceByName(ISortFilterFactory.class, string, false);
                                }
                                catch (IllegalStateException illegalStateException) {
                                    continue;
                                }
                                List<PDFCProperty<?>> list2 = object.getFilterProperties();
                                if (list2 == null || list2.isEmpty()) {
                                    this.pY.push(new Object[]{this.lU, object.getFilterName(), "", string, Boolean.TRUE});
                                    continue;
                                }
                                StringBuilder stringBuilder = new StringBuilder();
                                stringBuilder.append("<html><body><table border='0' style='width: 100%'>");
                                if ("HEADERFOOTER".equals(string)) {
                                    int n = iProfile.getInt(PDFCProperty.FIXED_HEADER_SIZE);
                                    int n2 = iProfile.getInt(PDFCProperty.FIXED_FOOTER_SIZE);
                                    if (n < 0 || n2 < 0) {
                                        stringBuilder.append("<tr><td style='width:53.3%'>" + object.getPropertyName(PDFCProperty.FIXED_HEADER_SIZE) + "</td><td>" + n + "</td></tr>");
                                        stringBuilder.append("<tr><td style='width:53.3%'>" + object.getPropertyName(PDFCProperty.FIXED_FOOTER_SIZE) + "</td><td>" + n2 + "</td></tr>");
                                    } else {
                                        stringBuilder.append("<tr><td style='width:53.3%'>" + Msg.getMsg("Settings.headerFooter.auto") + "</td><td>" + Msg.getMsg("reportdata.filter.active") + "</td></tr>");
                                    }
                                } else {
                                    for (PDFCProperty<?> pDFCProperty : list2) {
                                        Object object2 = iProfile.getObject(pDFCProperty);
                                        if (pDFCProperty == null) continue;
                                        stringBuilder.append("<tr><td style='width:53.3%'>");
                                        stringBuilder.append(object.getPropertyName(pDFCProperty));
                                        stringBuilder.append("</td><td>");
                                        if (object2 instanceof Boolean) {
                                            stringBuilder.append(Msg.getMsg("reportdata.filter." + ((Boolean)object2 != false ? "active" : "inactive")));
                                        } else {
                                            stringBuilder.append(object2);
                                        }
                                        stringBuilder.append("</td>");
                                    }
                                }
                                stringBuilder.append("</table></body></html>");
                                this.pY.push(new Object[]{this.lU, object.getFilterName(), stringBuilder.toString(), string, Boolean.TRUE});
                            }
                            if (!this.pY.isEmpty()) continue;
                            this.pY.push(new Object[]{this.lU, "No filters active", "", "", Boolean.TRUE});
                        }
                        if (this.pY.isEmpty()) {
                            return null;
                        }
                        return this.pY.pollFirst();
                    }

                    @Override
                    public /* synthetic */ Object next() {
                        return this.cH();
                    }
                });
                return new TableData((ResultSet)iteratorBasedResultSet);
            }
        }
        return new TableData(ts.getColumnNames(), arrayList);
    }

    private Map<String, ReportDataProvider.ComparisonDataProvider> cG() {
        ResultModelData resultModelData = new ResultModelData();
        DefaultProfile defaultProfile = new DefaultProfile();
        defaultProfile.putValue(PDFCProperty.FILTERS, "INVISIBLEELEMENTS,MULTICOLUMN");
        defaultProfile.putValue("PROFIL_NAME", "Designer Test Profile");
        InfoData infoData = new InfoData(new ArrayPdfSource("file1.pdf", new Date().getTime(), "file1.pdf".getBytes()), new ArrayPdfSource("file2.pdf", new Date().getTime(), "file2.pdf".getBytes()), 3, 4, defaultProfile);
        resultModelData.setInfo(infoData);
        WordElement wordElement = ComparisonResultDataFactory.createWord("Word", 0.0, 0.0, new Font("Serif", 0, 12));
        WordElement wordElement2 = ComparisonResultDataFactory.createWord("Text", 0.0, 0.0, new Font("Serif", 0, 12));
        resultModelData.addDiffs(List.of(new CompareDiffGroup(new Modification(DiffGroup.GroupType.Replaced, List.of(wordElement), List.of(wordElement2), null), DiffGroup.GroupType.Replaced)));
        WordElement wordElement3 = ComparisonResultDataFactory.createWord("Delete me", 0.0, 0.0, new Font("Serif", 0, 12));
        resultModelData.addDiffs(List.of(new CompareDiffGroup(new Modification(DiffGroup.GroupType.AddedOrRemoved, List.of(wordElement3), List.of(), null), DiffGroup.GroupType.AddedOrRemoved)));
        WordElement wordElement4 = ComparisonResultDataFactory.createWord("New text", 0.0, 0.0, new Font("Serif", 0, 12));
        resultModelData.addDiffs(List.of(new CompareDiffGroup(new Modification(DiffGroup.GroupType.AddedOrRemoved, List.of(), List.of(wordElement4), null), DiffGroup.GroupType.AddedOrRemoved)));
        ResultModel resultModel = new ResultModel(resultModelData);
        HashMap<String, ReportDataProvider.ComparisonDataProvider> hashMap = new HashMap<String, ReportDataProvider.ComparisonDataProvider>();
        hashMap.put(DEMO_1.toString(), new ReportDataProvider.ResultModelDataProvider("Sample 1", resultModel));
        hashMap.put(DEMO_2.toString(), new ReportDataProvider.ResultModelDataProvider("Sample 2", resultModel));
        DefaultProfile defaultProfile2 = new DefaultProfile();
        defaultProfile2.putValue(PDFCProperty.FILTERS, "INVISIBLEELEMENTS,MULTICOLUMN");
        defaultProfile2.putValue("PROFIL_NAME", "Designer Test Profile");
        resultModelData = new ResultModelData();
        resultModelData.setInfo(new InfoData(new ArrayPdfSource("", 0L, new byte[0]), new ArrayPdfSource("", 0L, new byte[0]), defaultProfile2));
        hashMap.put("BatchProfile", new ReportDataProvider.ResultModelDataProvider("BatchProfile", new ResultModel(resultModelData)));
        return hashMap;
    }

    @Nonnull
    public static WordElement createWord(String text, double x, double y, Font font) {
        AWTFontInfo aWTFontInfo = new AWTFontInfo(font);
        Rectangle2D rectangle2D = font.getStringBounds(text, kn);
        TextStyle textStyle = new TextStyle(0.0, font.getSize2D(), aWTFontInfo);
        double[] dArray = new double[text.length()];
        Arrays.fill(dArray, rectangle2D.getWidth() / (double)text.length());
        WordElement wordElement = new WordElement(text, new Rectangle2D.Double(x, y, rectangle2D.getWidth(), rectangle2D.getHeight()), dArray, 0, textStyle, ElementID.DUMMY);
        return wordElement;
    }

    @Nonnull
    public Map<String, TableSourceInfo> getTableSourceInfos(@Nonnull Datasource ds, String catalog) throws ReportException {
        HashMap<String, TableSourceInfo> hashMap = new HashMap<String, TableSourceInfo>();
        hashMap.put(TABLE_RESULT_IDS, new TableSourceInfo("", CATALOG_NAME, TABLE_RESULT_IDS, 0));
        hashMap.put(TABLE_RESULT_INFOS, new TableSourceInfo("", CATALOG_NAME, TABLE_RESULT_INFOS, 0));
        hashMap.put(TABLE_RESULT_FILTERS, new TableSourceInfo("", CATALOG_NAME, TABLE_RESULT_FILTERS, 0));
        hashMap.put(TABLE_RESULT_DIFFERENCES, new TableSourceInfo("", CATALOG_NAME, TABLE_RESULT_DIFFERENCES, 0));
        return hashMap;
    }

    @Nonnull
    public List<ColumnInfo> getColumns(@Nonnull TableSource ts) throws ReportException {
        String string;
        ArrayList<ColumnInfo> arrayList = new ArrayList<ColumnInfo>();
        switch (string = this.a(ts)) {
            case "ids": {
                arrayList.add(new ColumnInfo("ResultID", 11));
                arrayList.add(new ColumnInfo("Title", 11));
                arrayList.add(new ColumnInfo("TotalDiffCountUnfiltered", 6));
                break;
            }
            case "infos": {
                arrayList.add(new ColumnInfo("ResultID", 11));
                arrayList.add(new ColumnInfo("Name1", 11));
                arrayList.add(new ColumnInfo("Size1", 6));
                arrayList.add(new ColumnInfo("Modified1", 15));
                arrayList.add(new ColumnInfo("Pages1", 6));
                arrayList.add(new ColumnInfo("Name2", 11));
                arrayList.add(new ColumnInfo("Size2", 6));
                arrayList.add(new ColumnInfo("Modified2", 15));
                arrayList.add(new ColumnInfo("Pages2", 6));
                arrayList.add(new ColumnInfo("TotalDiffCountUnfiltered", 6));
                arrayList.add(new ColumnInfo("TotalDiffCountFiltered", 6));
                arrayList.add(new ColumnInfo("OnlyOverview", 8));
                arrayList.add(new ColumnInfo("CmpName", 11));
                arrayList.add(new ColumnInfo("CmpConti", 8));
                arrayList.add(new ColumnInfo("CmpHeadFoot", 8));
                arrayList.add(new ColumnInfo("CmpHeadFootFixedHeader", 11));
                arrayList.add(new ColumnInfo("CmpHeadFootFixedFooter", 11));
                arrayList.add(new ColumnInfo("CmpHeadFootAutoDetect", 8));
                arrayList.add(new ColumnInfo("CmpMultiColumn", 8));
                arrayList.add(new ColumnInfo("CmpInvisibleElements", 8));
                arrayList.add(new ColumnInfo("CmpText", 8));
                arrayList.add(new ColumnInfo("CmpTextAlignRatio", 11));
                arrayList.add(new ColumnInfo("CmpTextLocationTolerance", 11));
                arrayList.add(new ColumnInfo("CmpLine", 8));
                arrayList.add(new ColumnInfo("CmpLineSizeTolerance", 11));
                arrayList.add(new ColumnInfo("CmpLineThicknessTolerance", 11));
                arrayList.add(new ColumnInfo("CmpLinePositionTolerance", 11));
                arrayList.add(new ColumnInfo("CmpImage", 8));
                arrayList.add(new ColumnInfo("CmpImagePixelTolerance", 11));
                arrayList.add(new ColumnInfo("CmpImageSizeTolerance", 11));
                arrayList.add(new ColumnInfo("CmpImageDistanceTolerance", 11));
                arrayList.add(new ColumnInfo("Filter", 11));
                break;
            }
            case "differences": {
                arrayList.add(new ColumnInfo("ResultID", 11));
                arrayList.add(new ColumnInfo("PageNumber", 6));
                arrayList.add(new ColumnInfo("Type", 11));
                arrayList.add(new ColumnInfo("Message", 11));
                arrayList.add(new ColumnInfo("TypeID", 6));
                break;
            }
            case "filters": {
                arrayList.add(new ColumnInfo("ResultID", 11));
                arrayList.add(new ColumnInfo("Name", 11));
                arrayList.add(new ColumnInfo("Settings", 11));
                arrayList.add(new ColumnInfo("FilterKey", 11));
                arrayList.add(new ColumnInfo("Active", 8));
            }
        }
        return arrayList;
    }

    static void b(IProfile iProfile, List<Object> list) {
        String string = iProfile.getString("PROFIL_NAME");
        list.add(string);
        boolean bl = "CONTINUOUS".equalsIgnoreCase(iProfile.getString(PDFCProperty.CONTINUOUS_COMPARE));
        list.add(bl);
        list.add(String.valueOf(ComparisonResultDataFactory.a(PDFCProperty.FILTERS, "HEADERFOOTER", iProfile)));
        int n = iProfile.getInt(PDFCProperty.FIXED_HEADER_SIZE);
        list.add(String.valueOf(n));
        int n2 = iProfile.getInt(PDFCProperty.FIXED_FOOTER_SIZE);
        list.add(String.valueOf(n2));
        boolean bl2 = (n2 < 0 || n < 0) && bl;
        list.add(bl2);
        list.add(ComparisonResultDataFactory.a(PDFCProperty.FILTERS, "MULTICOLUMN", iProfile));
        list.add(ComparisonResultDataFactory.a(PDFCProperty.FILTERS, "INVISIBLEELEMENTS", iProfile));
        list.add(ComparisonResultDataFactory.a(PDFCProperty.COMPARE_TYPES, (Object)CompareType.TEXT, iProfile));
        list.add(String.valueOf(iProfile.getDouble(PDFCProperty.TEXT_ALIGN_RATIO)));
        if (bl) {
            list.add("-1");
        } else {
            list.add(String.valueOf(iProfile.getInt(PDFCProperty.TOLERANCE_TEXT_LOCATION)));
        }
        list.add(ComparisonResultDataFactory.a(PDFCProperty.COMPARE_TYPES, (Object)CompareType.LINE, iProfile));
        list.add(String.valueOf(iProfile.getDouble(PDFCProperty.TOLERANCE_LINE_SIZE)));
        list.add(String.valueOf(iProfile.getInt(PDFCProperty.TOLERANCE_LINE_THICKNESS)));
        if (bl) {
            list.add("-1");
        } else {
            list.add(String.valueOf(iProfile.getInt(PDFCProperty.TOLERANCE_LINE_POSITION)));
        }
        list.add(ComparisonResultDataFactory.a(PDFCProperty.COMPARE_TYPES, (Object)CompareType.IMAGE, iProfile));
        list.add(String.valueOf(iProfile.getDouble(PDFCProperty.TOLERANCE_IMAGE_PIXEL_VALUE)));
        list.add(String.valueOf(iProfile.getDouble(PDFCProperty.TOLERANCE_IMAGE_SIZE)));
        if (bl) {
            list.add("-1");
        } else {
            list.add(String.valueOf(iProfile.getInt(PDFCProperty.TOLERANCE_IMAGE_DISTANCE)));
        }
    }

    private static boolean a(PDFCProperty<?> pDFCProperty, Object object, IProfile iProfile) {
        if (pDFCProperty == null || object == null) {
            return false;
        }
        String string = iProfile.getString(pDFCProperty);
        if (string == null || string.length() == 0) {
            return false;
        }
        String string2 = object.toString();
        for (String string3 : string.split("\\s*[,;]\\s*")) {
            if (!string3.trim().equals(string2)) continue;
            return true;
        }
        return false;
    }

    private String a(TableSource tableSource) {
        String string = tableSource.getDatabaseIdentifier();
        if (string.startsWith("Comaprison Results.")) {
            string = string.substring(CATALOG_NAME.length() + 1);
        }
        return string;
    }

    public void setConfiguration(@Nonnull DatabaseConfiguration configuration) {
        this.pP = configuration;
    }

    public DatabaseConfiguration getConfiguration() {
        return this.pP;
    }
}

