/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfc.presenter;

import com.inet.annotations.InternalApi;
import com.inet.annotations.JsonData;
import com.inet.annotations.PublicApi;
import com.inet.id.GUID;
import com.inet.lib.json.Json;
import com.inet.pdfc.PDFCCore;
import com.inet.pdfc.generator.model.DiffGroup;
import com.inet.pdfc.generator.model.Modification;
import com.inet.pdfc.model.ElementType;
import com.inet.pdfc.model.PagedElement;
import com.inet.pdfc.presenter.BasePresenter;
import com.inet.pdfc.results.ResultModel;
import com.inet.pdfc.results.ResultModelUpdater;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;

@PublicApi
public class JsonPresenter
extends BasePresenter {
    private JsonResult pr;

    public String getExtensionName() {
        return "Presenter_Json";
    }

    @Override
    public void onComparisonDone() throws Exception {
        ResultModel resultModel = this.getModel();
        if (resultModel == null) {
            return;
        }
        String string = resultModel.getComparisonParameters().getFirstFile().getName();
        String string2 = resultModel.getComparisonParameters().getSecondFile().getName();
        GUID gUID = new ResultModelUpdater(resultModel).getModelData().getComparisonID();
        if (resultModel.getDifferencesCount(false) > 0) {
            ArrayList<JsonDifference> arrayList = new ArrayList<JsonDifference>();
            for (DiffGroup diffGroup : resultModel.getDifferences(false)) {
                if (diffGroup.getType() == DiffGroup.GroupType.Sync || diffGroup.getModifications().size() == 0) continue;
                for (Modification modification : diffGroup.getModifications()) {
                    JsonDifference jsonDifference = new JsonDifference(this.c(modification), modification.getModificationType(), this.d(modification), modification.getMessage());
                    arrayList.add(jsonDifference);
                }
            }
            this.pr = gUID != null ? new JsonResultWithComparisonID(string, string2, arrayList, gUID) : new JsonResult(string, string2, arrayList);
        } else {
            this.pr = gUID != null ? new JsonResultWithComparisonID(string, string2, new ArrayList<JsonDifference>(), gUID) : new JsonResult(string, string2, new ArrayList<JsonDifference>());
        }
    }

    @Nonnull
    public String getJson() {
        if (this.pr == null && this.getModel() != null) {
            try {
                this.onComparisonDone();
            }
            catch (Exception exception) {
                PDFCCore.LOGGER_CORE.error((Throwable)exception);
            }
        }
        return this.pr != null ? new Json().toJson((Object)this.pr) : "";
    }

    @Override
    public BasePresenter spawn(boolean spawnWithParent) {
        return this;
    }

    private MediaTyp d(Modification modification) {
        MediaTyp mediaTyp = this.w(modification.getAffectedElements(true));
        MediaTyp mediaTyp2 = this.w(modification.getAffectedElements(false));
        if (mediaTyp == null) {
            return mediaTyp2;
        }
        if (mediaTyp2 == null) {
            return mediaTyp;
        }
        if (mediaTyp == MediaTyp.NOTDEFINED || mediaTyp2 == MediaTyp.NOTDEFINED) {
            return MediaTyp.NOTDEFINED;
        }
        return mediaTyp == mediaTyp2 ? mediaTyp : MediaTyp.MIXED;
    }

    private MediaTyp w(List<PagedElement> list) {
        if (list == null || list.isEmpty()) {
            return null;
        }
        MediaTyp mediaTyp = null;
        for (PagedElement pagedElement : list) {
            MediaTyp mediaTyp2 = this.b(pagedElement.getType());
            if (mediaTyp2 == MediaTyp.NOTDEFINED) {
                return MediaTyp.NOTDEFINED;
            }
            if (mediaTyp == null) {
                mediaTyp = mediaTyp2;
                continue;
            }
            if (mediaTyp == mediaTyp2) continue;
            return MediaTyp.MIXED;
        }
        return mediaTyp;
    }

    private MediaTyp b(ElementType elementType) {
        switch (elementType) {
            case Text: {
                return MediaTyp.TEXT;
            }
            case TextWord: {
                return MediaTyp.TEXT;
            }
            case Shape: {
                return MediaTyp.SHAPE;
            }
            case Image: {
                return MediaTyp.IMAGE;
            }
            case Curve: {
                return MediaTyp.SHAPE;
            }
            case Line: {
                return MediaTyp.SHAPE;
            }
            case LineHorizontal: {
                return MediaTyp.SHAPE;
            }
            case LineVertical: {
                return MediaTyp.SHAPE;
            }
            case Page: {
                return MediaTyp.PAGE;
            }
        }
        return MediaTyp.NOTDEFINED;
    }

    @JsonData
    @InternalApi
    public static class JsonDifference {
        private final int pageNumber;
        private final Modification.ModificationType modificationType;
        private final MediaTyp mediaType;
        private final String message;

        public JsonDifference(int pageNumber, Modification.ModificationType modificationType, MediaTyp mediaType, String message) {
            this.pageNumber = pageNumber;
            this.modificationType = modificationType;
            this.mediaType = mediaType;
            this.message = message;
        }
    }

    @InternalApi
    static final class MediaTyp
    extends Enum<MediaTyp> {
        public static final /* enum */ MediaTyp TEXT = new MediaTyp();
        public static final /* enum */ MediaTyp SHAPE = new MediaTyp();
        public static final /* enum */ MediaTyp IMAGE = new MediaTyp();
        public static final /* enum */ MediaTyp MIXED = new MediaTyp();
        public static final /* enum */ MediaTyp PAGE = new MediaTyp();
        public static final /* enum */ MediaTyp NOTDEFINED = new MediaTyp();
        private static final /* synthetic */ MediaTyp[] ps;

        public static MediaTyp[] values() {
            return (MediaTyp[])ps.clone();
        }

        public static MediaTyp valueOf(String name) {
            return Enum.valueOf(MediaTyp.class, name);
        }

        private static /* synthetic */ MediaTyp[] cA() {
            return new MediaTyp[]{TEXT, SHAPE, IMAGE, MIXED, PAGE, NOTDEFINED};
        }

        static {
            ps = MediaTyp.cA();
        }
    }

    @JsonData
    @InternalApi
    public static class JsonResultWithComparisonID
    extends JsonResult {
        private final String comparisonID;

        public JsonResultWithComparisonID(String document, String compareDocument, List<JsonDifference> differences, GUID comparisonID) {
            super(document, compareDocument, differences);
            this.comparisonID = comparisonID.toString();
        }
    }

    @JsonData
    @InternalApi
    public static class JsonResult {
        private final String document;
        private final String compareDocument;
        private final List<JsonDifference> differences;

        public JsonResult(String document, String compareDocument, List<JsonDifference> differences) {
            this.document = document;
            this.compareDocument = compareDocument;
            this.differences = differences;
        }
    }
}

