/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfc.images;

import com.inet.annotations.InternalApi;
import com.inet.pdfc.PDFCCore;
import com.inet.plugin.ServerPluginManager;
import com.inet.plugin.image.ProductLogoProvider;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.Path2D;
import java.awt.image.BufferedImage;
import java.io.IOException;
import javax.imageio.ImageIO;

@InternalApi
public class PDFCLogoProvider
implements ProductLogoProvider {
    public static final Color COLOR_LOGO_1 = new Color(Integer.parseUnsignedInt("00a623", 16));
    public static final Color COLOR_LOGO_2 = new Color(Integer.parseUnsignedInt("99dba7", 16));
    private static BufferedImage je;
    private static BufferedImage jf;
    private static BufferedImage jg;
    private static BufferedImage jh;

    public BufferedImage provideLogo(String title, int targetHeight, boolean icononly, boolean inverseTextColor) {
        BufferedImage bufferedImage;
        if (!"i-net PDFC".equals(title) && !"pdfc.gui".equals(ServerPluginManager.getInstance().getCorePluginId())) {
            return null;
        }
        int n = targetHeight;
        boolean bl = (double)targetHeight > 48.0;
        double d2 = 1.0;
        double d3 = 0.0875;
        double d4 = 0.0875;
        BufferedImage bufferedImage2 = inverseTextColor ? jf : je;
        BufferedImage bufferedImage3 = bufferedImage = inverseTextColor ? jh : jg;
        if (!icononly) {
            int n2 = bufferedImage.getHeight();
            if (!bl) {
                n2 = 0;
                d3 *= 2.0;
                d4 *= 2.0;
            }
            d2 = (double)targetHeight * (1.0 - d3 - d4) / (double)(bufferedImage2.getHeight() + n2);
            n = (int)((double)n + ((double)n * 0.33 + (double)bufferedImage2.getWidth() * d2));
        }
        BufferedImage bufferedImage4 = new BufferedImage(n, targetHeight, 6);
        Graphics2D graphics2D = (Graphics2D)bufferedImage4.getGraphics();
        this.a(graphics2D, targetHeight, !inverseTextColor);
        if (!icononly) {
            int n3 = (int)((double)targetHeight * 1.33);
            int n4 = (int)(d3 * (double)targetHeight);
            int n5 = (int)Math.round((double)bufferedImage2.getWidth() * d2);
            int n6 = (int)Math.round((double)bufferedImage2.getHeight() * d2);
            graphics2D.drawImage(bufferedImage2.getScaledInstance(n5, n6, 4), n3, n4, null);
            if (bl) {
                n4 = (int)((d4 + d3) * (double)targetHeight + (double)bufferedImage2.getHeight() * d2);
                n5 = (int)Math.round((double)bufferedImage.getWidth() * d2);
                n6 = (int)Math.round((double)bufferedImage.getHeight() * d2);
                graphics2D.drawImage(bufferedImage.getScaledInstance(n5, n6, 4), n3, n4, null);
            }
        }
        return bufferedImage4;
    }

    private void a(Graphics2D graphics2D, int n, boolean bl) {
        Color color;
        Color color2;
        double d2 = (double)n / 21.0;
        float f2 = (float)n / 2.0f;
        double d3 = Math.floor(d2 * 10.0);
        double d4 = Math.ceil(d2 * 11.0);
        if (d4 - d3 > (double)((float)n / 10.0f)) {
            d4 -= 1.0;
            d2 = (double)(--n) / 21.0;
            f2 = (float)n / 2.0f;
        }
        Path2D.Double double_ = new Path2D.Double();
        ((Path2D)double_).moveTo(d3, 0.0);
        ((Path2D)double_).lineTo(d3, d2 * 5.0);
        ((Path2D)double_).lineTo(d2 * 5.0, d3);
        ((Path2D)double_).lineTo(0.0, d3);
        ((Path2D)double_).lineTo(d3, 0.0);
        Path2D.Double double_2 = new Path2D.Double();
        ((Path2D)double_2).moveTo(d4, 0.0);
        ((Path2D)double_2).lineTo(n, d3);
        ((Path2D)double_2).lineTo(d2 * 16.0, d3);
        ((Path2D)double_2).lineTo(d4, d2 * 5.0);
        ((Path2D)double_2).lineTo(d4, 0.0);
        Path2D.Double double_3 = new Path2D.Double();
        ((Path2D)double_3).moveTo(n, d4);
        ((Path2D)double_3).lineTo(d4, n);
        ((Path2D)double_3).lineTo(d4, d2 * 16.0);
        ((Path2D)double_3).lineTo(d2 * 16.0, d4);
        ((Path2D)double_3).lineTo(n, d4);
        Path2D.Double double_4 = new Path2D.Double();
        ((Path2D)double_4).moveTo(0.0, d4);
        ((Path2D)double_4).lineTo(d2 * 5.0, d4);
        ((Path2D)double_4).lineTo(d3, d2 * 16.0);
        ((Path2D)double_4).lineTo(d3, n);
        ((Path2D)double_4).lineTo(0.0, d4);
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setColor(COLOR_LOGO_1);
        graphics2D.fill(double_);
        graphics2D.fill(double_3);
        graphics2D.setColor(COLOR_LOGO_2);
        graphics2D.fill(double_2);
        graphics2D.fill(double_4);
        if (bl) {
            color2 = new Color(255, 255, 255, 38);
            color = new Color(255, 255, 255, 0);
        } else {
            color2 = new Color(0, 0, 0, 0);
            color = new Color(0, 0, 0, 18);
        }
        float f3 = f2 / 2.0f;
        GradientPaint gradientPaint = new GradientPaint(f3, f3, color2, f2 * 3.0f / 4.0f, f2 * 3.0f / 4.0f, color);
        graphics2D.setClip(double_);
        graphics2D.setPaint(gradientPaint);
        graphics2D.fillRect(0, 0, n, n);
        gradientPaint = new GradientPaint((float)n - f3, f3, color2, (float)n - f2 * 3.0f / 4.0f, f2 * 3.0f / 4.0f, color);
        graphics2D.setClip(double_2);
        graphics2D.setPaint(gradientPaint);
        graphics2D.fillRect(0, 0, n, n);
        gradientPaint = new GradientPaint((float)n - f3, (float)n - f3, color2, (float)n - f2 * 3.0f / 4.0f, (float)n - f2 * 3.0f / 4.0f, color);
        graphics2D.setClip(double_3);
        graphics2D.setPaint(gradientPaint);
        graphics2D.fillRect(0, 0, n, n);
        gradientPaint = new GradientPaint(f3, (float)n - f3, color2, f2 * 3.0f / 4.0f, (float)n - f2 * 3.0f / 4.0f, color);
        graphics2D.setClip(double_4);
        graphics2D.setPaint(gradientPaint);
        graphics2D.fillRect(0, 0, n, n);
        graphics2D.setClip(null);
    }

    static {
        try {
            je = ImageIO.read(PDFCLogoProvider.class.getResource("title.png"));
            jg = ImageIO.read(PDFCLogoProvider.class.getResource("slogan.png"));
            jf = ImageIO.read(PDFCLogoProvider.class.getResource("title_inverted.png"));
            jh = ImageIO.read(PDFCLogoProvider.class.getResource("slogan_inverted.png"));
        }
        catch (IOException iOException) {
            PDFCCore.LOGGER_CORE.error((Throwable)iOException);
        }
    }
}

