/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfc.generator.rendercache;

import com.inet.annotations.InternalApi;
import com.inet.cache.HardDiskStoreMap;
import com.inet.cache.InetSerializable;
import com.inet.cache.PersistenceKey;
import com.inet.cache.PersistenceStoreMap;
import com.inet.cache.font.SerializableDerivedFont;
import com.inet.cache.font.SerializableDerivedFontData;
import com.inet.cache.font.SerializableGeneralFont;
import com.inet.cache.font.SerializableSystemFont;
import com.inet.cache.image.SerializableImage;
import com.inet.cache.internal.AbstractMap;
import com.inet.error.ErrorCode;
import com.inet.font.truetype.SessionFontFactoryCache;
import com.inet.graphics.buffered.GraphicsFilter;
import com.inet.pdfc.PDFCCore;
import com.inet.pdfc.error.PdfcErrorCode;
import com.inet.pdfc.error.PdfcException;
import com.inet.pdfc.generator.rendercache.HardDiskPageImageCache;
import com.inet.pdfc.generator.rendercache.RenderCacheBufferedGraphics;
import com.inet.pdfc.generator.rendercache.RenderCacheBufferedGraphicsWithSize;
import com.inet.pdfc.generator.rendercache.SerializableImageCache;
import com.inet.pdfc.generator.rendercache.TextSelectionData;
import com.inet.pdfc.model.Page;
import com.inet.pdfc.textselection.TextInfoImpl;
import com.inet.pdfc.thread.PdfcSession;
import com.inet.pdfc.util.FilteredGraphics;
import com.inet.thread.BaseRunnableSession;
import com.inet.thread.RunnableSession;
import com.inet.thread.SessionLocator;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontFormatException;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@InternalApi
public class PdfcRenderCache
implements HardDiskPageImageCache,
SerializableImageCache {
    public static final Font REPLACEMENT_FOR_MISSING_FONTS = new Font("Sansserif", 0, 12);
    private AtomicInteger if = new AtomicInteger(0);
    private final AbstractMap<PersistenceKey, InetSerializable> ig;
    private Map<Font, PersistenceKey> ih = new HashMap<Font, PersistenceKey>();
    private boolean ii = false;
    private static final Pattern KEY_PATTERN = Pattern.compile("\\w+?(\\d+)");

    public PdfcRenderCache() {
        this((AbstractMap<PersistenceKey, InetSerializable>)new HardDiskStoreMap());
    }

    public PdfcRenderCache(AbstractMap<PersistenceKey, InetSerializable> storeMap) {
        this.ig = storeMap;
        if (!storeMap.isEmpty()) {
            this.ii = true;
        }
        this.bi();
    }

    public boolean isInMemory(Object key) {
        return this.ig.getIfInMemeory(key) != null;
    }

    private void bi() {
        Function<PersistenceKey, Integer> function = persistenceKey -> {
            Matcher matcher = KEY_PATTERN.matcher(persistenceKey.keyValue());
            if (matcher.matches()) {
                String string = matcher.group(1);
                try {
                    return Integer.valueOf(string);
                }
                catch (NumberFormatException numberFormatException) {
                    return null;
                }
            }
            return null;
        };
        this.ig.keySet().stream().map(function).filter(n -> n != null).mapToInt(Integer::valueOf).max().ifPresent(n -> this.if.set(n));
    }

    public void initFontMap() {
        for (PersistenceKey persistenceKey : this.ig.keySet()) {
            try {
                if (!this.s(persistenceKey.keyValue())) continue;
                InetSerializable inetSerializable = (InetSerializable)this.ig.get((Object)persistenceKey);
                if (inetSerializable instanceof SerializableGeneralFont) {
                    try {
                        SerializableGeneralFont serializableGeneralFont = (SerializableGeneralFont)inetSerializable;
                        SessionFontFactoryCache.addTempFont((Font)serializableGeneralFont, (byte[])serializableGeneralFont.getFontData());
                    }
                    catch (IOException iOException) {
                        PDFCCore.LOGGER_CORE.error((Throwable)((Object)PdfcException.create((ErrorCode)PdfcErrorCode.errorWhileReadingCache, "Unable to cache font '" + ((Font)inetSerializable).getName() + "' for export: " + iOException.getMessage())));
                    }
                }
                if (inetSerializable instanceof Font) {
                    this.ih.put((Font)inetSerializable, persistenceKey);
                    continue;
                }
                if (!(inetSerializable instanceof SerializableDerivedFontData)) continue;
                this.a(persistenceKey, (SerializableDerivedFontData)inetSerializable);
            }
            catch (RuntimeException runtimeException) {
                PDFCCore.LOGGER_CORE.warn((Object)("Found corrupt cache entry " + persistenceKey.keyValue()));
                PDFCCore.LOGGER_CORE.debug((Object)runtimeException);
            }
        }
    }

    private boolean s(String string) {
        return string != null && (string.startsWith(CONTENT_TYPE.font.name()) || string.matches("\\d+"));
    }

    @Nonnull
    public PersistenceKey nextKey(CONTENT_TYPE type) {
        String string = type.name() + String.valueOf(this.if.incrementAndGet());
        return PersistenceKey.create((String)string);
    }

    @Override
    public boolean hasPage(boolean first, int pageIndex) {
        PersistenceKey persistenceKey = this.getKeyForPage(first, pageIndex);
        return this.ig.containsKey((Object)persistenceKey);
    }

    @Override
    public BufferedImage getPageImage(boolean first, int pageIndex, double scaleX, double scaleY) {
        return this.getPageImage(first, pageIndex, scaleX, scaleY, (GraphicsFilter)null);
    }

    public BufferedImage getPageImage(boolean first, int pageIndex, double scaleX, double scaleY, FilteredGraphics.FILTERTYPES filterType) {
        GraphicsFilter graphicsFilter = FilteredGraphics.getGraphicsFilterForName(filterType);
        return this.getPageImage(first, pageIndex, scaleX, scaleY, graphicsFilter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BufferedImage getPageImage(boolean first, int pageIndex, double scaleX, double scaleY, GraphicsFilter graphicFilter) {
        PersistenceKey persistenceKey = this.getKeyForPage(first, pageIndex);
        InetSerializable<?, ?> inetSerializable = this.c(persistenceKey);
        if (inetSerializable instanceof RenderCacheBufferedGraphicsWithSize) {
            RenderCacheBufferedGraphicsWithSize renderCacheBufferedGraphicsWithSize = (RenderCacheBufferedGraphicsWithSize)inetSerializable;
            BufferedImage bufferedImage = new BufferedImage((int)Math.ceil(scaleX * (double)renderCacheBufferedGraphicsWithSize.getWidth()), (int)Math.ceil(scaleY * (double)renderCacheBufferedGraphicsWithSize.getHeight()), 1);
            Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
            graphics2D.clipRect(0, 0, bufferedImage.getWidth(), bufferedImage.getHeight());
            graphics2D.setColor(Color.WHITE);
            graphics2D.fillRect(0, 0, bufferedImage.getWidth(), bufferedImage.getHeight());
            graphics2D.scale(scaleX, scaleY);
            graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
            graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            try {
                RenderCacheBufferedGraphics renderCacheBufferedGraphics = renderCacheBufferedGraphicsWithSize.getGraphics();
                renderCacheBufferedGraphics.setStoreMap(this);
                graphics2D = (Graphics2D)graphics2D.create();
                if (graphicFilter == null) {
                    renderCacheBufferedGraphics.drawTo(graphics2D);
                } else {
                    renderCacheBufferedGraphics.drawTo(graphics2D, graphicFilter);
                }
            }
            catch (RuntimeException runtimeException) {
                PDFCCore.LOGGER_CORE.error((Throwable)((Object)PdfcException.create((ErrorCode)PdfcErrorCode.errorWhileFetchingPage, runtimeException, new Object[0])));
                BufferedImage bufferedImage2 = null;
                return bufferedImage2;
            }
            finally {
                graphics2D.dispose();
            }
            return bufferedImage;
        }
        return null;
    }

    private void a(RenderCacheBufferedGraphics renderCacheBufferedGraphics, Graphics2D graphics2D) {
        renderCacheBufferedGraphics.setStoreMap(this);
        renderCacheBufferedGraphics.drawTo(graphics2D);
    }

    @Override
    public void renderPage(boolean first, int pageIndex, double scale, Graphics2D g2) {
        g2.scale(scale, scale);
        PersistenceKey persistenceKey = this.getKeyForPage(first, pageIndex);
        this.renderPage(persistenceKey, g2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private InetSerializable<?, ?> c(Object object) {
        PdfcSession pdfcSession = null;
        RunnableSession runnableSession = null;
        if (!SessionLocator.exists()) {
            runnableSession = new BaseRunnableSession();
            pdfcSession = PdfcSession.createSession(this);
            pdfcSession.setThreadLocal();
        } else {
            runnableSession = SessionLocator.getCurrent();
            if (!(runnableSession instanceof PdfcSession)) {
                pdfcSession = PdfcSession.createSession(this);
                pdfcSession.setThreadLocal();
            }
        }
        try {
            InetSerializable inetSerializable = (InetSerializable)this.ig.get(object);
            return inetSerializable;
        }
        finally {
            if (pdfcSession != null) {
                pdfcSession.resetThreadLocal();
                runnableSession.setThreadLocal();
            }
        }
    }

    @Override
    public void renderPage(Object key, Graphics2D g2) {
        InetSerializable<?, ?> inetSerializable = this.c(key);
        if (inetSerializable instanceof RenderCacheBufferedGraphicsWithSize) {
            RenderCacheBufferedGraphicsWithSize renderCacheBufferedGraphicsWithSize = (RenderCacheBufferedGraphicsWithSize)inetSerializable;
            try {
                this.a(renderCacheBufferedGraphicsWithSize.getGraphics(), g2);
            }
            catch (RuntimeException runtimeException) {
                PDFCCore.LOGGER_CORE.error((Throwable)((Object)PdfcException.create((ErrorCode)PdfcErrorCode.errorWhileFetchingPage, runtimeException, new Object[0])));
            }
        } else {
            PDFCCore.LOGGER_CORE.warn((Object)PdfcException.create((ErrorCode)PdfcErrorCode.errorWhileReadingCache, "Page '" + String.valueOf(key) + "' will not be rendered since it is " + String.valueOf(inetSerializable)));
        }
    }

    @Override
    public void clear() {
        this.ig.clear();
        this.if.set(0);
        this.ih.clear();
        this.ii = false;
    }

    @Override
    public RenderCacheBufferedGraphics getPageGraphics(int pageIndex, boolean first) throws IOException {
        PersistenceKey persistenceKey = this.getKeyForPage(first, pageIndex);
        InetSerializable inetSerializable = (InetSerializable)this.ig.get((Object)persistenceKey);
        if (inetSerializable instanceof RenderCacheBufferedGraphicsWithSize) {
            RenderCacheBufferedGraphicsWithSize renderCacheBufferedGraphicsWithSize = (RenderCacheBufferedGraphicsWithSize)inetSerializable;
            return renderCacheBufferedGraphicsWithSize.getGraphics();
        }
        return null;
    }

    @Override
    public InetSerializable<?, ?> getCacheContent(PersistenceKey key) {
        return (InetSerializable)this.ig.get((Object)key);
    }

    public void putPage(Page page, boolean first) {
        PersistenceKey persistenceKey = this.getKeyForPage(first, page.getPageIndex());
        this.a(page, persistenceKey);
    }

    @Nullable
    public List<TextInfoImpl> getTextSelectionData(boolean first, int pageIndex) {
        TextSelectionData textSelectionData = (TextSelectionData)this.ig.get((Object)this.b(first, pageIndex));
        return textSelectionData instanceof TextSelectionData ? textSelectionData.getData() : null;
    }

    public void putTextSelectionData(@Nullable List<TextInfoImpl> data, boolean first, int pageIndex) {
        PersistenceKey persistenceKey = this.b(first, pageIndex);
        this.ig.put((Object)persistenceKey, (Object)new TextSelectionData(data != null ? data : new ArrayList()));
    }

    @Nonnull
    private PersistenceKey b(boolean bl, int n) {
        return PersistenceKey.create((String)("text-" + bl + n));
    }

    private void a(Page page, PersistenceKey persistenceKey) {
        Rectangle2D rectangle2D = page.getBounds();
        Rectangle rectangle = new Rectangle((int)Math.ceil(rectangle2D.getWidth()), (int)Math.ceil(rectangle2D.getHeight()));
        RenderCacheBufferedGraphics renderCacheBufferedGraphics = new RenderCacheBufferedGraphics(this);
        page.renderPage((Graphics2D)((Object)renderCacheBufferedGraphics), rectangle);
        page.releaseResources();
        RenderCacheBufferedGraphicsWithSize renderCacheBufferedGraphicsWithSize = new RenderCacheBufferedGraphicsWithSize(renderCacheBufferedGraphics, rectangle.width, rectangle.height);
        this.ig.put((Object)persistenceKey, (Object)renderCacheBufferedGraphicsWithSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object putImage(SerializableImage img) {
        if (img == null) {
            return null;
        }
        SerializableImage serializableImage = img;
        synchronized (serializableImage) {
            PersistenceKey persistenceKey = img.getPersistenceKey();
            if (persistenceKey != null && this.ig.containsKey((Object)persistenceKey)) {
                return persistenceKey;
            }
            if (persistenceKey == null) {
                persistenceKey = this.nextKey(CONTENT_TYPE.image);
            }
            img.setPersistenceKey(persistenceKey);
            this.ig.put((Object)persistenceKey, (Object)img);
            return persistenceKey;
        }
    }

    @Override
    public SerializableImage getImage(Object key) {
        SerializableImage serializableImage = (SerializableImage)this.ig.get(key);
        return serializableImage != null ? serializableImage.getPaintableInstance() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasFont(Font font) {
        Map<Font, PersistenceKey> map = this.ih;
        synchronized (map) {
            return this.ih.containsKey(font);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PersistenceKey putFont(Font font) {
        if (font == null) {
            throw new IllegalArgumentException("given font must not be null");
        }
        Map<Font, PersistenceKey> map = this.ih;
        synchronized (map) {
            PersistenceKey persistenceKey;
            PersistenceKey persistenceKey2;
            if (this.ii) {
                this.initFontMap();
                this.ii = false;
            }
            if ((persistenceKey2 = this.ih.get(font)) != null) {
                return persistenceKey2;
            }
            if (font instanceof SerializableDerivedFont) {
                SerializableDerivedFont serializableDerivedFont = (SerializableDerivedFont)font;
                SerializableDerivedFontData serializableDerivedFontData = serializableDerivedFont.getDerivedFontData();
                PersistenceKey persistenceKey3 = serializableDerivedFontData.getGeneralFontPersistenceKey();
                Optional<Font> optional = this.a(persistenceKey3);
                if (!optional.isPresent()) {
                    try {
                        SerializableGeneralFont serializableGeneralFont = new SerializableGeneralFont(serializableDerivedFont.getGeneralFontData(), persistenceKey3);
                        this.ih.put((Font)serializableGeneralFont, persistenceKey3);
                        this.ig.put((Object)persistenceKey3, (Object)serializableGeneralFont);
                    }
                    catch (FontFormatException | IOException exception) {
                        String string = "Could not create instance of SerializableGeneralFont for key " + persistenceKey3.keyValue();
                        PDFCCore.LOGGER_CORE.error((Throwable)((Object)PdfcException.create((ErrorCode)PdfcErrorCode.errorWhileWritingCache, exception, string)));
                    }
                }
                persistenceKey = this.nextKey(CONTENT_TYPE.font);
                this.ig.put((Object)persistenceKey, (Object)serializableDerivedFontData);
            } else if (font instanceof SerializableGeneralFont) {
                SerializableGeneralFont serializableGeneralFont = (SerializableGeneralFont)font;
                persistenceKey = serializableGeneralFont.getPersistenceKey();
                this.ig.put((Object)persistenceKey, (Object)serializableGeneralFont);
            } else if (font instanceof InetSerializable) {
                persistenceKey = this.nextKey(CONTENT_TYPE.font);
                this.ig.put((Object)persistenceKey, (Object)((InetSerializable)font));
            } else {
                persistenceKey = this.nextKey(CONTENT_TYPE.font);
                this.ig.put((Object)persistenceKey, (Object)new SerializableSystemFont(font));
            }
            this.ih.put(font, persistenceKey);
            return persistenceKey;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Font getFont(PersistenceKey key) {
        Map<Font, PersistenceKey> map = this.ih;
        synchronized (map) {
            Optional<Font> optional = this.a(key);
            if (optional.isPresent()) {
                return optional.get();
            }
            Object object = this.ig.get((Object)key);
            if (object instanceof SerializableDerivedFontData) {
                return this.a(key, (SerializableDerivedFontData)object);
            }
            if (object instanceof Font) {
                this.ih.put((Font)object, key);
                return (Font)object;
            }
            this.logFontNotFound(key, object);
            return REPLACEMENT_FOR_MISSING_FONTS;
        }
    }

    protected void logFontNotFound(PersistenceKey key, Object value) {
        String string = "Illegal cache state, got '" + (value != null ? value.getClass().getName() : "null") + "' instead of java.awt.Font for key " + key.keyValue();
        PDFCCore.LOGGER_CORE.error((Throwable)((Object)PdfcException.create((ErrorCode)PdfcErrorCode.errorWhileReadingCache, string)));
    }

    private Font a(PersistenceKey persistenceKey, SerializableDerivedFontData serializableDerivedFontData) {
        InetSerializable inetSerializable;
        PersistenceKey persistenceKey2 = serializableDerivedFontData.getGeneralFontPersistenceKey();
        SerializableGeneralFont serializableGeneralFont = null;
        Optional<Font> optional = this.a(persistenceKey2);
        if (optional.isPresent() && optional.get() instanceof SerializableGeneralFont) {
            serializableGeneralFont = (SerializableGeneralFont)optional.get();
        } else {
            inetSerializable = (InetSerializable)this.ig.get((Object)persistenceKey2);
            if (inetSerializable instanceof SerializableGeneralFont) {
                serializableGeneralFont = (SerializableGeneralFont)inetSerializable;
                this.ih.put((Font)serializableGeneralFont, persistenceKey2);
            } else {
                String string = "Illegal cache state, got '" + (inetSerializable != null ? inetSerializable.getClass().getName() : "null") + "' instead of SerializableGeneralFont for key " + persistenceKey2.keyValue();
                PDFCCore.LOGGER_CORE.error((Throwable)((Object)PdfcException.create((ErrorCode)PdfcErrorCode.errorWhileReadingCache, string)));
                this.ih.put(REPLACEMENT_FOR_MISSING_FONTS, persistenceKey2);
                Font font = REPLACEMENT_FOR_MISSING_FONTS.deriveFont(serializableDerivedFontData.getFontAttributes());
                this.ih.put(font, persistenceKey);
                return font;
            }
        }
        inetSerializable = serializableGeneralFont.deriveSerializableFont(serializableDerivedFontData.getFontAttributes());
        this.ih.put((Font)inetSerializable, persistenceKey);
        return inetSerializable;
    }

    private Optional<Font> a(PersistenceKey persistenceKey) {
        return this.ih.entrySet().stream().filter(entry -> persistenceKey.equals(entry.getValue())).findFirst().map(entry -> (Font)entry.getKey());
    }

    public PersistenceKey putCustomPage(Page page) {
        PersistenceKey persistenceKey = this.nextKey(CONTENT_TYPE.graphics);
        this.a(page, persistenceKey);
        return persistenceKey;
    }

    public PersistenceKey putData(PersistenceKey optionalKey, InetSerializable serializable) {
        PersistenceKey persistenceKey = optionalKey != null ? optionalKey : this.nextKey(CONTENT_TYPE.any);
        this.ig.put((Object)persistenceKey, (Object)serializable);
        return persistenceKey;
    }

    @Override
    public SerializableImage getImageIfInMemory(Object key) {
        return (SerializableImage)this.ig.getIfInMemeory(key);
    }

    public long getMemorySize() {
        return this.ig.getMemorySize();
    }

    public long getSwapSize() {
        return this.ig.getSwapSize();
    }

    public long size() {
        return this.ig.size();
    }

    public PersistenceKey getKeyForPage(boolean first, int pageIndex) {
        String string = first ? "first" : "second";
        return PersistenceKey.create((String)(string + pageIndex));
    }

    public void swapAll() throws IOException {
        try {
            this.ig.swapAll();
        }
        catch (IOException iOException) {
            throw iOException;
        }
        catch (Exception exception) {
            throw new IOException(exception);
        }
    }

    public void clearForFinalize(boolean swapFirst) {
        if (!swapFirst) {
            this.ig.clear();
        }
        if (this.ig instanceof PersistenceStoreMap) {
            ((PersistenceStoreMap)this.ig).close();
        }
    }

    @InternalApi
    public static final class CONTENT_TYPE
    extends Enum<CONTENT_TYPE> {
        public static final /* enum */ CONTENT_TYPE first = new CONTENT_TYPE();
        public static final /* enum */ CONTENT_TYPE second = new CONTENT_TYPE();
        public static final /* enum */ CONTENT_TYPE graphics = new CONTENT_TYPE();
        public static final /* enum */ CONTENT_TYPE font = new CONTENT_TYPE();
        public static final /* enum */ CONTENT_TYPE image = new CONTENT_TYPE();
        public static final /* enum */ CONTENT_TYPE any = new CONTENT_TYPE();
        private static final /* synthetic */ CONTENT_TYPE[] ij;

        public static CONTENT_TYPE[] values() {
            return (CONTENT_TYPE[])ij.clone();
        }

        public static CONTENT_TYPE valueOf(String name) {
            return Enum.valueOf(CONTENT_TYPE.class, name);
        }

        private static /* synthetic */ CONTENT_TYPE[] bj() {
            return new CONTENT_TYPE[]{first, second, graphics, font, image, any};
        }

        static {
            ij = CONTENT_TYPE.bj();
        }
    }
}

