/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfc.generator.model;

import com.inet.annotations.InternalApi;
import com.inet.annotations.JsonData;
import com.inet.pdfc.generator.model.a;
import com.inet.pdfc.model.DrawableElement;
import com.inet.pdfc.model.ElementID;
import com.inet.pdfc.model.ElementType;
import com.inet.pdfc.model.PagedElement;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

@JsonData
@InternalApi
public class MinifiedElement
extends DrawableElement
implements a,
Serializable {
    private Rectangle2D.Float bounds;
    private ElementType type;
    private String label;
    private Map<String, String> customData;

    private MinifiedElement() {
        super(0, ElementID.DUMMY);
    }

    private MinifiedElement(PagedElement diff) {
        super(diff.getPageIndex(), diff instanceof DrawableElement ? ((DrawableElement)diff).getElementID() : ElementID.DUMMY);
        this.type = diff.getType();
        this.label = diff.getLabel();
        this.bounds = MinifiedElement.getBoundsFloat(diff.getBounds());
    }

    public static MinifiedElement minify(PagedElement e2) {
        Map<String, String> map;
        if (e2 == null) {
            return null;
        }
        if (e2 instanceof MinifiedElement) {
            return (MinifiedElement)e2;
        }
        MinifiedElement minifiedElement = new MinifiedElement(e2);
        if (e2 instanceof a && (map = ((a)((Object)e2)).getCustomData()) != null && !map.isEmpty()) {
            minifiedElement.customData = new HashMap<String, String>(map);
        }
        return minifiedElement;
    }

    public static Rectangle2D.Float getBoundsFloat(Rectangle2D rect) {
        if (rect instanceof Rectangle2D.Float) {
            return (Rectangle2D.Float)rect;
        }
        return new Rectangle2D.Float((float)rect.getX(), (float)rect.getY(), (float)rect.getWidth(), (float)rect.getHeight());
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    @Override
    public Rectangle2D getBounds() {
        return this.bounds;
    }

    @Override
    public ElementType getType() {
        return this.type;
    }

    public String toString() {
        return "Minified " + this.label;
    }

    @Override
    public void setX(double x) {
        this.bounds.setFrame(this.bounds.getX() + x, this.bounds.getY(), this.bounds.getWidth(), this.bounds.getHeight());
    }

    @Override
    public void setY(double y) {
        this.bounds.setFrame(this.bounds.getX(), this.bounds.getY() + y, this.bounds.getWidth(), this.bounds.getHeight());
    }

    @Override
    public double getX() {
        return this.bounds.getX();
    }

    @Override
    public double getY() {
        return this.bounds.getY();
    }

    @Override
    public int getCompareHash() {
        return this.getType().ordinal() * this.label.hashCode();
    }

    @Override
    public Map<String, String> getCustomData() {
        return this.customData;
    }
}

