/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfc.generator.filter;

import com.inet.annotations.InternalApi;
import com.inet.error.ErrorCode;
import com.inet.pdfc.PDFCCore;
import com.inet.pdfc.config.IProfile;
import com.inet.pdfc.config.PDFCProperty;
import com.inet.pdfc.error.PdfcErrorCode;
import com.inet.pdfc.error.PdfcException;
import com.inet.pdfc.generator.filter.IFilterFactory;
import com.inet.pdfc.generator.filter.ISortFilter;
import com.inet.pdfc.generator.filter.ISortFilterFactory;
import com.inet.pdfc.generator.resultfilter.IResultFilter;
import com.inet.pdfc.generator.resultfilter.IResultFilterFactory;
import com.inet.pdfc.plugin.PluginManager;
import com.inet.plugin.NamedExtension;
import com.inet.plugin.ServerPluginManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;

@InternalApi
public class FilterFactory {
    public static final String FIXED_ORDER_KEYWORD = "fixedorder";
    private static Map<String, Integer> eL = null;
    private static Map<String, Integer> eM = null;

    private static ISortFilter a(String string, IProfile iProfile) {
        try {
            ISortFilterFactory iSortFilterFactory = (ISortFilterFactory)ServerPluginManager.getInstance().getSingleInstanceByName(ISortFilterFactory.class, string, false);
            return (ISortFilter)iSortFilterFactory.createInstance(iProfile);
        }
        catch (IllegalStateException illegalStateException) {
            PDFCCore.LOGGER_CORE.warn((Object)("Filter '" + string + "' is not registered and will be disabled in this comparison."));
            return null;
        }
    }

    private static IResultFilter b(String string, IProfile iProfile) {
        try {
            IResultFilterFactory iResultFilterFactory = (IResultFilterFactory)ServerPluginManager.getInstance().getSingleInstanceByName(IResultFilterFactory.class, string, false);
            return (IResultFilter)iResultFilterFactory.createInstance(iProfile);
        }
        catch (IllegalStateException illegalStateException) {
            PDFCCore.LOGGER_CORE.warn((Object)("Result filter '" + string + "' is not registered and will be disabled in this comparison."));
            return null;
        }
    }

    public static List<String> getAvailableInputFilterKeys() {
        PluginManager.setPluginFilterForAPI();
        PluginManager.initConditionally();
        List list = ServerPluginManager.getInstance().get(ISortFilterFactory.class);
        Collections.sort(list, new a());
        return list.stream().map(iSortFilterFactory -> iSortFilterFactory.getExtensionName()).collect(Collectors.toList());
    }

    public static List<String> getAvailableResultFilterKeys() {
        PluginManager.setPluginFilterForAPI();
        PluginManager.initConditionally();
        ArrayList<String> arrayList = new ArrayList<String>();
        List list = ServerPluginManager.getInstance().get(IResultFilterFactory.class);
        list.forEach(iResultFilterFactory -> arrayList.add(iResultFilterFactory.getExtensionName()));
        return arrayList;
    }

    private static synchronized void aK() {
        if (eM != null) {
            return;
        }
        eM = new HashMap<String, Integer>();
        eL = new HashMap<String, Integer>();
        List list = ServerPluginManager.getInstance().get(ISortFilterFactory.class);
        for (ISortFilterFactory iSortFilterFactory : list) {
            eM.put(iSortFilterFactory.getExtensionName(), iSortFilterFactory.getFilterAnalyzePriority());
            eL.put(iSortFilterFactory.getExtensionName(), iSortFilterFactory.getFilterPriority());
        }
    }

    public static List<ISortFilter> getSortedFilters(List<ISortFilter> filters, IProfile config, boolean sortForAnalyze) {
        if (eM == null) {
            FilterFactory.aK();
        }
        String string = config.getString(PDFCProperty.FILTERS).toLowerCase();
        boolean bl = string.contains(FIXED_ORDER_KEYWORD);
        ArrayList<ISortFilter> arrayList = new ArrayList<ISortFilter>(filters.size());
        b b2 = new b(sortForAnalyze ? eM : eL);
        if (bl) {
            Map map = filters.stream().collect(Collectors.toMap(NamedExtension::getExtensionName, Function.identity()));
            List<String> list = FilterFactory.getConfiguredFilterNames(config);
            for (String string2 : list) {
                ISortFilter iSortFilter = (ISortFilter)map.remove(string2);
                if (iSortFilter == null) continue;
                arrayList.add(iSortFilter);
            }
            int n = arrayList.size();
            arrayList.addAll(map.values());
            Collections.sort(arrayList.subList(n, arrayList.size()), b2);
        } else {
            arrayList.addAll(filters);
            Collections.sort(arrayList, b2);
        }
        return arrayList;
    }

    public static List<ISortFilter> getFilters(IProfile config) {
        ISortFilter iSortFilter;
        String string = config.getString(PDFCProperty.FILTERS).toLowerCase();
        boolean bl = string.contains(FIXED_ORDER_KEYWORD);
        String string2 = config.getString(PDFCProperty.CONTINUOUS_COMPARE);
        boolean bl2 = "STRICT".equals(string2) || "false".equalsIgnoreCase(string2);
        ArrayList<ISortFilter> arrayList = new ArrayList<ISortFilter>();
        List<String> list = FilterFactory.getAvailableInputFilterKeys();
        List<String> list2 = FilterFactory.getConfiguredFilterNames(config);
        for (String object2 : FilterFactory.getAvailableResultFilterKeys()) {
            if (list.contains(object2)) continue;
            list2.remove(object2);
        }
        ArrayList arrayList2 = new ArrayList();
        Set set = ServerPluginManager.getInstance().get(ISortFilterFactory.class).stream().filter(iSortFilterFactory -> iSortFilterFactory.hasFlag(IFilterFactory.FLAG.executeAlways)).map(iSortFilterFactory -> iSortFilterFactory.getExtensionName()).collect(Collectors.toSet());
        if (!bl) {
            for (String string3 : list) {
                if (arrayList2.contains(string3) || !list2.contains(string3) && !set.contains(string3)) continue;
                arrayList2.add(string3);
                set.remove(string3);
                iSortFilter = FilterFactory.a(string3, config);
                if (iSortFilter != null) {
                    arrayList.add(iSortFilter);
                    continue;
                }
                PDFCCore.LOGGER_CORE.error((Throwable)((Object)PdfcException.create((ErrorCode)PdfcErrorCode.savedValueNoLongerExists, "filter:" + string3)));
            }
        }
        for (String string3 : list2) {
            if (arrayList2.contains(string3)) continue;
            arrayList2.add(string3);
            iSortFilter = FilterFactory.a(string3, config);
            if (iSortFilter != null) {
                arrayList.add(iSortFilter);
                continue;
            }
            if (bl2 && "MARGIN".equals(string3)) continue;
            PDFCCore.LOGGER_CORE.error((Throwable)((Object)PdfcException.create((ErrorCode)PdfcErrorCode.savedValueNoLongerExists, string3)));
        }
        for (String string3 : set) {
            if (arrayList2.contains(string3)) continue;
            arrayList2.add(string3);
            iSortFilter = FilterFactory.a(string3, config);
            if (iSortFilter != null) {
                arrayList.add(iSortFilter);
                continue;
            }
            PDFCCore.LOGGER_CORE.error((Throwable)((Object)PdfcException.create((ErrorCode)PdfcErrorCode.savedValueNoLongerExists, string3)));
        }
        return arrayList;
    }

    public static List<IResultFilter> getResultFilters(IProfile config, List<ISortFilter> filters) {
        Object object2;
        ArrayList<IResultFilter> arrayList = new ArrayList<IResultFilter>();
        List<String> list = FilterFactory.getConfiguredFilterNames(config);
        List<String> list2 = FilterFactory.getAvailableResultFilterKeys();
        for (String object32 : FilterFactory.getAvailableInputFilterKeys()) {
            if (list2.contains(object32)) continue;
            list.remove(object32);
        }
        ArrayList arrayList2 = new ArrayList();
        for (String string : list2) {
            if (arrayList2.contains(string) || !list.contains(string)) continue;
            arrayList2.add(string);
            object2 = FilterFactory.a(filters, string, config);
            if (object2 != null) {
                arrayList.add((IResultFilter)object2);
                continue;
            }
            PDFCCore.LOGGER_CORE.error((Throwable)((Object)PdfcException.create((ErrorCode)PdfcErrorCode.savedValueNoLongerExists, "filter:" + string)));
        }
        for (String string : list) {
            if (arrayList2.contains(string)) continue;
            arrayList2.add(string);
            object2 = FilterFactory.a(filters, string, config);
            if (object2 != null) {
                arrayList.add((IResultFilter)object2);
                continue;
            }
            PDFCCore.LOGGER_CORE.error((Throwable)((Object)PdfcException.create((ErrorCode)PdfcErrorCode.savedValueNoLongerExists, string)));
        }
        List list3 = ServerPluginManager.getInstance().get(IResultFilterFactory.class).stream().filter(iResultFilterFactory -> iResultFilterFactory.hasFlag(IFilterFactory.FLAG.executeAlways)).collect(Collectors.toList());
        for (Object object2 : list3) {
            if (arrayList2.contains(object2.getExtensionName())) continue;
            arrayList.add((IResultFilter)object2.createInstance(config));
            arrayList2.add(object2.getExtensionName());
        }
        return arrayList;
    }

    private static IResultFilter a(List<ISortFilter> list, String string, IProfile iProfile) {
        if (list != null) {
            for (ISortFilter iSortFilter : list) {
                if (!string.equalsIgnoreCase(iSortFilter.getExtensionName()) || !(iSortFilter instanceof IResultFilter)) continue;
                return (IResultFilter)((Object)iSortFilter);
            }
        }
        return FilterFactory.b(string, iProfile);
    }

    public static List<String> getConfiguredFilterNames(IProfile profile) {
        String string = profile.getString(PDFCProperty.FILTERS).toLowerCase();
        ArrayList<String> arrayList = new ArrayList<String>();
        if (!string.isEmpty()) {
            String string2 = string.replace(FIXED_ORDER_KEYWORD, "");
            String[] stringArray = string2.split(",");
            for (int i = 0; i < stringArray.length; ++i) {
                stringArray[i] = stringArray[i].trim().toUpperCase();
                if (stringArray[i].isEmpty()) continue;
                arrayList.add(stringArray[i]);
            }
        }
        return arrayList;
    }

    private static class a
    implements Comparator<ISortFilterFactory> {
        private a() {
        }

        public int a(ISortFilterFactory iSortFilterFactory, ISortFilterFactory iSortFilterFactory2) {
            if (iSortFilterFactory.getFilterPriority() != iSortFilterFactory2.getFilterPriority()) {
                return iSortFilterFactory.getFilterPriority() - iSortFilterFactory2.getFilterPriority();
            }
            return iSortFilterFactory.getExtensionName().compareTo(iSortFilterFactory2.getExtensionName());
        }

        @Override
        public /* synthetic */ int compare(Object object, Object object2) {
            return this.a((ISortFilterFactory)object, (ISortFilterFactory)object2);
        }
    }

    private static class b
    implements Comparator<ISortFilter> {
        private Map<String, Integer> eN;

        public b(Map<String, Integer> map) {
            this.eN = map;
        }

        public int a(ISortFilter iSortFilter, ISortFilter iSortFilter2) {
            Integer n = this.eN.get(iSortFilter.getExtensionName());
            Integer n2 = this.eN.get(iSortFilter2.getExtensionName());
            if (n != null && n2 != null) {
                return n.compareTo(n2);
            }
            if (n != null || n2 != null) {
                return n != null ? -1 : 1;
            }
            return iSortFilter.getExtensionName().compareTo(iSortFilter2.getExtensionName());
        }

        @Override
        public /* synthetic */ int compare(Object object, Object object2) {
            return this.a((ISortFilter)object, (ISortFilter)object2);
        }
    }
}

