/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfc.config;

import com.inet.annotations.PublicApi;
import com.inet.http.servlet.ClientLocale;
import com.inet.pdfc.config.CompareType;
import com.inet.pdfc.config.IProfile;
import com.inet.pdfc.config.LanguageValues;
import com.inet.pdfc.config.TextStyleType;
import com.inet.pdfc.config.ValidValueProvider;
import com.inet.pdfc.util.Pair;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nonnull;

@PublicApi
public class PDFCProperty<T> {
    private static final HashMap<String, PDFCProperty<?>> aO = new HashMap();
    private static final HashMap<String, PDFCProperty<?>> aP = new HashMap();
    @Deprecated
    public static final PDFCProperty<String> CREATE_DIFFIMAGES;
    @Deprecated
    public static final PDFCProperty<Boolean> CREATE_XORIMAGES;
    @Deprecated
    public static final PDFCProperty<Boolean> CREATE_ORIGIMAGES;
    @Deprecated
    public static final PDFCProperty<String> LOG_LEVEL;
    @Deprecated
    public static final PDFCProperty<String> LOG_FILE;
    public static final PDFCProperty<String> DOCUMENT_LANGUAGE;
    public static final PDFCProperty<Double> TOLERANCE_BOX_ROUND_EDGES;
    public static final PDFCProperty<Double> TOLERANCE_IMAGE_DISTANCE;
    public static final PDFCProperty<Double> TOLERANCE_IMAGE_PIXEL_VALUE;
    public static final PDFCProperty<Double> TOLERANCE_IMAGE_SIZE;
    public static final PDFCProperty<Boolean> IMAGE_CHANGE_AREA;
    public static final PDFCProperty<Boolean> IMAGE_META_COMPARISON;
    public static final PDFCProperty<Double> TOLERANCE_LINE_POSITION;
    public static final PDFCProperty<Double> TOLERANCE_LINE_SIZE;
    public static final PDFCProperty<Boolean> TOLERANCE_LINE_STYLE;
    public static final PDFCProperty<Double> TOLERANCE_LINE_THICKNESS;
    public static final PDFCProperty<Double> TOLERANCE_PAGE_LEFTCORNER;
    public static final PDFCProperty<Double> TOLERANCE_PAGE_RATIO;
    public static final PDFCProperty<Double> TOLERANCE_PAGE_SIZE;
    public static final PDFCProperty<Double> TOLERANCE_UNDERLINE_LENGTH;
    public static final PDFCProperty<Double> TOLERANCE_TEXT_LOCATION;
    public static final PDFCProperty<Double> TOLERANCE_TEXT_SIZE;
    public static final PDFCProperty<Double> TOLERANCE_COLOR;
    @Nonnull
    public static final @Nonnull PDFCProperty<@Nonnull TextStyleType> COMPARE_TEXT_STYLES;
    public static final PDFCProperty<Double> TEXT_ALIGN_RATIO;
    public static final PDFCProperty<Boolean> COMPARE_TEXT_CASE_SENSITIVE;
    public static final PDFCProperty<Boolean> COMPARE_LINE_STYLES;
    public static final PDFCProperty<Boolean> USE_PIXEL_MEDIUM_VALUE;
    public static final PDFCProperty<Integer> FIXED_HEADER_SIZE;
    public static final PDFCProperty<Integer> FIXED_FOOTER_SIZE;
    @Nonnull
    public static final @Nonnull PDFCProperty<@Nonnull String> FILTERS;
    @Nonnull
    public static final @Nonnull PDFCProperty<@Nonnull CompareType> COMPARE_TYPES;
    public static final PDFCProperty<Integer> CONTINUOUS_DETECT_PAGES;
    public static final PDFCProperty<String> CONTINUOUS_COMPARE;
    @Deprecated
    public static final PDFCProperty<Boolean> EXPORT_PDF_ALWAYS;
    public static final PDFCProperty<Boolean> COMPARE_ANNOTATIONS_DETAILED;
    public static final PDFCProperty<Boolean> COMPARE_TAGS;
    public static final PDFCProperty<String> FILTER_PATTERNS;
    public static final PDFCProperty<Integer> DIFF_MERGE_FACTOR;
    @Nonnull
    private final String aH;
    private T aQ;
    @Nonnull
    private Class<?> aR;
    private Number aS;
    private Number aT;
    private ValidValueProvider aU;
    private boolean aV;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PDFCProperty(@Nonnull String name, T defaultValue, @Nonnull Class<T> type) throws IllegalStateException {
        this.aH = name;
        this.aQ = defaultValue;
        this.aR = type;
        if (aP.containsKey(name)) {
            aP.put(name, this);
            return;
        }
        HashMap<String, PDFCProperty<?>> hashMap = aO;
        synchronized (hashMap) {
            if (aO.containsKey(name)) {
                PDFCProperty<?> pDFCProperty = aO.get(name);
                if (pDFCProperty != null && pDFCProperty.getType() == type && pDFCProperty.getDefaultValue() == defaultValue) {
                    return;
                }
                throw new IllegalStateException("A property with the same name '" + name + "' already exists.");
            }
            aO.put(name, this);
        }
    }

    public PDFCProperty(@Nonnull String name, int defaultValue, int lowerBound, int upperBound) {
        this(name, defaultValue, Integer.class);
        this.aS = lowerBound;
        this.aT = upperBound;
    }

    public PDFCProperty(@Nonnull String name, double defaultValue, double lowerBound, double upperBound) {
        this(name, defaultValue, Double.class);
        this.aS = lowerBound;
        this.aT = upperBound;
    }

    public PDFCProperty(@Nonnull String name, boolean defaultValue) {
        this(name, defaultValue, Boolean.class);
    }

    public PDFCProperty(@Nonnull String name, String defaultValue, String ... validValues) {
        this(name, defaultValue, String.class);
        this.aU = new ValidValueProvider(validValues);
    }

    public PDFCProperty(@Nonnull String name, String defaultValue, ValidValueProvider provider) {
        this(name, defaultValue, String.class);
        this.aU = provider;
    }

    @SafeVarargs
    public <D extends Enum<?>> PDFCProperty(@Nonnull String name, Class<T> validValues, D ... defaultValue) {
        this(name, (Enum)((Object)PDFCProperty.toPropertyValue(defaultValue)), Enum.class);
        this.aU = new ValidValueProvider(validValues.getEnumConstants());
    }

    @Nonnull
    public String name() {
        return this.aH;
    }

    public String toString() {
        return this.name();
    }

    public static PDFCProperty<?> valueOf(String name) {
        PDFCProperty<?> pDFCProperty = aO.get(name);
        if (pDFCProperty == null) {
            pDFCProperty = aP.get(name);
        }
        return pDFCProperty;
    }

    public static Collection<PDFCProperty<?>> values() {
        return aO.values();
    }

    public T getDefaultValue() {
        return this.aQ;
    }

    void a(T t) {
        this.aQ = t;
    }

    private PDFCProperty<T> K() {
        this.aV = true;
        return this;
    }

    public boolean isDeprecated() {
        return this.aV;
    }

    public Class<?> getType() {
        return this.aR;
    }

    public Pair<Number> getLimits() {
        if (this.aR == Integer.class || this.aR == Double.class) {
            return new Pair<Number>(this.aS, this.aT);
        }
        return null;
    }

    public Object[] getValidValues() {
        if (this.aU == null) {
            return null;
        }
        List<ValidValueProvider.ValidValue> list = this.aU.getValidValues();
        Object[] objectArray = new Object[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            objectArray[i] = list.get(i).getProfileValue();
        }
        return objectArray;
    }

    public List<ValidValueProvider.ValidValue> getAvailableValues() {
        if (this.aU == null) {
            return null;
        }
        return Collections.unmodifiableList(this.aU.getValidValues());
    }

    public static String toPropertyValue(Object[] choice) {
        if (choice == null || choice.length == 0) {
            return "";
        }
        return Arrays.toString(choice).replaceAll("\\[|\\]", "");
    }

    public static Object[] getSelectedValues(IProfile config, PDFCProperty<?> property) {
        if (property.aR == Enum.class) {
            String string = config.getString(property);
            if (string == null || string.length() == 0) {
                return new Object[0];
            }
            ArrayList<String> arrayList = new ArrayList<String>();
            block0: for (String string2 : string.split("\\s*[,;]\\s*")) {
                string2 = string2.trim();
                for (Object object : property.getValidValues()) {
                    if (!object.toString().equalsIgnoreCase(string2)) continue;
                    arrayList.add(string2);
                    continue block0;
                }
            }
            return arrayList.toArray();
        }
        return null;
    }

    static {
        aP.put("MODULES", null);
        aP.put("NORMALIZERS", null);
        aP.put("CONTINUOUS_FILTERS", null);
        aP.put("CONTINUOUS_COMPARE_TYPES", null);
        aP.put("INVISIBLEELEMENTS_HIDE_ROTATION", null);
        CREATE_DIFFIMAGES = new PDFCProperty("CREATE_DIFFIMAGES", "false", "false", "first", "second", "true").K();
        CREATE_XORIMAGES = new PDFCProperty("CREATE_XORIMAGES", false).K();
        CREATE_ORIGIMAGES = new PDFCProperty("CREATE_ORIGIMAGES", false).K();
        LOG_LEVEL = new PDFCProperty("LOG_LEVEL", "INFO", "OFF", "ERROR", "WARN", "INFO", "ALL").K();
        LOG_FILE = new PDFCProperty("LOG_FILE", "", new String[0]).K();
        DOCUMENT_LANGUAGE = new PDFCProperty<String>("DOCUMENT_LANGUAGE", null, (ValidValueProvider)LanguageValues.DEFAULT_INSTANCE){

            public String L() {
                String string = (String)super.getDefaultValue();
                if (string != null) {
                    return string;
                }
                Locale locale = ClientLocale.getThreadLocale();
                String string2 = LanguageValues.ISO_TO_TESS.get(locale.getLanguage());
                List<ValidValueProvider.ValidValue> list = this.getAvailableValues();
                if (string2 != null && list != null && list.stream().filter(validValue -> string2.equals(validValue.getProfileValue())).findFirst().isPresent()) {
                    return string2;
                }
                return "eng";
            }

            @Override
            public /* synthetic */ Object getDefaultValue() {
                return this.L();
            }
        };
        TOLERANCE_BOX_ROUND_EDGES = new PDFCProperty("TOLERANCE_BOX_ROUND_EDGES", 3.0, 0.0, 10.0);
        TOLERANCE_IMAGE_DISTANCE = new PDFCProperty("TOLERANCE_IMAGE_DISTANCE", 3.0, 0.0, 10.0);
        TOLERANCE_IMAGE_PIXEL_VALUE = new PDFCProperty("TOLERANCE_IMAGE_PIXEL_VALUE", 0.05, 0.0, 1.0);
        TOLERANCE_IMAGE_SIZE = new PDFCProperty("TOLERANCE_IMAGE_SIZE", 0.1, 0.0, 1.0);
        IMAGE_CHANGE_AREA = new PDFCProperty("IMAGE_CHANGE_AREA", false);
        IMAGE_META_COMPARISON = new PDFCProperty("IMAGE_META_COMPARISON", false);
        TOLERANCE_LINE_POSITION = new PDFCProperty("TOLERANCE_LINE_POSITION", 3.0, 0.0, 100.0);
        TOLERANCE_LINE_SIZE = new PDFCProperty("TOLERANCE_LINE_SIZE", 2.0, 0.0, 100.0);
        TOLERANCE_LINE_STYLE = new PDFCProperty("TOLERANCE_LINE_STYLE", false);
        TOLERANCE_LINE_THICKNESS = new PDFCProperty("TOLERANCE_LINE_THICKNESS", 1.0, 0.0, 100.0);
        TOLERANCE_PAGE_LEFTCORNER = new PDFCProperty("TOLERANCE_PAGE_LEFTCORNER", 3.0, 0.0, 100.0);
        TOLERANCE_PAGE_RATIO = new PDFCProperty("TOLERANCE_PAGE_RATIO", 0.01, 0.0, 1.0);
        TOLERANCE_PAGE_SIZE = new PDFCProperty("TOLERANCE_PAGE_SIZE", 2.0, 0.0, 100.0);
        TOLERANCE_UNDERLINE_LENGTH = new PDFCProperty("TOLERANCE_UNDERLINE_LENGTH", 0.1, 0.0, 10.0);
        TOLERANCE_TEXT_LOCATION = new PDFCProperty("TOLERANCE_TEXT_LOCATION", -1.0, -1.0, 100.0);
        TOLERANCE_TEXT_SIZE = new PDFCProperty("TOLERANCE_TEXT_SIZE", 0.05, 0.0, 1.0);
        TOLERANCE_COLOR = new PDFCProperty("TOLERANCE_COLOR", 0.01, 0.0, 1.0);
        COMPARE_TEXT_STYLES = new PDFCProperty("COMPARE_TEXT_STYLES", TextStyleType.class, (Enum[])TextStyleType.values());
        TEXT_ALIGN_RATIO = new PDFCProperty("TEXT_ALIGN_RATIO", 0.15, 0.0, 1.0);
        COMPARE_TEXT_CASE_SENSITIVE = new PDFCProperty("COMPARE_TEXT_CASE_SENSITIVE", true);
        COMPARE_LINE_STYLES = new PDFCProperty("COMPARE_LINE_STYLES", true);
        USE_PIXEL_MEDIUM_VALUE = new PDFCProperty("USE_PIXEL_MEDIUM_VALUE", true);
        FIXED_HEADER_SIZE = new PDFCProperty("FIXED_HEADER_SIZE", -1, -1, Integer.MAX_VALUE);
        FIXED_FOOTER_SIZE = new PDFCProperty("FIXED_FOOTER_SIZE", -1, -1, Integer.MAX_VALUE);
        FILTERS = new PDFCProperty<String>("FILTERS", "INVISIBLEELEMENTS,TEXTTRANSFORM,SOLVEFALSEREPLACE", String.class);
        COMPARE_TYPES = new PDFCProperty("COMPARE_TYPES", CompareType.class, (Enum[])CompareType.values());
        CONTINUOUS_DETECT_PAGES = new PDFCProperty("CONTINUOUS_DETECT_PAGES", 5, 0, Integer.MAX_VALUE);
        CONTINUOUS_COMPARE = new PDFCProperty("CONTINUOUS_COMPARE", "CONTINUOUS", "CONTINUOUS", "STRICT");
        EXPORT_PDF_ALWAYS = new PDFCProperty("EXPORT_PDF_ALWAYS", false).K();
        COMPARE_ANNOTATIONS_DETAILED = new PDFCProperty("COMPARE_ANNOTATIONS_DETAILED", false);
        COMPARE_TAGS = new PDFCProperty("COMPARE_TAGS", false);
        FILTER_PATTERNS = new PDFCProperty("FILTER_PATTERNS", "", new String[0]);
        DIFF_MERGE_FACTOR = new PDFCProperty("DIFF_MERGE_FACTOR", 0, Integer.MAX_VALUE, 0);
    }
}

